/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.memorydb;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.memorydb.MemoryDbAsyncClient;
import software.amazon.awssdk.services.memorydb.MemoryDbServiceClientConfiguration;
import software.amazon.awssdk.services.memorydb.internal.MemoryDbServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.memorydb.model.AclAlreadyExistsException;
import software.amazon.awssdk.services.memorydb.model.AclNotFoundException;
import software.amazon.awssdk.services.memorydb.model.AclQuotaExceededException;
import software.amazon.awssdk.services.memorydb.model.ApiCallRateForCustomerExceededException;
import software.amazon.awssdk.services.memorydb.model.BatchUpdateClusterRequest;
import software.amazon.awssdk.services.memorydb.model.BatchUpdateClusterResponse;
import software.amazon.awssdk.services.memorydb.model.ClusterAlreadyExistsException;
import software.amazon.awssdk.services.memorydb.model.ClusterNotFoundException;
import software.amazon.awssdk.services.memorydb.model.ClusterQuotaForCustomerExceededException;
import software.amazon.awssdk.services.memorydb.model.CopySnapshotRequest;
import software.amazon.awssdk.services.memorydb.model.CopySnapshotResponse;
import software.amazon.awssdk.services.memorydb.model.CreateAclRequest;
import software.amazon.awssdk.services.memorydb.model.CreateAclResponse;
import software.amazon.awssdk.services.memorydb.model.CreateClusterRequest;
import software.amazon.awssdk.services.memorydb.model.CreateClusterResponse;
import software.amazon.awssdk.services.memorydb.model.CreateMultiRegionClusterRequest;
import software.amazon.awssdk.services.memorydb.model.CreateMultiRegionClusterResponse;
import software.amazon.awssdk.services.memorydb.model.CreateParameterGroupRequest;
import software.amazon.awssdk.services.memorydb.model.CreateParameterGroupResponse;
import software.amazon.awssdk.services.memorydb.model.CreateSnapshotRequest;
import software.amazon.awssdk.services.memorydb.model.CreateSnapshotResponse;
import software.amazon.awssdk.services.memorydb.model.CreateSubnetGroupRequest;
import software.amazon.awssdk.services.memorydb.model.CreateSubnetGroupResponse;
import software.amazon.awssdk.services.memorydb.model.CreateUserRequest;
import software.amazon.awssdk.services.memorydb.model.CreateUserResponse;
import software.amazon.awssdk.services.memorydb.model.DefaultUserRequiredException;
import software.amazon.awssdk.services.memorydb.model.DeleteAclRequest;
import software.amazon.awssdk.services.memorydb.model.DeleteAclResponse;
import software.amazon.awssdk.services.memorydb.model.DeleteClusterRequest;
import software.amazon.awssdk.services.memorydb.model.DeleteClusterResponse;
import software.amazon.awssdk.services.memorydb.model.DeleteMultiRegionClusterRequest;
import software.amazon.awssdk.services.memorydb.model.DeleteMultiRegionClusterResponse;
import software.amazon.awssdk.services.memorydb.model.DeleteParameterGroupRequest;
import software.amazon.awssdk.services.memorydb.model.DeleteParameterGroupResponse;
import software.amazon.awssdk.services.memorydb.model.DeleteSnapshotRequest;
import software.amazon.awssdk.services.memorydb.model.DeleteSnapshotResponse;
import software.amazon.awssdk.services.memorydb.model.DeleteSubnetGroupRequest;
import software.amazon.awssdk.services.memorydb.model.DeleteSubnetGroupResponse;
import software.amazon.awssdk.services.memorydb.model.DeleteUserRequest;
import software.amazon.awssdk.services.memorydb.model.DeleteUserResponse;
import software.amazon.awssdk.services.memorydb.model.DescribeAcLsRequest;
import software.amazon.awssdk.services.memorydb.model.DescribeAcLsResponse;
import software.amazon.awssdk.services.memorydb.model.DescribeClustersRequest;
import software.amazon.awssdk.services.memorydb.model.DescribeClustersResponse;
import software.amazon.awssdk.services.memorydb.model.DescribeEngineVersionsRequest;
import software.amazon.awssdk.services.memorydb.model.DescribeEngineVersionsResponse;
import software.amazon.awssdk.services.memorydb.model.DescribeEventsRequest;
import software.amazon.awssdk.services.memorydb.model.DescribeEventsResponse;
import software.amazon.awssdk.services.memorydb.model.DescribeMultiRegionClustersRequest;
import software.amazon.awssdk.services.memorydb.model.DescribeMultiRegionClustersResponse;
import software.amazon.awssdk.services.memorydb.model.DescribeMultiRegionParameterGroupsRequest;
import software.amazon.awssdk.services.memorydb.model.DescribeMultiRegionParameterGroupsResponse;
import software.amazon.awssdk.services.memorydb.model.DescribeMultiRegionParametersRequest;
import software.amazon.awssdk.services.memorydb.model.DescribeMultiRegionParametersResponse;
import software.amazon.awssdk.services.memorydb.model.DescribeParameterGroupsRequest;
import software.amazon.awssdk.services.memorydb.model.DescribeParameterGroupsResponse;
import software.amazon.awssdk.services.memorydb.model.DescribeParametersRequest;
import software.amazon.awssdk.services.memorydb.model.DescribeParametersResponse;
import software.amazon.awssdk.services.memorydb.model.DescribeReservedNodesOfferingsRequest;
import software.amazon.awssdk.services.memorydb.model.DescribeReservedNodesOfferingsResponse;
import software.amazon.awssdk.services.memorydb.model.DescribeReservedNodesRequest;
import software.amazon.awssdk.services.memorydb.model.DescribeReservedNodesResponse;
import software.amazon.awssdk.services.memorydb.model.DescribeServiceUpdatesRequest;
import software.amazon.awssdk.services.memorydb.model.DescribeServiceUpdatesResponse;
import software.amazon.awssdk.services.memorydb.model.DescribeSnapshotsRequest;
import software.amazon.awssdk.services.memorydb.model.DescribeSnapshotsResponse;
import software.amazon.awssdk.services.memorydb.model.DescribeSubnetGroupsRequest;
import software.amazon.awssdk.services.memorydb.model.DescribeSubnetGroupsResponse;
import software.amazon.awssdk.services.memorydb.model.DescribeUsersRequest;
import software.amazon.awssdk.services.memorydb.model.DescribeUsersResponse;
import software.amazon.awssdk.services.memorydb.model.DuplicateUserNameException;
import software.amazon.awssdk.services.memorydb.model.FailoverShardRequest;
import software.amazon.awssdk.services.memorydb.model.FailoverShardResponse;
import software.amazon.awssdk.services.memorydb.model.InsufficientClusterCapacityException;
import software.amazon.awssdk.services.memorydb.model.InvalidAclStateException;
import software.amazon.awssdk.services.memorydb.model.InvalidArnException;
import software.amazon.awssdk.services.memorydb.model.InvalidClusterStateException;
import software.amazon.awssdk.services.memorydb.model.InvalidCredentialsException;
import software.amazon.awssdk.services.memorydb.model.InvalidKmsKeyException;
import software.amazon.awssdk.services.memorydb.model.InvalidMultiRegionClusterStateException;
import software.amazon.awssdk.services.memorydb.model.InvalidNodeStateException;
import software.amazon.awssdk.services.memorydb.model.InvalidParameterCombinationException;
import software.amazon.awssdk.services.memorydb.model.InvalidParameterGroupStateException;
import software.amazon.awssdk.services.memorydb.model.InvalidParameterValueException;
import software.amazon.awssdk.services.memorydb.model.InvalidSnapshotStateException;
import software.amazon.awssdk.services.memorydb.model.InvalidSubnetException;
import software.amazon.awssdk.services.memorydb.model.InvalidUserStateException;
import software.amazon.awssdk.services.memorydb.model.InvalidVpcNetworkStateException;
import software.amazon.awssdk.services.memorydb.model.ListAllowedMultiRegionClusterUpdatesRequest;
import software.amazon.awssdk.services.memorydb.model.ListAllowedMultiRegionClusterUpdatesResponse;
import software.amazon.awssdk.services.memorydb.model.ListAllowedNodeTypeUpdatesRequest;
import software.amazon.awssdk.services.memorydb.model.ListAllowedNodeTypeUpdatesResponse;
import software.amazon.awssdk.services.memorydb.model.ListTagsRequest;
import software.amazon.awssdk.services.memorydb.model.ListTagsResponse;
import software.amazon.awssdk.services.memorydb.model.MemoryDbException;
import software.amazon.awssdk.services.memorydb.model.MultiRegionClusterAlreadyExistsException;
import software.amazon.awssdk.services.memorydb.model.MultiRegionClusterNotFoundException;
import software.amazon.awssdk.services.memorydb.model.MultiRegionParameterGroupNotFoundException;
import software.amazon.awssdk.services.memorydb.model.NoOperationException;
import software.amazon.awssdk.services.memorydb.model.NodeQuotaForClusterExceededException;
import software.amazon.awssdk.services.memorydb.model.NodeQuotaForCustomerExceededException;
import software.amazon.awssdk.services.memorydb.model.ParameterGroupAlreadyExistsException;
import software.amazon.awssdk.services.memorydb.model.ParameterGroupNotFoundException;
import software.amazon.awssdk.services.memorydb.model.ParameterGroupQuotaExceededException;
import software.amazon.awssdk.services.memorydb.model.PurchaseReservedNodesOfferingRequest;
import software.amazon.awssdk.services.memorydb.model.PurchaseReservedNodesOfferingResponse;
import software.amazon.awssdk.services.memorydb.model.ReservedNodeAlreadyExistsException;
import software.amazon.awssdk.services.memorydb.model.ReservedNodeNotFoundException;
import software.amazon.awssdk.services.memorydb.model.ReservedNodeQuotaExceededException;
import software.amazon.awssdk.services.memorydb.model.ReservedNodesOfferingNotFoundException;
import software.amazon.awssdk.services.memorydb.model.ResetParameterGroupRequest;
import software.amazon.awssdk.services.memorydb.model.ResetParameterGroupResponse;
import software.amazon.awssdk.services.memorydb.model.ServiceLinkedRoleNotFoundException;
import software.amazon.awssdk.services.memorydb.model.ServiceUpdateNotFoundException;
import software.amazon.awssdk.services.memorydb.model.ShardNotFoundException;
import software.amazon.awssdk.services.memorydb.model.ShardsPerClusterQuotaExceededException;
import software.amazon.awssdk.services.memorydb.model.SnapshotAlreadyExistsException;
import software.amazon.awssdk.services.memorydb.model.SnapshotNotFoundException;
import software.amazon.awssdk.services.memorydb.model.SnapshotQuotaExceededException;
import software.amazon.awssdk.services.memorydb.model.SubnetGroupAlreadyExistsException;
import software.amazon.awssdk.services.memorydb.model.SubnetGroupInUseException;
import software.amazon.awssdk.services.memorydb.model.SubnetGroupNotFoundException;
import software.amazon.awssdk.services.memorydb.model.SubnetGroupQuotaExceededException;
import software.amazon.awssdk.services.memorydb.model.SubnetInUseException;
import software.amazon.awssdk.services.memorydb.model.SubnetNotAllowedException;
import software.amazon.awssdk.services.memorydb.model.SubnetQuotaExceededException;
import software.amazon.awssdk.services.memorydb.model.TagNotFoundException;
import software.amazon.awssdk.services.memorydb.model.TagQuotaPerResourceExceededException;
import software.amazon.awssdk.services.memorydb.model.TagResourceRequest;
import software.amazon.awssdk.services.memorydb.model.TagResourceResponse;
import software.amazon.awssdk.services.memorydb.model.TestFailoverNotAvailableException;
import software.amazon.awssdk.services.memorydb.model.UntagResourceRequest;
import software.amazon.awssdk.services.memorydb.model.UntagResourceResponse;
import software.amazon.awssdk.services.memorydb.model.UpdateAclRequest;
import software.amazon.awssdk.services.memorydb.model.UpdateAclResponse;
import software.amazon.awssdk.services.memorydb.model.UpdateClusterRequest;
import software.amazon.awssdk.services.memorydb.model.UpdateClusterResponse;
import software.amazon.awssdk.services.memorydb.model.UpdateMultiRegionClusterRequest;
import software.amazon.awssdk.services.memorydb.model.UpdateMultiRegionClusterResponse;
import software.amazon.awssdk.services.memorydb.model.UpdateParameterGroupRequest;
import software.amazon.awssdk.services.memorydb.model.UpdateParameterGroupResponse;
import software.amazon.awssdk.services.memorydb.model.UpdateSubnetGroupRequest;
import software.amazon.awssdk.services.memorydb.model.UpdateSubnetGroupResponse;
import software.amazon.awssdk.services.memorydb.model.UpdateUserRequest;
import software.amazon.awssdk.services.memorydb.model.UpdateUserResponse;
import software.amazon.awssdk.services.memorydb.model.UserAlreadyExistsException;
import software.amazon.awssdk.services.memorydb.model.UserNotFoundException;
import software.amazon.awssdk.services.memorydb.model.UserQuotaExceededException;
import software.amazon.awssdk.services.memorydb.transform.BatchUpdateClusterRequestMarshaller;
import software.amazon.awssdk.services.memorydb.transform.CopySnapshotRequestMarshaller;
import software.amazon.awssdk.services.memorydb.transform.CreateAclRequestMarshaller;
import software.amazon.awssdk.services.memorydb.transform.CreateClusterRequestMarshaller;
import software.amazon.awssdk.services.memorydb.transform.CreateMultiRegionClusterRequestMarshaller;
import software.amazon.awssdk.services.memorydb.transform.CreateParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.memorydb.transform.CreateSnapshotRequestMarshaller;
import software.amazon.awssdk.services.memorydb.transform.CreateSubnetGroupRequestMarshaller;
import software.amazon.awssdk.services.memorydb.transform.CreateUserRequestMarshaller;
import software.amazon.awssdk.services.memorydb.transform.DeleteAclRequestMarshaller;
import software.amazon.awssdk.services.memorydb.transform.DeleteClusterRequestMarshaller;
import software.amazon.awssdk.services.memorydb.transform.DeleteMultiRegionClusterRequestMarshaller;
import software.amazon.awssdk.services.memorydb.transform.DeleteParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.memorydb.transform.DeleteSnapshotRequestMarshaller;
import software.amazon.awssdk.services.memorydb.transform.DeleteSubnetGroupRequestMarshaller;
import software.amazon.awssdk.services.memorydb.transform.DeleteUserRequestMarshaller;
import software.amazon.awssdk.services.memorydb.transform.DescribeAcLsRequestMarshaller;
import software.amazon.awssdk.services.memorydb.transform.DescribeClustersRequestMarshaller;
import software.amazon.awssdk.services.memorydb.transform.DescribeEngineVersionsRequestMarshaller;
import software.amazon.awssdk.services.memorydb.transform.DescribeEventsRequestMarshaller;
import software.amazon.awssdk.services.memorydb.transform.DescribeMultiRegionClustersRequestMarshaller;
import software.amazon.awssdk.services.memorydb.transform.DescribeMultiRegionParameterGroupsRequestMarshaller;
import software.amazon.awssdk.services.memorydb.transform.DescribeMultiRegionParametersRequestMarshaller;
import software.amazon.awssdk.services.memorydb.transform.DescribeParameterGroupsRequestMarshaller;
import software.amazon.awssdk.services.memorydb.transform.DescribeParametersRequestMarshaller;
import software.amazon.awssdk.services.memorydb.transform.DescribeReservedNodesOfferingsRequestMarshaller;
import software.amazon.awssdk.services.memorydb.transform.DescribeReservedNodesRequestMarshaller;
import software.amazon.awssdk.services.memorydb.transform.DescribeServiceUpdatesRequestMarshaller;
import software.amazon.awssdk.services.memorydb.transform.DescribeSnapshotsRequestMarshaller;
import software.amazon.awssdk.services.memorydb.transform.DescribeSubnetGroupsRequestMarshaller;
import software.amazon.awssdk.services.memorydb.transform.DescribeUsersRequestMarshaller;
import software.amazon.awssdk.services.memorydb.transform.FailoverShardRequestMarshaller;
import software.amazon.awssdk.services.memorydb.transform.ListAllowedMultiRegionClusterUpdatesRequestMarshaller;
import software.amazon.awssdk.services.memorydb.transform.ListAllowedNodeTypeUpdatesRequestMarshaller;
import software.amazon.awssdk.services.memorydb.transform.ListTagsRequestMarshaller;
import software.amazon.awssdk.services.memorydb.transform.PurchaseReservedNodesOfferingRequestMarshaller;
import software.amazon.awssdk.services.memorydb.transform.ResetParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.memorydb.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.memorydb.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.memorydb.transform.UpdateAclRequestMarshaller;
import software.amazon.awssdk.services.memorydb.transform.UpdateClusterRequestMarshaller;
import software.amazon.awssdk.services.memorydb.transform.UpdateMultiRegionClusterRequestMarshaller;
import software.amazon.awssdk.services.memorydb.transform.UpdateParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.memorydb.transform.UpdateSubnetGroupRequestMarshaller;
import software.amazon.awssdk.services.memorydb.transform.UpdateUserRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkInternalApi
final class DefaultMemoryDbAsyncClient
implements MemoryDbAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultMemoryDbAsyncClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.AWS_JSON).build();
    private final AsyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultMemoryDbAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).option((ClientOption)SdkClientOption.API_METADATA, (Object)"MemoryDB#2.36.x").build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    @Override
    public CompletableFuture<BatchUpdateClusterResponse> batchUpdateCluster(BatchUpdateClusterRequest batchUpdateClusterRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)batchUpdateClusterRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMemoryDbAsyncClient.resolveMetricPublishers(clientConfiguration, batchUpdateClusterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MemoryDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchUpdateCluster");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchUpdateClusterResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "SubnetGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                    }
                    case "ParameterGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                    }
                    case "SubnetInUse": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                    }
                    case "InvalidARNFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "TestFailoverNotAvailableFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TestFailoverNotAvailableFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TestFailoverNotAvailableException::builder).build());
                    }
                    case "ACLQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclQuotaExceededException::builder).build());
                    }
                    case "InvalidKMSKeyFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKMSKeyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyException::builder).build());
                    }
                    case "DuplicateUserNameFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateUserNameFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateUserNameException::builder).build());
                    }
                    case "SubnetNotAllowedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotAllowedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotAllowedException::builder).build());
                    }
                    case "InvalidVPCNetworkStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                    }
                    case "InvalidParameterGroupStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                    }
                    case "ParameterGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                    }
                    case "ServiceLinkedRoleNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                    }
                    case "ParameterGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                    }
                    case "UserNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                    }
                    case "ClusterNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                    }
                    case "MultiRegionClusterAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterAlreadyExistsException::builder).build());
                    }
                    case "InvalidCredentialsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCredentialsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCredentialsException::builder).build());
                    }
                    case "InvalidClusterStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                    }
                    case "MultiRegionClusterNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterNotFoundException::builder).build());
                    }
                    case "SubnetGroupInUseFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                    }
                    case "InvalidSubnet": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                    }
                    case "ClusterAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                    }
                    case "NoOperationFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoOperationException::builder).build());
                    }
                    case "ShardNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShardNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardNotFoundException::builder).build());
                    }
                    case "ACLNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclNotFoundException::builder).build());
                    }
                    case "SubnetGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                    }
                    case "ReservedNodesOfferingNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodesOfferingNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodesOfferingNotFoundException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "SnapshotAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotAlreadyExistsException::builder).build());
                    }
                    case "SnapshotQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotQuotaExceededException::builder).build());
                    }
                    case "DefaultUserRequired": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DefaultUserRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultUserRequiredException::builder).build());
                    }
                    case "NodeQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                    }
                    case "UserAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserAlreadyExistsException::builder).build());
                    }
                    case "InvalidACLStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidACLStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAclStateException::builder).build());
                    }
                    case "TagNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                    }
                    case "ClusterQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                    }
                    case "APICallRateForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("APICallRateForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiCallRateForCustomerExceededException::builder).build());
                    }
                    case "NodeQuotaForClusterExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                    }
                    case "ServiceUpdateNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUpdateNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUpdateNotFoundException::builder).build());
                    }
                    case "SubnetQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                    }
                    case "ReservedNodeQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeQuotaExceededException::builder).build());
                    }
                    case "InvalidSnapshotStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnapshotStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnapshotStateException::builder).build());
                    }
                    case "InvalidNodeStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNodeStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNodeStateException::builder).build());
                    }
                    case "ShardsPerClusterQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShardsPerClusterQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardsPerClusterQuotaExceededException::builder).build());
                    }
                    case "ReservedNodeAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeAlreadyExistsException::builder).build());
                    }
                    case "ReservedNodeNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeNotFoundException::builder).build());
                    }
                    case "InvalidParameterCombinationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                    }
                    case "InvalidUserStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserStateException::builder).build());
                    }
                    case "SnapshotNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                    }
                    case "MultiRegionParameterGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionParameterGroupNotFoundException::builder).build());
                    }
                    case "ACLAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclAlreadyExistsException::builder).build());
                    }
                    case "InsufficientClusterCapacityFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                    }
                    case "UserQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserQuotaExceededException::builder).build());
                    }
                    case "TagQuotaPerResourceExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                    }
                    case "InvalidMultiRegionClusterStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMultiRegionClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMultiRegionClusterStateException::builder).build());
                    }
                    case "SubnetGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchUpdateCluster").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new BatchUpdateClusterRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)batchUpdateClusterRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMemoryDbAsyncClient.lambda$batchUpdateCluster$2(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMemoryDbAsyncClient.lambda$batchUpdateCluster$3((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CopySnapshotResponse> copySnapshot(CopySnapshotRequest copySnapshotRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)copySnapshotRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMemoryDbAsyncClient.resolveMetricPublishers(clientConfiguration, copySnapshotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MemoryDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CopySnapshot");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CopySnapshotResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "SubnetGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                    }
                    case "ParameterGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                    }
                    case "SubnetInUse": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                    }
                    case "InvalidARNFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "TestFailoverNotAvailableFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TestFailoverNotAvailableFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TestFailoverNotAvailableException::builder).build());
                    }
                    case "ACLQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclQuotaExceededException::builder).build());
                    }
                    case "InvalidKMSKeyFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKMSKeyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyException::builder).build());
                    }
                    case "DuplicateUserNameFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateUserNameFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateUserNameException::builder).build());
                    }
                    case "SubnetNotAllowedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotAllowedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotAllowedException::builder).build());
                    }
                    case "InvalidVPCNetworkStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                    }
                    case "InvalidParameterGroupStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                    }
                    case "ParameterGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                    }
                    case "ServiceLinkedRoleNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                    }
                    case "ParameterGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                    }
                    case "UserNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                    }
                    case "ClusterNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                    }
                    case "MultiRegionClusterAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterAlreadyExistsException::builder).build());
                    }
                    case "InvalidCredentialsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCredentialsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCredentialsException::builder).build());
                    }
                    case "InvalidClusterStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                    }
                    case "MultiRegionClusterNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterNotFoundException::builder).build());
                    }
                    case "SubnetGroupInUseFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                    }
                    case "InvalidSubnet": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                    }
                    case "ClusterAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                    }
                    case "NoOperationFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoOperationException::builder).build());
                    }
                    case "ShardNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShardNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardNotFoundException::builder).build());
                    }
                    case "ACLNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclNotFoundException::builder).build());
                    }
                    case "SubnetGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                    }
                    case "ReservedNodesOfferingNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodesOfferingNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodesOfferingNotFoundException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "SnapshotAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotAlreadyExistsException::builder).build());
                    }
                    case "SnapshotQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotQuotaExceededException::builder).build());
                    }
                    case "DefaultUserRequired": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DefaultUserRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultUserRequiredException::builder).build());
                    }
                    case "NodeQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                    }
                    case "UserAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserAlreadyExistsException::builder).build());
                    }
                    case "InvalidACLStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidACLStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAclStateException::builder).build());
                    }
                    case "TagNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                    }
                    case "ClusterQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                    }
                    case "APICallRateForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("APICallRateForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiCallRateForCustomerExceededException::builder).build());
                    }
                    case "NodeQuotaForClusterExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                    }
                    case "ServiceUpdateNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUpdateNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUpdateNotFoundException::builder).build());
                    }
                    case "SubnetQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                    }
                    case "ReservedNodeQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeQuotaExceededException::builder).build());
                    }
                    case "InvalidSnapshotStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnapshotStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnapshotStateException::builder).build());
                    }
                    case "InvalidNodeStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNodeStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNodeStateException::builder).build());
                    }
                    case "ShardsPerClusterQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShardsPerClusterQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardsPerClusterQuotaExceededException::builder).build());
                    }
                    case "ReservedNodeAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeAlreadyExistsException::builder).build());
                    }
                    case "ReservedNodeNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeNotFoundException::builder).build());
                    }
                    case "InvalidParameterCombinationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                    }
                    case "InvalidUserStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserStateException::builder).build());
                    }
                    case "SnapshotNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                    }
                    case "MultiRegionParameterGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionParameterGroupNotFoundException::builder).build());
                    }
                    case "ACLAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclAlreadyExistsException::builder).build());
                    }
                    case "InsufficientClusterCapacityFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                    }
                    case "UserQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserQuotaExceededException::builder).build());
                    }
                    case "TagQuotaPerResourceExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                    }
                    case "InvalidMultiRegionClusterStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMultiRegionClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMultiRegionClusterStateException::builder).build());
                    }
                    case "SubnetGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CopySnapshot").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CopySnapshotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)copySnapshotRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMemoryDbAsyncClient.lambda$copySnapshot$6(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMemoryDbAsyncClient.lambda$copySnapshot$7((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateAclResponse> createACL(CreateAclRequest createAclRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createAclRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMemoryDbAsyncClient.resolveMetricPublishers(clientConfiguration, createAclRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MemoryDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateACL");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateAclResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "SubnetGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                    }
                    case "ParameterGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                    }
                    case "SubnetInUse": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                    }
                    case "InvalidARNFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "TestFailoverNotAvailableFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TestFailoverNotAvailableFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TestFailoverNotAvailableException::builder).build());
                    }
                    case "ACLQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclQuotaExceededException::builder).build());
                    }
                    case "InvalidKMSKeyFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKMSKeyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyException::builder).build());
                    }
                    case "DuplicateUserNameFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateUserNameFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateUserNameException::builder).build());
                    }
                    case "SubnetNotAllowedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotAllowedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotAllowedException::builder).build());
                    }
                    case "InvalidVPCNetworkStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                    }
                    case "InvalidParameterGroupStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                    }
                    case "ParameterGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                    }
                    case "ServiceLinkedRoleNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                    }
                    case "ParameterGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                    }
                    case "UserNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                    }
                    case "ClusterNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                    }
                    case "MultiRegionClusterAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterAlreadyExistsException::builder).build());
                    }
                    case "InvalidCredentialsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCredentialsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCredentialsException::builder).build());
                    }
                    case "InvalidClusterStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                    }
                    case "MultiRegionClusterNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterNotFoundException::builder).build());
                    }
                    case "SubnetGroupInUseFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                    }
                    case "InvalidSubnet": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                    }
                    case "ClusterAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                    }
                    case "NoOperationFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoOperationException::builder).build());
                    }
                    case "ShardNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShardNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardNotFoundException::builder).build());
                    }
                    case "ACLNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclNotFoundException::builder).build());
                    }
                    case "SubnetGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                    }
                    case "ReservedNodesOfferingNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodesOfferingNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodesOfferingNotFoundException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "SnapshotAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotAlreadyExistsException::builder).build());
                    }
                    case "SnapshotQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotQuotaExceededException::builder).build());
                    }
                    case "DefaultUserRequired": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DefaultUserRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultUserRequiredException::builder).build());
                    }
                    case "NodeQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                    }
                    case "UserAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserAlreadyExistsException::builder).build());
                    }
                    case "InvalidACLStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidACLStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAclStateException::builder).build());
                    }
                    case "TagNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                    }
                    case "ClusterQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                    }
                    case "APICallRateForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("APICallRateForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiCallRateForCustomerExceededException::builder).build());
                    }
                    case "NodeQuotaForClusterExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                    }
                    case "ServiceUpdateNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUpdateNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUpdateNotFoundException::builder).build());
                    }
                    case "SubnetQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                    }
                    case "ReservedNodeQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeQuotaExceededException::builder).build());
                    }
                    case "InvalidSnapshotStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnapshotStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnapshotStateException::builder).build());
                    }
                    case "InvalidNodeStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNodeStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNodeStateException::builder).build());
                    }
                    case "ShardsPerClusterQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShardsPerClusterQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardsPerClusterQuotaExceededException::builder).build());
                    }
                    case "ReservedNodeAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeAlreadyExistsException::builder).build());
                    }
                    case "ReservedNodeNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeNotFoundException::builder).build());
                    }
                    case "InvalidParameterCombinationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                    }
                    case "InvalidUserStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserStateException::builder).build());
                    }
                    case "SnapshotNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                    }
                    case "MultiRegionParameterGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionParameterGroupNotFoundException::builder).build());
                    }
                    case "ACLAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclAlreadyExistsException::builder).build());
                    }
                    case "InsufficientClusterCapacityFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                    }
                    case "UserQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserQuotaExceededException::builder).build());
                    }
                    case "TagQuotaPerResourceExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                    }
                    case "InvalidMultiRegionClusterStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMultiRegionClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMultiRegionClusterStateException::builder).build());
                    }
                    case "SubnetGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateACL").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateAclRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createAclRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMemoryDbAsyncClient.lambda$createACL$10(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMemoryDbAsyncClient.lambda$createACL$11((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateClusterResponse> createCluster(CreateClusterRequest createClusterRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createClusterRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMemoryDbAsyncClient.resolveMetricPublishers(clientConfiguration, createClusterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MemoryDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateCluster");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateClusterResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "SubnetGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                    }
                    case "ParameterGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                    }
                    case "SubnetInUse": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                    }
                    case "InvalidARNFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "TestFailoverNotAvailableFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TestFailoverNotAvailableFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TestFailoverNotAvailableException::builder).build());
                    }
                    case "ACLQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclQuotaExceededException::builder).build());
                    }
                    case "InvalidKMSKeyFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKMSKeyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyException::builder).build());
                    }
                    case "DuplicateUserNameFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateUserNameFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateUserNameException::builder).build());
                    }
                    case "SubnetNotAllowedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotAllowedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotAllowedException::builder).build());
                    }
                    case "InvalidVPCNetworkStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                    }
                    case "InvalidParameterGroupStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                    }
                    case "ParameterGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                    }
                    case "ServiceLinkedRoleNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                    }
                    case "ParameterGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                    }
                    case "UserNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                    }
                    case "ClusterNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                    }
                    case "MultiRegionClusterAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterAlreadyExistsException::builder).build());
                    }
                    case "InvalidCredentialsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCredentialsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCredentialsException::builder).build());
                    }
                    case "InvalidClusterStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                    }
                    case "MultiRegionClusterNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterNotFoundException::builder).build());
                    }
                    case "SubnetGroupInUseFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                    }
                    case "InvalidSubnet": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                    }
                    case "ClusterAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                    }
                    case "NoOperationFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoOperationException::builder).build());
                    }
                    case "ShardNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShardNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardNotFoundException::builder).build());
                    }
                    case "ACLNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclNotFoundException::builder).build());
                    }
                    case "SubnetGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                    }
                    case "ReservedNodesOfferingNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodesOfferingNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodesOfferingNotFoundException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "SnapshotAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotAlreadyExistsException::builder).build());
                    }
                    case "SnapshotQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotQuotaExceededException::builder).build());
                    }
                    case "DefaultUserRequired": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DefaultUserRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultUserRequiredException::builder).build());
                    }
                    case "NodeQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                    }
                    case "UserAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserAlreadyExistsException::builder).build());
                    }
                    case "InvalidACLStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidACLStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAclStateException::builder).build());
                    }
                    case "TagNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                    }
                    case "ClusterQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                    }
                    case "APICallRateForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("APICallRateForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiCallRateForCustomerExceededException::builder).build());
                    }
                    case "NodeQuotaForClusterExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                    }
                    case "ServiceUpdateNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUpdateNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUpdateNotFoundException::builder).build());
                    }
                    case "SubnetQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                    }
                    case "ReservedNodeQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeQuotaExceededException::builder).build());
                    }
                    case "InvalidSnapshotStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnapshotStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnapshotStateException::builder).build());
                    }
                    case "InvalidNodeStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNodeStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNodeStateException::builder).build());
                    }
                    case "ShardsPerClusterQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShardsPerClusterQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardsPerClusterQuotaExceededException::builder).build());
                    }
                    case "ReservedNodeAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeAlreadyExistsException::builder).build());
                    }
                    case "ReservedNodeNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeNotFoundException::builder).build());
                    }
                    case "InvalidParameterCombinationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                    }
                    case "InvalidUserStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserStateException::builder).build());
                    }
                    case "SnapshotNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                    }
                    case "MultiRegionParameterGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionParameterGroupNotFoundException::builder).build());
                    }
                    case "ACLAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclAlreadyExistsException::builder).build());
                    }
                    case "InsufficientClusterCapacityFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                    }
                    case "UserQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserQuotaExceededException::builder).build());
                    }
                    case "TagQuotaPerResourceExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                    }
                    case "InvalidMultiRegionClusterStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMultiRegionClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMultiRegionClusterStateException::builder).build());
                    }
                    case "SubnetGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateCluster").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateClusterRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createClusterRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMemoryDbAsyncClient.lambda$createCluster$14(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMemoryDbAsyncClient.lambda$createCluster$15((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateMultiRegionClusterResponse> createMultiRegionCluster(CreateMultiRegionClusterRequest createMultiRegionClusterRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createMultiRegionClusterRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMemoryDbAsyncClient.resolveMetricPublishers(clientConfiguration, createMultiRegionClusterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MemoryDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateMultiRegionCluster");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateMultiRegionClusterResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "SubnetGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                    }
                    case "ParameterGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                    }
                    case "SubnetInUse": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                    }
                    case "InvalidARNFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "TestFailoverNotAvailableFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TestFailoverNotAvailableFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TestFailoverNotAvailableException::builder).build());
                    }
                    case "ACLQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclQuotaExceededException::builder).build());
                    }
                    case "InvalidKMSKeyFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKMSKeyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyException::builder).build());
                    }
                    case "DuplicateUserNameFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateUserNameFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateUserNameException::builder).build());
                    }
                    case "SubnetNotAllowedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotAllowedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotAllowedException::builder).build());
                    }
                    case "InvalidVPCNetworkStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                    }
                    case "InvalidParameterGroupStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                    }
                    case "ParameterGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                    }
                    case "ServiceLinkedRoleNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                    }
                    case "ParameterGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                    }
                    case "UserNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                    }
                    case "ClusterNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                    }
                    case "MultiRegionClusterAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterAlreadyExistsException::builder).build());
                    }
                    case "InvalidCredentialsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCredentialsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCredentialsException::builder).build());
                    }
                    case "InvalidClusterStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                    }
                    case "MultiRegionClusterNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterNotFoundException::builder).build());
                    }
                    case "SubnetGroupInUseFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                    }
                    case "InvalidSubnet": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                    }
                    case "ClusterAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                    }
                    case "NoOperationFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoOperationException::builder).build());
                    }
                    case "ShardNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShardNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardNotFoundException::builder).build());
                    }
                    case "ACLNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclNotFoundException::builder).build());
                    }
                    case "SubnetGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                    }
                    case "ReservedNodesOfferingNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodesOfferingNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodesOfferingNotFoundException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "SnapshotAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotAlreadyExistsException::builder).build());
                    }
                    case "SnapshotQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotQuotaExceededException::builder).build());
                    }
                    case "DefaultUserRequired": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DefaultUserRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultUserRequiredException::builder).build());
                    }
                    case "NodeQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                    }
                    case "UserAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserAlreadyExistsException::builder).build());
                    }
                    case "InvalidACLStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidACLStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAclStateException::builder).build());
                    }
                    case "TagNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                    }
                    case "ClusterQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                    }
                    case "APICallRateForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("APICallRateForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiCallRateForCustomerExceededException::builder).build());
                    }
                    case "NodeQuotaForClusterExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                    }
                    case "ServiceUpdateNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUpdateNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUpdateNotFoundException::builder).build());
                    }
                    case "SubnetQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                    }
                    case "ReservedNodeQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeQuotaExceededException::builder).build());
                    }
                    case "InvalidSnapshotStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnapshotStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnapshotStateException::builder).build());
                    }
                    case "InvalidNodeStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNodeStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNodeStateException::builder).build());
                    }
                    case "ShardsPerClusterQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShardsPerClusterQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardsPerClusterQuotaExceededException::builder).build());
                    }
                    case "ReservedNodeAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeAlreadyExistsException::builder).build());
                    }
                    case "ReservedNodeNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeNotFoundException::builder).build());
                    }
                    case "InvalidParameterCombinationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                    }
                    case "InvalidUserStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserStateException::builder).build());
                    }
                    case "SnapshotNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                    }
                    case "MultiRegionParameterGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionParameterGroupNotFoundException::builder).build());
                    }
                    case "ACLAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclAlreadyExistsException::builder).build());
                    }
                    case "InsufficientClusterCapacityFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                    }
                    case "UserQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserQuotaExceededException::builder).build());
                    }
                    case "TagQuotaPerResourceExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                    }
                    case "InvalidMultiRegionClusterStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMultiRegionClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMultiRegionClusterStateException::builder).build());
                    }
                    case "SubnetGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateMultiRegionCluster").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateMultiRegionClusterRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createMultiRegionClusterRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMemoryDbAsyncClient.lambda$createMultiRegionCluster$18(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMemoryDbAsyncClient.lambda$createMultiRegionCluster$19((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateParameterGroupResponse> createParameterGroup(CreateParameterGroupRequest createParameterGroupRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createParameterGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMemoryDbAsyncClient.resolveMetricPublishers(clientConfiguration, createParameterGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MemoryDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateParameterGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateParameterGroupResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "SubnetGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                    }
                    case "ParameterGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                    }
                    case "SubnetInUse": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                    }
                    case "InvalidARNFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "TestFailoverNotAvailableFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TestFailoverNotAvailableFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TestFailoverNotAvailableException::builder).build());
                    }
                    case "ACLQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclQuotaExceededException::builder).build());
                    }
                    case "InvalidKMSKeyFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKMSKeyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyException::builder).build());
                    }
                    case "DuplicateUserNameFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateUserNameFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateUserNameException::builder).build());
                    }
                    case "SubnetNotAllowedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotAllowedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotAllowedException::builder).build());
                    }
                    case "InvalidVPCNetworkStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                    }
                    case "InvalidParameterGroupStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                    }
                    case "ParameterGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                    }
                    case "ServiceLinkedRoleNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                    }
                    case "ParameterGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                    }
                    case "UserNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                    }
                    case "ClusterNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                    }
                    case "MultiRegionClusterAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterAlreadyExistsException::builder).build());
                    }
                    case "InvalidCredentialsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCredentialsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCredentialsException::builder).build());
                    }
                    case "InvalidClusterStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                    }
                    case "MultiRegionClusterNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterNotFoundException::builder).build());
                    }
                    case "SubnetGroupInUseFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                    }
                    case "InvalidSubnet": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                    }
                    case "ClusterAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                    }
                    case "NoOperationFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoOperationException::builder).build());
                    }
                    case "ShardNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShardNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardNotFoundException::builder).build());
                    }
                    case "ACLNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclNotFoundException::builder).build());
                    }
                    case "SubnetGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                    }
                    case "ReservedNodesOfferingNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodesOfferingNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodesOfferingNotFoundException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "SnapshotAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotAlreadyExistsException::builder).build());
                    }
                    case "SnapshotQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotQuotaExceededException::builder).build());
                    }
                    case "DefaultUserRequired": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DefaultUserRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultUserRequiredException::builder).build());
                    }
                    case "NodeQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                    }
                    case "UserAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserAlreadyExistsException::builder).build());
                    }
                    case "InvalidACLStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidACLStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAclStateException::builder).build());
                    }
                    case "TagNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                    }
                    case "ClusterQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                    }
                    case "APICallRateForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("APICallRateForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiCallRateForCustomerExceededException::builder).build());
                    }
                    case "NodeQuotaForClusterExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                    }
                    case "ServiceUpdateNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUpdateNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUpdateNotFoundException::builder).build());
                    }
                    case "SubnetQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                    }
                    case "ReservedNodeQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeQuotaExceededException::builder).build());
                    }
                    case "InvalidSnapshotStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnapshotStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnapshotStateException::builder).build());
                    }
                    case "InvalidNodeStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNodeStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNodeStateException::builder).build());
                    }
                    case "ShardsPerClusterQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShardsPerClusterQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardsPerClusterQuotaExceededException::builder).build());
                    }
                    case "ReservedNodeAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeAlreadyExistsException::builder).build());
                    }
                    case "ReservedNodeNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeNotFoundException::builder).build());
                    }
                    case "InvalidParameterCombinationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                    }
                    case "InvalidUserStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserStateException::builder).build());
                    }
                    case "SnapshotNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                    }
                    case "MultiRegionParameterGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionParameterGroupNotFoundException::builder).build());
                    }
                    case "ACLAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclAlreadyExistsException::builder).build());
                    }
                    case "InsufficientClusterCapacityFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                    }
                    case "UserQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserQuotaExceededException::builder).build());
                    }
                    case "TagQuotaPerResourceExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                    }
                    case "InvalidMultiRegionClusterStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMultiRegionClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMultiRegionClusterStateException::builder).build());
                    }
                    case "SubnetGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateParameterGroup").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateParameterGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createParameterGroupRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMemoryDbAsyncClient.lambda$createParameterGroup$22(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMemoryDbAsyncClient.lambda$createParameterGroup$23((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateSnapshotResponse> createSnapshot(CreateSnapshotRequest createSnapshotRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createSnapshotRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMemoryDbAsyncClient.resolveMetricPublishers(clientConfiguration, createSnapshotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MemoryDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateSnapshot");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateSnapshotResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "SubnetGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                    }
                    case "ParameterGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                    }
                    case "SubnetInUse": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                    }
                    case "InvalidARNFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "TestFailoverNotAvailableFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TestFailoverNotAvailableFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TestFailoverNotAvailableException::builder).build());
                    }
                    case "ACLQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclQuotaExceededException::builder).build());
                    }
                    case "InvalidKMSKeyFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKMSKeyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyException::builder).build());
                    }
                    case "DuplicateUserNameFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateUserNameFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateUserNameException::builder).build());
                    }
                    case "SubnetNotAllowedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotAllowedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotAllowedException::builder).build());
                    }
                    case "InvalidVPCNetworkStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                    }
                    case "InvalidParameterGroupStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                    }
                    case "ParameterGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                    }
                    case "ServiceLinkedRoleNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                    }
                    case "ParameterGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                    }
                    case "UserNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                    }
                    case "ClusterNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                    }
                    case "MultiRegionClusterAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterAlreadyExistsException::builder).build());
                    }
                    case "InvalidCredentialsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCredentialsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCredentialsException::builder).build());
                    }
                    case "InvalidClusterStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                    }
                    case "MultiRegionClusterNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterNotFoundException::builder).build());
                    }
                    case "SubnetGroupInUseFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                    }
                    case "InvalidSubnet": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                    }
                    case "ClusterAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                    }
                    case "NoOperationFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoOperationException::builder).build());
                    }
                    case "ShardNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShardNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardNotFoundException::builder).build());
                    }
                    case "ACLNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclNotFoundException::builder).build());
                    }
                    case "SubnetGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                    }
                    case "ReservedNodesOfferingNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodesOfferingNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodesOfferingNotFoundException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "SnapshotAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotAlreadyExistsException::builder).build());
                    }
                    case "SnapshotQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotQuotaExceededException::builder).build());
                    }
                    case "DefaultUserRequired": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DefaultUserRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultUserRequiredException::builder).build());
                    }
                    case "NodeQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                    }
                    case "UserAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserAlreadyExistsException::builder).build());
                    }
                    case "InvalidACLStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidACLStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAclStateException::builder).build());
                    }
                    case "TagNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                    }
                    case "ClusterQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                    }
                    case "APICallRateForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("APICallRateForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiCallRateForCustomerExceededException::builder).build());
                    }
                    case "NodeQuotaForClusterExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                    }
                    case "ServiceUpdateNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUpdateNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUpdateNotFoundException::builder).build());
                    }
                    case "SubnetQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                    }
                    case "ReservedNodeQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeQuotaExceededException::builder).build());
                    }
                    case "InvalidSnapshotStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnapshotStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnapshotStateException::builder).build());
                    }
                    case "InvalidNodeStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNodeStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNodeStateException::builder).build());
                    }
                    case "ShardsPerClusterQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShardsPerClusterQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardsPerClusterQuotaExceededException::builder).build());
                    }
                    case "ReservedNodeAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeAlreadyExistsException::builder).build());
                    }
                    case "ReservedNodeNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeNotFoundException::builder).build());
                    }
                    case "InvalidParameterCombinationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                    }
                    case "InvalidUserStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserStateException::builder).build());
                    }
                    case "SnapshotNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                    }
                    case "MultiRegionParameterGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionParameterGroupNotFoundException::builder).build());
                    }
                    case "ACLAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclAlreadyExistsException::builder).build());
                    }
                    case "InsufficientClusterCapacityFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                    }
                    case "UserQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserQuotaExceededException::builder).build());
                    }
                    case "TagQuotaPerResourceExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                    }
                    case "InvalidMultiRegionClusterStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMultiRegionClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMultiRegionClusterStateException::builder).build());
                    }
                    case "SubnetGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateSnapshot").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateSnapshotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createSnapshotRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMemoryDbAsyncClient.lambda$createSnapshot$26(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMemoryDbAsyncClient.lambda$createSnapshot$27((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateSubnetGroupResponse> createSubnetGroup(CreateSubnetGroupRequest createSubnetGroupRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createSubnetGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMemoryDbAsyncClient.resolveMetricPublishers(clientConfiguration, createSubnetGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MemoryDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateSubnetGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateSubnetGroupResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "SubnetGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                    }
                    case "ParameterGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                    }
                    case "SubnetInUse": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                    }
                    case "InvalidARNFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "TestFailoverNotAvailableFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TestFailoverNotAvailableFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TestFailoverNotAvailableException::builder).build());
                    }
                    case "ACLQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclQuotaExceededException::builder).build());
                    }
                    case "InvalidKMSKeyFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKMSKeyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyException::builder).build());
                    }
                    case "DuplicateUserNameFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateUserNameFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateUserNameException::builder).build());
                    }
                    case "SubnetNotAllowedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotAllowedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotAllowedException::builder).build());
                    }
                    case "InvalidVPCNetworkStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                    }
                    case "InvalidParameterGroupStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                    }
                    case "ParameterGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                    }
                    case "ServiceLinkedRoleNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                    }
                    case "ParameterGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                    }
                    case "UserNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                    }
                    case "ClusterNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                    }
                    case "MultiRegionClusterAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterAlreadyExistsException::builder).build());
                    }
                    case "InvalidCredentialsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCredentialsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCredentialsException::builder).build());
                    }
                    case "InvalidClusterStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                    }
                    case "MultiRegionClusterNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterNotFoundException::builder).build());
                    }
                    case "SubnetGroupInUseFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                    }
                    case "InvalidSubnet": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                    }
                    case "ClusterAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                    }
                    case "NoOperationFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoOperationException::builder).build());
                    }
                    case "ShardNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShardNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardNotFoundException::builder).build());
                    }
                    case "ACLNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclNotFoundException::builder).build());
                    }
                    case "SubnetGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                    }
                    case "ReservedNodesOfferingNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodesOfferingNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodesOfferingNotFoundException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "SnapshotAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotAlreadyExistsException::builder).build());
                    }
                    case "SnapshotQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotQuotaExceededException::builder).build());
                    }
                    case "DefaultUserRequired": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DefaultUserRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultUserRequiredException::builder).build());
                    }
                    case "NodeQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                    }
                    case "UserAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserAlreadyExistsException::builder).build());
                    }
                    case "InvalidACLStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidACLStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAclStateException::builder).build());
                    }
                    case "TagNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                    }
                    case "ClusterQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                    }
                    case "APICallRateForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("APICallRateForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiCallRateForCustomerExceededException::builder).build());
                    }
                    case "NodeQuotaForClusterExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                    }
                    case "ServiceUpdateNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUpdateNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUpdateNotFoundException::builder).build());
                    }
                    case "SubnetQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                    }
                    case "ReservedNodeQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeQuotaExceededException::builder).build());
                    }
                    case "InvalidSnapshotStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnapshotStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnapshotStateException::builder).build());
                    }
                    case "InvalidNodeStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNodeStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNodeStateException::builder).build());
                    }
                    case "ShardsPerClusterQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShardsPerClusterQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardsPerClusterQuotaExceededException::builder).build());
                    }
                    case "ReservedNodeAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeAlreadyExistsException::builder).build());
                    }
                    case "ReservedNodeNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeNotFoundException::builder).build());
                    }
                    case "InvalidParameterCombinationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                    }
                    case "InvalidUserStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserStateException::builder).build());
                    }
                    case "SnapshotNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                    }
                    case "MultiRegionParameterGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionParameterGroupNotFoundException::builder).build());
                    }
                    case "ACLAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclAlreadyExistsException::builder).build());
                    }
                    case "InsufficientClusterCapacityFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                    }
                    case "UserQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserQuotaExceededException::builder).build());
                    }
                    case "TagQuotaPerResourceExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                    }
                    case "InvalidMultiRegionClusterStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMultiRegionClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMultiRegionClusterStateException::builder).build());
                    }
                    case "SubnetGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateSubnetGroup").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateSubnetGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createSubnetGroupRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMemoryDbAsyncClient.lambda$createSubnetGroup$30(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMemoryDbAsyncClient.lambda$createSubnetGroup$31((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateUserResponse> createUser(CreateUserRequest createUserRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createUserRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMemoryDbAsyncClient.resolveMetricPublishers(clientConfiguration, createUserRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MemoryDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateUser");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateUserResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "SubnetGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                    }
                    case "ParameterGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                    }
                    case "SubnetInUse": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                    }
                    case "InvalidARNFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "TestFailoverNotAvailableFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TestFailoverNotAvailableFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TestFailoverNotAvailableException::builder).build());
                    }
                    case "ACLQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclQuotaExceededException::builder).build());
                    }
                    case "InvalidKMSKeyFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKMSKeyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyException::builder).build());
                    }
                    case "DuplicateUserNameFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateUserNameFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateUserNameException::builder).build());
                    }
                    case "SubnetNotAllowedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotAllowedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotAllowedException::builder).build());
                    }
                    case "InvalidVPCNetworkStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                    }
                    case "InvalidParameterGroupStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                    }
                    case "ParameterGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                    }
                    case "ServiceLinkedRoleNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                    }
                    case "ParameterGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                    }
                    case "UserNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                    }
                    case "ClusterNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                    }
                    case "MultiRegionClusterAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterAlreadyExistsException::builder).build());
                    }
                    case "InvalidCredentialsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCredentialsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCredentialsException::builder).build());
                    }
                    case "InvalidClusterStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                    }
                    case "MultiRegionClusterNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterNotFoundException::builder).build());
                    }
                    case "SubnetGroupInUseFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                    }
                    case "InvalidSubnet": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                    }
                    case "ClusterAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                    }
                    case "NoOperationFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoOperationException::builder).build());
                    }
                    case "ShardNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShardNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardNotFoundException::builder).build());
                    }
                    case "ACLNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclNotFoundException::builder).build());
                    }
                    case "SubnetGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                    }
                    case "ReservedNodesOfferingNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodesOfferingNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodesOfferingNotFoundException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "SnapshotAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotAlreadyExistsException::builder).build());
                    }
                    case "SnapshotQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotQuotaExceededException::builder).build());
                    }
                    case "DefaultUserRequired": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DefaultUserRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultUserRequiredException::builder).build());
                    }
                    case "NodeQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                    }
                    case "UserAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserAlreadyExistsException::builder).build());
                    }
                    case "InvalidACLStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidACLStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAclStateException::builder).build());
                    }
                    case "TagNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                    }
                    case "ClusterQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                    }
                    case "APICallRateForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("APICallRateForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiCallRateForCustomerExceededException::builder).build());
                    }
                    case "NodeQuotaForClusterExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                    }
                    case "ServiceUpdateNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUpdateNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUpdateNotFoundException::builder).build());
                    }
                    case "SubnetQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                    }
                    case "ReservedNodeQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeQuotaExceededException::builder).build());
                    }
                    case "InvalidSnapshotStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnapshotStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnapshotStateException::builder).build());
                    }
                    case "InvalidNodeStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNodeStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNodeStateException::builder).build());
                    }
                    case "ShardsPerClusterQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShardsPerClusterQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardsPerClusterQuotaExceededException::builder).build());
                    }
                    case "ReservedNodeAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeAlreadyExistsException::builder).build());
                    }
                    case "ReservedNodeNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeNotFoundException::builder).build());
                    }
                    case "InvalidParameterCombinationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                    }
                    case "InvalidUserStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserStateException::builder).build());
                    }
                    case "SnapshotNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                    }
                    case "MultiRegionParameterGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionParameterGroupNotFoundException::builder).build());
                    }
                    case "ACLAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclAlreadyExistsException::builder).build());
                    }
                    case "InsufficientClusterCapacityFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                    }
                    case "UserQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserQuotaExceededException::builder).build());
                    }
                    case "TagQuotaPerResourceExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                    }
                    case "InvalidMultiRegionClusterStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMultiRegionClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMultiRegionClusterStateException::builder).build());
                    }
                    case "SubnetGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateUser").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateUserRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createUserRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMemoryDbAsyncClient.lambda$createUser$34(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMemoryDbAsyncClient.lambda$createUser$35((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteAclResponse> deleteACL(DeleteAclRequest deleteAclRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteAclRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMemoryDbAsyncClient.resolveMetricPublishers(clientConfiguration, deleteAclRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MemoryDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteACL");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteAclResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "SubnetGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                    }
                    case "ParameterGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                    }
                    case "SubnetInUse": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                    }
                    case "InvalidARNFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "TestFailoverNotAvailableFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TestFailoverNotAvailableFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TestFailoverNotAvailableException::builder).build());
                    }
                    case "ACLQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclQuotaExceededException::builder).build());
                    }
                    case "InvalidKMSKeyFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKMSKeyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyException::builder).build());
                    }
                    case "DuplicateUserNameFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateUserNameFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateUserNameException::builder).build());
                    }
                    case "SubnetNotAllowedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotAllowedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotAllowedException::builder).build());
                    }
                    case "InvalidVPCNetworkStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                    }
                    case "InvalidParameterGroupStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                    }
                    case "ParameterGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                    }
                    case "ServiceLinkedRoleNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                    }
                    case "ParameterGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                    }
                    case "UserNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                    }
                    case "ClusterNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                    }
                    case "MultiRegionClusterAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterAlreadyExistsException::builder).build());
                    }
                    case "InvalidCredentialsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCredentialsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCredentialsException::builder).build());
                    }
                    case "InvalidClusterStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                    }
                    case "MultiRegionClusterNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterNotFoundException::builder).build());
                    }
                    case "SubnetGroupInUseFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                    }
                    case "InvalidSubnet": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                    }
                    case "ClusterAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                    }
                    case "NoOperationFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoOperationException::builder).build());
                    }
                    case "ShardNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShardNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardNotFoundException::builder).build());
                    }
                    case "ACLNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclNotFoundException::builder).build());
                    }
                    case "SubnetGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                    }
                    case "ReservedNodesOfferingNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodesOfferingNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodesOfferingNotFoundException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "SnapshotAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotAlreadyExistsException::builder).build());
                    }
                    case "SnapshotQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotQuotaExceededException::builder).build());
                    }
                    case "DefaultUserRequired": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DefaultUserRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultUserRequiredException::builder).build());
                    }
                    case "NodeQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                    }
                    case "UserAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserAlreadyExistsException::builder).build());
                    }
                    case "InvalidACLStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidACLStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAclStateException::builder).build());
                    }
                    case "TagNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                    }
                    case "ClusterQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                    }
                    case "APICallRateForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("APICallRateForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiCallRateForCustomerExceededException::builder).build());
                    }
                    case "NodeQuotaForClusterExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                    }
                    case "ServiceUpdateNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUpdateNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUpdateNotFoundException::builder).build());
                    }
                    case "SubnetQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                    }
                    case "ReservedNodeQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeQuotaExceededException::builder).build());
                    }
                    case "InvalidSnapshotStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnapshotStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnapshotStateException::builder).build());
                    }
                    case "InvalidNodeStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNodeStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNodeStateException::builder).build());
                    }
                    case "ShardsPerClusterQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShardsPerClusterQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardsPerClusterQuotaExceededException::builder).build());
                    }
                    case "ReservedNodeAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeAlreadyExistsException::builder).build());
                    }
                    case "ReservedNodeNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeNotFoundException::builder).build());
                    }
                    case "InvalidParameterCombinationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                    }
                    case "InvalidUserStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserStateException::builder).build());
                    }
                    case "SnapshotNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                    }
                    case "MultiRegionParameterGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionParameterGroupNotFoundException::builder).build());
                    }
                    case "ACLAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclAlreadyExistsException::builder).build());
                    }
                    case "InsufficientClusterCapacityFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                    }
                    case "UserQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserQuotaExceededException::builder).build());
                    }
                    case "TagQuotaPerResourceExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                    }
                    case "InvalidMultiRegionClusterStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMultiRegionClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMultiRegionClusterStateException::builder).build());
                    }
                    case "SubnetGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteACL").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteAclRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteAclRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMemoryDbAsyncClient.lambda$deleteACL$38(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMemoryDbAsyncClient.lambda$deleteACL$39((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteClusterResponse> deleteCluster(DeleteClusterRequest deleteClusterRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteClusterRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMemoryDbAsyncClient.resolveMetricPublishers(clientConfiguration, deleteClusterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MemoryDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteCluster");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteClusterResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "SubnetGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                    }
                    case "ParameterGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                    }
                    case "SubnetInUse": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                    }
                    case "InvalidARNFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "TestFailoverNotAvailableFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TestFailoverNotAvailableFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TestFailoverNotAvailableException::builder).build());
                    }
                    case "ACLQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclQuotaExceededException::builder).build());
                    }
                    case "InvalidKMSKeyFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKMSKeyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyException::builder).build());
                    }
                    case "DuplicateUserNameFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateUserNameFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateUserNameException::builder).build());
                    }
                    case "SubnetNotAllowedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotAllowedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotAllowedException::builder).build());
                    }
                    case "InvalidVPCNetworkStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                    }
                    case "InvalidParameterGroupStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                    }
                    case "ParameterGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                    }
                    case "ServiceLinkedRoleNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                    }
                    case "ParameterGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                    }
                    case "UserNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                    }
                    case "ClusterNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                    }
                    case "MultiRegionClusterAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterAlreadyExistsException::builder).build());
                    }
                    case "InvalidCredentialsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCredentialsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCredentialsException::builder).build());
                    }
                    case "InvalidClusterStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                    }
                    case "MultiRegionClusterNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterNotFoundException::builder).build());
                    }
                    case "SubnetGroupInUseFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                    }
                    case "InvalidSubnet": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                    }
                    case "ClusterAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                    }
                    case "NoOperationFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoOperationException::builder).build());
                    }
                    case "ShardNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShardNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardNotFoundException::builder).build());
                    }
                    case "ACLNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclNotFoundException::builder).build());
                    }
                    case "SubnetGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                    }
                    case "ReservedNodesOfferingNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodesOfferingNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodesOfferingNotFoundException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "SnapshotAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotAlreadyExistsException::builder).build());
                    }
                    case "SnapshotQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotQuotaExceededException::builder).build());
                    }
                    case "DefaultUserRequired": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DefaultUserRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultUserRequiredException::builder).build());
                    }
                    case "NodeQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                    }
                    case "UserAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserAlreadyExistsException::builder).build());
                    }
                    case "InvalidACLStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidACLStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAclStateException::builder).build());
                    }
                    case "TagNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                    }
                    case "ClusterQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                    }
                    case "APICallRateForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("APICallRateForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiCallRateForCustomerExceededException::builder).build());
                    }
                    case "NodeQuotaForClusterExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                    }
                    case "ServiceUpdateNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUpdateNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUpdateNotFoundException::builder).build());
                    }
                    case "SubnetQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                    }
                    case "ReservedNodeQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeQuotaExceededException::builder).build());
                    }
                    case "InvalidSnapshotStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnapshotStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnapshotStateException::builder).build());
                    }
                    case "InvalidNodeStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNodeStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNodeStateException::builder).build());
                    }
                    case "ShardsPerClusterQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShardsPerClusterQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardsPerClusterQuotaExceededException::builder).build());
                    }
                    case "ReservedNodeAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeAlreadyExistsException::builder).build());
                    }
                    case "ReservedNodeNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeNotFoundException::builder).build());
                    }
                    case "InvalidParameterCombinationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                    }
                    case "InvalidUserStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserStateException::builder).build());
                    }
                    case "SnapshotNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                    }
                    case "MultiRegionParameterGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionParameterGroupNotFoundException::builder).build());
                    }
                    case "ACLAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclAlreadyExistsException::builder).build());
                    }
                    case "InsufficientClusterCapacityFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                    }
                    case "UserQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserQuotaExceededException::builder).build());
                    }
                    case "TagQuotaPerResourceExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                    }
                    case "InvalidMultiRegionClusterStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMultiRegionClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMultiRegionClusterStateException::builder).build());
                    }
                    case "SubnetGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteCluster").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteClusterRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteClusterRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMemoryDbAsyncClient.lambda$deleteCluster$42(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMemoryDbAsyncClient.lambda$deleteCluster$43((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteMultiRegionClusterResponse> deleteMultiRegionCluster(DeleteMultiRegionClusterRequest deleteMultiRegionClusterRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteMultiRegionClusterRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMemoryDbAsyncClient.resolveMetricPublishers(clientConfiguration, deleteMultiRegionClusterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MemoryDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteMultiRegionCluster");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteMultiRegionClusterResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "SubnetGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                    }
                    case "ParameterGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                    }
                    case "SubnetInUse": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                    }
                    case "InvalidARNFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "TestFailoverNotAvailableFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TestFailoverNotAvailableFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TestFailoverNotAvailableException::builder).build());
                    }
                    case "ACLQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclQuotaExceededException::builder).build());
                    }
                    case "InvalidKMSKeyFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKMSKeyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyException::builder).build());
                    }
                    case "DuplicateUserNameFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateUserNameFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateUserNameException::builder).build());
                    }
                    case "SubnetNotAllowedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotAllowedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotAllowedException::builder).build());
                    }
                    case "InvalidVPCNetworkStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                    }
                    case "InvalidParameterGroupStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                    }
                    case "ParameterGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                    }
                    case "ServiceLinkedRoleNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                    }
                    case "ParameterGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                    }
                    case "UserNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                    }
                    case "ClusterNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                    }
                    case "MultiRegionClusterAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterAlreadyExistsException::builder).build());
                    }
                    case "InvalidCredentialsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCredentialsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCredentialsException::builder).build());
                    }
                    case "InvalidClusterStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                    }
                    case "MultiRegionClusterNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterNotFoundException::builder).build());
                    }
                    case "SubnetGroupInUseFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                    }
                    case "InvalidSubnet": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                    }
                    case "ClusterAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                    }
                    case "NoOperationFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoOperationException::builder).build());
                    }
                    case "ShardNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShardNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardNotFoundException::builder).build());
                    }
                    case "ACLNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclNotFoundException::builder).build());
                    }
                    case "SubnetGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                    }
                    case "ReservedNodesOfferingNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodesOfferingNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodesOfferingNotFoundException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "SnapshotAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotAlreadyExistsException::builder).build());
                    }
                    case "SnapshotQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotQuotaExceededException::builder).build());
                    }
                    case "DefaultUserRequired": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DefaultUserRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultUserRequiredException::builder).build());
                    }
                    case "NodeQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                    }
                    case "UserAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserAlreadyExistsException::builder).build());
                    }
                    case "InvalidACLStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidACLStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAclStateException::builder).build());
                    }
                    case "TagNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                    }
                    case "ClusterQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                    }
                    case "APICallRateForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("APICallRateForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiCallRateForCustomerExceededException::builder).build());
                    }
                    case "NodeQuotaForClusterExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                    }
                    case "ServiceUpdateNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUpdateNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUpdateNotFoundException::builder).build());
                    }
                    case "SubnetQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                    }
                    case "ReservedNodeQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeQuotaExceededException::builder).build());
                    }
                    case "InvalidSnapshotStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnapshotStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnapshotStateException::builder).build());
                    }
                    case "InvalidNodeStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNodeStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNodeStateException::builder).build());
                    }
                    case "ShardsPerClusterQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShardsPerClusterQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardsPerClusterQuotaExceededException::builder).build());
                    }
                    case "ReservedNodeAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeAlreadyExistsException::builder).build());
                    }
                    case "ReservedNodeNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeNotFoundException::builder).build());
                    }
                    case "InvalidParameterCombinationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                    }
                    case "InvalidUserStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserStateException::builder).build());
                    }
                    case "SnapshotNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                    }
                    case "MultiRegionParameterGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionParameterGroupNotFoundException::builder).build());
                    }
                    case "ACLAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclAlreadyExistsException::builder).build());
                    }
                    case "InsufficientClusterCapacityFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                    }
                    case "UserQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserQuotaExceededException::builder).build());
                    }
                    case "TagQuotaPerResourceExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                    }
                    case "InvalidMultiRegionClusterStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMultiRegionClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMultiRegionClusterStateException::builder).build());
                    }
                    case "SubnetGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteMultiRegionCluster").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteMultiRegionClusterRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteMultiRegionClusterRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMemoryDbAsyncClient.lambda$deleteMultiRegionCluster$46(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMemoryDbAsyncClient.lambda$deleteMultiRegionCluster$47((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteParameterGroupResponse> deleteParameterGroup(DeleteParameterGroupRequest deleteParameterGroupRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteParameterGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMemoryDbAsyncClient.resolveMetricPublishers(clientConfiguration, deleteParameterGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MemoryDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteParameterGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteParameterGroupResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "SubnetGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                    }
                    case "ParameterGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                    }
                    case "SubnetInUse": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                    }
                    case "InvalidARNFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "TestFailoverNotAvailableFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TestFailoverNotAvailableFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TestFailoverNotAvailableException::builder).build());
                    }
                    case "ACLQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclQuotaExceededException::builder).build());
                    }
                    case "InvalidKMSKeyFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKMSKeyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyException::builder).build());
                    }
                    case "DuplicateUserNameFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateUserNameFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateUserNameException::builder).build());
                    }
                    case "SubnetNotAllowedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotAllowedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotAllowedException::builder).build());
                    }
                    case "InvalidVPCNetworkStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                    }
                    case "InvalidParameterGroupStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                    }
                    case "ParameterGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                    }
                    case "ServiceLinkedRoleNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                    }
                    case "ParameterGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                    }
                    case "UserNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                    }
                    case "ClusterNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                    }
                    case "MultiRegionClusterAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterAlreadyExistsException::builder).build());
                    }
                    case "InvalidCredentialsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCredentialsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCredentialsException::builder).build());
                    }
                    case "InvalidClusterStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                    }
                    case "MultiRegionClusterNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterNotFoundException::builder).build());
                    }
                    case "SubnetGroupInUseFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                    }
                    case "InvalidSubnet": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                    }
                    case "ClusterAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                    }
                    case "NoOperationFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoOperationException::builder).build());
                    }
                    case "ShardNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShardNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardNotFoundException::builder).build());
                    }
                    case "ACLNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclNotFoundException::builder).build());
                    }
                    case "SubnetGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                    }
                    case "ReservedNodesOfferingNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodesOfferingNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodesOfferingNotFoundException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "SnapshotAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotAlreadyExistsException::builder).build());
                    }
                    case "SnapshotQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotQuotaExceededException::builder).build());
                    }
                    case "DefaultUserRequired": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DefaultUserRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultUserRequiredException::builder).build());
                    }
                    case "NodeQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                    }
                    case "UserAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserAlreadyExistsException::builder).build());
                    }
                    case "InvalidACLStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidACLStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAclStateException::builder).build());
                    }
                    case "TagNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                    }
                    case "ClusterQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                    }
                    case "APICallRateForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("APICallRateForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiCallRateForCustomerExceededException::builder).build());
                    }
                    case "NodeQuotaForClusterExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                    }
                    case "ServiceUpdateNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUpdateNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUpdateNotFoundException::builder).build());
                    }
                    case "SubnetQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                    }
                    case "ReservedNodeQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeQuotaExceededException::builder).build());
                    }
                    case "InvalidSnapshotStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnapshotStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnapshotStateException::builder).build());
                    }
                    case "InvalidNodeStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNodeStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNodeStateException::builder).build());
                    }
                    case "ShardsPerClusterQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShardsPerClusterQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardsPerClusterQuotaExceededException::builder).build());
                    }
                    case "ReservedNodeAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeAlreadyExistsException::builder).build());
                    }
                    case "ReservedNodeNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeNotFoundException::builder).build());
                    }
                    case "InvalidParameterCombinationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                    }
                    case "InvalidUserStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserStateException::builder).build());
                    }
                    case "SnapshotNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                    }
                    case "MultiRegionParameterGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionParameterGroupNotFoundException::builder).build());
                    }
                    case "ACLAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclAlreadyExistsException::builder).build());
                    }
                    case "InsufficientClusterCapacityFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                    }
                    case "UserQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserQuotaExceededException::builder).build());
                    }
                    case "TagQuotaPerResourceExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                    }
                    case "InvalidMultiRegionClusterStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMultiRegionClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMultiRegionClusterStateException::builder).build());
                    }
                    case "SubnetGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteParameterGroup").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteParameterGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteParameterGroupRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMemoryDbAsyncClient.lambda$deleteParameterGroup$50(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMemoryDbAsyncClient.lambda$deleteParameterGroup$51((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteSnapshotResponse> deleteSnapshot(DeleteSnapshotRequest deleteSnapshotRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteSnapshotRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMemoryDbAsyncClient.resolveMetricPublishers(clientConfiguration, deleteSnapshotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MemoryDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteSnapshot");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteSnapshotResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "SubnetGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                    }
                    case "ParameterGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                    }
                    case "SubnetInUse": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                    }
                    case "InvalidARNFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "TestFailoverNotAvailableFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TestFailoverNotAvailableFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TestFailoverNotAvailableException::builder).build());
                    }
                    case "ACLQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclQuotaExceededException::builder).build());
                    }
                    case "InvalidKMSKeyFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKMSKeyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyException::builder).build());
                    }
                    case "DuplicateUserNameFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateUserNameFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateUserNameException::builder).build());
                    }
                    case "SubnetNotAllowedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotAllowedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotAllowedException::builder).build());
                    }
                    case "InvalidVPCNetworkStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                    }
                    case "InvalidParameterGroupStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                    }
                    case "ParameterGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                    }
                    case "ServiceLinkedRoleNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                    }
                    case "ParameterGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                    }
                    case "UserNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                    }
                    case "ClusterNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                    }
                    case "MultiRegionClusterAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterAlreadyExistsException::builder).build());
                    }
                    case "InvalidCredentialsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCredentialsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCredentialsException::builder).build());
                    }
                    case "InvalidClusterStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                    }
                    case "MultiRegionClusterNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterNotFoundException::builder).build());
                    }
                    case "SubnetGroupInUseFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                    }
                    case "InvalidSubnet": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                    }
                    case "ClusterAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                    }
                    case "NoOperationFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoOperationException::builder).build());
                    }
                    case "ShardNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShardNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardNotFoundException::builder).build());
                    }
                    case "ACLNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclNotFoundException::builder).build());
                    }
                    case "SubnetGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                    }
                    case "ReservedNodesOfferingNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodesOfferingNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodesOfferingNotFoundException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "SnapshotAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotAlreadyExistsException::builder).build());
                    }
                    case "SnapshotQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotQuotaExceededException::builder).build());
                    }
                    case "DefaultUserRequired": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DefaultUserRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultUserRequiredException::builder).build());
                    }
                    case "NodeQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                    }
                    case "UserAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserAlreadyExistsException::builder).build());
                    }
                    case "InvalidACLStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidACLStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAclStateException::builder).build());
                    }
                    case "TagNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                    }
                    case "ClusterQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                    }
                    case "APICallRateForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("APICallRateForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiCallRateForCustomerExceededException::builder).build());
                    }
                    case "NodeQuotaForClusterExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                    }
                    case "ServiceUpdateNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUpdateNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUpdateNotFoundException::builder).build());
                    }
                    case "SubnetQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                    }
                    case "ReservedNodeQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeQuotaExceededException::builder).build());
                    }
                    case "InvalidSnapshotStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnapshotStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnapshotStateException::builder).build());
                    }
                    case "InvalidNodeStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNodeStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNodeStateException::builder).build());
                    }
                    case "ShardsPerClusterQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShardsPerClusterQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardsPerClusterQuotaExceededException::builder).build());
                    }
                    case "ReservedNodeAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeAlreadyExistsException::builder).build());
                    }
                    case "ReservedNodeNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeNotFoundException::builder).build());
                    }
                    case "InvalidParameterCombinationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                    }
                    case "InvalidUserStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserStateException::builder).build());
                    }
                    case "SnapshotNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                    }
                    case "MultiRegionParameterGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionParameterGroupNotFoundException::builder).build());
                    }
                    case "ACLAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclAlreadyExistsException::builder).build());
                    }
                    case "InsufficientClusterCapacityFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                    }
                    case "UserQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserQuotaExceededException::builder).build());
                    }
                    case "TagQuotaPerResourceExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                    }
                    case "InvalidMultiRegionClusterStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMultiRegionClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMultiRegionClusterStateException::builder).build());
                    }
                    case "SubnetGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteSnapshot").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteSnapshotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteSnapshotRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMemoryDbAsyncClient.lambda$deleteSnapshot$54(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMemoryDbAsyncClient.lambda$deleteSnapshot$55((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteSubnetGroupResponse> deleteSubnetGroup(DeleteSubnetGroupRequest deleteSubnetGroupRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteSubnetGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMemoryDbAsyncClient.resolveMetricPublishers(clientConfiguration, deleteSubnetGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MemoryDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteSubnetGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteSubnetGroupResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "SubnetGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                    }
                    case "ParameterGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                    }
                    case "SubnetInUse": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                    }
                    case "InvalidARNFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "TestFailoverNotAvailableFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TestFailoverNotAvailableFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TestFailoverNotAvailableException::builder).build());
                    }
                    case "ACLQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclQuotaExceededException::builder).build());
                    }
                    case "InvalidKMSKeyFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKMSKeyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyException::builder).build());
                    }
                    case "DuplicateUserNameFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateUserNameFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateUserNameException::builder).build());
                    }
                    case "SubnetNotAllowedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotAllowedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotAllowedException::builder).build());
                    }
                    case "InvalidVPCNetworkStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                    }
                    case "InvalidParameterGroupStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                    }
                    case "ParameterGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                    }
                    case "ServiceLinkedRoleNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                    }
                    case "ParameterGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                    }
                    case "UserNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                    }
                    case "ClusterNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                    }
                    case "MultiRegionClusterAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterAlreadyExistsException::builder).build());
                    }
                    case "InvalidCredentialsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCredentialsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCredentialsException::builder).build());
                    }
                    case "InvalidClusterStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                    }
                    case "MultiRegionClusterNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterNotFoundException::builder).build());
                    }
                    case "SubnetGroupInUseFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                    }
                    case "InvalidSubnet": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                    }
                    case "ClusterAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                    }
                    case "NoOperationFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoOperationException::builder).build());
                    }
                    case "ShardNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShardNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardNotFoundException::builder).build());
                    }
                    case "ACLNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclNotFoundException::builder).build());
                    }
                    case "SubnetGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                    }
                    case "ReservedNodesOfferingNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodesOfferingNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodesOfferingNotFoundException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "SnapshotAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotAlreadyExistsException::builder).build());
                    }
                    case "SnapshotQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotQuotaExceededException::builder).build());
                    }
                    case "DefaultUserRequired": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DefaultUserRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultUserRequiredException::builder).build());
                    }
                    case "NodeQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                    }
                    case "UserAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserAlreadyExistsException::builder).build());
                    }
                    case "InvalidACLStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidACLStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAclStateException::builder).build());
                    }
                    case "TagNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                    }
                    case "ClusterQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                    }
                    case "APICallRateForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("APICallRateForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiCallRateForCustomerExceededException::builder).build());
                    }
                    case "NodeQuotaForClusterExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                    }
                    case "ServiceUpdateNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUpdateNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUpdateNotFoundException::builder).build());
                    }
                    case "SubnetQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                    }
                    case "ReservedNodeQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeQuotaExceededException::builder).build());
                    }
                    case "InvalidSnapshotStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnapshotStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnapshotStateException::builder).build());
                    }
                    case "InvalidNodeStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNodeStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNodeStateException::builder).build());
                    }
                    case "ShardsPerClusterQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShardsPerClusterQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardsPerClusterQuotaExceededException::builder).build());
                    }
                    case "ReservedNodeAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeAlreadyExistsException::builder).build());
                    }
                    case "ReservedNodeNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeNotFoundException::builder).build());
                    }
                    case "InvalidParameterCombinationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                    }
                    case "InvalidUserStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserStateException::builder).build());
                    }
                    case "SnapshotNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                    }
                    case "MultiRegionParameterGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionParameterGroupNotFoundException::builder).build());
                    }
                    case "ACLAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclAlreadyExistsException::builder).build());
                    }
                    case "InsufficientClusterCapacityFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                    }
                    case "UserQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserQuotaExceededException::builder).build());
                    }
                    case "TagQuotaPerResourceExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                    }
                    case "InvalidMultiRegionClusterStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMultiRegionClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMultiRegionClusterStateException::builder).build());
                    }
                    case "SubnetGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteSubnetGroup").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteSubnetGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteSubnetGroupRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMemoryDbAsyncClient.lambda$deleteSubnetGroup$58(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMemoryDbAsyncClient.lambda$deleteSubnetGroup$59((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteUserResponse> deleteUser(DeleteUserRequest deleteUserRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteUserRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMemoryDbAsyncClient.resolveMetricPublishers(clientConfiguration, deleteUserRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MemoryDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteUser");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteUserResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "SubnetGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                    }
                    case "ParameterGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                    }
                    case "SubnetInUse": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                    }
                    case "InvalidARNFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "TestFailoverNotAvailableFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TestFailoverNotAvailableFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TestFailoverNotAvailableException::builder).build());
                    }
                    case "ACLQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclQuotaExceededException::builder).build());
                    }
                    case "InvalidKMSKeyFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKMSKeyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyException::builder).build());
                    }
                    case "DuplicateUserNameFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateUserNameFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateUserNameException::builder).build());
                    }
                    case "SubnetNotAllowedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotAllowedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotAllowedException::builder).build());
                    }
                    case "InvalidVPCNetworkStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                    }
                    case "InvalidParameterGroupStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                    }
                    case "ParameterGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                    }
                    case "ServiceLinkedRoleNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                    }
                    case "ParameterGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                    }
                    case "UserNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                    }
                    case "ClusterNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                    }
                    case "MultiRegionClusterAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterAlreadyExistsException::builder).build());
                    }
                    case "InvalidCredentialsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCredentialsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCredentialsException::builder).build());
                    }
                    case "InvalidClusterStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                    }
                    case "MultiRegionClusterNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterNotFoundException::builder).build());
                    }
                    case "SubnetGroupInUseFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                    }
                    case "InvalidSubnet": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                    }
                    case "ClusterAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                    }
                    case "NoOperationFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoOperationException::builder).build());
                    }
                    case "ShardNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShardNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardNotFoundException::builder).build());
                    }
                    case "ACLNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclNotFoundException::builder).build());
                    }
                    case "SubnetGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                    }
                    case "ReservedNodesOfferingNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodesOfferingNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodesOfferingNotFoundException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "SnapshotAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotAlreadyExistsException::builder).build());
                    }
                    case "SnapshotQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotQuotaExceededException::builder).build());
                    }
                    case "DefaultUserRequired": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DefaultUserRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultUserRequiredException::builder).build());
                    }
                    case "NodeQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                    }
                    case "UserAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserAlreadyExistsException::builder).build());
                    }
                    case "InvalidACLStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidACLStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAclStateException::builder).build());
                    }
                    case "TagNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                    }
                    case "ClusterQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                    }
                    case "APICallRateForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("APICallRateForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiCallRateForCustomerExceededException::builder).build());
                    }
                    case "NodeQuotaForClusterExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                    }
                    case "ServiceUpdateNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUpdateNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUpdateNotFoundException::builder).build());
                    }
                    case "SubnetQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                    }
                    case "ReservedNodeQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeQuotaExceededException::builder).build());
                    }
                    case "InvalidSnapshotStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnapshotStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnapshotStateException::builder).build());
                    }
                    case "InvalidNodeStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNodeStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNodeStateException::builder).build());
                    }
                    case "ShardsPerClusterQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShardsPerClusterQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardsPerClusterQuotaExceededException::builder).build());
                    }
                    case "ReservedNodeAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeAlreadyExistsException::builder).build());
                    }
                    case "ReservedNodeNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeNotFoundException::builder).build());
                    }
                    case "InvalidParameterCombinationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                    }
                    case "InvalidUserStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserStateException::builder).build());
                    }
                    case "SnapshotNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                    }
                    case "MultiRegionParameterGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionParameterGroupNotFoundException::builder).build());
                    }
                    case "ACLAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclAlreadyExistsException::builder).build());
                    }
                    case "InsufficientClusterCapacityFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                    }
                    case "UserQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserQuotaExceededException::builder).build());
                    }
                    case "TagQuotaPerResourceExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                    }
                    case "InvalidMultiRegionClusterStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMultiRegionClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMultiRegionClusterStateException::builder).build());
                    }
                    case "SubnetGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteUser").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteUserRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteUserRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMemoryDbAsyncClient.lambda$deleteUser$62(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMemoryDbAsyncClient.lambda$deleteUser$63((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeAcLsResponse> describeACLs(DescribeAcLsRequest describeAcLsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeAcLsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMemoryDbAsyncClient.resolveMetricPublishers(clientConfiguration, describeAcLsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MemoryDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeACLs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeAcLsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "SubnetGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                    }
                    case "ParameterGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                    }
                    case "SubnetInUse": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                    }
                    case "InvalidARNFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "TestFailoverNotAvailableFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TestFailoverNotAvailableFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TestFailoverNotAvailableException::builder).build());
                    }
                    case "ACLQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclQuotaExceededException::builder).build());
                    }
                    case "InvalidKMSKeyFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKMSKeyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyException::builder).build());
                    }
                    case "DuplicateUserNameFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateUserNameFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateUserNameException::builder).build());
                    }
                    case "SubnetNotAllowedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotAllowedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotAllowedException::builder).build());
                    }
                    case "InvalidVPCNetworkStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                    }
                    case "InvalidParameterGroupStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                    }
                    case "ParameterGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                    }
                    case "ServiceLinkedRoleNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                    }
                    case "ParameterGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                    }
                    case "UserNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                    }
                    case "ClusterNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                    }
                    case "MultiRegionClusterAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterAlreadyExistsException::builder).build());
                    }
                    case "InvalidCredentialsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCredentialsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCredentialsException::builder).build());
                    }
                    case "InvalidClusterStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                    }
                    case "MultiRegionClusterNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterNotFoundException::builder).build());
                    }
                    case "SubnetGroupInUseFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                    }
                    case "InvalidSubnet": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                    }
                    case "ClusterAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                    }
                    case "NoOperationFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoOperationException::builder).build());
                    }
                    case "ShardNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShardNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardNotFoundException::builder).build());
                    }
                    case "ACLNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclNotFoundException::builder).build());
                    }
                    case "SubnetGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                    }
                    case "ReservedNodesOfferingNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodesOfferingNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodesOfferingNotFoundException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "SnapshotAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotAlreadyExistsException::builder).build());
                    }
                    case "SnapshotQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotQuotaExceededException::builder).build());
                    }
                    case "DefaultUserRequired": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DefaultUserRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultUserRequiredException::builder).build());
                    }
                    case "NodeQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                    }
                    case "UserAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserAlreadyExistsException::builder).build());
                    }
                    case "InvalidACLStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidACLStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAclStateException::builder).build());
                    }
                    case "TagNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                    }
                    case "ClusterQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                    }
                    case "APICallRateForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("APICallRateForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiCallRateForCustomerExceededException::builder).build());
                    }
                    case "NodeQuotaForClusterExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                    }
                    case "ServiceUpdateNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUpdateNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUpdateNotFoundException::builder).build());
                    }
                    case "SubnetQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                    }
                    case "ReservedNodeQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeQuotaExceededException::builder).build());
                    }
                    case "InvalidSnapshotStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnapshotStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnapshotStateException::builder).build());
                    }
                    case "InvalidNodeStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNodeStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNodeStateException::builder).build());
                    }
                    case "ShardsPerClusterQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShardsPerClusterQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardsPerClusterQuotaExceededException::builder).build());
                    }
                    case "ReservedNodeAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeAlreadyExistsException::builder).build());
                    }
                    case "ReservedNodeNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeNotFoundException::builder).build());
                    }
                    case "InvalidParameterCombinationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                    }
                    case "InvalidUserStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserStateException::builder).build());
                    }
                    case "SnapshotNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                    }
                    case "MultiRegionParameterGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionParameterGroupNotFoundException::builder).build());
                    }
                    case "ACLAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclAlreadyExistsException::builder).build());
                    }
                    case "InsufficientClusterCapacityFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                    }
                    case "UserQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserQuotaExceededException::builder).build());
                    }
                    case "TagQuotaPerResourceExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                    }
                    case "InvalidMultiRegionClusterStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMultiRegionClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMultiRegionClusterStateException::builder).build());
                    }
                    case "SubnetGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeACLs").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeAcLsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeAcLsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMemoryDbAsyncClient.lambda$describeACLs$66(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMemoryDbAsyncClient.lambda$describeACLs$67((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeClustersResponse> describeClusters(DescribeClustersRequest describeClustersRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeClustersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMemoryDbAsyncClient.resolveMetricPublishers(clientConfiguration, describeClustersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MemoryDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeClusters");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeClustersResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "SubnetGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                    }
                    case "ParameterGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                    }
                    case "SubnetInUse": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                    }
                    case "InvalidARNFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "TestFailoverNotAvailableFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TestFailoverNotAvailableFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TestFailoverNotAvailableException::builder).build());
                    }
                    case "ACLQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclQuotaExceededException::builder).build());
                    }
                    case "InvalidKMSKeyFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKMSKeyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyException::builder).build());
                    }
                    case "DuplicateUserNameFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateUserNameFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateUserNameException::builder).build());
                    }
                    case "SubnetNotAllowedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotAllowedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotAllowedException::builder).build());
                    }
                    case "InvalidVPCNetworkStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                    }
                    case "InvalidParameterGroupStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                    }
                    case "ParameterGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                    }
                    case "ServiceLinkedRoleNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                    }
                    case "ParameterGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                    }
                    case "UserNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                    }
                    case "ClusterNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                    }
                    case "MultiRegionClusterAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterAlreadyExistsException::builder).build());
                    }
                    case "InvalidCredentialsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCredentialsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCredentialsException::builder).build());
                    }
                    case "InvalidClusterStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                    }
                    case "MultiRegionClusterNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterNotFoundException::builder).build());
                    }
                    case "SubnetGroupInUseFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                    }
                    case "InvalidSubnet": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                    }
                    case "ClusterAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                    }
                    case "NoOperationFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoOperationException::builder).build());
                    }
                    case "ShardNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShardNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardNotFoundException::builder).build());
                    }
                    case "ACLNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclNotFoundException::builder).build());
                    }
                    case "SubnetGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                    }
                    case "ReservedNodesOfferingNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodesOfferingNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodesOfferingNotFoundException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "SnapshotAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotAlreadyExistsException::builder).build());
                    }
                    case "SnapshotQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotQuotaExceededException::builder).build());
                    }
                    case "DefaultUserRequired": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DefaultUserRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultUserRequiredException::builder).build());
                    }
                    case "NodeQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                    }
                    case "UserAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserAlreadyExistsException::builder).build());
                    }
                    case "InvalidACLStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidACLStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAclStateException::builder).build());
                    }
                    case "TagNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                    }
                    case "ClusterQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                    }
                    case "APICallRateForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("APICallRateForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiCallRateForCustomerExceededException::builder).build());
                    }
                    case "NodeQuotaForClusterExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                    }
                    case "ServiceUpdateNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUpdateNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUpdateNotFoundException::builder).build());
                    }
                    case "SubnetQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                    }
                    case "ReservedNodeQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeQuotaExceededException::builder).build());
                    }
                    case "InvalidSnapshotStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnapshotStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnapshotStateException::builder).build());
                    }
                    case "InvalidNodeStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNodeStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNodeStateException::builder).build());
                    }
                    case "ShardsPerClusterQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShardsPerClusterQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardsPerClusterQuotaExceededException::builder).build());
                    }
                    case "ReservedNodeAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeAlreadyExistsException::builder).build());
                    }
                    case "ReservedNodeNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeNotFoundException::builder).build());
                    }
                    case "InvalidParameterCombinationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                    }
                    case "InvalidUserStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserStateException::builder).build());
                    }
                    case "SnapshotNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                    }
                    case "MultiRegionParameterGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionParameterGroupNotFoundException::builder).build());
                    }
                    case "ACLAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclAlreadyExistsException::builder).build());
                    }
                    case "InsufficientClusterCapacityFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                    }
                    case "UserQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserQuotaExceededException::builder).build());
                    }
                    case "TagQuotaPerResourceExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                    }
                    case "InvalidMultiRegionClusterStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMultiRegionClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMultiRegionClusterStateException::builder).build());
                    }
                    case "SubnetGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeClusters").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeClustersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeClustersRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMemoryDbAsyncClient.lambda$describeClusters$70(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMemoryDbAsyncClient.lambda$describeClusters$71((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeEngineVersionsResponse> describeEngineVersions(DescribeEngineVersionsRequest describeEngineVersionsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeEngineVersionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMemoryDbAsyncClient.resolveMetricPublishers(clientConfiguration, describeEngineVersionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MemoryDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeEngineVersions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeEngineVersionsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "SubnetGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                    }
                    case "ParameterGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                    }
                    case "SubnetInUse": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                    }
                    case "InvalidARNFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "TestFailoverNotAvailableFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TestFailoverNotAvailableFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TestFailoverNotAvailableException::builder).build());
                    }
                    case "ACLQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclQuotaExceededException::builder).build());
                    }
                    case "InvalidKMSKeyFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKMSKeyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyException::builder).build());
                    }
                    case "DuplicateUserNameFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateUserNameFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateUserNameException::builder).build());
                    }
                    case "SubnetNotAllowedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotAllowedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotAllowedException::builder).build());
                    }
                    case "InvalidVPCNetworkStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                    }
                    case "InvalidParameterGroupStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                    }
                    case "ParameterGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                    }
                    case "ServiceLinkedRoleNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                    }
                    case "ParameterGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                    }
                    case "UserNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                    }
                    case "ClusterNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                    }
                    case "MultiRegionClusterAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterAlreadyExistsException::builder).build());
                    }
                    case "InvalidCredentialsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCredentialsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCredentialsException::builder).build());
                    }
                    case "InvalidClusterStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                    }
                    case "MultiRegionClusterNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterNotFoundException::builder).build());
                    }
                    case "SubnetGroupInUseFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                    }
                    case "InvalidSubnet": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                    }
                    case "ClusterAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                    }
                    case "NoOperationFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoOperationException::builder).build());
                    }
                    case "ShardNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShardNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardNotFoundException::builder).build());
                    }
                    case "ACLNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclNotFoundException::builder).build());
                    }
                    case "SubnetGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                    }
                    case "ReservedNodesOfferingNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodesOfferingNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodesOfferingNotFoundException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "SnapshotAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotAlreadyExistsException::builder).build());
                    }
                    case "SnapshotQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotQuotaExceededException::builder).build());
                    }
                    case "DefaultUserRequired": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DefaultUserRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultUserRequiredException::builder).build());
                    }
                    case "NodeQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                    }
                    case "UserAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserAlreadyExistsException::builder).build());
                    }
                    case "InvalidACLStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidACLStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAclStateException::builder).build());
                    }
                    case "TagNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                    }
                    case "ClusterQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                    }
                    case "APICallRateForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("APICallRateForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiCallRateForCustomerExceededException::builder).build());
                    }
                    case "NodeQuotaForClusterExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                    }
                    case "ServiceUpdateNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUpdateNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUpdateNotFoundException::builder).build());
                    }
                    case "SubnetQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                    }
                    case "ReservedNodeQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeQuotaExceededException::builder).build());
                    }
                    case "InvalidSnapshotStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnapshotStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnapshotStateException::builder).build());
                    }
                    case "InvalidNodeStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNodeStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNodeStateException::builder).build());
                    }
                    case "ShardsPerClusterQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShardsPerClusterQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardsPerClusterQuotaExceededException::builder).build());
                    }
                    case "ReservedNodeAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeAlreadyExistsException::builder).build());
                    }
                    case "ReservedNodeNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeNotFoundException::builder).build());
                    }
                    case "InvalidParameterCombinationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                    }
                    case "InvalidUserStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserStateException::builder).build());
                    }
                    case "SnapshotNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                    }
                    case "MultiRegionParameterGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionParameterGroupNotFoundException::builder).build());
                    }
                    case "ACLAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclAlreadyExistsException::builder).build());
                    }
                    case "InsufficientClusterCapacityFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                    }
                    case "UserQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserQuotaExceededException::builder).build());
                    }
                    case "TagQuotaPerResourceExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                    }
                    case "InvalidMultiRegionClusterStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMultiRegionClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMultiRegionClusterStateException::builder).build());
                    }
                    case "SubnetGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeEngineVersions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeEngineVersionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeEngineVersionsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMemoryDbAsyncClient.lambda$describeEngineVersions$74(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMemoryDbAsyncClient.lambda$describeEngineVersions$75((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeEventsResponse> describeEvents(DescribeEventsRequest describeEventsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeEventsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMemoryDbAsyncClient.resolveMetricPublishers(clientConfiguration, describeEventsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MemoryDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeEvents");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeEventsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "SubnetGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                    }
                    case "ParameterGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                    }
                    case "SubnetInUse": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                    }
                    case "InvalidARNFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "TestFailoverNotAvailableFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TestFailoverNotAvailableFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TestFailoverNotAvailableException::builder).build());
                    }
                    case "ACLQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclQuotaExceededException::builder).build());
                    }
                    case "InvalidKMSKeyFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKMSKeyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyException::builder).build());
                    }
                    case "DuplicateUserNameFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateUserNameFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateUserNameException::builder).build());
                    }
                    case "SubnetNotAllowedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotAllowedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotAllowedException::builder).build());
                    }
                    case "InvalidVPCNetworkStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                    }
                    case "InvalidParameterGroupStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                    }
                    case "ParameterGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                    }
                    case "ServiceLinkedRoleNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                    }
                    case "ParameterGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                    }
                    case "UserNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                    }
                    case "ClusterNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                    }
                    case "MultiRegionClusterAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterAlreadyExistsException::builder).build());
                    }
                    case "InvalidCredentialsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCredentialsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCredentialsException::builder).build());
                    }
                    case "InvalidClusterStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                    }
                    case "MultiRegionClusterNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterNotFoundException::builder).build());
                    }
                    case "SubnetGroupInUseFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                    }
                    case "InvalidSubnet": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                    }
                    case "ClusterAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                    }
                    case "NoOperationFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoOperationException::builder).build());
                    }
                    case "ShardNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShardNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardNotFoundException::builder).build());
                    }
                    case "ACLNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclNotFoundException::builder).build());
                    }
                    case "SubnetGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                    }
                    case "ReservedNodesOfferingNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodesOfferingNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodesOfferingNotFoundException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "SnapshotAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotAlreadyExistsException::builder).build());
                    }
                    case "SnapshotQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotQuotaExceededException::builder).build());
                    }
                    case "DefaultUserRequired": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DefaultUserRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultUserRequiredException::builder).build());
                    }
                    case "NodeQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                    }
                    case "UserAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserAlreadyExistsException::builder).build());
                    }
                    case "InvalidACLStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidACLStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAclStateException::builder).build());
                    }
                    case "TagNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                    }
                    case "ClusterQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                    }
                    case "APICallRateForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("APICallRateForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiCallRateForCustomerExceededException::builder).build());
                    }
                    case "NodeQuotaForClusterExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                    }
                    case "ServiceUpdateNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUpdateNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUpdateNotFoundException::builder).build());
                    }
                    case "SubnetQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                    }
                    case "ReservedNodeQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeQuotaExceededException::builder).build());
                    }
                    case "InvalidSnapshotStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnapshotStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnapshotStateException::builder).build());
                    }
                    case "InvalidNodeStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNodeStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNodeStateException::builder).build());
                    }
                    case "ShardsPerClusterQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShardsPerClusterQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardsPerClusterQuotaExceededException::builder).build());
                    }
                    case "ReservedNodeAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeAlreadyExistsException::builder).build());
                    }
                    case "ReservedNodeNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeNotFoundException::builder).build());
                    }
                    case "InvalidParameterCombinationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                    }
                    case "InvalidUserStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserStateException::builder).build());
                    }
                    case "SnapshotNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                    }
                    case "MultiRegionParameterGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionParameterGroupNotFoundException::builder).build());
                    }
                    case "ACLAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclAlreadyExistsException::builder).build());
                    }
                    case "InsufficientClusterCapacityFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                    }
                    case "UserQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserQuotaExceededException::builder).build());
                    }
                    case "TagQuotaPerResourceExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                    }
                    case "InvalidMultiRegionClusterStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMultiRegionClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMultiRegionClusterStateException::builder).build());
                    }
                    case "SubnetGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeEvents").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeEventsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeEventsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMemoryDbAsyncClient.lambda$describeEvents$78(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMemoryDbAsyncClient.lambda$describeEvents$79((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeMultiRegionClustersResponse> describeMultiRegionClusters(DescribeMultiRegionClustersRequest describeMultiRegionClustersRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeMultiRegionClustersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMemoryDbAsyncClient.resolveMetricPublishers(clientConfiguration, describeMultiRegionClustersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MemoryDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeMultiRegionClusters");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeMultiRegionClustersResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "SubnetGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                    }
                    case "ParameterGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                    }
                    case "SubnetInUse": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                    }
                    case "InvalidARNFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "TestFailoverNotAvailableFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TestFailoverNotAvailableFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TestFailoverNotAvailableException::builder).build());
                    }
                    case "ACLQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclQuotaExceededException::builder).build());
                    }
                    case "InvalidKMSKeyFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKMSKeyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyException::builder).build());
                    }
                    case "DuplicateUserNameFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateUserNameFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateUserNameException::builder).build());
                    }
                    case "SubnetNotAllowedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotAllowedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotAllowedException::builder).build());
                    }
                    case "InvalidVPCNetworkStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                    }
                    case "InvalidParameterGroupStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                    }
                    case "ParameterGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                    }
                    case "ServiceLinkedRoleNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                    }
                    case "ParameterGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                    }
                    case "UserNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                    }
                    case "ClusterNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                    }
                    case "MultiRegionClusterAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterAlreadyExistsException::builder).build());
                    }
                    case "InvalidCredentialsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCredentialsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCredentialsException::builder).build());
                    }
                    case "InvalidClusterStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                    }
                    case "MultiRegionClusterNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterNotFoundException::builder).build());
                    }
                    case "SubnetGroupInUseFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                    }
                    case "InvalidSubnet": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                    }
                    case "ClusterAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                    }
                    case "NoOperationFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoOperationException::builder).build());
                    }
                    case "ShardNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShardNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardNotFoundException::builder).build());
                    }
                    case "ACLNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclNotFoundException::builder).build());
                    }
                    case "SubnetGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                    }
                    case "ReservedNodesOfferingNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodesOfferingNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodesOfferingNotFoundException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "SnapshotAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotAlreadyExistsException::builder).build());
                    }
                    case "SnapshotQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotQuotaExceededException::builder).build());
                    }
                    case "DefaultUserRequired": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DefaultUserRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultUserRequiredException::builder).build());
                    }
                    case "NodeQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                    }
                    case "UserAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserAlreadyExistsException::builder).build());
                    }
                    case "InvalidACLStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidACLStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAclStateException::builder).build());
                    }
                    case "TagNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                    }
                    case "ClusterQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                    }
                    case "APICallRateForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("APICallRateForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiCallRateForCustomerExceededException::builder).build());
                    }
                    case "NodeQuotaForClusterExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                    }
                    case "ServiceUpdateNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUpdateNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUpdateNotFoundException::builder).build());
                    }
                    case "SubnetQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                    }
                    case "ReservedNodeQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeQuotaExceededException::builder).build());
                    }
                    case "InvalidSnapshotStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnapshotStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnapshotStateException::builder).build());
                    }
                    case "InvalidNodeStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNodeStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNodeStateException::builder).build());
                    }
                    case "ShardsPerClusterQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShardsPerClusterQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardsPerClusterQuotaExceededException::builder).build());
                    }
                    case "ReservedNodeAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeAlreadyExistsException::builder).build());
                    }
                    case "ReservedNodeNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeNotFoundException::builder).build());
                    }
                    case "InvalidParameterCombinationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                    }
                    case "InvalidUserStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserStateException::builder).build());
                    }
                    case "SnapshotNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                    }
                    case "MultiRegionParameterGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionParameterGroupNotFoundException::builder).build());
                    }
                    case "ACLAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclAlreadyExistsException::builder).build());
                    }
                    case "InsufficientClusterCapacityFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                    }
                    case "UserQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserQuotaExceededException::builder).build());
                    }
                    case "TagQuotaPerResourceExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                    }
                    case "InvalidMultiRegionClusterStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMultiRegionClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMultiRegionClusterStateException::builder).build());
                    }
                    case "SubnetGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeMultiRegionClusters").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeMultiRegionClustersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeMultiRegionClustersRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMemoryDbAsyncClient.lambda$describeMultiRegionClusters$82(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMemoryDbAsyncClient.lambda$describeMultiRegionClusters$83((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeMultiRegionParameterGroupsResponse> describeMultiRegionParameterGroups(DescribeMultiRegionParameterGroupsRequest describeMultiRegionParameterGroupsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeMultiRegionParameterGroupsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMemoryDbAsyncClient.resolveMetricPublishers(clientConfiguration, describeMultiRegionParameterGroupsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MemoryDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeMultiRegionParameterGroups");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeMultiRegionParameterGroupsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "SubnetGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                    }
                    case "ParameterGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                    }
                    case "SubnetInUse": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                    }
                    case "InvalidARNFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "TestFailoverNotAvailableFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TestFailoverNotAvailableFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TestFailoverNotAvailableException::builder).build());
                    }
                    case "ACLQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclQuotaExceededException::builder).build());
                    }
                    case "InvalidKMSKeyFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKMSKeyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyException::builder).build());
                    }
                    case "DuplicateUserNameFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateUserNameFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateUserNameException::builder).build());
                    }
                    case "SubnetNotAllowedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotAllowedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotAllowedException::builder).build());
                    }
                    case "InvalidVPCNetworkStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                    }
                    case "InvalidParameterGroupStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                    }
                    case "ParameterGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                    }
                    case "ServiceLinkedRoleNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                    }
                    case "ParameterGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                    }
                    case "UserNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                    }
                    case "ClusterNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                    }
                    case "MultiRegionClusterAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterAlreadyExistsException::builder).build());
                    }
                    case "InvalidCredentialsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCredentialsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCredentialsException::builder).build());
                    }
                    case "InvalidClusterStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                    }
                    case "MultiRegionClusterNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterNotFoundException::builder).build());
                    }
                    case "SubnetGroupInUseFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                    }
                    case "InvalidSubnet": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                    }
                    case "ClusterAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                    }
                    case "NoOperationFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoOperationException::builder).build());
                    }
                    case "ShardNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShardNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardNotFoundException::builder).build());
                    }
                    case "ACLNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclNotFoundException::builder).build());
                    }
                    case "SubnetGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                    }
                    case "ReservedNodesOfferingNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodesOfferingNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodesOfferingNotFoundException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "SnapshotAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotAlreadyExistsException::builder).build());
                    }
                    case "SnapshotQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotQuotaExceededException::builder).build());
                    }
                    case "DefaultUserRequired": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DefaultUserRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultUserRequiredException::builder).build());
                    }
                    case "NodeQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                    }
                    case "UserAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserAlreadyExistsException::builder).build());
                    }
                    case "InvalidACLStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidACLStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAclStateException::builder).build());
                    }
                    case "TagNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                    }
                    case "ClusterQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                    }
                    case "APICallRateForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("APICallRateForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiCallRateForCustomerExceededException::builder).build());
                    }
                    case "NodeQuotaForClusterExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                    }
                    case "ServiceUpdateNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUpdateNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUpdateNotFoundException::builder).build());
                    }
                    case "SubnetQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                    }
                    case "ReservedNodeQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeQuotaExceededException::builder).build());
                    }
                    case "InvalidSnapshotStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnapshotStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnapshotStateException::builder).build());
                    }
                    case "InvalidNodeStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNodeStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNodeStateException::builder).build());
                    }
                    case "ShardsPerClusterQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShardsPerClusterQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardsPerClusterQuotaExceededException::builder).build());
                    }
                    case "ReservedNodeAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeAlreadyExistsException::builder).build());
                    }
                    case "ReservedNodeNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeNotFoundException::builder).build());
                    }
                    case "InvalidParameterCombinationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                    }
                    case "InvalidUserStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserStateException::builder).build());
                    }
                    case "SnapshotNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                    }
                    case "MultiRegionParameterGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionParameterGroupNotFoundException::builder).build());
                    }
                    case "ACLAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclAlreadyExistsException::builder).build());
                    }
                    case "InsufficientClusterCapacityFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                    }
                    case "UserQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserQuotaExceededException::builder).build());
                    }
                    case "TagQuotaPerResourceExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                    }
                    case "InvalidMultiRegionClusterStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMultiRegionClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMultiRegionClusterStateException::builder).build());
                    }
                    case "SubnetGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeMultiRegionParameterGroups").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeMultiRegionParameterGroupsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeMultiRegionParameterGroupsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMemoryDbAsyncClient.lambda$describeMultiRegionParameterGroups$86(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMemoryDbAsyncClient.lambda$describeMultiRegionParameterGroups$87((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeMultiRegionParametersResponse> describeMultiRegionParameters(DescribeMultiRegionParametersRequest describeMultiRegionParametersRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeMultiRegionParametersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMemoryDbAsyncClient.resolveMetricPublishers(clientConfiguration, describeMultiRegionParametersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MemoryDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeMultiRegionParameters");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeMultiRegionParametersResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "SubnetGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                    }
                    case "ParameterGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                    }
                    case "SubnetInUse": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                    }
                    case "InvalidARNFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "TestFailoverNotAvailableFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TestFailoverNotAvailableFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TestFailoverNotAvailableException::builder).build());
                    }
                    case "ACLQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclQuotaExceededException::builder).build());
                    }
                    case "InvalidKMSKeyFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKMSKeyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyException::builder).build());
                    }
                    case "DuplicateUserNameFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateUserNameFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateUserNameException::builder).build());
                    }
                    case "SubnetNotAllowedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotAllowedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotAllowedException::builder).build());
                    }
                    case "InvalidVPCNetworkStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                    }
                    case "InvalidParameterGroupStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                    }
                    case "ParameterGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                    }
                    case "ServiceLinkedRoleNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                    }
                    case "ParameterGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                    }
                    case "UserNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                    }
                    case "ClusterNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                    }
                    case "MultiRegionClusterAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterAlreadyExistsException::builder).build());
                    }
                    case "InvalidCredentialsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCredentialsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCredentialsException::builder).build());
                    }
                    case "InvalidClusterStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                    }
                    case "MultiRegionClusterNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterNotFoundException::builder).build());
                    }
                    case "SubnetGroupInUseFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                    }
                    case "InvalidSubnet": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                    }
                    case "ClusterAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                    }
                    case "NoOperationFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoOperationException::builder).build());
                    }
                    case "ShardNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShardNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardNotFoundException::builder).build());
                    }
                    case "ACLNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclNotFoundException::builder).build());
                    }
                    case "SubnetGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                    }
                    case "ReservedNodesOfferingNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodesOfferingNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodesOfferingNotFoundException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "SnapshotAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotAlreadyExistsException::builder).build());
                    }
                    case "SnapshotQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotQuotaExceededException::builder).build());
                    }
                    case "DefaultUserRequired": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DefaultUserRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultUserRequiredException::builder).build());
                    }
                    case "NodeQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                    }
                    case "UserAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserAlreadyExistsException::builder).build());
                    }
                    case "InvalidACLStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidACLStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAclStateException::builder).build());
                    }
                    case "TagNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                    }
                    case "ClusterQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                    }
                    case "APICallRateForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("APICallRateForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiCallRateForCustomerExceededException::builder).build());
                    }
                    case "NodeQuotaForClusterExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                    }
                    case "ServiceUpdateNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUpdateNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUpdateNotFoundException::builder).build());
                    }
                    case "SubnetQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                    }
                    case "ReservedNodeQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeQuotaExceededException::builder).build());
                    }
                    case "InvalidSnapshotStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnapshotStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnapshotStateException::builder).build());
                    }
                    case "InvalidNodeStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNodeStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNodeStateException::builder).build());
                    }
                    case "ShardsPerClusterQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShardsPerClusterQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardsPerClusterQuotaExceededException::builder).build());
                    }
                    case "ReservedNodeAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeAlreadyExistsException::builder).build());
                    }
                    case "ReservedNodeNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeNotFoundException::builder).build());
                    }
                    case "InvalidParameterCombinationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                    }
                    case "InvalidUserStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserStateException::builder).build());
                    }
                    case "SnapshotNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                    }
                    case "MultiRegionParameterGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionParameterGroupNotFoundException::builder).build());
                    }
                    case "ACLAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclAlreadyExistsException::builder).build());
                    }
                    case "InsufficientClusterCapacityFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                    }
                    case "UserQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserQuotaExceededException::builder).build());
                    }
                    case "TagQuotaPerResourceExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                    }
                    case "InvalidMultiRegionClusterStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMultiRegionClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMultiRegionClusterStateException::builder).build());
                    }
                    case "SubnetGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeMultiRegionParameters").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeMultiRegionParametersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeMultiRegionParametersRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMemoryDbAsyncClient.lambda$describeMultiRegionParameters$90(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMemoryDbAsyncClient.lambda$describeMultiRegionParameters$91((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeParameterGroupsResponse> describeParameterGroups(DescribeParameterGroupsRequest describeParameterGroupsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeParameterGroupsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMemoryDbAsyncClient.resolveMetricPublishers(clientConfiguration, describeParameterGroupsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MemoryDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeParameterGroups");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeParameterGroupsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "SubnetGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                    }
                    case "ParameterGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                    }
                    case "SubnetInUse": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                    }
                    case "InvalidARNFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "TestFailoverNotAvailableFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TestFailoverNotAvailableFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TestFailoverNotAvailableException::builder).build());
                    }
                    case "ACLQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclQuotaExceededException::builder).build());
                    }
                    case "InvalidKMSKeyFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKMSKeyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyException::builder).build());
                    }
                    case "DuplicateUserNameFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateUserNameFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateUserNameException::builder).build());
                    }
                    case "SubnetNotAllowedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotAllowedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotAllowedException::builder).build());
                    }
                    case "InvalidVPCNetworkStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                    }
                    case "InvalidParameterGroupStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                    }
                    case "ParameterGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                    }
                    case "ServiceLinkedRoleNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                    }
                    case "ParameterGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                    }
                    case "UserNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                    }
                    case "ClusterNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                    }
                    case "MultiRegionClusterAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterAlreadyExistsException::builder).build());
                    }
                    case "InvalidCredentialsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCredentialsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCredentialsException::builder).build());
                    }
                    case "InvalidClusterStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                    }
                    case "MultiRegionClusterNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterNotFoundException::builder).build());
                    }
                    case "SubnetGroupInUseFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                    }
                    case "InvalidSubnet": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                    }
                    case "ClusterAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                    }
                    case "NoOperationFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoOperationException::builder).build());
                    }
                    case "ShardNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShardNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardNotFoundException::builder).build());
                    }
                    case "ACLNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclNotFoundException::builder).build());
                    }
                    case "SubnetGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                    }
                    case "ReservedNodesOfferingNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodesOfferingNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodesOfferingNotFoundException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "SnapshotAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotAlreadyExistsException::builder).build());
                    }
                    case "SnapshotQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotQuotaExceededException::builder).build());
                    }
                    case "DefaultUserRequired": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DefaultUserRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultUserRequiredException::builder).build());
                    }
                    case "NodeQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                    }
                    case "UserAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserAlreadyExistsException::builder).build());
                    }
                    case "InvalidACLStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidACLStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAclStateException::builder).build());
                    }
                    case "TagNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                    }
                    case "ClusterQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                    }
                    case "APICallRateForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("APICallRateForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiCallRateForCustomerExceededException::builder).build());
                    }
                    case "NodeQuotaForClusterExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                    }
                    case "ServiceUpdateNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUpdateNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUpdateNotFoundException::builder).build());
                    }
                    case "SubnetQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                    }
                    case "ReservedNodeQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeQuotaExceededException::builder).build());
                    }
                    case "InvalidSnapshotStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnapshotStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnapshotStateException::builder).build());
                    }
                    case "InvalidNodeStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNodeStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNodeStateException::builder).build());
                    }
                    case "ShardsPerClusterQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShardsPerClusterQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardsPerClusterQuotaExceededException::builder).build());
                    }
                    case "ReservedNodeAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeAlreadyExistsException::builder).build());
                    }
                    case "ReservedNodeNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeNotFoundException::builder).build());
                    }
                    case "InvalidParameterCombinationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                    }
                    case "InvalidUserStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserStateException::builder).build());
                    }
                    case "SnapshotNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                    }
                    case "MultiRegionParameterGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionParameterGroupNotFoundException::builder).build());
                    }
                    case "ACLAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclAlreadyExistsException::builder).build());
                    }
                    case "InsufficientClusterCapacityFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                    }
                    case "UserQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserQuotaExceededException::builder).build());
                    }
                    case "TagQuotaPerResourceExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                    }
                    case "InvalidMultiRegionClusterStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMultiRegionClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMultiRegionClusterStateException::builder).build());
                    }
                    case "SubnetGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeParameterGroups").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeParameterGroupsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeParameterGroupsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMemoryDbAsyncClient.lambda$describeParameterGroups$94(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMemoryDbAsyncClient.lambda$describeParameterGroups$95((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeParametersResponse> describeParameters(DescribeParametersRequest describeParametersRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeParametersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMemoryDbAsyncClient.resolveMetricPublishers(clientConfiguration, describeParametersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MemoryDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeParameters");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeParametersResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "SubnetGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                    }
                    case "ParameterGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                    }
                    case "SubnetInUse": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                    }
                    case "InvalidARNFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "TestFailoverNotAvailableFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TestFailoverNotAvailableFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TestFailoverNotAvailableException::builder).build());
                    }
                    case "ACLQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclQuotaExceededException::builder).build());
                    }
                    case "InvalidKMSKeyFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKMSKeyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyException::builder).build());
                    }
                    case "DuplicateUserNameFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateUserNameFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateUserNameException::builder).build());
                    }
                    case "SubnetNotAllowedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotAllowedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotAllowedException::builder).build());
                    }
                    case "InvalidVPCNetworkStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                    }
                    case "InvalidParameterGroupStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                    }
                    case "ParameterGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                    }
                    case "ServiceLinkedRoleNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                    }
                    case "ParameterGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                    }
                    case "UserNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                    }
                    case "ClusterNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                    }
                    case "MultiRegionClusterAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterAlreadyExistsException::builder).build());
                    }
                    case "InvalidCredentialsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCredentialsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCredentialsException::builder).build());
                    }
                    case "InvalidClusterStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                    }
                    case "MultiRegionClusterNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterNotFoundException::builder).build());
                    }
                    case "SubnetGroupInUseFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                    }
                    case "InvalidSubnet": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                    }
                    case "ClusterAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                    }
                    case "NoOperationFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoOperationException::builder).build());
                    }
                    case "ShardNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShardNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardNotFoundException::builder).build());
                    }
                    case "ACLNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclNotFoundException::builder).build());
                    }
                    case "SubnetGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                    }
                    case "ReservedNodesOfferingNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodesOfferingNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodesOfferingNotFoundException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "SnapshotAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotAlreadyExistsException::builder).build());
                    }
                    case "SnapshotQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotQuotaExceededException::builder).build());
                    }
                    case "DefaultUserRequired": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DefaultUserRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultUserRequiredException::builder).build());
                    }
                    case "NodeQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                    }
                    case "UserAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserAlreadyExistsException::builder).build());
                    }
                    case "InvalidACLStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidACLStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAclStateException::builder).build());
                    }
                    case "TagNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                    }
                    case "ClusterQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                    }
                    case "APICallRateForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("APICallRateForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiCallRateForCustomerExceededException::builder).build());
                    }
                    case "NodeQuotaForClusterExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                    }
                    case "ServiceUpdateNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUpdateNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUpdateNotFoundException::builder).build());
                    }
                    case "SubnetQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                    }
                    case "ReservedNodeQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeQuotaExceededException::builder).build());
                    }
                    case "InvalidSnapshotStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnapshotStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnapshotStateException::builder).build());
                    }
                    case "InvalidNodeStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNodeStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNodeStateException::builder).build());
                    }
                    case "ShardsPerClusterQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShardsPerClusterQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardsPerClusterQuotaExceededException::builder).build());
                    }
                    case "ReservedNodeAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeAlreadyExistsException::builder).build());
                    }
                    case "ReservedNodeNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeNotFoundException::builder).build());
                    }
                    case "InvalidParameterCombinationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                    }
                    case "InvalidUserStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserStateException::builder).build());
                    }
                    case "SnapshotNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                    }
                    case "MultiRegionParameterGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionParameterGroupNotFoundException::builder).build());
                    }
                    case "ACLAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclAlreadyExistsException::builder).build());
                    }
                    case "InsufficientClusterCapacityFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                    }
                    case "UserQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserQuotaExceededException::builder).build());
                    }
                    case "TagQuotaPerResourceExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                    }
                    case "InvalidMultiRegionClusterStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMultiRegionClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMultiRegionClusterStateException::builder).build());
                    }
                    case "SubnetGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeParameters").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeParametersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeParametersRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMemoryDbAsyncClient.lambda$describeParameters$98(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMemoryDbAsyncClient.lambda$describeParameters$99((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeReservedNodesResponse> describeReservedNodes(DescribeReservedNodesRequest describeReservedNodesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeReservedNodesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMemoryDbAsyncClient.resolveMetricPublishers(clientConfiguration, describeReservedNodesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MemoryDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeReservedNodes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeReservedNodesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "SubnetGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                    }
                    case "ParameterGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                    }
                    case "SubnetInUse": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                    }
                    case "InvalidARNFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "TestFailoverNotAvailableFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TestFailoverNotAvailableFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TestFailoverNotAvailableException::builder).build());
                    }
                    case "ACLQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclQuotaExceededException::builder).build());
                    }
                    case "InvalidKMSKeyFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKMSKeyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyException::builder).build());
                    }
                    case "DuplicateUserNameFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateUserNameFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateUserNameException::builder).build());
                    }
                    case "SubnetNotAllowedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotAllowedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotAllowedException::builder).build());
                    }
                    case "InvalidVPCNetworkStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                    }
                    case "InvalidParameterGroupStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                    }
                    case "ParameterGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                    }
                    case "ServiceLinkedRoleNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                    }
                    case "ParameterGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                    }
                    case "UserNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                    }
                    case "ClusterNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                    }
                    case "MultiRegionClusterAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterAlreadyExistsException::builder).build());
                    }
                    case "InvalidCredentialsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCredentialsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCredentialsException::builder).build());
                    }
                    case "InvalidClusterStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                    }
                    case "MultiRegionClusterNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterNotFoundException::builder).build());
                    }
                    case "SubnetGroupInUseFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                    }
                    case "InvalidSubnet": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                    }
                    case "ClusterAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                    }
                    case "NoOperationFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoOperationException::builder).build());
                    }
                    case "ShardNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShardNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardNotFoundException::builder).build());
                    }
                    case "ACLNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclNotFoundException::builder).build());
                    }
                    case "SubnetGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                    }
                    case "ReservedNodesOfferingNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodesOfferingNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodesOfferingNotFoundException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "SnapshotAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotAlreadyExistsException::builder).build());
                    }
                    case "SnapshotQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotQuotaExceededException::builder).build());
                    }
                    case "DefaultUserRequired": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DefaultUserRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultUserRequiredException::builder).build());
                    }
                    case "NodeQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                    }
                    case "UserAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserAlreadyExistsException::builder).build());
                    }
                    case "InvalidACLStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidACLStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAclStateException::builder).build());
                    }
                    case "TagNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                    }
                    case "ClusterQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                    }
                    case "APICallRateForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("APICallRateForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiCallRateForCustomerExceededException::builder).build());
                    }
                    case "NodeQuotaForClusterExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                    }
                    case "ServiceUpdateNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUpdateNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUpdateNotFoundException::builder).build());
                    }
                    case "SubnetQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                    }
                    case "ReservedNodeQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeQuotaExceededException::builder).build());
                    }
                    case "InvalidSnapshotStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnapshotStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnapshotStateException::builder).build());
                    }
                    case "InvalidNodeStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNodeStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNodeStateException::builder).build());
                    }
                    case "ShardsPerClusterQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShardsPerClusterQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardsPerClusterQuotaExceededException::builder).build());
                    }
                    case "ReservedNodeAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeAlreadyExistsException::builder).build());
                    }
                    case "ReservedNodeNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeNotFoundException::builder).build());
                    }
                    case "InvalidParameterCombinationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                    }
                    case "InvalidUserStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserStateException::builder).build());
                    }
                    case "SnapshotNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                    }
                    case "MultiRegionParameterGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionParameterGroupNotFoundException::builder).build());
                    }
                    case "ACLAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclAlreadyExistsException::builder).build());
                    }
                    case "InsufficientClusterCapacityFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                    }
                    case "UserQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserQuotaExceededException::builder).build());
                    }
                    case "TagQuotaPerResourceExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                    }
                    case "InvalidMultiRegionClusterStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMultiRegionClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMultiRegionClusterStateException::builder).build());
                    }
                    case "SubnetGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeReservedNodes").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeReservedNodesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeReservedNodesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMemoryDbAsyncClient.lambda$describeReservedNodes$102(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMemoryDbAsyncClient.lambda$describeReservedNodes$103((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeReservedNodesOfferingsResponse> describeReservedNodesOfferings(DescribeReservedNodesOfferingsRequest describeReservedNodesOfferingsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeReservedNodesOfferingsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMemoryDbAsyncClient.resolveMetricPublishers(clientConfiguration, describeReservedNodesOfferingsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MemoryDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeReservedNodesOfferings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeReservedNodesOfferingsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "SubnetGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                    }
                    case "ParameterGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                    }
                    case "SubnetInUse": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                    }
                    case "InvalidARNFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "TestFailoverNotAvailableFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TestFailoverNotAvailableFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TestFailoverNotAvailableException::builder).build());
                    }
                    case "ACLQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclQuotaExceededException::builder).build());
                    }
                    case "InvalidKMSKeyFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKMSKeyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyException::builder).build());
                    }
                    case "DuplicateUserNameFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateUserNameFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateUserNameException::builder).build());
                    }
                    case "SubnetNotAllowedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotAllowedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotAllowedException::builder).build());
                    }
                    case "InvalidVPCNetworkStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                    }
                    case "InvalidParameterGroupStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                    }
                    case "ParameterGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                    }
                    case "ServiceLinkedRoleNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                    }
                    case "ParameterGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                    }
                    case "UserNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                    }
                    case "ClusterNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                    }
                    case "MultiRegionClusterAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterAlreadyExistsException::builder).build());
                    }
                    case "InvalidCredentialsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCredentialsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCredentialsException::builder).build());
                    }
                    case "InvalidClusterStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                    }
                    case "MultiRegionClusterNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterNotFoundException::builder).build());
                    }
                    case "SubnetGroupInUseFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                    }
                    case "InvalidSubnet": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                    }
                    case "ClusterAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                    }
                    case "NoOperationFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoOperationException::builder).build());
                    }
                    case "ShardNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShardNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardNotFoundException::builder).build());
                    }
                    case "ACLNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclNotFoundException::builder).build());
                    }
                    case "SubnetGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                    }
                    case "ReservedNodesOfferingNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodesOfferingNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodesOfferingNotFoundException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "SnapshotAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotAlreadyExistsException::builder).build());
                    }
                    case "SnapshotQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotQuotaExceededException::builder).build());
                    }
                    case "DefaultUserRequired": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DefaultUserRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultUserRequiredException::builder).build());
                    }
                    case "NodeQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                    }
                    case "UserAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserAlreadyExistsException::builder).build());
                    }
                    case "InvalidACLStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidACLStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAclStateException::builder).build());
                    }
                    case "TagNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                    }
                    case "ClusterQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                    }
                    case "APICallRateForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("APICallRateForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiCallRateForCustomerExceededException::builder).build());
                    }
                    case "NodeQuotaForClusterExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                    }
                    case "ServiceUpdateNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUpdateNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUpdateNotFoundException::builder).build());
                    }
                    case "SubnetQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                    }
                    case "ReservedNodeQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeQuotaExceededException::builder).build());
                    }
                    case "InvalidSnapshotStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnapshotStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnapshotStateException::builder).build());
                    }
                    case "InvalidNodeStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNodeStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNodeStateException::builder).build());
                    }
                    case "ShardsPerClusterQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShardsPerClusterQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardsPerClusterQuotaExceededException::builder).build());
                    }
                    case "ReservedNodeAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeAlreadyExistsException::builder).build());
                    }
                    case "ReservedNodeNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeNotFoundException::builder).build());
                    }
                    case "InvalidParameterCombinationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                    }
                    case "InvalidUserStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserStateException::builder).build());
                    }
                    case "SnapshotNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                    }
                    case "MultiRegionParameterGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionParameterGroupNotFoundException::builder).build());
                    }
                    case "ACLAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclAlreadyExistsException::builder).build());
                    }
                    case "InsufficientClusterCapacityFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                    }
                    case "UserQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserQuotaExceededException::builder).build());
                    }
                    case "TagQuotaPerResourceExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                    }
                    case "InvalidMultiRegionClusterStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMultiRegionClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMultiRegionClusterStateException::builder).build());
                    }
                    case "SubnetGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeReservedNodesOfferings").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeReservedNodesOfferingsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeReservedNodesOfferingsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMemoryDbAsyncClient.lambda$describeReservedNodesOfferings$106(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMemoryDbAsyncClient.lambda$describeReservedNodesOfferings$107((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeServiceUpdatesResponse> describeServiceUpdates(DescribeServiceUpdatesRequest describeServiceUpdatesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeServiceUpdatesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMemoryDbAsyncClient.resolveMetricPublishers(clientConfiguration, describeServiceUpdatesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MemoryDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeServiceUpdates");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeServiceUpdatesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "SubnetGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                    }
                    case "ParameterGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                    }
                    case "SubnetInUse": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                    }
                    case "InvalidARNFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "TestFailoverNotAvailableFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TestFailoverNotAvailableFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TestFailoverNotAvailableException::builder).build());
                    }
                    case "ACLQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclQuotaExceededException::builder).build());
                    }
                    case "InvalidKMSKeyFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKMSKeyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyException::builder).build());
                    }
                    case "DuplicateUserNameFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateUserNameFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateUserNameException::builder).build());
                    }
                    case "SubnetNotAllowedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotAllowedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotAllowedException::builder).build());
                    }
                    case "InvalidVPCNetworkStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                    }
                    case "InvalidParameterGroupStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                    }
                    case "ParameterGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                    }
                    case "ServiceLinkedRoleNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                    }
                    case "ParameterGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                    }
                    case "UserNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                    }
                    case "ClusterNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                    }
                    case "MultiRegionClusterAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterAlreadyExistsException::builder).build());
                    }
                    case "InvalidCredentialsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCredentialsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCredentialsException::builder).build());
                    }
                    case "InvalidClusterStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                    }
                    case "MultiRegionClusterNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterNotFoundException::builder).build());
                    }
                    case "SubnetGroupInUseFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                    }
                    case "InvalidSubnet": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                    }
                    case "ClusterAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                    }
                    case "NoOperationFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoOperationException::builder).build());
                    }
                    case "ShardNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShardNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardNotFoundException::builder).build());
                    }
                    case "ACLNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclNotFoundException::builder).build());
                    }
                    case "SubnetGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                    }
                    case "ReservedNodesOfferingNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodesOfferingNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodesOfferingNotFoundException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "SnapshotAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotAlreadyExistsException::builder).build());
                    }
                    case "SnapshotQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotQuotaExceededException::builder).build());
                    }
                    case "DefaultUserRequired": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DefaultUserRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultUserRequiredException::builder).build());
                    }
                    case "NodeQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                    }
                    case "UserAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserAlreadyExistsException::builder).build());
                    }
                    case "InvalidACLStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidACLStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAclStateException::builder).build());
                    }
                    case "TagNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                    }
                    case "ClusterQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                    }
                    case "APICallRateForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("APICallRateForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiCallRateForCustomerExceededException::builder).build());
                    }
                    case "NodeQuotaForClusterExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                    }
                    case "ServiceUpdateNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUpdateNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUpdateNotFoundException::builder).build());
                    }
                    case "SubnetQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                    }
                    case "ReservedNodeQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeQuotaExceededException::builder).build());
                    }
                    case "InvalidSnapshotStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnapshotStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnapshotStateException::builder).build());
                    }
                    case "InvalidNodeStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNodeStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNodeStateException::builder).build());
                    }
                    case "ShardsPerClusterQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShardsPerClusterQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardsPerClusterQuotaExceededException::builder).build());
                    }
                    case "ReservedNodeAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeAlreadyExistsException::builder).build());
                    }
                    case "ReservedNodeNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeNotFoundException::builder).build());
                    }
                    case "InvalidParameterCombinationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                    }
                    case "InvalidUserStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserStateException::builder).build());
                    }
                    case "SnapshotNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                    }
                    case "MultiRegionParameterGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionParameterGroupNotFoundException::builder).build());
                    }
                    case "ACLAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclAlreadyExistsException::builder).build());
                    }
                    case "InsufficientClusterCapacityFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                    }
                    case "UserQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserQuotaExceededException::builder).build());
                    }
                    case "TagQuotaPerResourceExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                    }
                    case "InvalidMultiRegionClusterStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMultiRegionClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMultiRegionClusterStateException::builder).build());
                    }
                    case "SubnetGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeServiceUpdates").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeServiceUpdatesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeServiceUpdatesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMemoryDbAsyncClient.lambda$describeServiceUpdates$110(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMemoryDbAsyncClient.lambda$describeServiceUpdates$111((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeSnapshotsResponse> describeSnapshots(DescribeSnapshotsRequest describeSnapshotsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeSnapshotsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMemoryDbAsyncClient.resolveMetricPublishers(clientConfiguration, describeSnapshotsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MemoryDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeSnapshots");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeSnapshotsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "SubnetGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                    }
                    case "ParameterGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                    }
                    case "SubnetInUse": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                    }
                    case "InvalidARNFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "TestFailoverNotAvailableFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TestFailoverNotAvailableFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TestFailoverNotAvailableException::builder).build());
                    }
                    case "ACLQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclQuotaExceededException::builder).build());
                    }
                    case "InvalidKMSKeyFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKMSKeyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyException::builder).build());
                    }
                    case "DuplicateUserNameFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateUserNameFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateUserNameException::builder).build());
                    }
                    case "SubnetNotAllowedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotAllowedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotAllowedException::builder).build());
                    }
                    case "InvalidVPCNetworkStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                    }
                    case "InvalidParameterGroupStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                    }
                    case "ParameterGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                    }
                    case "ServiceLinkedRoleNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                    }
                    case "ParameterGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                    }
                    case "UserNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                    }
                    case "ClusterNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                    }
                    case "MultiRegionClusterAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterAlreadyExistsException::builder).build());
                    }
                    case "InvalidCredentialsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCredentialsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCredentialsException::builder).build());
                    }
                    case "InvalidClusterStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                    }
                    case "MultiRegionClusterNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterNotFoundException::builder).build());
                    }
                    case "SubnetGroupInUseFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                    }
                    case "InvalidSubnet": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                    }
                    case "ClusterAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                    }
                    case "NoOperationFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoOperationException::builder).build());
                    }
                    case "ShardNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShardNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardNotFoundException::builder).build());
                    }
                    case "ACLNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclNotFoundException::builder).build());
                    }
                    case "SubnetGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                    }
                    case "ReservedNodesOfferingNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodesOfferingNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodesOfferingNotFoundException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "SnapshotAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotAlreadyExistsException::builder).build());
                    }
                    case "SnapshotQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotQuotaExceededException::builder).build());
                    }
                    case "DefaultUserRequired": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DefaultUserRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultUserRequiredException::builder).build());
                    }
                    case "NodeQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                    }
                    case "UserAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserAlreadyExistsException::builder).build());
                    }
                    case "InvalidACLStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidACLStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAclStateException::builder).build());
                    }
                    case "TagNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                    }
                    case "ClusterQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                    }
                    case "APICallRateForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("APICallRateForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiCallRateForCustomerExceededException::builder).build());
                    }
                    case "NodeQuotaForClusterExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                    }
                    case "ServiceUpdateNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUpdateNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUpdateNotFoundException::builder).build());
                    }
                    case "SubnetQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                    }
                    case "ReservedNodeQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeQuotaExceededException::builder).build());
                    }
                    case "InvalidSnapshotStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnapshotStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnapshotStateException::builder).build());
                    }
                    case "InvalidNodeStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNodeStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNodeStateException::builder).build());
                    }
                    case "ShardsPerClusterQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShardsPerClusterQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardsPerClusterQuotaExceededException::builder).build());
                    }
                    case "ReservedNodeAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeAlreadyExistsException::builder).build());
                    }
                    case "ReservedNodeNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeNotFoundException::builder).build());
                    }
                    case "InvalidParameterCombinationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                    }
                    case "InvalidUserStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserStateException::builder).build());
                    }
                    case "SnapshotNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                    }
                    case "MultiRegionParameterGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionParameterGroupNotFoundException::builder).build());
                    }
                    case "ACLAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclAlreadyExistsException::builder).build());
                    }
                    case "InsufficientClusterCapacityFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                    }
                    case "UserQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserQuotaExceededException::builder).build());
                    }
                    case "TagQuotaPerResourceExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                    }
                    case "InvalidMultiRegionClusterStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMultiRegionClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMultiRegionClusterStateException::builder).build());
                    }
                    case "SubnetGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeSnapshots").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeSnapshotsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeSnapshotsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMemoryDbAsyncClient.lambda$describeSnapshots$114(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMemoryDbAsyncClient.lambda$describeSnapshots$115((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeSubnetGroupsResponse> describeSubnetGroups(DescribeSubnetGroupsRequest describeSubnetGroupsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeSubnetGroupsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMemoryDbAsyncClient.resolveMetricPublishers(clientConfiguration, describeSubnetGroupsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MemoryDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeSubnetGroups");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeSubnetGroupsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "SubnetGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                    }
                    case "ParameterGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                    }
                    case "SubnetInUse": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                    }
                    case "InvalidARNFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "TestFailoverNotAvailableFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TestFailoverNotAvailableFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TestFailoverNotAvailableException::builder).build());
                    }
                    case "ACLQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclQuotaExceededException::builder).build());
                    }
                    case "InvalidKMSKeyFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKMSKeyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyException::builder).build());
                    }
                    case "DuplicateUserNameFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateUserNameFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateUserNameException::builder).build());
                    }
                    case "SubnetNotAllowedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotAllowedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotAllowedException::builder).build());
                    }
                    case "InvalidVPCNetworkStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                    }
                    case "InvalidParameterGroupStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                    }
                    case "ParameterGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                    }
                    case "ServiceLinkedRoleNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                    }
                    case "ParameterGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                    }
                    case "UserNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                    }
                    case "ClusterNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                    }
                    case "MultiRegionClusterAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterAlreadyExistsException::builder).build());
                    }
                    case "InvalidCredentialsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCredentialsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCredentialsException::builder).build());
                    }
                    case "InvalidClusterStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                    }
                    case "MultiRegionClusterNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterNotFoundException::builder).build());
                    }
                    case "SubnetGroupInUseFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                    }
                    case "InvalidSubnet": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                    }
                    case "ClusterAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                    }
                    case "NoOperationFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoOperationException::builder).build());
                    }
                    case "ShardNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShardNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardNotFoundException::builder).build());
                    }
                    case "ACLNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclNotFoundException::builder).build());
                    }
                    case "SubnetGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                    }
                    case "ReservedNodesOfferingNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodesOfferingNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodesOfferingNotFoundException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "SnapshotAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotAlreadyExistsException::builder).build());
                    }
                    case "SnapshotQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotQuotaExceededException::builder).build());
                    }
                    case "DefaultUserRequired": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DefaultUserRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultUserRequiredException::builder).build());
                    }
                    case "NodeQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                    }
                    case "UserAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserAlreadyExistsException::builder).build());
                    }
                    case "InvalidACLStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidACLStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAclStateException::builder).build());
                    }
                    case "TagNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                    }
                    case "ClusterQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                    }
                    case "APICallRateForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("APICallRateForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiCallRateForCustomerExceededException::builder).build());
                    }
                    case "NodeQuotaForClusterExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                    }
                    case "ServiceUpdateNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUpdateNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUpdateNotFoundException::builder).build());
                    }
                    case "SubnetQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                    }
                    case "ReservedNodeQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeQuotaExceededException::builder).build());
                    }
                    case "InvalidSnapshotStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnapshotStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnapshotStateException::builder).build());
                    }
                    case "InvalidNodeStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNodeStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNodeStateException::builder).build());
                    }
                    case "ShardsPerClusterQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShardsPerClusterQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardsPerClusterQuotaExceededException::builder).build());
                    }
                    case "ReservedNodeAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeAlreadyExistsException::builder).build());
                    }
                    case "ReservedNodeNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeNotFoundException::builder).build());
                    }
                    case "InvalidParameterCombinationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                    }
                    case "InvalidUserStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserStateException::builder).build());
                    }
                    case "SnapshotNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                    }
                    case "MultiRegionParameterGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionParameterGroupNotFoundException::builder).build());
                    }
                    case "ACLAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclAlreadyExistsException::builder).build());
                    }
                    case "InsufficientClusterCapacityFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                    }
                    case "UserQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserQuotaExceededException::builder).build());
                    }
                    case "TagQuotaPerResourceExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                    }
                    case "InvalidMultiRegionClusterStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMultiRegionClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMultiRegionClusterStateException::builder).build());
                    }
                    case "SubnetGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeSubnetGroups").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeSubnetGroupsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeSubnetGroupsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMemoryDbAsyncClient.lambda$describeSubnetGroups$118(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMemoryDbAsyncClient.lambda$describeSubnetGroups$119((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeUsersResponse> describeUsers(DescribeUsersRequest describeUsersRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeUsersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMemoryDbAsyncClient.resolveMetricPublishers(clientConfiguration, describeUsersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MemoryDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeUsers");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeUsersResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "SubnetGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                    }
                    case "ParameterGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                    }
                    case "SubnetInUse": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                    }
                    case "InvalidARNFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "TestFailoverNotAvailableFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TestFailoverNotAvailableFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TestFailoverNotAvailableException::builder).build());
                    }
                    case "ACLQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclQuotaExceededException::builder).build());
                    }
                    case "InvalidKMSKeyFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKMSKeyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyException::builder).build());
                    }
                    case "DuplicateUserNameFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateUserNameFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateUserNameException::builder).build());
                    }
                    case "SubnetNotAllowedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotAllowedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotAllowedException::builder).build());
                    }
                    case "InvalidVPCNetworkStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                    }
                    case "InvalidParameterGroupStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                    }
                    case "ParameterGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                    }
                    case "ServiceLinkedRoleNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                    }
                    case "ParameterGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                    }
                    case "UserNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                    }
                    case "ClusterNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                    }
                    case "MultiRegionClusterAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterAlreadyExistsException::builder).build());
                    }
                    case "InvalidCredentialsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCredentialsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCredentialsException::builder).build());
                    }
                    case "InvalidClusterStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                    }
                    case "MultiRegionClusterNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterNotFoundException::builder).build());
                    }
                    case "SubnetGroupInUseFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                    }
                    case "InvalidSubnet": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                    }
                    case "ClusterAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                    }
                    case "NoOperationFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoOperationException::builder).build());
                    }
                    case "ShardNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShardNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardNotFoundException::builder).build());
                    }
                    case "ACLNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclNotFoundException::builder).build());
                    }
                    case "SubnetGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                    }
                    case "ReservedNodesOfferingNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodesOfferingNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodesOfferingNotFoundException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "SnapshotAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotAlreadyExistsException::builder).build());
                    }
                    case "SnapshotQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotQuotaExceededException::builder).build());
                    }
                    case "DefaultUserRequired": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DefaultUserRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultUserRequiredException::builder).build());
                    }
                    case "NodeQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                    }
                    case "UserAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserAlreadyExistsException::builder).build());
                    }
                    case "InvalidACLStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidACLStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAclStateException::builder).build());
                    }
                    case "TagNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                    }
                    case "ClusterQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                    }
                    case "APICallRateForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("APICallRateForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiCallRateForCustomerExceededException::builder).build());
                    }
                    case "NodeQuotaForClusterExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                    }
                    case "ServiceUpdateNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUpdateNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUpdateNotFoundException::builder).build());
                    }
                    case "SubnetQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                    }
                    case "ReservedNodeQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeQuotaExceededException::builder).build());
                    }
                    case "InvalidSnapshotStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnapshotStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnapshotStateException::builder).build());
                    }
                    case "InvalidNodeStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNodeStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNodeStateException::builder).build());
                    }
                    case "ShardsPerClusterQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShardsPerClusterQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardsPerClusterQuotaExceededException::builder).build());
                    }
                    case "ReservedNodeAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeAlreadyExistsException::builder).build());
                    }
                    case "ReservedNodeNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeNotFoundException::builder).build());
                    }
                    case "InvalidParameterCombinationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                    }
                    case "InvalidUserStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserStateException::builder).build());
                    }
                    case "SnapshotNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                    }
                    case "MultiRegionParameterGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionParameterGroupNotFoundException::builder).build());
                    }
                    case "ACLAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclAlreadyExistsException::builder).build());
                    }
                    case "InsufficientClusterCapacityFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                    }
                    case "UserQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserQuotaExceededException::builder).build());
                    }
                    case "TagQuotaPerResourceExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                    }
                    case "InvalidMultiRegionClusterStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMultiRegionClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMultiRegionClusterStateException::builder).build());
                    }
                    case "SubnetGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeUsers").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeUsersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeUsersRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMemoryDbAsyncClient.lambda$describeUsers$122(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMemoryDbAsyncClient.lambda$describeUsers$123((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<FailoverShardResponse> failoverShard(FailoverShardRequest failoverShardRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)failoverShardRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMemoryDbAsyncClient.resolveMetricPublishers(clientConfiguration, failoverShardRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MemoryDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"FailoverShard");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, FailoverShardResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "SubnetGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                    }
                    case "ParameterGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                    }
                    case "SubnetInUse": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                    }
                    case "InvalidARNFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "TestFailoverNotAvailableFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TestFailoverNotAvailableFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TestFailoverNotAvailableException::builder).build());
                    }
                    case "ACLQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclQuotaExceededException::builder).build());
                    }
                    case "InvalidKMSKeyFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKMSKeyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyException::builder).build());
                    }
                    case "DuplicateUserNameFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateUserNameFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateUserNameException::builder).build());
                    }
                    case "SubnetNotAllowedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotAllowedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotAllowedException::builder).build());
                    }
                    case "InvalidVPCNetworkStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                    }
                    case "InvalidParameterGroupStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                    }
                    case "ParameterGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                    }
                    case "ServiceLinkedRoleNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                    }
                    case "ParameterGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                    }
                    case "UserNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                    }
                    case "ClusterNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                    }
                    case "MultiRegionClusterAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterAlreadyExistsException::builder).build());
                    }
                    case "InvalidCredentialsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCredentialsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCredentialsException::builder).build());
                    }
                    case "InvalidClusterStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                    }
                    case "MultiRegionClusterNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterNotFoundException::builder).build());
                    }
                    case "SubnetGroupInUseFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                    }
                    case "InvalidSubnet": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                    }
                    case "ClusterAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                    }
                    case "NoOperationFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoOperationException::builder).build());
                    }
                    case "ShardNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShardNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardNotFoundException::builder).build());
                    }
                    case "ACLNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclNotFoundException::builder).build());
                    }
                    case "SubnetGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                    }
                    case "ReservedNodesOfferingNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodesOfferingNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodesOfferingNotFoundException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "SnapshotAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotAlreadyExistsException::builder).build());
                    }
                    case "SnapshotQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotQuotaExceededException::builder).build());
                    }
                    case "DefaultUserRequired": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DefaultUserRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultUserRequiredException::builder).build());
                    }
                    case "NodeQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                    }
                    case "UserAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserAlreadyExistsException::builder).build());
                    }
                    case "InvalidACLStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidACLStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAclStateException::builder).build());
                    }
                    case "TagNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                    }
                    case "ClusterQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                    }
                    case "APICallRateForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("APICallRateForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiCallRateForCustomerExceededException::builder).build());
                    }
                    case "NodeQuotaForClusterExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                    }
                    case "ServiceUpdateNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUpdateNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUpdateNotFoundException::builder).build());
                    }
                    case "SubnetQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                    }
                    case "ReservedNodeQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeQuotaExceededException::builder).build());
                    }
                    case "InvalidSnapshotStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnapshotStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnapshotStateException::builder).build());
                    }
                    case "InvalidNodeStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNodeStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNodeStateException::builder).build());
                    }
                    case "ShardsPerClusterQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShardsPerClusterQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardsPerClusterQuotaExceededException::builder).build());
                    }
                    case "ReservedNodeAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeAlreadyExistsException::builder).build());
                    }
                    case "ReservedNodeNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeNotFoundException::builder).build());
                    }
                    case "InvalidParameterCombinationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                    }
                    case "InvalidUserStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserStateException::builder).build());
                    }
                    case "SnapshotNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                    }
                    case "MultiRegionParameterGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionParameterGroupNotFoundException::builder).build());
                    }
                    case "ACLAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclAlreadyExistsException::builder).build());
                    }
                    case "InsufficientClusterCapacityFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                    }
                    case "UserQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserQuotaExceededException::builder).build());
                    }
                    case "TagQuotaPerResourceExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                    }
                    case "InvalidMultiRegionClusterStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMultiRegionClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMultiRegionClusterStateException::builder).build());
                    }
                    case "SubnetGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("FailoverShard").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new FailoverShardRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)failoverShardRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMemoryDbAsyncClient.lambda$failoverShard$126(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMemoryDbAsyncClient.lambda$failoverShard$127((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListAllowedMultiRegionClusterUpdatesResponse> listAllowedMultiRegionClusterUpdates(ListAllowedMultiRegionClusterUpdatesRequest listAllowedMultiRegionClusterUpdatesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listAllowedMultiRegionClusterUpdatesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMemoryDbAsyncClient.resolveMetricPublishers(clientConfiguration, listAllowedMultiRegionClusterUpdatesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MemoryDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListAllowedMultiRegionClusterUpdates");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListAllowedMultiRegionClusterUpdatesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "SubnetGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                    }
                    case "ParameterGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                    }
                    case "SubnetInUse": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                    }
                    case "InvalidARNFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "TestFailoverNotAvailableFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TestFailoverNotAvailableFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TestFailoverNotAvailableException::builder).build());
                    }
                    case "ACLQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclQuotaExceededException::builder).build());
                    }
                    case "InvalidKMSKeyFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKMSKeyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyException::builder).build());
                    }
                    case "DuplicateUserNameFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateUserNameFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateUserNameException::builder).build());
                    }
                    case "SubnetNotAllowedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotAllowedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotAllowedException::builder).build());
                    }
                    case "InvalidVPCNetworkStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                    }
                    case "InvalidParameterGroupStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                    }
                    case "ParameterGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                    }
                    case "ServiceLinkedRoleNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                    }
                    case "ParameterGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                    }
                    case "UserNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                    }
                    case "ClusterNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                    }
                    case "MultiRegionClusterAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterAlreadyExistsException::builder).build());
                    }
                    case "InvalidCredentialsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCredentialsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCredentialsException::builder).build());
                    }
                    case "InvalidClusterStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                    }
                    case "MultiRegionClusterNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterNotFoundException::builder).build());
                    }
                    case "SubnetGroupInUseFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                    }
                    case "InvalidSubnet": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                    }
                    case "ClusterAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                    }
                    case "NoOperationFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoOperationException::builder).build());
                    }
                    case "ShardNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShardNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardNotFoundException::builder).build());
                    }
                    case "ACLNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclNotFoundException::builder).build());
                    }
                    case "SubnetGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                    }
                    case "ReservedNodesOfferingNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodesOfferingNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodesOfferingNotFoundException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "SnapshotAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotAlreadyExistsException::builder).build());
                    }
                    case "SnapshotQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotQuotaExceededException::builder).build());
                    }
                    case "DefaultUserRequired": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DefaultUserRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultUserRequiredException::builder).build());
                    }
                    case "NodeQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                    }
                    case "UserAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserAlreadyExistsException::builder).build());
                    }
                    case "InvalidACLStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidACLStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAclStateException::builder).build());
                    }
                    case "TagNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                    }
                    case "ClusterQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                    }
                    case "APICallRateForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("APICallRateForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiCallRateForCustomerExceededException::builder).build());
                    }
                    case "NodeQuotaForClusterExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                    }
                    case "ServiceUpdateNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUpdateNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUpdateNotFoundException::builder).build());
                    }
                    case "SubnetQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                    }
                    case "ReservedNodeQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeQuotaExceededException::builder).build());
                    }
                    case "InvalidSnapshotStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnapshotStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnapshotStateException::builder).build());
                    }
                    case "InvalidNodeStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNodeStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNodeStateException::builder).build());
                    }
                    case "ShardsPerClusterQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShardsPerClusterQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardsPerClusterQuotaExceededException::builder).build());
                    }
                    case "ReservedNodeAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeAlreadyExistsException::builder).build());
                    }
                    case "ReservedNodeNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeNotFoundException::builder).build());
                    }
                    case "InvalidParameterCombinationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                    }
                    case "InvalidUserStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserStateException::builder).build());
                    }
                    case "SnapshotNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                    }
                    case "MultiRegionParameterGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionParameterGroupNotFoundException::builder).build());
                    }
                    case "ACLAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclAlreadyExistsException::builder).build());
                    }
                    case "InsufficientClusterCapacityFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                    }
                    case "UserQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserQuotaExceededException::builder).build());
                    }
                    case "TagQuotaPerResourceExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                    }
                    case "InvalidMultiRegionClusterStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMultiRegionClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMultiRegionClusterStateException::builder).build());
                    }
                    case "SubnetGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListAllowedMultiRegionClusterUpdates").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListAllowedMultiRegionClusterUpdatesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listAllowedMultiRegionClusterUpdatesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMemoryDbAsyncClient.lambda$listAllowedMultiRegionClusterUpdates$130(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMemoryDbAsyncClient.lambda$listAllowedMultiRegionClusterUpdates$131((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListAllowedNodeTypeUpdatesResponse> listAllowedNodeTypeUpdates(ListAllowedNodeTypeUpdatesRequest listAllowedNodeTypeUpdatesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listAllowedNodeTypeUpdatesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMemoryDbAsyncClient.resolveMetricPublishers(clientConfiguration, listAllowedNodeTypeUpdatesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MemoryDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListAllowedNodeTypeUpdates");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListAllowedNodeTypeUpdatesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "SubnetGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                    }
                    case "ParameterGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                    }
                    case "SubnetInUse": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                    }
                    case "InvalidARNFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "TestFailoverNotAvailableFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TestFailoverNotAvailableFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TestFailoverNotAvailableException::builder).build());
                    }
                    case "ACLQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclQuotaExceededException::builder).build());
                    }
                    case "InvalidKMSKeyFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKMSKeyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyException::builder).build());
                    }
                    case "DuplicateUserNameFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateUserNameFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateUserNameException::builder).build());
                    }
                    case "SubnetNotAllowedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotAllowedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotAllowedException::builder).build());
                    }
                    case "InvalidVPCNetworkStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                    }
                    case "InvalidParameterGroupStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                    }
                    case "ParameterGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                    }
                    case "ServiceLinkedRoleNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                    }
                    case "ParameterGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                    }
                    case "UserNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                    }
                    case "ClusterNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                    }
                    case "MultiRegionClusterAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterAlreadyExistsException::builder).build());
                    }
                    case "InvalidCredentialsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCredentialsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCredentialsException::builder).build());
                    }
                    case "InvalidClusterStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                    }
                    case "MultiRegionClusterNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterNotFoundException::builder).build());
                    }
                    case "SubnetGroupInUseFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                    }
                    case "InvalidSubnet": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                    }
                    case "ClusterAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                    }
                    case "NoOperationFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoOperationException::builder).build());
                    }
                    case "ShardNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShardNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardNotFoundException::builder).build());
                    }
                    case "ACLNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclNotFoundException::builder).build());
                    }
                    case "SubnetGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                    }
                    case "ReservedNodesOfferingNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodesOfferingNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodesOfferingNotFoundException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "SnapshotAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotAlreadyExistsException::builder).build());
                    }
                    case "SnapshotQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotQuotaExceededException::builder).build());
                    }
                    case "DefaultUserRequired": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DefaultUserRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultUserRequiredException::builder).build());
                    }
                    case "NodeQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                    }
                    case "UserAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserAlreadyExistsException::builder).build());
                    }
                    case "InvalidACLStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidACLStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAclStateException::builder).build());
                    }
                    case "TagNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                    }
                    case "ClusterQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                    }
                    case "APICallRateForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("APICallRateForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiCallRateForCustomerExceededException::builder).build());
                    }
                    case "NodeQuotaForClusterExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                    }
                    case "ServiceUpdateNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUpdateNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUpdateNotFoundException::builder).build());
                    }
                    case "SubnetQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                    }
                    case "ReservedNodeQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeQuotaExceededException::builder).build());
                    }
                    case "InvalidSnapshotStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnapshotStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnapshotStateException::builder).build());
                    }
                    case "InvalidNodeStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNodeStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNodeStateException::builder).build());
                    }
                    case "ShardsPerClusterQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShardsPerClusterQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardsPerClusterQuotaExceededException::builder).build());
                    }
                    case "ReservedNodeAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeAlreadyExistsException::builder).build());
                    }
                    case "ReservedNodeNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeNotFoundException::builder).build());
                    }
                    case "InvalidParameterCombinationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                    }
                    case "InvalidUserStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserStateException::builder).build());
                    }
                    case "SnapshotNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                    }
                    case "MultiRegionParameterGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionParameterGroupNotFoundException::builder).build());
                    }
                    case "ACLAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclAlreadyExistsException::builder).build());
                    }
                    case "InsufficientClusterCapacityFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                    }
                    case "UserQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserQuotaExceededException::builder).build());
                    }
                    case "TagQuotaPerResourceExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                    }
                    case "InvalidMultiRegionClusterStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMultiRegionClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMultiRegionClusterStateException::builder).build());
                    }
                    case "SubnetGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListAllowedNodeTypeUpdates").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListAllowedNodeTypeUpdatesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listAllowedNodeTypeUpdatesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMemoryDbAsyncClient.lambda$listAllowedNodeTypeUpdates$134(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMemoryDbAsyncClient.lambda$listAllowedNodeTypeUpdates$135((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListTagsResponse> listTags(ListTagsRequest listTagsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTagsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMemoryDbAsyncClient.resolveMetricPublishers(clientConfiguration, listTagsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MemoryDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTags");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "SubnetGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                    }
                    case "ParameterGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                    }
                    case "SubnetInUse": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                    }
                    case "InvalidARNFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "TestFailoverNotAvailableFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TestFailoverNotAvailableFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TestFailoverNotAvailableException::builder).build());
                    }
                    case "ACLQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclQuotaExceededException::builder).build());
                    }
                    case "InvalidKMSKeyFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKMSKeyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyException::builder).build());
                    }
                    case "DuplicateUserNameFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateUserNameFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateUserNameException::builder).build());
                    }
                    case "SubnetNotAllowedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotAllowedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotAllowedException::builder).build());
                    }
                    case "InvalidVPCNetworkStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                    }
                    case "InvalidParameterGroupStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                    }
                    case "ParameterGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                    }
                    case "ServiceLinkedRoleNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                    }
                    case "ParameterGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                    }
                    case "UserNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                    }
                    case "ClusterNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                    }
                    case "MultiRegionClusterAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterAlreadyExistsException::builder).build());
                    }
                    case "InvalidCredentialsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCredentialsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCredentialsException::builder).build());
                    }
                    case "InvalidClusterStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                    }
                    case "MultiRegionClusterNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterNotFoundException::builder).build());
                    }
                    case "SubnetGroupInUseFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                    }
                    case "InvalidSubnet": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                    }
                    case "ClusterAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                    }
                    case "NoOperationFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoOperationException::builder).build());
                    }
                    case "ShardNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShardNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardNotFoundException::builder).build());
                    }
                    case "ACLNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclNotFoundException::builder).build());
                    }
                    case "SubnetGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                    }
                    case "ReservedNodesOfferingNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodesOfferingNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodesOfferingNotFoundException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "SnapshotAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotAlreadyExistsException::builder).build());
                    }
                    case "SnapshotQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotQuotaExceededException::builder).build());
                    }
                    case "DefaultUserRequired": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DefaultUserRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultUserRequiredException::builder).build());
                    }
                    case "NodeQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                    }
                    case "UserAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserAlreadyExistsException::builder).build());
                    }
                    case "InvalidACLStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidACLStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAclStateException::builder).build());
                    }
                    case "TagNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                    }
                    case "ClusterQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                    }
                    case "APICallRateForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("APICallRateForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiCallRateForCustomerExceededException::builder).build());
                    }
                    case "NodeQuotaForClusterExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                    }
                    case "ServiceUpdateNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUpdateNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUpdateNotFoundException::builder).build());
                    }
                    case "SubnetQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                    }
                    case "ReservedNodeQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeQuotaExceededException::builder).build());
                    }
                    case "InvalidSnapshotStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnapshotStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnapshotStateException::builder).build());
                    }
                    case "InvalidNodeStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNodeStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNodeStateException::builder).build());
                    }
                    case "ShardsPerClusterQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShardsPerClusterQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardsPerClusterQuotaExceededException::builder).build());
                    }
                    case "ReservedNodeAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeAlreadyExistsException::builder).build());
                    }
                    case "ReservedNodeNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeNotFoundException::builder).build());
                    }
                    case "InvalidParameterCombinationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                    }
                    case "InvalidUserStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserStateException::builder).build());
                    }
                    case "SnapshotNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                    }
                    case "MultiRegionParameterGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionParameterGroupNotFoundException::builder).build());
                    }
                    case "ACLAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclAlreadyExistsException::builder).build());
                    }
                    case "InsufficientClusterCapacityFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                    }
                    case "UserQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserQuotaExceededException::builder).build());
                    }
                    case "TagQuotaPerResourceExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                    }
                    case "InvalidMultiRegionClusterStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMultiRegionClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMultiRegionClusterStateException::builder).build());
                    }
                    case "SubnetGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTags").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListTagsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listTagsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMemoryDbAsyncClient.lambda$listTags$138(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMemoryDbAsyncClient.lambda$listTags$139((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PurchaseReservedNodesOfferingResponse> purchaseReservedNodesOffering(PurchaseReservedNodesOfferingRequest purchaseReservedNodesOfferingRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)purchaseReservedNodesOfferingRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMemoryDbAsyncClient.resolveMetricPublishers(clientConfiguration, purchaseReservedNodesOfferingRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MemoryDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PurchaseReservedNodesOffering");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PurchaseReservedNodesOfferingResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "SubnetGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                    }
                    case "ParameterGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                    }
                    case "SubnetInUse": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                    }
                    case "InvalidARNFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "TestFailoverNotAvailableFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TestFailoverNotAvailableFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TestFailoverNotAvailableException::builder).build());
                    }
                    case "ACLQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclQuotaExceededException::builder).build());
                    }
                    case "InvalidKMSKeyFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKMSKeyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyException::builder).build());
                    }
                    case "DuplicateUserNameFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateUserNameFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateUserNameException::builder).build());
                    }
                    case "SubnetNotAllowedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotAllowedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotAllowedException::builder).build());
                    }
                    case "InvalidVPCNetworkStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                    }
                    case "InvalidParameterGroupStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                    }
                    case "ParameterGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                    }
                    case "ServiceLinkedRoleNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                    }
                    case "ParameterGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                    }
                    case "UserNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                    }
                    case "ClusterNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                    }
                    case "MultiRegionClusterAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterAlreadyExistsException::builder).build());
                    }
                    case "InvalidCredentialsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCredentialsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCredentialsException::builder).build());
                    }
                    case "InvalidClusterStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                    }
                    case "MultiRegionClusterNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterNotFoundException::builder).build());
                    }
                    case "SubnetGroupInUseFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                    }
                    case "InvalidSubnet": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                    }
                    case "ClusterAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                    }
                    case "NoOperationFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoOperationException::builder).build());
                    }
                    case "ShardNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShardNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardNotFoundException::builder).build());
                    }
                    case "ACLNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclNotFoundException::builder).build());
                    }
                    case "SubnetGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                    }
                    case "ReservedNodesOfferingNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodesOfferingNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodesOfferingNotFoundException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "SnapshotAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotAlreadyExistsException::builder).build());
                    }
                    case "SnapshotQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotQuotaExceededException::builder).build());
                    }
                    case "DefaultUserRequired": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DefaultUserRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultUserRequiredException::builder).build());
                    }
                    case "NodeQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                    }
                    case "UserAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserAlreadyExistsException::builder).build());
                    }
                    case "InvalidACLStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidACLStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAclStateException::builder).build());
                    }
                    case "TagNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                    }
                    case "ClusterQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                    }
                    case "APICallRateForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("APICallRateForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiCallRateForCustomerExceededException::builder).build());
                    }
                    case "NodeQuotaForClusterExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                    }
                    case "ServiceUpdateNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUpdateNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUpdateNotFoundException::builder).build());
                    }
                    case "SubnetQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                    }
                    case "ReservedNodeQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeQuotaExceededException::builder).build());
                    }
                    case "InvalidSnapshotStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnapshotStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnapshotStateException::builder).build());
                    }
                    case "InvalidNodeStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNodeStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNodeStateException::builder).build());
                    }
                    case "ShardsPerClusterQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShardsPerClusterQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardsPerClusterQuotaExceededException::builder).build());
                    }
                    case "ReservedNodeAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeAlreadyExistsException::builder).build());
                    }
                    case "ReservedNodeNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeNotFoundException::builder).build());
                    }
                    case "InvalidParameterCombinationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                    }
                    case "InvalidUserStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserStateException::builder).build());
                    }
                    case "SnapshotNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                    }
                    case "MultiRegionParameterGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionParameterGroupNotFoundException::builder).build());
                    }
                    case "ACLAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclAlreadyExistsException::builder).build());
                    }
                    case "InsufficientClusterCapacityFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                    }
                    case "UserQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserQuotaExceededException::builder).build());
                    }
                    case "TagQuotaPerResourceExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                    }
                    case "InvalidMultiRegionClusterStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMultiRegionClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMultiRegionClusterStateException::builder).build());
                    }
                    case "SubnetGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PurchaseReservedNodesOffering").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new PurchaseReservedNodesOfferingRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)purchaseReservedNodesOfferingRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMemoryDbAsyncClient.lambda$purchaseReservedNodesOffering$142(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMemoryDbAsyncClient.lambda$purchaseReservedNodesOffering$143((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ResetParameterGroupResponse> resetParameterGroup(ResetParameterGroupRequest resetParameterGroupRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)resetParameterGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMemoryDbAsyncClient.resolveMetricPublishers(clientConfiguration, resetParameterGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MemoryDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ResetParameterGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ResetParameterGroupResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "SubnetGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                    }
                    case "ParameterGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                    }
                    case "SubnetInUse": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                    }
                    case "InvalidARNFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "TestFailoverNotAvailableFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TestFailoverNotAvailableFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TestFailoverNotAvailableException::builder).build());
                    }
                    case "ACLQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclQuotaExceededException::builder).build());
                    }
                    case "InvalidKMSKeyFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKMSKeyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyException::builder).build());
                    }
                    case "DuplicateUserNameFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateUserNameFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateUserNameException::builder).build());
                    }
                    case "SubnetNotAllowedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotAllowedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotAllowedException::builder).build());
                    }
                    case "InvalidVPCNetworkStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                    }
                    case "InvalidParameterGroupStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                    }
                    case "ParameterGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                    }
                    case "ServiceLinkedRoleNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                    }
                    case "ParameterGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                    }
                    case "UserNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                    }
                    case "ClusterNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                    }
                    case "MultiRegionClusterAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterAlreadyExistsException::builder).build());
                    }
                    case "InvalidCredentialsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCredentialsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCredentialsException::builder).build());
                    }
                    case "InvalidClusterStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                    }
                    case "MultiRegionClusterNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterNotFoundException::builder).build());
                    }
                    case "SubnetGroupInUseFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                    }
                    case "InvalidSubnet": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                    }
                    case "ClusterAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                    }
                    case "NoOperationFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoOperationException::builder).build());
                    }
                    case "ShardNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShardNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardNotFoundException::builder).build());
                    }
                    case "ACLNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclNotFoundException::builder).build());
                    }
                    case "SubnetGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                    }
                    case "ReservedNodesOfferingNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodesOfferingNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodesOfferingNotFoundException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "SnapshotAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotAlreadyExistsException::builder).build());
                    }
                    case "SnapshotQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotQuotaExceededException::builder).build());
                    }
                    case "DefaultUserRequired": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DefaultUserRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultUserRequiredException::builder).build());
                    }
                    case "NodeQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                    }
                    case "UserAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserAlreadyExistsException::builder).build());
                    }
                    case "InvalidACLStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidACLStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAclStateException::builder).build());
                    }
                    case "TagNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                    }
                    case "ClusterQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                    }
                    case "APICallRateForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("APICallRateForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiCallRateForCustomerExceededException::builder).build());
                    }
                    case "NodeQuotaForClusterExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                    }
                    case "ServiceUpdateNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUpdateNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUpdateNotFoundException::builder).build());
                    }
                    case "SubnetQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                    }
                    case "ReservedNodeQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeQuotaExceededException::builder).build());
                    }
                    case "InvalidSnapshotStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnapshotStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnapshotStateException::builder).build());
                    }
                    case "InvalidNodeStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNodeStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNodeStateException::builder).build());
                    }
                    case "ShardsPerClusterQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShardsPerClusterQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardsPerClusterQuotaExceededException::builder).build());
                    }
                    case "ReservedNodeAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeAlreadyExistsException::builder).build());
                    }
                    case "ReservedNodeNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeNotFoundException::builder).build());
                    }
                    case "InvalidParameterCombinationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                    }
                    case "InvalidUserStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserStateException::builder).build());
                    }
                    case "SnapshotNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                    }
                    case "MultiRegionParameterGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionParameterGroupNotFoundException::builder).build());
                    }
                    case "ACLAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclAlreadyExistsException::builder).build());
                    }
                    case "InsufficientClusterCapacityFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                    }
                    case "UserQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserQuotaExceededException::builder).build());
                    }
                    case "TagQuotaPerResourceExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                    }
                    case "InvalidMultiRegionClusterStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMultiRegionClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMultiRegionClusterStateException::builder).build());
                    }
                    case "SubnetGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ResetParameterGroup").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ResetParameterGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)resetParameterGroupRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMemoryDbAsyncClient.lambda$resetParameterGroup$146(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMemoryDbAsyncClient.lambda$resetParameterGroup$147((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMemoryDbAsyncClient.resolveMetricPublishers(clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MemoryDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "SubnetGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                    }
                    case "ParameterGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                    }
                    case "SubnetInUse": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                    }
                    case "InvalidARNFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "TestFailoverNotAvailableFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TestFailoverNotAvailableFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TestFailoverNotAvailableException::builder).build());
                    }
                    case "ACLQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclQuotaExceededException::builder).build());
                    }
                    case "InvalidKMSKeyFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKMSKeyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyException::builder).build());
                    }
                    case "DuplicateUserNameFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateUserNameFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateUserNameException::builder).build());
                    }
                    case "SubnetNotAllowedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotAllowedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotAllowedException::builder).build());
                    }
                    case "InvalidVPCNetworkStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                    }
                    case "InvalidParameterGroupStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                    }
                    case "ParameterGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                    }
                    case "ServiceLinkedRoleNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                    }
                    case "ParameterGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                    }
                    case "UserNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                    }
                    case "ClusterNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                    }
                    case "MultiRegionClusterAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterAlreadyExistsException::builder).build());
                    }
                    case "InvalidCredentialsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCredentialsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCredentialsException::builder).build());
                    }
                    case "InvalidClusterStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                    }
                    case "MultiRegionClusterNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterNotFoundException::builder).build());
                    }
                    case "SubnetGroupInUseFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                    }
                    case "InvalidSubnet": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                    }
                    case "ClusterAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                    }
                    case "NoOperationFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoOperationException::builder).build());
                    }
                    case "ShardNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShardNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardNotFoundException::builder).build());
                    }
                    case "ACLNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclNotFoundException::builder).build());
                    }
                    case "SubnetGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                    }
                    case "ReservedNodesOfferingNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodesOfferingNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodesOfferingNotFoundException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "SnapshotAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotAlreadyExistsException::builder).build());
                    }
                    case "SnapshotQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotQuotaExceededException::builder).build());
                    }
                    case "DefaultUserRequired": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DefaultUserRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultUserRequiredException::builder).build());
                    }
                    case "NodeQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                    }
                    case "UserAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserAlreadyExistsException::builder).build());
                    }
                    case "InvalidACLStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidACLStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAclStateException::builder).build());
                    }
                    case "TagNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                    }
                    case "ClusterQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                    }
                    case "APICallRateForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("APICallRateForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiCallRateForCustomerExceededException::builder).build());
                    }
                    case "NodeQuotaForClusterExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                    }
                    case "ServiceUpdateNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUpdateNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUpdateNotFoundException::builder).build());
                    }
                    case "SubnetQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                    }
                    case "ReservedNodeQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeQuotaExceededException::builder).build());
                    }
                    case "InvalidSnapshotStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnapshotStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnapshotStateException::builder).build());
                    }
                    case "InvalidNodeStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNodeStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNodeStateException::builder).build());
                    }
                    case "ShardsPerClusterQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShardsPerClusterQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardsPerClusterQuotaExceededException::builder).build());
                    }
                    case "ReservedNodeAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeAlreadyExistsException::builder).build());
                    }
                    case "ReservedNodeNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeNotFoundException::builder).build());
                    }
                    case "InvalidParameterCombinationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                    }
                    case "InvalidUserStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserStateException::builder).build());
                    }
                    case "SnapshotNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                    }
                    case "MultiRegionParameterGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionParameterGroupNotFoundException::builder).build());
                    }
                    case "ACLAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclAlreadyExistsException::builder).build());
                    }
                    case "InsufficientClusterCapacityFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                    }
                    case "UserQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserQuotaExceededException::builder).build());
                    }
                    case "TagQuotaPerResourceExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                    }
                    case "InvalidMultiRegionClusterStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMultiRegionClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMultiRegionClusterStateException::builder).build());
                    }
                    case "SubnetGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)tagResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMemoryDbAsyncClient.lambda$tagResource$150(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMemoryDbAsyncClient.lambda$tagResource$151((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMemoryDbAsyncClient.resolveMetricPublishers(clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MemoryDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "SubnetGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                    }
                    case "ParameterGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                    }
                    case "SubnetInUse": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                    }
                    case "InvalidARNFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "TestFailoverNotAvailableFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TestFailoverNotAvailableFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TestFailoverNotAvailableException::builder).build());
                    }
                    case "ACLQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclQuotaExceededException::builder).build());
                    }
                    case "InvalidKMSKeyFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKMSKeyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyException::builder).build());
                    }
                    case "DuplicateUserNameFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateUserNameFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateUserNameException::builder).build());
                    }
                    case "SubnetNotAllowedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotAllowedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotAllowedException::builder).build());
                    }
                    case "InvalidVPCNetworkStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                    }
                    case "InvalidParameterGroupStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                    }
                    case "ParameterGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                    }
                    case "ServiceLinkedRoleNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                    }
                    case "ParameterGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                    }
                    case "UserNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                    }
                    case "ClusterNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                    }
                    case "MultiRegionClusterAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterAlreadyExistsException::builder).build());
                    }
                    case "InvalidCredentialsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCredentialsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCredentialsException::builder).build());
                    }
                    case "InvalidClusterStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                    }
                    case "MultiRegionClusterNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterNotFoundException::builder).build());
                    }
                    case "SubnetGroupInUseFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                    }
                    case "InvalidSubnet": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                    }
                    case "ClusterAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                    }
                    case "NoOperationFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoOperationException::builder).build());
                    }
                    case "ShardNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShardNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardNotFoundException::builder).build());
                    }
                    case "ACLNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclNotFoundException::builder).build());
                    }
                    case "SubnetGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                    }
                    case "ReservedNodesOfferingNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodesOfferingNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodesOfferingNotFoundException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "SnapshotAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotAlreadyExistsException::builder).build());
                    }
                    case "SnapshotQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotQuotaExceededException::builder).build());
                    }
                    case "DefaultUserRequired": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DefaultUserRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultUserRequiredException::builder).build());
                    }
                    case "NodeQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                    }
                    case "UserAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserAlreadyExistsException::builder).build());
                    }
                    case "InvalidACLStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidACLStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAclStateException::builder).build());
                    }
                    case "TagNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                    }
                    case "ClusterQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                    }
                    case "APICallRateForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("APICallRateForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiCallRateForCustomerExceededException::builder).build());
                    }
                    case "NodeQuotaForClusterExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                    }
                    case "ServiceUpdateNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUpdateNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUpdateNotFoundException::builder).build());
                    }
                    case "SubnetQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                    }
                    case "ReservedNodeQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeQuotaExceededException::builder).build());
                    }
                    case "InvalidSnapshotStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnapshotStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnapshotStateException::builder).build());
                    }
                    case "InvalidNodeStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNodeStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNodeStateException::builder).build());
                    }
                    case "ShardsPerClusterQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShardsPerClusterQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardsPerClusterQuotaExceededException::builder).build());
                    }
                    case "ReservedNodeAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeAlreadyExistsException::builder).build());
                    }
                    case "ReservedNodeNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeNotFoundException::builder).build());
                    }
                    case "InvalidParameterCombinationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                    }
                    case "InvalidUserStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserStateException::builder).build());
                    }
                    case "SnapshotNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                    }
                    case "MultiRegionParameterGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionParameterGroupNotFoundException::builder).build());
                    }
                    case "ACLAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclAlreadyExistsException::builder).build());
                    }
                    case "InsufficientClusterCapacityFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                    }
                    case "UserQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserQuotaExceededException::builder).build());
                    }
                    case "TagQuotaPerResourceExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                    }
                    case "InvalidMultiRegionClusterStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMultiRegionClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMultiRegionClusterStateException::builder).build());
                    }
                    case "SubnetGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)untagResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMemoryDbAsyncClient.lambda$untagResource$154(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMemoryDbAsyncClient.lambda$untagResource$155((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateAclResponse> updateACL(UpdateAclRequest updateAclRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateAclRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMemoryDbAsyncClient.resolveMetricPublishers(clientConfiguration, updateAclRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MemoryDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateACL");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateAclResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "SubnetGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                    }
                    case "ParameterGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                    }
                    case "SubnetInUse": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                    }
                    case "InvalidARNFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "TestFailoverNotAvailableFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TestFailoverNotAvailableFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TestFailoverNotAvailableException::builder).build());
                    }
                    case "ACLQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclQuotaExceededException::builder).build());
                    }
                    case "InvalidKMSKeyFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKMSKeyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyException::builder).build());
                    }
                    case "DuplicateUserNameFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateUserNameFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateUserNameException::builder).build());
                    }
                    case "SubnetNotAllowedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotAllowedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotAllowedException::builder).build());
                    }
                    case "InvalidVPCNetworkStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                    }
                    case "InvalidParameterGroupStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                    }
                    case "ParameterGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                    }
                    case "ServiceLinkedRoleNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                    }
                    case "ParameterGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                    }
                    case "UserNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                    }
                    case "ClusterNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                    }
                    case "MultiRegionClusterAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterAlreadyExistsException::builder).build());
                    }
                    case "InvalidCredentialsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCredentialsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCredentialsException::builder).build());
                    }
                    case "InvalidClusterStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                    }
                    case "MultiRegionClusterNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterNotFoundException::builder).build());
                    }
                    case "SubnetGroupInUseFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                    }
                    case "InvalidSubnet": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                    }
                    case "ClusterAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                    }
                    case "NoOperationFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoOperationException::builder).build());
                    }
                    case "ShardNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShardNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardNotFoundException::builder).build());
                    }
                    case "ACLNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclNotFoundException::builder).build());
                    }
                    case "SubnetGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                    }
                    case "ReservedNodesOfferingNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodesOfferingNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodesOfferingNotFoundException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "SnapshotAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotAlreadyExistsException::builder).build());
                    }
                    case "SnapshotQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotQuotaExceededException::builder).build());
                    }
                    case "DefaultUserRequired": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DefaultUserRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultUserRequiredException::builder).build());
                    }
                    case "NodeQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                    }
                    case "UserAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserAlreadyExistsException::builder).build());
                    }
                    case "InvalidACLStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidACLStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAclStateException::builder).build());
                    }
                    case "TagNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                    }
                    case "ClusterQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                    }
                    case "APICallRateForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("APICallRateForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiCallRateForCustomerExceededException::builder).build());
                    }
                    case "NodeQuotaForClusterExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                    }
                    case "ServiceUpdateNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUpdateNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUpdateNotFoundException::builder).build());
                    }
                    case "SubnetQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                    }
                    case "ReservedNodeQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeQuotaExceededException::builder).build());
                    }
                    case "InvalidSnapshotStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnapshotStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnapshotStateException::builder).build());
                    }
                    case "InvalidNodeStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNodeStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNodeStateException::builder).build());
                    }
                    case "ShardsPerClusterQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShardsPerClusterQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardsPerClusterQuotaExceededException::builder).build());
                    }
                    case "ReservedNodeAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeAlreadyExistsException::builder).build());
                    }
                    case "ReservedNodeNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeNotFoundException::builder).build());
                    }
                    case "InvalidParameterCombinationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                    }
                    case "InvalidUserStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserStateException::builder).build());
                    }
                    case "SnapshotNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                    }
                    case "MultiRegionParameterGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionParameterGroupNotFoundException::builder).build());
                    }
                    case "ACLAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclAlreadyExistsException::builder).build());
                    }
                    case "InsufficientClusterCapacityFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                    }
                    case "UserQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserQuotaExceededException::builder).build());
                    }
                    case "TagQuotaPerResourceExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                    }
                    case "InvalidMultiRegionClusterStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMultiRegionClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMultiRegionClusterStateException::builder).build());
                    }
                    case "SubnetGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateACL").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateAclRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateAclRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMemoryDbAsyncClient.lambda$updateACL$158(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMemoryDbAsyncClient.lambda$updateACL$159((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateClusterResponse> updateCluster(UpdateClusterRequest updateClusterRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateClusterRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMemoryDbAsyncClient.resolveMetricPublishers(clientConfiguration, updateClusterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MemoryDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateCluster");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateClusterResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "SubnetGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                    }
                    case "ParameterGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                    }
                    case "SubnetInUse": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                    }
                    case "InvalidARNFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "TestFailoverNotAvailableFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TestFailoverNotAvailableFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TestFailoverNotAvailableException::builder).build());
                    }
                    case "ACLQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclQuotaExceededException::builder).build());
                    }
                    case "InvalidKMSKeyFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKMSKeyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyException::builder).build());
                    }
                    case "DuplicateUserNameFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateUserNameFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateUserNameException::builder).build());
                    }
                    case "SubnetNotAllowedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotAllowedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotAllowedException::builder).build());
                    }
                    case "InvalidVPCNetworkStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                    }
                    case "InvalidParameterGroupStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                    }
                    case "ParameterGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                    }
                    case "ServiceLinkedRoleNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                    }
                    case "ParameterGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                    }
                    case "UserNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                    }
                    case "ClusterNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                    }
                    case "MultiRegionClusterAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterAlreadyExistsException::builder).build());
                    }
                    case "InvalidCredentialsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCredentialsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCredentialsException::builder).build());
                    }
                    case "InvalidClusterStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                    }
                    case "MultiRegionClusterNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterNotFoundException::builder).build());
                    }
                    case "SubnetGroupInUseFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                    }
                    case "InvalidSubnet": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                    }
                    case "ClusterAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                    }
                    case "NoOperationFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoOperationException::builder).build());
                    }
                    case "ShardNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShardNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardNotFoundException::builder).build());
                    }
                    case "ACLNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclNotFoundException::builder).build());
                    }
                    case "SubnetGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                    }
                    case "ReservedNodesOfferingNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodesOfferingNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodesOfferingNotFoundException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "SnapshotAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotAlreadyExistsException::builder).build());
                    }
                    case "SnapshotQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotQuotaExceededException::builder).build());
                    }
                    case "DefaultUserRequired": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DefaultUserRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultUserRequiredException::builder).build());
                    }
                    case "NodeQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                    }
                    case "UserAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserAlreadyExistsException::builder).build());
                    }
                    case "InvalidACLStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidACLStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAclStateException::builder).build());
                    }
                    case "TagNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                    }
                    case "ClusterQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                    }
                    case "APICallRateForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("APICallRateForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiCallRateForCustomerExceededException::builder).build());
                    }
                    case "NodeQuotaForClusterExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                    }
                    case "ServiceUpdateNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUpdateNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUpdateNotFoundException::builder).build());
                    }
                    case "SubnetQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                    }
                    case "ReservedNodeQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeQuotaExceededException::builder).build());
                    }
                    case "InvalidSnapshotStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnapshotStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnapshotStateException::builder).build());
                    }
                    case "InvalidNodeStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNodeStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNodeStateException::builder).build());
                    }
                    case "ShardsPerClusterQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShardsPerClusterQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardsPerClusterQuotaExceededException::builder).build());
                    }
                    case "ReservedNodeAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeAlreadyExistsException::builder).build());
                    }
                    case "ReservedNodeNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeNotFoundException::builder).build());
                    }
                    case "InvalidParameterCombinationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                    }
                    case "InvalidUserStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserStateException::builder).build());
                    }
                    case "SnapshotNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                    }
                    case "MultiRegionParameterGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionParameterGroupNotFoundException::builder).build());
                    }
                    case "ACLAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclAlreadyExistsException::builder).build());
                    }
                    case "InsufficientClusterCapacityFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                    }
                    case "UserQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserQuotaExceededException::builder).build());
                    }
                    case "TagQuotaPerResourceExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                    }
                    case "InvalidMultiRegionClusterStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMultiRegionClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMultiRegionClusterStateException::builder).build());
                    }
                    case "SubnetGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateCluster").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateClusterRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateClusterRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMemoryDbAsyncClient.lambda$updateCluster$162(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMemoryDbAsyncClient.lambda$updateCluster$163((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateMultiRegionClusterResponse> updateMultiRegionCluster(UpdateMultiRegionClusterRequest updateMultiRegionClusterRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateMultiRegionClusterRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMemoryDbAsyncClient.resolveMetricPublishers(clientConfiguration, updateMultiRegionClusterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MemoryDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateMultiRegionCluster");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateMultiRegionClusterResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "SubnetGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                    }
                    case "ParameterGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                    }
                    case "SubnetInUse": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                    }
                    case "InvalidARNFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "TestFailoverNotAvailableFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TestFailoverNotAvailableFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TestFailoverNotAvailableException::builder).build());
                    }
                    case "ACLQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclQuotaExceededException::builder).build());
                    }
                    case "InvalidKMSKeyFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKMSKeyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyException::builder).build());
                    }
                    case "DuplicateUserNameFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateUserNameFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateUserNameException::builder).build());
                    }
                    case "SubnetNotAllowedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotAllowedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotAllowedException::builder).build());
                    }
                    case "InvalidVPCNetworkStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                    }
                    case "InvalidParameterGroupStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                    }
                    case "ParameterGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                    }
                    case "ServiceLinkedRoleNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                    }
                    case "ParameterGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                    }
                    case "UserNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                    }
                    case "ClusterNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                    }
                    case "MultiRegionClusterAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterAlreadyExistsException::builder).build());
                    }
                    case "InvalidCredentialsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCredentialsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCredentialsException::builder).build());
                    }
                    case "InvalidClusterStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                    }
                    case "MultiRegionClusterNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterNotFoundException::builder).build());
                    }
                    case "SubnetGroupInUseFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                    }
                    case "InvalidSubnet": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                    }
                    case "ClusterAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                    }
                    case "NoOperationFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoOperationException::builder).build());
                    }
                    case "ShardNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShardNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardNotFoundException::builder).build());
                    }
                    case "ACLNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclNotFoundException::builder).build());
                    }
                    case "SubnetGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                    }
                    case "ReservedNodesOfferingNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodesOfferingNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodesOfferingNotFoundException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "SnapshotAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotAlreadyExistsException::builder).build());
                    }
                    case "SnapshotQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotQuotaExceededException::builder).build());
                    }
                    case "DefaultUserRequired": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DefaultUserRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultUserRequiredException::builder).build());
                    }
                    case "NodeQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                    }
                    case "UserAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserAlreadyExistsException::builder).build());
                    }
                    case "InvalidACLStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidACLStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAclStateException::builder).build());
                    }
                    case "TagNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                    }
                    case "ClusterQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                    }
                    case "APICallRateForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("APICallRateForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiCallRateForCustomerExceededException::builder).build());
                    }
                    case "NodeQuotaForClusterExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                    }
                    case "ServiceUpdateNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUpdateNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUpdateNotFoundException::builder).build());
                    }
                    case "SubnetQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                    }
                    case "ReservedNodeQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeQuotaExceededException::builder).build());
                    }
                    case "InvalidSnapshotStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnapshotStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnapshotStateException::builder).build());
                    }
                    case "InvalidNodeStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNodeStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNodeStateException::builder).build());
                    }
                    case "ShardsPerClusterQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShardsPerClusterQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardsPerClusterQuotaExceededException::builder).build());
                    }
                    case "ReservedNodeAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeAlreadyExistsException::builder).build());
                    }
                    case "ReservedNodeNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeNotFoundException::builder).build());
                    }
                    case "InvalidParameterCombinationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                    }
                    case "InvalidUserStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserStateException::builder).build());
                    }
                    case "SnapshotNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                    }
                    case "MultiRegionParameterGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionParameterGroupNotFoundException::builder).build());
                    }
                    case "ACLAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclAlreadyExistsException::builder).build());
                    }
                    case "InsufficientClusterCapacityFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                    }
                    case "UserQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserQuotaExceededException::builder).build());
                    }
                    case "TagQuotaPerResourceExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                    }
                    case "InvalidMultiRegionClusterStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMultiRegionClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMultiRegionClusterStateException::builder).build());
                    }
                    case "SubnetGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateMultiRegionCluster").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateMultiRegionClusterRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateMultiRegionClusterRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMemoryDbAsyncClient.lambda$updateMultiRegionCluster$166(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMemoryDbAsyncClient.lambda$updateMultiRegionCluster$167((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateParameterGroupResponse> updateParameterGroup(UpdateParameterGroupRequest updateParameterGroupRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateParameterGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMemoryDbAsyncClient.resolveMetricPublishers(clientConfiguration, updateParameterGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MemoryDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateParameterGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateParameterGroupResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "SubnetGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                    }
                    case "ParameterGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                    }
                    case "SubnetInUse": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                    }
                    case "InvalidARNFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "TestFailoverNotAvailableFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TestFailoverNotAvailableFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TestFailoverNotAvailableException::builder).build());
                    }
                    case "ACLQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclQuotaExceededException::builder).build());
                    }
                    case "InvalidKMSKeyFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKMSKeyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyException::builder).build());
                    }
                    case "DuplicateUserNameFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateUserNameFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateUserNameException::builder).build());
                    }
                    case "SubnetNotAllowedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotAllowedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotAllowedException::builder).build());
                    }
                    case "InvalidVPCNetworkStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                    }
                    case "InvalidParameterGroupStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                    }
                    case "ParameterGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                    }
                    case "ServiceLinkedRoleNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                    }
                    case "ParameterGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                    }
                    case "UserNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                    }
                    case "ClusterNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                    }
                    case "MultiRegionClusterAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterAlreadyExistsException::builder).build());
                    }
                    case "InvalidCredentialsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCredentialsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCredentialsException::builder).build());
                    }
                    case "InvalidClusterStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                    }
                    case "MultiRegionClusterNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterNotFoundException::builder).build());
                    }
                    case "SubnetGroupInUseFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                    }
                    case "InvalidSubnet": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                    }
                    case "ClusterAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                    }
                    case "NoOperationFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoOperationException::builder).build());
                    }
                    case "ShardNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShardNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardNotFoundException::builder).build());
                    }
                    case "ACLNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclNotFoundException::builder).build());
                    }
                    case "SubnetGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                    }
                    case "ReservedNodesOfferingNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodesOfferingNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodesOfferingNotFoundException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "SnapshotAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotAlreadyExistsException::builder).build());
                    }
                    case "SnapshotQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotQuotaExceededException::builder).build());
                    }
                    case "DefaultUserRequired": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DefaultUserRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultUserRequiredException::builder).build());
                    }
                    case "NodeQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                    }
                    case "UserAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserAlreadyExistsException::builder).build());
                    }
                    case "InvalidACLStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidACLStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAclStateException::builder).build());
                    }
                    case "TagNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                    }
                    case "ClusterQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                    }
                    case "APICallRateForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("APICallRateForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiCallRateForCustomerExceededException::builder).build());
                    }
                    case "NodeQuotaForClusterExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                    }
                    case "ServiceUpdateNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUpdateNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUpdateNotFoundException::builder).build());
                    }
                    case "SubnetQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                    }
                    case "ReservedNodeQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeQuotaExceededException::builder).build());
                    }
                    case "InvalidSnapshotStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnapshotStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnapshotStateException::builder).build());
                    }
                    case "InvalidNodeStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNodeStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNodeStateException::builder).build());
                    }
                    case "ShardsPerClusterQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShardsPerClusterQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardsPerClusterQuotaExceededException::builder).build());
                    }
                    case "ReservedNodeAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeAlreadyExistsException::builder).build());
                    }
                    case "ReservedNodeNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeNotFoundException::builder).build());
                    }
                    case "InvalidParameterCombinationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                    }
                    case "InvalidUserStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserStateException::builder).build());
                    }
                    case "SnapshotNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                    }
                    case "MultiRegionParameterGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionParameterGroupNotFoundException::builder).build());
                    }
                    case "ACLAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclAlreadyExistsException::builder).build());
                    }
                    case "InsufficientClusterCapacityFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                    }
                    case "UserQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserQuotaExceededException::builder).build());
                    }
                    case "TagQuotaPerResourceExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                    }
                    case "InvalidMultiRegionClusterStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMultiRegionClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMultiRegionClusterStateException::builder).build());
                    }
                    case "SubnetGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateParameterGroup").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateParameterGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateParameterGroupRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMemoryDbAsyncClient.lambda$updateParameterGroup$170(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMemoryDbAsyncClient.lambda$updateParameterGroup$171((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateSubnetGroupResponse> updateSubnetGroup(UpdateSubnetGroupRequest updateSubnetGroupRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateSubnetGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMemoryDbAsyncClient.resolveMetricPublishers(clientConfiguration, updateSubnetGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MemoryDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateSubnetGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateSubnetGroupResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "SubnetGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                    }
                    case "ParameterGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                    }
                    case "SubnetInUse": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                    }
                    case "InvalidARNFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "TestFailoverNotAvailableFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TestFailoverNotAvailableFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TestFailoverNotAvailableException::builder).build());
                    }
                    case "ACLQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclQuotaExceededException::builder).build());
                    }
                    case "InvalidKMSKeyFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKMSKeyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyException::builder).build());
                    }
                    case "DuplicateUserNameFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateUserNameFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateUserNameException::builder).build());
                    }
                    case "SubnetNotAllowedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotAllowedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotAllowedException::builder).build());
                    }
                    case "InvalidVPCNetworkStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                    }
                    case "InvalidParameterGroupStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                    }
                    case "ParameterGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                    }
                    case "ServiceLinkedRoleNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                    }
                    case "ParameterGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                    }
                    case "UserNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                    }
                    case "ClusterNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                    }
                    case "MultiRegionClusterAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterAlreadyExistsException::builder).build());
                    }
                    case "InvalidCredentialsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCredentialsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCredentialsException::builder).build());
                    }
                    case "InvalidClusterStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                    }
                    case "MultiRegionClusterNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterNotFoundException::builder).build());
                    }
                    case "SubnetGroupInUseFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                    }
                    case "InvalidSubnet": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                    }
                    case "ClusterAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                    }
                    case "NoOperationFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoOperationException::builder).build());
                    }
                    case "ShardNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShardNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardNotFoundException::builder).build());
                    }
                    case "ACLNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclNotFoundException::builder).build());
                    }
                    case "SubnetGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                    }
                    case "ReservedNodesOfferingNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodesOfferingNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodesOfferingNotFoundException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "SnapshotAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotAlreadyExistsException::builder).build());
                    }
                    case "SnapshotQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotQuotaExceededException::builder).build());
                    }
                    case "DefaultUserRequired": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DefaultUserRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultUserRequiredException::builder).build());
                    }
                    case "NodeQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                    }
                    case "UserAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserAlreadyExistsException::builder).build());
                    }
                    case "InvalidACLStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidACLStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAclStateException::builder).build());
                    }
                    case "TagNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                    }
                    case "ClusterQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                    }
                    case "APICallRateForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("APICallRateForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiCallRateForCustomerExceededException::builder).build());
                    }
                    case "NodeQuotaForClusterExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                    }
                    case "ServiceUpdateNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUpdateNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUpdateNotFoundException::builder).build());
                    }
                    case "SubnetQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                    }
                    case "ReservedNodeQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeQuotaExceededException::builder).build());
                    }
                    case "InvalidSnapshotStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnapshotStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnapshotStateException::builder).build());
                    }
                    case "InvalidNodeStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNodeStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNodeStateException::builder).build());
                    }
                    case "ShardsPerClusterQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShardsPerClusterQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardsPerClusterQuotaExceededException::builder).build());
                    }
                    case "ReservedNodeAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeAlreadyExistsException::builder).build());
                    }
                    case "ReservedNodeNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeNotFoundException::builder).build());
                    }
                    case "InvalidParameterCombinationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                    }
                    case "InvalidUserStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserStateException::builder).build());
                    }
                    case "SnapshotNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                    }
                    case "MultiRegionParameterGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionParameterGroupNotFoundException::builder).build());
                    }
                    case "ACLAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclAlreadyExistsException::builder).build());
                    }
                    case "InsufficientClusterCapacityFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                    }
                    case "UserQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserQuotaExceededException::builder).build());
                    }
                    case "TagQuotaPerResourceExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                    }
                    case "InvalidMultiRegionClusterStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMultiRegionClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMultiRegionClusterStateException::builder).build());
                    }
                    case "SubnetGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateSubnetGroup").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateSubnetGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateSubnetGroupRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMemoryDbAsyncClient.lambda$updateSubnetGroup$174(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMemoryDbAsyncClient.lambda$updateSubnetGroup$175((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateUserResponse> updateUser(UpdateUserRequest updateUserRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateUserRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMemoryDbAsyncClient.resolveMetricPublishers(clientConfiguration, updateUserRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MemoryDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateUser");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateUserResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "SubnetGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).build());
                    }
                    case "ParameterGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).build());
                    }
                    case "SubnetInUse": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetInUseException::builder).build());
                    }
                    case "InvalidARNFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidARNFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "TestFailoverNotAvailableFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TestFailoverNotAvailableFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TestFailoverNotAvailableException::builder).build());
                    }
                    case "ACLQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclQuotaExceededException::builder).build());
                    }
                    case "InvalidKMSKeyFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKMSKeyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyException::builder).build());
                    }
                    case "DuplicateUserNameFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateUserNameFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateUserNameException::builder).build());
                    }
                    case "SubnetNotAllowedFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotAllowedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotAllowedException::builder).build());
                    }
                    case "InvalidVPCNetworkStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).build());
                    }
                    case "InvalidParameterGroupStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).build());
                    }
                    case "ParameterGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).build());
                    }
                    case "ServiceLinkedRoleNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).build());
                    }
                    case "ParameterGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).build());
                    }
                    case "UserNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserNotFoundException::builder).build());
                    }
                    case "ClusterNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterNotFoundException::builder).build());
                    }
                    case "MultiRegionClusterAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterAlreadyExistsException::builder).build());
                    }
                    case "InvalidCredentialsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCredentialsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCredentialsException::builder).build());
                    }
                    case "InvalidClusterStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClusterStateException::builder).build());
                    }
                    case "MultiRegionClusterNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionClusterNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionClusterNotFoundException::builder).build());
                    }
                    case "SubnetGroupInUseFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupInUseException::builder).build());
                    }
                    case "InvalidSubnet": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                    }
                    case "ClusterAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).build());
                    }
                    case "NoOperationFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoOperationException::builder).build());
                    }
                    case "ShardNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShardNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardNotFoundException::builder).build());
                    }
                    case "ACLNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclNotFoundException::builder).build());
                    }
                    case "SubnetGroupQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).build());
                    }
                    case "ReservedNodesOfferingNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodesOfferingNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodesOfferingNotFoundException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "SnapshotAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotAlreadyExistsException::builder).build());
                    }
                    case "SnapshotQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotQuotaExceededException::builder).build());
                    }
                    case "DefaultUserRequired": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DefaultUserRequired").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DefaultUserRequiredException::builder).build());
                    }
                    case "NodeQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).build());
                    }
                    case "UserAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserAlreadyExistsException::builder).build());
                    }
                    case "InvalidACLStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidACLStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAclStateException::builder).build());
                    }
                    case "TagNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagNotFoundException::builder).build());
                    }
                    case "ClusterQuotaForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).build());
                    }
                    case "APICallRateForCustomerExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("APICallRateForCustomerExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApiCallRateForCustomerExceededException::builder).build());
                    }
                    case "NodeQuotaForClusterExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).build());
                    }
                    case "ServiceUpdateNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUpdateNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUpdateNotFoundException::builder).build());
                    }
                    case "SubnetQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetQuotaExceededException::builder).build());
                    }
                    case "ReservedNodeQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeQuotaExceededException::builder).build());
                    }
                    case "InvalidSnapshotStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnapshotStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnapshotStateException::builder).build());
                    }
                    case "InvalidNodeStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNodeStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNodeStateException::builder).build());
                    }
                    case "ShardsPerClusterQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ShardsPerClusterQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ShardsPerClusterQuotaExceededException::builder).build());
                    }
                    case "ReservedNodeAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeAlreadyExistsException::builder).build());
                    }
                    case "ReservedNodeNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNodeNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReservedNodeNotFoundException::builder).build());
                    }
                    case "InvalidParameterCombinationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                    }
                    case "InvalidUserStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUserStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUserStateException::builder).build());
                    }
                    case "SnapshotNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnapshotNotFoundException::builder).build());
                    }
                    case "MultiRegionParameterGroupNotFoundFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MultiRegionParameterGroupNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MultiRegionParameterGroupNotFoundException::builder).build());
                    }
                    case "ACLAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ACLAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AclAlreadyExistsException::builder).build());
                    }
                    case "InsufficientClusterCapacityFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).build());
                    }
                    case "UserQuotaExceededFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UserQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UserQuotaExceededException::builder).build());
                    }
                    case "TagQuotaPerResourceExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).build());
                    }
                    case "InvalidMultiRegionClusterStateFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMultiRegionClusterStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMultiRegionClusterStateException::builder).build());
                    }
                    case "SubnetGroupAlreadyExistsFault": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateUser").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateUserRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateUserRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMemoryDbAsyncClient.lambda$updateUser$178(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMemoryDbAsyncClient.lambda$updateUser$179((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public final MemoryDbServiceClientConfiguration serviceClientConfiguration() {
        return new MemoryDbServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public final String serviceName() {
        return "memorydb";
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(MemoryDbException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1");
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        MemoryDbServiceClientConfigurationBuilder serviceConfigBuilder = new MemoryDbServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updateUser$179(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateUser$178(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateUserResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateSubnetGroup$175(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateSubnetGroup$174(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateSubnetGroupResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateParameterGroup$171(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateParameterGroup$170(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateParameterGroupResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateMultiRegionCluster$167(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateMultiRegionCluster$166(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateMultiRegionClusterResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateCluster$163(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateCluster$162(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateClusterResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateACL$159(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateACL$158(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateAclResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$untagResource$155(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$154(List metricPublishers, MetricCollector apiCallMetricCollector, UntagResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$tagResource$151(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$150(List metricPublishers, MetricCollector apiCallMetricCollector, TagResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$resetParameterGroup$147(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$resetParameterGroup$146(List metricPublishers, MetricCollector apiCallMetricCollector, ResetParameterGroupResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$purchaseReservedNodesOffering$143(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$purchaseReservedNodesOffering$142(List metricPublishers, MetricCollector apiCallMetricCollector, PurchaseReservedNodesOfferingResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listTags$139(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTags$138(List metricPublishers, MetricCollector apiCallMetricCollector, ListTagsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listAllowedNodeTypeUpdates$135(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listAllowedNodeTypeUpdates$134(List metricPublishers, MetricCollector apiCallMetricCollector, ListAllowedNodeTypeUpdatesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listAllowedMultiRegionClusterUpdates$131(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listAllowedMultiRegionClusterUpdates$130(List metricPublishers, MetricCollector apiCallMetricCollector, ListAllowedMultiRegionClusterUpdatesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$failoverShard$127(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$failoverShard$126(List metricPublishers, MetricCollector apiCallMetricCollector, FailoverShardResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeUsers$123(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeUsers$122(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeUsersResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeSubnetGroups$119(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeSubnetGroups$118(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeSubnetGroupsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeSnapshots$115(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeSnapshots$114(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeSnapshotsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeServiceUpdates$111(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeServiceUpdates$110(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeServiceUpdatesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeReservedNodesOfferings$107(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeReservedNodesOfferings$106(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeReservedNodesOfferingsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeReservedNodes$103(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeReservedNodes$102(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeReservedNodesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeParameters$99(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeParameters$98(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeParametersResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeParameterGroups$95(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeParameterGroups$94(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeParameterGroupsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeMultiRegionParameters$91(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeMultiRegionParameters$90(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeMultiRegionParametersResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeMultiRegionParameterGroups$87(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeMultiRegionParameterGroups$86(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeMultiRegionParameterGroupsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeMultiRegionClusters$83(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeMultiRegionClusters$82(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeMultiRegionClustersResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeEvents$79(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeEvents$78(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeEventsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeEngineVersions$75(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeEngineVersions$74(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeEngineVersionsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeClusters$71(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeClusters$70(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeClustersResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeACLs$67(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeACLs$66(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeAcLsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteUser$63(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteUser$62(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteUserResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteSubnetGroup$59(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteSubnetGroup$58(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteSubnetGroupResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteSnapshot$55(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteSnapshot$54(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteSnapshotResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteParameterGroup$51(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteParameterGroup$50(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteParameterGroupResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteMultiRegionCluster$47(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteMultiRegionCluster$46(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteMultiRegionClusterResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteCluster$43(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteCluster$42(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteClusterResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteACL$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteACL$38(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteAclResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createUser$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createUser$34(List metricPublishers, MetricCollector apiCallMetricCollector, CreateUserResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createSubnetGroup$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createSubnetGroup$30(List metricPublishers, MetricCollector apiCallMetricCollector, CreateSubnetGroupResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createSnapshot$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createSnapshot$26(List metricPublishers, MetricCollector apiCallMetricCollector, CreateSnapshotResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createParameterGroup$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createParameterGroup$22(List metricPublishers, MetricCollector apiCallMetricCollector, CreateParameterGroupResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createMultiRegionCluster$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createMultiRegionCluster$18(List metricPublishers, MetricCollector apiCallMetricCollector, CreateMultiRegionClusterResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createCluster$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createCluster$14(List metricPublishers, MetricCollector apiCallMetricCollector, CreateClusterResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createACL$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createACL$10(List metricPublishers, MetricCollector apiCallMetricCollector, CreateAclResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$copySnapshot$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$copySnapshot$6(List metricPublishers, MetricCollector apiCallMetricCollector, CopySnapshotResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$batchUpdateCluster$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchUpdateCluster$2(List metricPublishers, MetricCollector apiCallMetricCollector, BatchUpdateClusterResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }
}

