/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mgn.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Source server CPU information.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CPU implements SdkPojo, Serializable, ToCopyableBuilder<CPU.Builder, CPU> {
    private static final SdkField<Long> CORES_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("cores")
            .getter(getter(CPU::cores)).setter(setter(Builder::cores))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cores").build()).build();

    private static final SdkField<String> MODEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("modelName").getter(getter(CPU::modelName)).setter(setter(Builder::modelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(CORES_FIELD, MODEL_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long cores;

    private final String modelName;

    private CPU(BuilderImpl builder) {
        this.cores = builder.cores;
        this.modelName = builder.modelName;
    }

    /**
     * <p>
     * The number of CPU cores on the source server.
     * </p>
     * 
     * @return The number of CPU cores on the source server.
     */
    public final Long cores() {
        return cores;
    }

    /**
     * <p>
     * The source server's CPU model name.
     * </p>
     * 
     * @return The source server's CPU model name.
     */
    public final String modelName() {
        return modelName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cores());
        hashCode = 31 * hashCode + Objects.hashCode(modelName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CPU)) {
            return false;
        }
        CPU other = (CPU) obj;
        return Objects.equals(cores(), other.cores()) && Objects.equals(modelName(), other.modelName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CPU").add("Cores", cores()).add("ModelName", modelName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "cores":
            return Optional.ofNullable(clazz.cast(cores()));
        case "modelName":
            return Optional.ofNullable(clazz.cast(modelName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CPU, T> g) {
        return obj -> g.apply((CPU) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CPU> {
        /**
         * <p>
         * The number of CPU cores on the source server.
         * </p>
         * 
         * @param cores
         *        The number of CPU cores on the source server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cores(Long cores);

        /**
         * <p>
         * The source server's CPU model name.
         * </p>
         * 
         * @param modelName
         *        The source server's CPU model name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelName(String modelName);
    }

    static final class BuilderImpl implements Builder {
        private Long cores;

        private String modelName;

        private BuilderImpl() {
        }

        private BuilderImpl(CPU model) {
            cores(model.cores);
            modelName(model.modelName);
        }

        public final Long getCores() {
            return cores;
        }

        @Override
        public final Builder cores(Long cores) {
            this.cores = cores;
            return this;
        }

        public final void setCores(Long cores) {
            this.cores = cores;
        }

        public final String getModelName() {
            return modelName;
        }

        @Override
        public final Builder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public final void setModelName(String modelName) {
            this.modelName = modelName;
        }

        @Override
        public CPU build() {
            return new CPU(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
