/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mgn.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Request data replication info.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataReplicationInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<DataReplicationInfo.Builder, DataReplicationInfo> {
    private static final SdkField<DataReplicationError> DATA_REPLICATION_ERROR_FIELD = SdkField
            .<DataReplicationError> builder(MarshallingType.SDK_POJO).memberName("dataReplicationError")
            .getter(getter(DataReplicationInfo::dataReplicationError)).setter(setter(Builder::dataReplicationError))
            .constructor(DataReplicationError::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataReplicationError").build())
            .build();

    private static final SdkField<DataReplicationInitiation> DATA_REPLICATION_INITIATION_FIELD = SdkField
            .<DataReplicationInitiation> builder(MarshallingType.SDK_POJO).memberName("dataReplicationInitiation")
            .getter(getter(DataReplicationInfo::dataReplicationInitiation)).setter(setter(Builder::dataReplicationInitiation))
            .constructor(DataReplicationInitiation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataReplicationInitiation").build())
            .build();

    private static final SdkField<String> DATA_REPLICATION_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataReplicationState").getter(getter(DataReplicationInfo::dataReplicationStateAsString))
            .setter(setter(Builder::dataReplicationState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataReplicationState").build())
            .build();

    private static final SdkField<String> ETA_DATE_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("etaDateTime").getter(getter(DataReplicationInfo::etaDateTime)).setter(setter(Builder::etaDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("etaDateTime").build()).build();

    private static final SdkField<String> LAG_DURATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lagDuration").getter(getter(DataReplicationInfo::lagDuration)).setter(setter(Builder::lagDuration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lagDuration").build()).build();

    private static final SdkField<List<DataReplicationInfoReplicatedDisk>> REPLICATED_DISKS_FIELD = SdkField
            .<List<DataReplicationInfoReplicatedDisk>> builder(MarshallingType.LIST)
            .memberName("replicatedDisks")
            .getter(getter(DataReplicationInfo::replicatedDisks))
            .setter(setter(Builder::replicatedDisks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicatedDisks").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DataReplicationInfoReplicatedDisk> builder(MarshallingType.SDK_POJO)
                                            .constructor(DataReplicationInfoReplicatedDisk::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_REPLICATION_ERROR_FIELD,
            DATA_REPLICATION_INITIATION_FIELD, DATA_REPLICATION_STATE_FIELD, ETA_DATE_TIME_FIELD, LAG_DURATION_FIELD,
            REPLICATED_DISKS_FIELD));

    private static final long serialVersionUID = 1L;

    private final DataReplicationError dataReplicationError;

    private final DataReplicationInitiation dataReplicationInitiation;

    private final String dataReplicationState;

    private final String etaDateTime;

    private final String lagDuration;

    private final List<DataReplicationInfoReplicatedDisk> replicatedDisks;

    private DataReplicationInfo(BuilderImpl builder) {
        this.dataReplicationError = builder.dataReplicationError;
        this.dataReplicationInitiation = builder.dataReplicationInitiation;
        this.dataReplicationState = builder.dataReplicationState;
        this.etaDateTime = builder.etaDateTime;
        this.lagDuration = builder.lagDuration;
        this.replicatedDisks = builder.replicatedDisks;
    }

    /**
     * <p>
     * Error in obtaining data replication info.
     * </p>
     * 
     * @return Error in obtaining data replication info.
     */
    public final DataReplicationError dataReplicationError() {
        return dataReplicationError;
    }

    /**
     * <p>
     * Request to query whether data replication has been initiated.
     * </p>
     * 
     * @return Request to query whether data replication has been initiated.
     */
    public final DataReplicationInitiation dataReplicationInitiation() {
        return dataReplicationInitiation;
    }

    /**
     * <p>
     * Request to query the data replication state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #dataReplicationState} will return {@link DataReplicationState#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #dataReplicationStateAsString}.
     * </p>
     * 
     * @return Request to query the data replication state.
     * @see DataReplicationState
     */
    public final DataReplicationState dataReplicationState() {
        return DataReplicationState.fromValue(dataReplicationState);
    }

    /**
     * <p>
     * Request to query the data replication state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #dataReplicationState} will return {@link DataReplicationState#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #dataReplicationStateAsString}.
     * </p>
     * 
     * @return Request to query the data replication state.
     * @see DataReplicationState
     */
    public final String dataReplicationStateAsString() {
        return dataReplicationState;
    }

    /**
     * <p>
     * Request to query the time when data replication will be complete.
     * </p>
     * 
     * @return Request to query the time when data replication will be complete.
     */
    public final String etaDateTime() {
        return etaDateTime;
    }

    /**
     * <p>
     * Request to query data replication lag durating.
     * </p>
     * 
     * @return Request to query data replication lag durating.
     */
    public final String lagDuration() {
        return lagDuration;
    }

    /**
     * Returns true if the ReplicatedDisks property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasReplicatedDisks() {
        return replicatedDisks != null && !(replicatedDisks instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Request to query disks replicated.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasReplicatedDisks()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Request to query disks replicated.
     */
    public final List<DataReplicationInfoReplicatedDisk> replicatedDisks() {
        return replicatedDisks;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dataReplicationError());
        hashCode = 31 * hashCode + Objects.hashCode(dataReplicationInitiation());
        hashCode = 31 * hashCode + Objects.hashCode(dataReplicationStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(etaDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(lagDuration());
        hashCode = 31 * hashCode + Objects.hashCode(hasReplicatedDisks() ? replicatedDisks() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataReplicationInfo)) {
            return false;
        }
        DataReplicationInfo other = (DataReplicationInfo) obj;
        return Objects.equals(dataReplicationError(), other.dataReplicationError())
                && Objects.equals(dataReplicationInitiation(), other.dataReplicationInitiation())
                && Objects.equals(dataReplicationStateAsString(), other.dataReplicationStateAsString())
                && Objects.equals(etaDateTime(), other.etaDateTime()) && Objects.equals(lagDuration(), other.lagDuration())
                && hasReplicatedDisks() == other.hasReplicatedDisks()
                && Objects.equals(replicatedDisks(), other.replicatedDisks());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataReplicationInfo").add("DataReplicationError", dataReplicationError())
                .add("DataReplicationInitiation", dataReplicationInitiation())
                .add("DataReplicationState", dataReplicationStateAsString()).add("EtaDateTime", etaDateTime())
                .add("LagDuration", lagDuration()).add("ReplicatedDisks", hasReplicatedDisks() ? replicatedDisks() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "dataReplicationError":
            return Optional.ofNullable(clazz.cast(dataReplicationError()));
        case "dataReplicationInitiation":
            return Optional.ofNullable(clazz.cast(dataReplicationInitiation()));
        case "dataReplicationState":
            return Optional.ofNullable(clazz.cast(dataReplicationStateAsString()));
        case "etaDateTime":
            return Optional.ofNullable(clazz.cast(etaDateTime()));
        case "lagDuration":
            return Optional.ofNullable(clazz.cast(lagDuration()));
        case "replicatedDisks":
            return Optional.ofNullable(clazz.cast(replicatedDisks()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataReplicationInfo, T> g) {
        return obj -> g.apply((DataReplicationInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataReplicationInfo> {
        /**
         * <p>
         * Error in obtaining data replication info.
         * </p>
         * 
         * @param dataReplicationError
         *        Error in obtaining data replication info.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataReplicationError(DataReplicationError dataReplicationError);

        /**
         * <p>
         * Error in obtaining data replication info.
         * </p>
         * This is a convenience that creates an instance of the {@link DataReplicationError.Builder} avoiding the need
         * to create one manually via {@link DataReplicationError#builder()}.
         *
         * When the {@link Consumer} completes, {@link DataReplicationError.Builder#build()} is called immediately and
         * its result is passed to {@link #dataReplicationError(DataReplicationError)}.
         * 
         * @param dataReplicationError
         *        a consumer that will call methods on {@link DataReplicationError.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataReplicationError(DataReplicationError)
         */
        default Builder dataReplicationError(Consumer<DataReplicationError.Builder> dataReplicationError) {
            return dataReplicationError(DataReplicationError.builder().applyMutation(dataReplicationError).build());
        }

        /**
         * <p>
         * Request to query whether data replication has been initiated.
         * </p>
         * 
         * @param dataReplicationInitiation
         *        Request to query whether data replication has been initiated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataReplicationInitiation(DataReplicationInitiation dataReplicationInitiation);

        /**
         * <p>
         * Request to query whether data replication has been initiated.
         * </p>
         * This is a convenience that creates an instance of the {@link DataReplicationInitiation.Builder} avoiding the
         * need to create one manually via {@link DataReplicationInitiation#builder()}.
         *
         * When the {@link Consumer} completes, {@link DataReplicationInitiation.Builder#build()} is called immediately
         * and its result is passed to {@link #dataReplicationInitiation(DataReplicationInitiation)}.
         * 
         * @param dataReplicationInitiation
         *        a consumer that will call methods on {@link DataReplicationInitiation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataReplicationInitiation(DataReplicationInitiation)
         */
        default Builder dataReplicationInitiation(Consumer<DataReplicationInitiation.Builder> dataReplicationInitiation) {
            return dataReplicationInitiation(DataReplicationInitiation.builder().applyMutation(dataReplicationInitiation).build());
        }

        /**
         * <p>
         * Request to query the data replication state.
         * </p>
         * 
         * @param dataReplicationState
         *        Request to query the data replication state.
         * @see DataReplicationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataReplicationState
         */
        Builder dataReplicationState(String dataReplicationState);

        /**
         * <p>
         * Request to query the data replication state.
         * </p>
         * 
         * @param dataReplicationState
         *        Request to query the data replication state.
         * @see DataReplicationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataReplicationState
         */
        Builder dataReplicationState(DataReplicationState dataReplicationState);

        /**
         * <p>
         * Request to query the time when data replication will be complete.
         * </p>
         * 
         * @param etaDateTime
         *        Request to query the time when data replication will be complete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder etaDateTime(String etaDateTime);

        /**
         * <p>
         * Request to query data replication lag durating.
         * </p>
         * 
         * @param lagDuration
         *        Request to query data replication lag durating.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lagDuration(String lagDuration);

        /**
         * <p>
         * Request to query disks replicated.
         * </p>
         * 
         * @param replicatedDisks
         *        Request to query disks replicated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicatedDisks(Collection<DataReplicationInfoReplicatedDisk> replicatedDisks);

        /**
         * <p>
         * Request to query disks replicated.
         * </p>
         * 
         * @param replicatedDisks
         *        Request to query disks replicated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicatedDisks(DataReplicationInfoReplicatedDisk... replicatedDisks);

        /**
         * <p>
         * Request to query disks replicated.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DataReplicationInfoReplicatedDisk>.Builder}
         * avoiding the need to create one manually via {@link List<DataReplicationInfoReplicatedDisk>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DataReplicationInfoReplicatedDisk>.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #replicatedDisks(List<DataReplicationInfoReplicatedDisk>)}.
         * 
         * @param replicatedDisks
         *        a consumer that will call methods on {@link List<DataReplicationInfoReplicatedDisk>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #replicatedDisks(List<DataReplicationInfoReplicatedDisk>)
         */
        Builder replicatedDisks(Consumer<DataReplicationInfoReplicatedDisk.Builder>... replicatedDisks);
    }

    static final class BuilderImpl implements Builder {
        private DataReplicationError dataReplicationError;

        private DataReplicationInitiation dataReplicationInitiation;

        private String dataReplicationState;

        private String etaDateTime;

        private String lagDuration;

        private List<DataReplicationInfoReplicatedDisk> replicatedDisks = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DataReplicationInfo model) {
            dataReplicationError(model.dataReplicationError);
            dataReplicationInitiation(model.dataReplicationInitiation);
            dataReplicationState(model.dataReplicationState);
            etaDateTime(model.etaDateTime);
            lagDuration(model.lagDuration);
            replicatedDisks(model.replicatedDisks);
        }

        public final DataReplicationError.Builder getDataReplicationError() {
            return dataReplicationError != null ? dataReplicationError.toBuilder() : null;
        }

        @Override
        public final Builder dataReplicationError(DataReplicationError dataReplicationError) {
            this.dataReplicationError = dataReplicationError;
            return this;
        }

        public final void setDataReplicationError(DataReplicationError.BuilderImpl dataReplicationError) {
            this.dataReplicationError = dataReplicationError != null ? dataReplicationError.build() : null;
        }

        public final DataReplicationInitiation.Builder getDataReplicationInitiation() {
            return dataReplicationInitiation != null ? dataReplicationInitiation.toBuilder() : null;
        }

        @Override
        public final Builder dataReplicationInitiation(DataReplicationInitiation dataReplicationInitiation) {
            this.dataReplicationInitiation = dataReplicationInitiation;
            return this;
        }

        public final void setDataReplicationInitiation(DataReplicationInitiation.BuilderImpl dataReplicationInitiation) {
            this.dataReplicationInitiation = dataReplicationInitiation != null ? dataReplicationInitiation.build() : null;
        }

        public final String getDataReplicationState() {
            return dataReplicationState;
        }

        @Override
        public final Builder dataReplicationState(String dataReplicationState) {
            this.dataReplicationState = dataReplicationState;
            return this;
        }

        @Override
        public final Builder dataReplicationState(DataReplicationState dataReplicationState) {
            this.dataReplicationState(dataReplicationState == null ? null : dataReplicationState.toString());
            return this;
        }

        public final void setDataReplicationState(String dataReplicationState) {
            this.dataReplicationState = dataReplicationState;
        }

        public final String getEtaDateTime() {
            return etaDateTime;
        }

        @Override
        public final Builder etaDateTime(String etaDateTime) {
            this.etaDateTime = etaDateTime;
            return this;
        }

        public final void setEtaDateTime(String etaDateTime) {
            this.etaDateTime = etaDateTime;
        }

        public final String getLagDuration() {
            return lagDuration;
        }

        @Override
        public final Builder lagDuration(String lagDuration) {
            this.lagDuration = lagDuration;
            return this;
        }

        public final void setLagDuration(String lagDuration) {
            this.lagDuration = lagDuration;
        }

        public final List<DataReplicationInfoReplicatedDisk.Builder> getReplicatedDisks() {
            List<DataReplicationInfoReplicatedDisk.Builder> result = DataReplicationInfoReplicatedDisksCopier
                    .copyToBuilder(this.replicatedDisks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder replicatedDisks(Collection<DataReplicationInfoReplicatedDisk> replicatedDisks) {
            this.replicatedDisks = DataReplicationInfoReplicatedDisksCopier.copy(replicatedDisks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicatedDisks(DataReplicationInfoReplicatedDisk... replicatedDisks) {
            replicatedDisks(Arrays.asList(replicatedDisks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicatedDisks(Consumer<DataReplicationInfoReplicatedDisk.Builder>... replicatedDisks) {
            replicatedDisks(Stream.of(replicatedDisks)
                    .map(c -> DataReplicationInfoReplicatedDisk.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setReplicatedDisks(Collection<DataReplicationInfoReplicatedDisk.BuilderImpl> replicatedDisks) {
            this.replicatedDisks = DataReplicationInfoReplicatedDisksCopier.copyFromBuilder(replicatedDisks);
        }

        @Override
        public DataReplicationInfo build() {
            return new DataReplicationInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
