/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mgn.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeJobsRequest extends MgnRequest implements
        ToCopyableBuilder<DescribeJobsRequest.Builder, DescribeJobsRequest> {
    private static final SdkField<DescribeJobsRequestFilters> FILTERS_FIELD = SdkField
            .<DescribeJobsRequestFilters> builder(MarshallingType.SDK_POJO).memberName("filters")
            .getter(getter(DescribeJobsRequest::filters)).setter(setter(Builder::filters))
            .constructor(DescribeJobsRequestFilters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filters").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(DescribeJobsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(DescribeJobsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTERS_FIELD,
            MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private final DescribeJobsRequestFilters filters;

    private final Integer maxResults;

    private final String nextToken;

    private DescribeJobsRequest(BuilderImpl builder) {
        super(builder);
        this.filters = builder.filters;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Request to describe Job log filters.
     * </p>
     * 
     * @return Request to describe Job log filters.
     */
    public final DescribeJobsRequestFilters filters() {
        return filters;
    }

    /**
     * <p>
     * Request to describe Job log by max results.
     * </p>
     * 
     * @return Request to describe Job log by max results.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * Request to describe Job logby next token.
     * </p>
     * 
     * @return Request to describe Job logby next token.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(filters());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeJobsRequest)) {
            return false;
        }
        DescribeJobsRequest other = (DescribeJobsRequest) obj;
        return Objects.equals(filters(), other.filters()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeJobsRequest").add("Filters", filters()).add("MaxResults", maxResults())
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeJobsRequest, T> g) {
        return obj -> g.apply((DescribeJobsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MgnRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeJobsRequest> {
        /**
         * <p>
         * Request to describe Job log filters.
         * </p>
         * 
         * @param filters
         *        Request to describe Job log filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(DescribeJobsRequestFilters filters);

        /**
         * <p>
         * Request to describe Job log filters.
         * </p>
         * This is a convenience that creates an instance of the {@link DescribeJobsRequestFilters.Builder} avoiding the
         * need to create one manually via {@link DescribeJobsRequestFilters#builder()}.
         *
         * When the {@link Consumer} completes, {@link DescribeJobsRequestFilters.Builder#build()} is called immediately
         * and its result is passed to {@link #filters(DescribeJobsRequestFilters)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link DescribeJobsRequestFilters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(DescribeJobsRequestFilters)
         */
        default Builder filters(Consumer<DescribeJobsRequestFilters.Builder> filters) {
            return filters(DescribeJobsRequestFilters.builder().applyMutation(filters).build());
        }

        /**
         * <p>
         * Request to describe Job log by max results.
         * </p>
         * 
         * @param maxResults
         *        Request to describe Job log by max results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * Request to describe Job logby next token.
         * </p>
         * 
         * @param nextToken
         *        Request to describe Job logby next token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MgnRequest.BuilderImpl implements Builder {
        private DescribeJobsRequestFilters filters;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeJobsRequest model) {
            super(model);
            filters(model.filters);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final DescribeJobsRequestFilters.Builder getFilters() {
            return filters != null ? filters.toBuilder() : null;
        }

        @Override
        public final Builder filters(DescribeJobsRequestFilters filters) {
            this.filters = filters;
            return this;
        }

        public final void setFilters(DescribeJobsRequestFilters.BuilderImpl filters) {
            this.filters = filters != null ? filters.build() : null;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeJobsRequest build() {
            return new DescribeJobsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
