/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mgn.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Request to filter Source Servers list.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeSourceServersRequestFilters implements SdkPojo, Serializable,
        ToCopyableBuilder<DescribeSourceServersRequestFilters.Builder, DescribeSourceServersRequestFilters> {
    private static final SdkField<Boolean> IS_ARCHIVED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isArchived").getter(getter(DescribeSourceServersRequestFilters::isArchived))
            .setter(setter(Builder::isArchived))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isArchived").build()).build();

    private static final SdkField<List<String>> SOURCE_SERVER_I_DS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("sourceServerIDs")
            .getter(getter(DescribeSourceServersRequestFilters::sourceServerIDs))
            .setter(setter(Builder::sourceServerIDs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceServerIDs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IS_ARCHIVED_FIELD,
            SOURCE_SERVER_I_DS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean isArchived;

    private final List<String> sourceServerIDs;

    private DescribeSourceServersRequestFilters(BuilderImpl builder) {
        this.isArchived = builder.isArchived;
        this.sourceServerIDs = builder.sourceServerIDs;
    }

    /**
     * <p>
     * Request to filter Source Servers list by archived.
     * </p>
     * 
     * @return Request to filter Source Servers list by archived.
     */
    public final Boolean isArchived() {
        return isArchived;
    }

    /**
     * Returns true if the SourceServerIDs property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasSourceServerIDs() {
        return sourceServerIDs != null && !(sourceServerIDs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Request to filter Source Servers list by Source Server ID.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSourceServerIDs()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Request to filter Source Servers list by Source Server ID.
     */
    public final List<String> sourceServerIDs() {
        return sourceServerIDs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(isArchived());
        hashCode = 31 * hashCode + Objects.hashCode(hasSourceServerIDs() ? sourceServerIDs() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSourceServersRequestFilters)) {
            return false;
        }
        DescribeSourceServersRequestFilters other = (DescribeSourceServersRequestFilters) obj;
        return Objects.equals(isArchived(), other.isArchived()) && hasSourceServerIDs() == other.hasSourceServerIDs()
                && Objects.equals(sourceServerIDs(), other.sourceServerIDs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeSourceServersRequestFilters").add("IsArchived", isArchived())
                .add("SourceServerIDs", hasSourceServerIDs() ? sourceServerIDs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "isArchived":
            return Optional.ofNullable(clazz.cast(isArchived()));
        case "sourceServerIDs":
            return Optional.ofNullable(clazz.cast(sourceServerIDs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeSourceServersRequestFilters, T> g) {
        return obj -> g.apply((DescribeSourceServersRequestFilters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DescribeSourceServersRequestFilters> {
        /**
         * <p>
         * Request to filter Source Servers list by archived.
         * </p>
         * 
         * @param isArchived
         *        Request to filter Source Servers list by archived.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isArchived(Boolean isArchived);

        /**
         * <p>
         * Request to filter Source Servers list by Source Server ID.
         * </p>
         * 
         * @param sourceServerIDs
         *        Request to filter Source Servers list by Source Server ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceServerIDs(Collection<String> sourceServerIDs);

        /**
         * <p>
         * Request to filter Source Servers list by Source Server ID.
         * </p>
         * 
         * @param sourceServerIDs
         *        Request to filter Source Servers list by Source Server ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceServerIDs(String... sourceServerIDs);
    }

    static final class BuilderImpl implements Builder {
        private Boolean isArchived;

        private List<String> sourceServerIDs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSourceServersRequestFilters model) {
            isArchived(model.isArchived);
            sourceServerIDs(model.sourceServerIDs);
        }

        public final Boolean getIsArchived() {
            return isArchived;
        }

        @Override
        public final Builder isArchived(Boolean isArchived) {
            this.isArchived = isArchived;
            return this;
        }

        public final void setIsArchived(Boolean isArchived) {
            this.isArchived = isArchived;
        }

        public final Collection<String> getSourceServerIDs() {
            if (sourceServerIDs instanceof SdkAutoConstructList) {
                return null;
            }
            return sourceServerIDs;
        }

        @Override
        public final Builder sourceServerIDs(Collection<String> sourceServerIDs) {
            this.sourceServerIDs = DescribeSourceServersRequestFiltersIDsCopier.copy(sourceServerIDs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceServerIDs(String... sourceServerIDs) {
            sourceServerIDs(Arrays.asList(sourceServerIDs));
            return this;
        }

        public final void setSourceServerIDs(Collection<String> sourceServerIDs) {
            this.sourceServerIDs = DescribeSourceServersRequestFiltersIDsCopier.copy(sourceServerIDs);
        }

        @Override
        public DescribeSourceServersRequestFilters build() {
            return new DescribeSourceServersRequestFilters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
