/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mgn.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Lifecycle last Cutover .
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LifeCycleLastCutover implements SdkPojo, Serializable,
        ToCopyableBuilder<LifeCycleLastCutover.Builder, LifeCycleLastCutover> {
    private static final SdkField<LifeCycleLastCutoverFinalized> FINALIZED_FIELD = SdkField
            .<LifeCycleLastCutoverFinalized> builder(MarshallingType.SDK_POJO).memberName("finalized")
            .getter(getter(LifeCycleLastCutover::finalized)).setter(setter(Builder::finalized))
            .constructor(LifeCycleLastCutoverFinalized::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("finalized").build()).build();

    private static final SdkField<LifeCycleLastCutoverInitiated> INITIATED_FIELD = SdkField
            .<LifeCycleLastCutoverInitiated> builder(MarshallingType.SDK_POJO).memberName("initiated")
            .getter(getter(LifeCycleLastCutover::initiated)).setter(setter(Builder::initiated))
            .constructor(LifeCycleLastCutoverInitiated::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("initiated").build()).build();

    private static final SdkField<LifeCycleLastCutoverReverted> REVERTED_FIELD = SdkField
            .<LifeCycleLastCutoverReverted> builder(MarshallingType.SDK_POJO).memberName("reverted")
            .getter(getter(LifeCycleLastCutover::reverted)).setter(setter(Builder::reverted))
            .constructor(LifeCycleLastCutoverReverted::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reverted").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FINALIZED_FIELD,
            INITIATED_FIELD, REVERTED_FIELD));

    private static final long serialVersionUID = 1L;

    private final LifeCycleLastCutoverFinalized finalized;

    private final LifeCycleLastCutoverInitiated initiated;

    private final LifeCycleLastCutoverReverted reverted;

    private LifeCycleLastCutover(BuilderImpl builder) {
        this.finalized = builder.finalized;
        this.initiated = builder.initiated;
        this.reverted = builder.reverted;
    }

    /**
     * <p>
     * Lifecycle Cutover finalized date and time.
     * </p>
     * 
     * @return Lifecycle Cutover finalized date and time.
     */
    public final LifeCycleLastCutoverFinalized finalized() {
        return finalized;
    }

    /**
     * <p>
     * Lifecycle last Cutover initiated.
     * </p>
     * 
     * @return Lifecycle last Cutover initiated.
     */
    public final LifeCycleLastCutoverInitiated initiated() {
        return initiated;
    }

    /**
     * <p>
     * Lifecycle last Cutover reverted.
     * </p>
     * 
     * @return Lifecycle last Cutover reverted.
     */
    public final LifeCycleLastCutoverReverted reverted() {
        return reverted;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(finalized());
        hashCode = 31 * hashCode + Objects.hashCode(initiated());
        hashCode = 31 * hashCode + Objects.hashCode(reverted());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LifeCycleLastCutover)) {
            return false;
        }
        LifeCycleLastCutover other = (LifeCycleLastCutover) obj;
        return Objects.equals(finalized(), other.finalized()) && Objects.equals(initiated(), other.initiated())
                && Objects.equals(reverted(), other.reverted());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LifeCycleLastCutover").add("Finalized", finalized()).add("Initiated", initiated())
                .add("Reverted", reverted()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "finalized":
            return Optional.ofNullable(clazz.cast(finalized()));
        case "initiated":
            return Optional.ofNullable(clazz.cast(initiated()));
        case "reverted":
            return Optional.ofNullable(clazz.cast(reverted()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LifeCycleLastCutover, T> g) {
        return obj -> g.apply((LifeCycleLastCutover) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LifeCycleLastCutover> {
        /**
         * <p>
         * Lifecycle Cutover finalized date and time.
         * </p>
         * 
         * @param finalized
         *        Lifecycle Cutover finalized date and time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder finalized(LifeCycleLastCutoverFinalized finalized);

        /**
         * <p>
         * Lifecycle Cutover finalized date and time.
         * </p>
         * This is a convenience that creates an instance of the {@link LifeCycleLastCutoverFinalized.Builder} avoiding
         * the need to create one manually via {@link LifeCycleLastCutoverFinalized#builder()}.
         *
         * When the {@link Consumer} completes, {@link LifeCycleLastCutoverFinalized.Builder#build()} is called
         * immediately and its result is passed to {@link #finalized(LifeCycleLastCutoverFinalized)}.
         * 
         * @param finalized
         *        a consumer that will call methods on {@link LifeCycleLastCutoverFinalized.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #finalized(LifeCycleLastCutoverFinalized)
         */
        default Builder finalized(Consumer<LifeCycleLastCutoverFinalized.Builder> finalized) {
            return finalized(LifeCycleLastCutoverFinalized.builder().applyMutation(finalized).build());
        }

        /**
         * <p>
         * Lifecycle last Cutover initiated.
         * </p>
         * 
         * @param initiated
         *        Lifecycle last Cutover initiated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder initiated(LifeCycleLastCutoverInitiated initiated);

        /**
         * <p>
         * Lifecycle last Cutover initiated.
         * </p>
         * This is a convenience that creates an instance of the {@link LifeCycleLastCutoverInitiated.Builder} avoiding
         * the need to create one manually via {@link LifeCycleLastCutoverInitiated#builder()}.
         *
         * When the {@link Consumer} completes, {@link LifeCycleLastCutoverInitiated.Builder#build()} is called
         * immediately and its result is passed to {@link #initiated(LifeCycleLastCutoverInitiated)}.
         * 
         * @param initiated
         *        a consumer that will call methods on {@link LifeCycleLastCutoverInitiated.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #initiated(LifeCycleLastCutoverInitiated)
         */
        default Builder initiated(Consumer<LifeCycleLastCutoverInitiated.Builder> initiated) {
            return initiated(LifeCycleLastCutoverInitiated.builder().applyMutation(initiated).build());
        }

        /**
         * <p>
         * Lifecycle last Cutover reverted.
         * </p>
         * 
         * @param reverted
         *        Lifecycle last Cutover reverted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reverted(LifeCycleLastCutoverReverted reverted);

        /**
         * <p>
         * Lifecycle last Cutover reverted.
         * </p>
         * This is a convenience that creates an instance of the {@link LifeCycleLastCutoverReverted.Builder} avoiding
         * the need to create one manually via {@link LifeCycleLastCutoverReverted#builder()}.
         *
         * When the {@link Consumer} completes, {@link LifeCycleLastCutoverReverted.Builder#build()} is called
         * immediately and its result is passed to {@link #reverted(LifeCycleLastCutoverReverted)}.
         * 
         * @param reverted
         *        a consumer that will call methods on {@link LifeCycleLastCutoverReverted.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #reverted(LifeCycleLastCutoverReverted)
         */
        default Builder reverted(Consumer<LifeCycleLastCutoverReverted.Builder> reverted) {
            return reverted(LifeCycleLastCutoverReverted.builder().applyMutation(reverted).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private LifeCycleLastCutoverFinalized finalized;

        private LifeCycleLastCutoverInitiated initiated;

        private LifeCycleLastCutoverReverted reverted;

        private BuilderImpl() {
        }

        private BuilderImpl(LifeCycleLastCutover model) {
            finalized(model.finalized);
            initiated(model.initiated);
            reverted(model.reverted);
        }

        public final LifeCycleLastCutoverFinalized.Builder getFinalized() {
            return finalized != null ? finalized.toBuilder() : null;
        }

        @Override
        public final Builder finalized(LifeCycleLastCutoverFinalized finalized) {
            this.finalized = finalized;
            return this;
        }

        public final void setFinalized(LifeCycleLastCutoverFinalized.BuilderImpl finalized) {
            this.finalized = finalized != null ? finalized.build() : null;
        }

        public final LifeCycleLastCutoverInitiated.Builder getInitiated() {
            return initiated != null ? initiated.toBuilder() : null;
        }

        @Override
        public final Builder initiated(LifeCycleLastCutoverInitiated initiated) {
            this.initiated = initiated;
            return this;
        }

        public final void setInitiated(LifeCycleLastCutoverInitiated.BuilderImpl initiated) {
            this.initiated = initiated != null ? initiated.build() : null;
        }

        public final LifeCycleLastCutoverReverted.Builder getReverted() {
            return reverted != null ? reverted.toBuilder() : null;
        }

        @Override
        public final Builder reverted(LifeCycleLastCutoverReverted reverted) {
            this.reverted = reverted;
            return this;
        }

        public final void setReverted(LifeCycleLastCutoverReverted.BuilderImpl reverted) {
            this.reverted = reverted != null ? reverted.build() : null;
        }

        @Override
        public LifeCycleLastCutover build() {
            return new LifeCycleLastCutover(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
