/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mgn.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Lifecycle last Test initiated.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LifeCycleLastTestInitiated implements SdkPojo, Serializable,
        ToCopyableBuilder<LifeCycleLastTestInitiated.Builder, LifeCycleLastTestInitiated> {
    private static final SdkField<String> API_CALL_DATE_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("apiCallDateTime").getter(getter(LifeCycleLastTestInitiated::apiCallDateTime))
            .setter(setter(Builder::apiCallDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiCallDateTime").build()).build();

    private static final SdkField<String> JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("jobID")
            .getter(getter(LifeCycleLastTestInitiated::jobID)).setter(setter(Builder::jobID))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobID").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(API_CALL_DATE_TIME_FIELD,
            JOB_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String apiCallDateTime;

    private final String jobID;

    private LifeCycleLastTestInitiated(BuilderImpl builder) {
        this.apiCallDateTime = builder.apiCallDateTime;
        this.jobID = builder.jobID;
    }

    /**
     * <p>
     * Lifecycle last Test initiated API call date and time.
     * </p>
     * 
     * @return Lifecycle last Test initiated API call date and time.
     */
    public final String apiCallDateTime() {
        return apiCallDateTime;
    }

    /**
     * <p>
     * Lifecycle last Test initiated Job ID.
     * </p>
     * 
     * @return Lifecycle last Test initiated Job ID.
     */
    public final String jobID() {
        return jobID;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(apiCallDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(jobID());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LifeCycleLastTestInitiated)) {
            return false;
        }
        LifeCycleLastTestInitiated other = (LifeCycleLastTestInitiated) obj;
        return Objects.equals(apiCallDateTime(), other.apiCallDateTime()) && Objects.equals(jobID(), other.jobID());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LifeCycleLastTestInitiated").add("ApiCallDateTime", apiCallDateTime()).add("JobID", jobID())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "apiCallDateTime":
            return Optional.ofNullable(clazz.cast(apiCallDateTime()));
        case "jobID":
            return Optional.ofNullable(clazz.cast(jobID()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LifeCycleLastTestInitiated, T> g) {
        return obj -> g.apply((LifeCycleLastTestInitiated) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LifeCycleLastTestInitiated> {
        /**
         * <p>
         * Lifecycle last Test initiated API call date and time.
         * </p>
         * 
         * @param apiCallDateTime
         *        Lifecycle last Test initiated API call date and time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiCallDateTime(String apiCallDateTime);

        /**
         * <p>
         * Lifecycle last Test initiated Job ID.
         * </p>
         * 
         * @param jobID
         *        Lifecycle last Test initiated Job ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobID(String jobID);
    }

    static final class BuilderImpl implements Builder {
        private String apiCallDateTime;

        private String jobID;

        private BuilderImpl() {
        }

        private BuilderImpl(LifeCycleLastTestInitiated model) {
            apiCallDateTime(model.apiCallDateTime);
            jobID(model.jobID);
        }

        public final String getApiCallDateTime() {
            return apiCallDateTime;
        }

        @Override
        public final Builder apiCallDateTime(String apiCallDateTime) {
            this.apiCallDateTime = apiCallDateTime;
            return this;
        }

        public final void setApiCallDateTime(String apiCallDateTime) {
            this.apiCallDateTime = apiCallDateTime;
        }

        public final String getJobID() {
            return jobID;
        }

        @Override
        public final Builder jobID(String jobID) {
            this.jobID = jobID;
            return this;
        }

        public final void setJobID(String jobID) {
            this.jobID = jobID;
        }

        @Override
        public LifeCycleLastTestInitiated build() {
            return new LifeCycleLastTestInitiated(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
