/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mgn.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Operating System.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OS implements SdkPojo, Serializable, ToCopyableBuilder<OS.Builder, OS> {
    private static final SdkField<String> FULL_STRING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("fullString").getter(getter(OS::fullString)).setter(setter(Builder::fullString))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fullString").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FULL_STRING_FIELD));

    private static final long serialVersionUID = 1L;

    private final String fullString;

    private OS(BuilderImpl builder) {
        this.fullString = builder.fullString;
    }

    /**
     * <p>
     * OS full string.
     * </p>
     * 
     * @return OS full string.
     */
    public final String fullString() {
        return fullString;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fullString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OS)) {
            return false;
        }
        OS other = (OS) obj;
        return Objects.equals(fullString(), other.fullString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OS").add("FullString", fullString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "fullString":
            return Optional.ofNullable(clazz.cast(fullString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OS, T> g) {
        return obj -> g.apply((OS) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OS> {
        /**
         * <p>
         * OS full string.
         * </p>
         * 
         * @param fullString
         *        OS full string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fullString(String fullString);
    }

    static final class BuilderImpl implements Builder {
        private String fullString;

        private BuilderImpl() {
        }

        private BuilderImpl(OS model) {
            fullString(model.fullString);
        }

        public final String getFullString() {
            return fullString;
        }

        @Override
        public final Builder fullString(String fullString) {
            this.fullString = fullString;
            return this;
        }

        public final void setFullString(String fullString) {
            this.fullString = fullString;
        }

        @Override
        public OS build() {
            return new OS(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
