/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mgn.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateReplicationConfigurationRequest extends MgnRequest implements
        ToCopyableBuilder<UpdateReplicationConfigurationRequest.Builder, UpdateReplicationConfigurationRequest> {
    private static final SdkField<Boolean> ASSOCIATE_DEFAULT_SECURITY_GROUP_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("associateDefaultSecurityGroup")
            .getter(getter(UpdateReplicationConfigurationRequest::associateDefaultSecurityGroup))
            .setter(setter(Builder::associateDefaultSecurityGroup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associateDefaultSecurityGroup")
                    .build()).build();

    private static final SdkField<Long> BANDWIDTH_THROTTLING_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("bandwidthThrottling").getter(getter(UpdateReplicationConfigurationRequest::bandwidthThrottling))
            .setter(setter(Builder::bandwidthThrottling))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bandwidthThrottling").build())
            .build();

    private static final SdkField<Boolean> CREATE_PUBLIC_IP_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("createPublicIP").getter(getter(UpdateReplicationConfigurationRequest::createPublicIP))
            .setter(setter(Builder::createPublicIP))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createPublicIP").build()).build();

    private static final SdkField<String> DATA_PLANE_ROUTING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataPlaneRouting").getter(getter(UpdateReplicationConfigurationRequest::dataPlaneRoutingAsString))
            .setter(setter(Builder::dataPlaneRouting))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataPlaneRouting").build()).build();

    private static final SdkField<String> DEFAULT_LARGE_STAGING_DISK_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("defaultLargeStagingDiskType")
            .getter(getter(UpdateReplicationConfigurationRequest::defaultLargeStagingDiskTypeAsString))
            .setter(setter(Builder::defaultLargeStagingDiskType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultLargeStagingDiskType")
                    .build()).build();

    private static final SdkField<String> EBS_ENCRYPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ebsEncryption").getter(getter(UpdateReplicationConfigurationRequest::ebsEncryptionAsString))
            .setter(setter(Builder::ebsEncryption))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ebsEncryption").build()).build();

    private static final SdkField<String> EBS_ENCRYPTION_KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ebsEncryptionKeyArn").getter(getter(UpdateReplicationConfigurationRequest::ebsEncryptionKeyArn))
            .setter(setter(Builder::ebsEncryptionKeyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ebsEncryptionKeyArn").build())
            .build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(UpdateReplicationConfigurationRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<List<ReplicationConfigurationReplicatedDisk>> REPLICATED_DISKS_FIELD = SdkField
            .<List<ReplicationConfigurationReplicatedDisk>> builder(MarshallingType.LIST)
            .memberName("replicatedDisks")
            .getter(getter(UpdateReplicationConfigurationRequest::replicatedDisks))
            .setter(setter(Builder::replicatedDisks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicatedDisks").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ReplicationConfigurationReplicatedDisk> builder(MarshallingType.SDK_POJO)
                                            .constructor(ReplicationConfigurationReplicatedDisk::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> REPLICATION_SERVER_INSTANCE_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("replicationServerInstanceType")
            .getter(getter(UpdateReplicationConfigurationRequest::replicationServerInstanceType))
            .setter(setter(Builder::replicationServerInstanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicationServerInstanceType")
                    .build()).build();

    private static final SdkField<List<String>> REPLICATION_SERVERS_SECURITY_GROUPS_I_DS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("replicationServersSecurityGroupsIDs")
            .getter(getter(UpdateReplicationConfigurationRequest::replicationServersSecurityGroupsIDs))
            .setter(setter(Builder::replicationServersSecurityGroupsIDs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("replicationServersSecurityGroupsIDs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SOURCE_SERVER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceServerID").getter(getter(UpdateReplicationConfigurationRequest::sourceServerID))
            .setter(setter(Builder::sourceServerID))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceServerID").build()).build();

    private static final SdkField<String> STAGING_AREA_SUBNET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("stagingAreaSubnetId").getter(getter(UpdateReplicationConfigurationRequest::stagingAreaSubnetId))
            .setter(setter(Builder::stagingAreaSubnetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stagingAreaSubnetId").build())
            .build();

    private static final SdkField<Map<String, String>> STAGING_AREA_TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("stagingAreaTags")
            .getter(getter(UpdateReplicationConfigurationRequest::stagingAreaTags))
            .setter(setter(Builder::stagingAreaTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stagingAreaTags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Boolean> USE_DEDICATED_REPLICATION_SERVER_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("useDedicatedReplicationServer")
            .getter(getter(UpdateReplicationConfigurationRequest::useDedicatedReplicationServer))
            .setter(setter(Builder::useDedicatedReplicationServer))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("useDedicatedReplicationServer")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(ASSOCIATE_DEFAULT_SECURITY_GROUP_FIELD, BANDWIDTH_THROTTLING_FIELD, CREATE_PUBLIC_IP_FIELD,
                    DATA_PLANE_ROUTING_FIELD, DEFAULT_LARGE_STAGING_DISK_TYPE_FIELD, EBS_ENCRYPTION_FIELD,
                    EBS_ENCRYPTION_KEY_ARN_FIELD, NAME_FIELD, REPLICATED_DISKS_FIELD, REPLICATION_SERVER_INSTANCE_TYPE_FIELD,
                    REPLICATION_SERVERS_SECURITY_GROUPS_I_DS_FIELD, SOURCE_SERVER_ID_FIELD, STAGING_AREA_SUBNET_ID_FIELD,
                    STAGING_AREA_TAGS_FIELD, USE_DEDICATED_REPLICATION_SERVER_FIELD));

    private final Boolean associateDefaultSecurityGroup;

    private final Long bandwidthThrottling;

    private final Boolean createPublicIP;

    private final String dataPlaneRouting;

    private final String defaultLargeStagingDiskType;

    private final String ebsEncryption;

    private final String ebsEncryptionKeyArn;

    private final String name;

    private final List<ReplicationConfigurationReplicatedDisk> replicatedDisks;

    private final String replicationServerInstanceType;

    private final List<String> replicationServersSecurityGroupsIDs;

    private final String sourceServerID;

    private final String stagingAreaSubnetId;

    private final Map<String, String> stagingAreaTags;

    private final Boolean useDedicatedReplicationServer;

    private UpdateReplicationConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.associateDefaultSecurityGroup = builder.associateDefaultSecurityGroup;
        this.bandwidthThrottling = builder.bandwidthThrottling;
        this.createPublicIP = builder.createPublicIP;
        this.dataPlaneRouting = builder.dataPlaneRouting;
        this.defaultLargeStagingDiskType = builder.defaultLargeStagingDiskType;
        this.ebsEncryption = builder.ebsEncryption;
        this.ebsEncryptionKeyArn = builder.ebsEncryptionKeyArn;
        this.name = builder.name;
        this.replicatedDisks = builder.replicatedDisks;
        this.replicationServerInstanceType = builder.replicationServerInstanceType;
        this.replicationServersSecurityGroupsIDs = builder.replicationServersSecurityGroupsIDs;
        this.sourceServerID = builder.sourceServerID;
        this.stagingAreaSubnetId = builder.stagingAreaSubnetId;
        this.stagingAreaTags = builder.stagingAreaTags;
        this.useDedicatedReplicationServer = builder.useDedicatedReplicationServer;
    }

    /**
     * <p>
     * Update replication configuration associate default Application Migration Service Security group request.
     * </p>
     * 
     * @return Update replication configuration associate default Application Migration Service Security group request.
     */
    public final Boolean associateDefaultSecurityGroup() {
        return associateDefaultSecurityGroup;
    }

    /**
     * <p>
     * Update replication configuration bandwidth throttling request.
     * </p>
     * 
     * @return Update replication configuration bandwidth throttling request.
     */
    public final Long bandwidthThrottling() {
        return bandwidthThrottling;
    }

    /**
     * <p>
     * Update replication configuration create Public IP request.
     * </p>
     * 
     * @return Update replication configuration create Public IP request.
     */
    public final Boolean createPublicIP() {
        return createPublicIP;
    }

    /**
     * <p>
     * Update replication configuration data plane routing request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dataPlaneRouting}
     * will return {@link ReplicationConfigurationDataPlaneRouting#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #dataPlaneRoutingAsString}.
     * </p>
     * 
     * @return Update replication configuration data plane routing request.
     * @see ReplicationConfigurationDataPlaneRouting
     */
    public final ReplicationConfigurationDataPlaneRouting dataPlaneRouting() {
        return ReplicationConfigurationDataPlaneRouting.fromValue(dataPlaneRouting);
    }

    /**
     * <p>
     * Update replication configuration data plane routing request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dataPlaneRouting}
     * will return {@link ReplicationConfigurationDataPlaneRouting#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #dataPlaneRoutingAsString}.
     * </p>
     * 
     * @return Update replication configuration data plane routing request.
     * @see ReplicationConfigurationDataPlaneRouting
     */
    public final String dataPlaneRoutingAsString() {
        return dataPlaneRouting;
    }

    /**
     * <p>
     * Update replication configuration use default large Staging Disk type request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #defaultLargeStagingDiskType} will return
     * {@link ReplicationConfigurationDefaultLargeStagingDiskType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #defaultLargeStagingDiskTypeAsString}.
     * </p>
     * 
     * @return Update replication configuration use default large Staging Disk type request.
     * @see ReplicationConfigurationDefaultLargeStagingDiskType
     */
    public final ReplicationConfigurationDefaultLargeStagingDiskType defaultLargeStagingDiskType() {
        return ReplicationConfigurationDefaultLargeStagingDiskType.fromValue(defaultLargeStagingDiskType);
    }

    /**
     * <p>
     * Update replication configuration use default large Staging Disk type request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #defaultLargeStagingDiskType} will return
     * {@link ReplicationConfigurationDefaultLargeStagingDiskType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #defaultLargeStagingDiskTypeAsString}.
     * </p>
     * 
     * @return Update replication configuration use default large Staging Disk type request.
     * @see ReplicationConfigurationDefaultLargeStagingDiskType
     */
    public final String defaultLargeStagingDiskTypeAsString() {
        return defaultLargeStagingDiskType;
    }

    /**
     * <p>
     * Update replication configuration EBS encryption request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ebsEncryption}
     * will return {@link ReplicationConfigurationEbsEncryption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #ebsEncryptionAsString}.
     * </p>
     * 
     * @return Update replication configuration EBS encryption request.
     * @see ReplicationConfigurationEbsEncryption
     */
    public final ReplicationConfigurationEbsEncryption ebsEncryption() {
        return ReplicationConfigurationEbsEncryption.fromValue(ebsEncryption);
    }

    /**
     * <p>
     * Update replication configuration EBS encryption request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ebsEncryption}
     * will return {@link ReplicationConfigurationEbsEncryption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #ebsEncryptionAsString}.
     * </p>
     * 
     * @return Update replication configuration EBS encryption request.
     * @see ReplicationConfigurationEbsEncryption
     */
    public final String ebsEncryptionAsString() {
        return ebsEncryption;
    }

    /**
     * <p>
     * Update replication configuration EBS encryption key ARN request.
     * </p>
     * 
     * @return Update replication configuration EBS encryption key ARN request.
     */
    public final String ebsEncryptionKeyArn() {
        return ebsEncryptionKeyArn;
    }

    /**
     * <p>
     * Update replication configuration name request.
     * </p>
     * 
     * @return Update replication configuration name request.
     */
    public final String name() {
        return name;
    }

    /**
     * Returns true if the ReplicatedDisks property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasReplicatedDisks() {
        return replicatedDisks != null && !(replicatedDisks instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Update replication configuration replicated disks request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasReplicatedDisks()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Update replication configuration replicated disks request.
     */
    public final List<ReplicationConfigurationReplicatedDisk> replicatedDisks() {
        return replicatedDisks;
    }

    /**
     * <p>
     * Update replication configuration Replication Server instance type request.
     * </p>
     * 
     * @return Update replication configuration Replication Server instance type request.
     */
    public final String replicationServerInstanceType() {
        return replicationServerInstanceType;
    }

    /**
     * Returns true if the ReplicationServersSecurityGroupsIDs property was specified by the sender (it may be empty),
     * or false if the sender did not specify the value (it will be empty). For responses returned by the SDK, the
     * sender is the AWS service.
     */
    public final boolean hasReplicationServersSecurityGroupsIDs() {
        return replicationServersSecurityGroupsIDs != null
                && !(replicationServersSecurityGroupsIDs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Update replication configuration Replication Server Security Groups IDs request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasReplicationServersSecurityGroupsIDs()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Update replication configuration Replication Server Security Groups IDs request.
     */
    public final List<String> replicationServersSecurityGroupsIDs() {
        return replicationServersSecurityGroupsIDs;
    }

    /**
     * <p>
     * Update replication configuration Source Server ID request.
     * </p>
     * 
     * @return Update replication configuration Source Server ID request.
     */
    public final String sourceServerID() {
        return sourceServerID;
    }

    /**
     * <p>
     * Update replication configuration Staging Area subnet request.
     * </p>
     * 
     * @return Update replication configuration Staging Area subnet request.
     */
    public final String stagingAreaSubnetId() {
        return stagingAreaSubnetId;
    }

    /**
     * Returns true if the StagingAreaTags property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasStagingAreaTags() {
        return stagingAreaTags != null && !(stagingAreaTags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Update replication configuration Staging Area Tags request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasStagingAreaTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Update replication configuration Staging Area Tags request.
     */
    public final Map<String, String> stagingAreaTags() {
        return stagingAreaTags;
    }

    /**
     * <p>
     * Update replication configuration use dedicated Replication Server request.
     * </p>
     * 
     * @return Update replication configuration use dedicated Replication Server request.
     */
    public final Boolean useDedicatedReplicationServer() {
        return useDedicatedReplicationServer;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(associateDefaultSecurityGroup());
        hashCode = 31 * hashCode + Objects.hashCode(bandwidthThrottling());
        hashCode = 31 * hashCode + Objects.hashCode(createPublicIP());
        hashCode = 31 * hashCode + Objects.hashCode(dataPlaneRoutingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(defaultLargeStagingDiskTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(ebsEncryptionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(ebsEncryptionKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasReplicatedDisks() ? replicatedDisks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(replicationServerInstanceType());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasReplicationServersSecurityGroupsIDs() ? replicationServersSecurityGroupsIDs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(sourceServerID());
        hashCode = 31 * hashCode + Objects.hashCode(stagingAreaSubnetId());
        hashCode = 31 * hashCode + Objects.hashCode(hasStagingAreaTags() ? stagingAreaTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(useDedicatedReplicationServer());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateReplicationConfigurationRequest)) {
            return false;
        }
        UpdateReplicationConfigurationRequest other = (UpdateReplicationConfigurationRequest) obj;
        return Objects.equals(associateDefaultSecurityGroup(), other.associateDefaultSecurityGroup())
                && Objects.equals(bandwidthThrottling(), other.bandwidthThrottling())
                && Objects.equals(createPublicIP(), other.createPublicIP())
                && Objects.equals(dataPlaneRoutingAsString(), other.dataPlaneRoutingAsString())
                && Objects.equals(defaultLargeStagingDiskTypeAsString(), other.defaultLargeStagingDiskTypeAsString())
                && Objects.equals(ebsEncryptionAsString(), other.ebsEncryptionAsString())
                && Objects.equals(ebsEncryptionKeyArn(), other.ebsEncryptionKeyArn()) && Objects.equals(name(), other.name())
                && hasReplicatedDisks() == other.hasReplicatedDisks()
                && Objects.equals(replicatedDisks(), other.replicatedDisks())
                && Objects.equals(replicationServerInstanceType(), other.replicationServerInstanceType())
                && hasReplicationServersSecurityGroupsIDs() == other.hasReplicationServersSecurityGroupsIDs()
                && Objects.equals(replicationServersSecurityGroupsIDs(), other.replicationServersSecurityGroupsIDs())
                && Objects.equals(sourceServerID(), other.sourceServerID())
                && Objects.equals(stagingAreaSubnetId(), other.stagingAreaSubnetId())
                && hasStagingAreaTags() == other.hasStagingAreaTags()
                && Objects.equals(stagingAreaTags(), other.stagingAreaTags())
                && Objects.equals(useDedicatedReplicationServer(), other.useDedicatedReplicationServer());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("UpdateReplicationConfigurationRequest")
                .add("AssociateDefaultSecurityGroup", associateDefaultSecurityGroup())
                .add("BandwidthThrottling", bandwidthThrottling())
                .add("CreatePublicIP", createPublicIP())
                .add("DataPlaneRouting", dataPlaneRoutingAsString())
                .add("DefaultLargeStagingDiskType", defaultLargeStagingDiskTypeAsString())
                .add("EbsEncryption", ebsEncryptionAsString())
                .add("EbsEncryptionKeyArn", ebsEncryptionKeyArn())
                .add("Name", name())
                .add("ReplicatedDisks", hasReplicatedDisks() ? replicatedDisks() : null)
                .add("ReplicationServerInstanceType", replicationServerInstanceType())
                .add("ReplicationServersSecurityGroupsIDs",
                        hasReplicationServersSecurityGroupsIDs() ? replicationServersSecurityGroupsIDs() : null)
                .add("SourceServerID", sourceServerID()).add("StagingAreaSubnetId", stagingAreaSubnetId())
                .add("StagingAreaTags", stagingAreaTags() == null ? null : "*** Sensitive Data Redacted ***")
                .add("UseDedicatedReplicationServer", useDedicatedReplicationServer()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "associateDefaultSecurityGroup":
            return Optional.ofNullable(clazz.cast(associateDefaultSecurityGroup()));
        case "bandwidthThrottling":
            return Optional.ofNullable(clazz.cast(bandwidthThrottling()));
        case "createPublicIP":
            return Optional.ofNullable(clazz.cast(createPublicIP()));
        case "dataPlaneRouting":
            return Optional.ofNullable(clazz.cast(dataPlaneRoutingAsString()));
        case "defaultLargeStagingDiskType":
            return Optional.ofNullable(clazz.cast(defaultLargeStagingDiskTypeAsString()));
        case "ebsEncryption":
            return Optional.ofNullable(clazz.cast(ebsEncryptionAsString()));
        case "ebsEncryptionKeyArn":
            return Optional.ofNullable(clazz.cast(ebsEncryptionKeyArn()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "replicatedDisks":
            return Optional.ofNullable(clazz.cast(replicatedDisks()));
        case "replicationServerInstanceType":
            return Optional.ofNullable(clazz.cast(replicationServerInstanceType()));
        case "replicationServersSecurityGroupsIDs":
            return Optional.ofNullable(clazz.cast(replicationServersSecurityGroupsIDs()));
        case "sourceServerID":
            return Optional.ofNullable(clazz.cast(sourceServerID()));
        case "stagingAreaSubnetId":
            return Optional.ofNullable(clazz.cast(stagingAreaSubnetId()));
        case "stagingAreaTags":
            return Optional.ofNullable(clazz.cast(stagingAreaTags()));
        case "useDedicatedReplicationServer":
            return Optional.ofNullable(clazz.cast(useDedicatedReplicationServer()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateReplicationConfigurationRequest, T> g) {
        return obj -> g.apply((UpdateReplicationConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MgnRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateReplicationConfigurationRequest> {
        /**
         * <p>
         * Update replication configuration associate default Application Migration Service Security group request.
         * </p>
         * 
         * @param associateDefaultSecurityGroup
         *        Update replication configuration associate default Application Migration Service Security group
         *        request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associateDefaultSecurityGroup(Boolean associateDefaultSecurityGroup);

        /**
         * <p>
         * Update replication configuration bandwidth throttling request.
         * </p>
         * 
         * @param bandwidthThrottling
         *        Update replication configuration bandwidth throttling request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bandwidthThrottling(Long bandwidthThrottling);

        /**
         * <p>
         * Update replication configuration create Public IP request.
         * </p>
         * 
         * @param createPublicIP
         *        Update replication configuration create Public IP request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createPublicIP(Boolean createPublicIP);

        /**
         * <p>
         * Update replication configuration data plane routing request.
         * </p>
         * 
         * @param dataPlaneRouting
         *        Update replication configuration data plane routing request.
         * @see ReplicationConfigurationDataPlaneRouting
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReplicationConfigurationDataPlaneRouting
         */
        Builder dataPlaneRouting(String dataPlaneRouting);

        /**
         * <p>
         * Update replication configuration data plane routing request.
         * </p>
         * 
         * @param dataPlaneRouting
         *        Update replication configuration data plane routing request.
         * @see ReplicationConfigurationDataPlaneRouting
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReplicationConfigurationDataPlaneRouting
         */
        Builder dataPlaneRouting(ReplicationConfigurationDataPlaneRouting dataPlaneRouting);

        /**
         * <p>
         * Update replication configuration use default large Staging Disk type request.
         * </p>
         * 
         * @param defaultLargeStagingDiskType
         *        Update replication configuration use default large Staging Disk type request.
         * @see ReplicationConfigurationDefaultLargeStagingDiskType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReplicationConfigurationDefaultLargeStagingDiskType
         */
        Builder defaultLargeStagingDiskType(String defaultLargeStagingDiskType);

        /**
         * <p>
         * Update replication configuration use default large Staging Disk type request.
         * </p>
         * 
         * @param defaultLargeStagingDiskType
         *        Update replication configuration use default large Staging Disk type request.
         * @see ReplicationConfigurationDefaultLargeStagingDiskType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReplicationConfigurationDefaultLargeStagingDiskType
         */
        Builder defaultLargeStagingDiskType(ReplicationConfigurationDefaultLargeStagingDiskType defaultLargeStagingDiskType);

        /**
         * <p>
         * Update replication configuration EBS encryption request.
         * </p>
         * 
         * @param ebsEncryption
         *        Update replication configuration EBS encryption request.
         * @see ReplicationConfigurationEbsEncryption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReplicationConfigurationEbsEncryption
         */
        Builder ebsEncryption(String ebsEncryption);

        /**
         * <p>
         * Update replication configuration EBS encryption request.
         * </p>
         * 
         * @param ebsEncryption
         *        Update replication configuration EBS encryption request.
         * @see ReplicationConfigurationEbsEncryption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReplicationConfigurationEbsEncryption
         */
        Builder ebsEncryption(ReplicationConfigurationEbsEncryption ebsEncryption);

        /**
         * <p>
         * Update replication configuration EBS encryption key ARN request.
         * </p>
         * 
         * @param ebsEncryptionKeyArn
         *        Update replication configuration EBS encryption key ARN request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ebsEncryptionKeyArn(String ebsEncryptionKeyArn);

        /**
         * <p>
         * Update replication configuration name request.
         * </p>
         * 
         * @param name
         *        Update replication configuration name request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Update replication configuration replicated disks request.
         * </p>
         * 
         * @param replicatedDisks
         *        Update replication configuration replicated disks request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicatedDisks(Collection<ReplicationConfigurationReplicatedDisk> replicatedDisks);

        /**
         * <p>
         * Update replication configuration replicated disks request.
         * </p>
         * 
         * @param replicatedDisks
         *        Update replication configuration replicated disks request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicatedDisks(ReplicationConfigurationReplicatedDisk... replicatedDisks);

        /**
         * <p>
         * Update replication configuration replicated disks request.
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <ReplicationConfigurationReplicatedDisk>.Builder} avoiding the need to create one manually via {@link List
         * <ReplicationConfigurationReplicatedDisk>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ReplicationConfigurationReplicatedDisk>.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #replicatedDisks(List<ReplicationConfigurationReplicatedDisk>)}.
         * 
         * @param replicatedDisks
         *        a consumer that will call methods on {@link List<ReplicationConfigurationReplicatedDisk>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #replicatedDisks(List<ReplicationConfigurationReplicatedDisk>)
         */
        Builder replicatedDisks(Consumer<ReplicationConfigurationReplicatedDisk.Builder>... replicatedDisks);

        /**
         * <p>
         * Update replication configuration Replication Server instance type request.
         * </p>
         * 
         * @param replicationServerInstanceType
         *        Update replication configuration Replication Server instance type request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationServerInstanceType(String replicationServerInstanceType);

        /**
         * <p>
         * Update replication configuration Replication Server Security Groups IDs request.
         * </p>
         * 
         * @param replicationServersSecurityGroupsIDs
         *        Update replication configuration Replication Server Security Groups IDs request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationServersSecurityGroupsIDs(Collection<String> replicationServersSecurityGroupsIDs);

        /**
         * <p>
         * Update replication configuration Replication Server Security Groups IDs request.
         * </p>
         * 
         * @param replicationServersSecurityGroupsIDs
         *        Update replication configuration Replication Server Security Groups IDs request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationServersSecurityGroupsIDs(String... replicationServersSecurityGroupsIDs);

        /**
         * <p>
         * Update replication configuration Source Server ID request.
         * </p>
         * 
         * @param sourceServerID
         *        Update replication configuration Source Server ID request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceServerID(String sourceServerID);

        /**
         * <p>
         * Update replication configuration Staging Area subnet request.
         * </p>
         * 
         * @param stagingAreaSubnetId
         *        Update replication configuration Staging Area subnet request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stagingAreaSubnetId(String stagingAreaSubnetId);

        /**
         * <p>
         * Update replication configuration Staging Area Tags request.
         * </p>
         * 
         * @param stagingAreaTags
         *        Update replication configuration Staging Area Tags request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stagingAreaTags(Map<String, String> stagingAreaTags);

        /**
         * <p>
         * Update replication configuration use dedicated Replication Server request.
         * </p>
         * 
         * @param useDedicatedReplicationServer
         *        Update replication configuration use dedicated Replication Server request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder useDedicatedReplicationServer(Boolean useDedicatedReplicationServer);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MgnRequest.BuilderImpl implements Builder {
        private Boolean associateDefaultSecurityGroup;

        private Long bandwidthThrottling;

        private Boolean createPublicIP;

        private String dataPlaneRouting;

        private String defaultLargeStagingDiskType;

        private String ebsEncryption;

        private String ebsEncryptionKeyArn;

        private String name;

        private List<ReplicationConfigurationReplicatedDisk> replicatedDisks = DefaultSdkAutoConstructList.getInstance();

        private String replicationServerInstanceType;

        private List<String> replicationServersSecurityGroupsIDs = DefaultSdkAutoConstructList.getInstance();

        private String sourceServerID;

        private String stagingAreaSubnetId;

        private Map<String, String> stagingAreaTags = DefaultSdkAutoConstructMap.getInstance();

        private Boolean useDedicatedReplicationServer;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateReplicationConfigurationRequest model) {
            super(model);
            associateDefaultSecurityGroup(model.associateDefaultSecurityGroup);
            bandwidthThrottling(model.bandwidthThrottling);
            createPublicIP(model.createPublicIP);
            dataPlaneRouting(model.dataPlaneRouting);
            defaultLargeStagingDiskType(model.defaultLargeStagingDiskType);
            ebsEncryption(model.ebsEncryption);
            ebsEncryptionKeyArn(model.ebsEncryptionKeyArn);
            name(model.name);
            replicatedDisks(model.replicatedDisks);
            replicationServerInstanceType(model.replicationServerInstanceType);
            replicationServersSecurityGroupsIDs(model.replicationServersSecurityGroupsIDs);
            sourceServerID(model.sourceServerID);
            stagingAreaSubnetId(model.stagingAreaSubnetId);
            stagingAreaTags(model.stagingAreaTags);
            useDedicatedReplicationServer(model.useDedicatedReplicationServer);
        }

        public final Boolean getAssociateDefaultSecurityGroup() {
            return associateDefaultSecurityGroup;
        }

        @Override
        public final Builder associateDefaultSecurityGroup(Boolean associateDefaultSecurityGroup) {
            this.associateDefaultSecurityGroup = associateDefaultSecurityGroup;
            return this;
        }

        public final void setAssociateDefaultSecurityGroup(Boolean associateDefaultSecurityGroup) {
            this.associateDefaultSecurityGroup = associateDefaultSecurityGroup;
        }

        public final Long getBandwidthThrottling() {
            return bandwidthThrottling;
        }

        @Override
        public final Builder bandwidthThrottling(Long bandwidthThrottling) {
            this.bandwidthThrottling = bandwidthThrottling;
            return this;
        }

        public final void setBandwidthThrottling(Long bandwidthThrottling) {
            this.bandwidthThrottling = bandwidthThrottling;
        }

        public final Boolean getCreatePublicIP() {
            return createPublicIP;
        }

        @Override
        public final Builder createPublicIP(Boolean createPublicIP) {
            this.createPublicIP = createPublicIP;
            return this;
        }

        public final void setCreatePublicIP(Boolean createPublicIP) {
            this.createPublicIP = createPublicIP;
        }

        public final String getDataPlaneRouting() {
            return dataPlaneRouting;
        }

        @Override
        public final Builder dataPlaneRouting(String dataPlaneRouting) {
            this.dataPlaneRouting = dataPlaneRouting;
            return this;
        }

        @Override
        public final Builder dataPlaneRouting(ReplicationConfigurationDataPlaneRouting dataPlaneRouting) {
            this.dataPlaneRouting(dataPlaneRouting == null ? null : dataPlaneRouting.toString());
            return this;
        }

        public final void setDataPlaneRouting(String dataPlaneRouting) {
            this.dataPlaneRouting = dataPlaneRouting;
        }

        public final String getDefaultLargeStagingDiskType() {
            return defaultLargeStagingDiskType;
        }

        @Override
        public final Builder defaultLargeStagingDiskType(String defaultLargeStagingDiskType) {
            this.defaultLargeStagingDiskType = defaultLargeStagingDiskType;
            return this;
        }

        @Override
        public final Builder defaultLargeStagingDiskType(
                ReplicationConfigurationDefaultLargeStagingDiskType defaultLargeStagingDiskType) {
            this.defaultLargeStagingDiskType(defaultLargeStagingDiskType == null ? null : defaultLargeStagingDiskType.toString());
            return this;
        }

        public final void setDefaultLargeStagingDiskType(String defaultLargeStagingDiskType) {
            this.defaultLargeStagingDiskType = defaultLargeStagingDiskType;
        }

        public final String getEbsEncryption() {
            return ebsEncryption;
        }

        @Override
        public final Builder ebsEncryption(String ebsEncryption) {
            this.ebsEncryption = ebsEncryption;
            return this;
        }

        @Override
        public final Builder ebsEncryption(ReplicationConfigurationEbsEncryption ebsEncryption) {
            this.ebsEncryption(ebsEncryption == null ? null : ebsEncryption.toString());
            return this;
        }

        public final void setEbsEncryption(String ebsEncryption) {
            this.ebsEncryption = ebsEncryption;
        }

        public final String getEbsEncryptionKeyArn() {
            return ebsEncryptionKeyArn;
        }

        @Override
        public final Builder ebsEncryptionKeyArn(String ebsEncryptionKeyArn) {
            this.ebsEncryptionKeyArn = ebsEncryptionKeyArn;
            return this;
        }

        public final void setEbsEncryptionKeyArn(String ebsEncryptionKeyArn) {
            this.ebsEncryptionKeyArn = ebsEncryptionKeyArn;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final List<ReplicationConfigurationReplicatedDisk.Builder> getReplicatedDisks() {
            List<ReplicationConfigurationReplicatedDisk.Builder> result = ReplicationConfigurationReplicatedDisksCopier
                    .copyToBuilder(this.replicatedDisks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder replicatedDisks(Collection<ReplicationConfigurationReplicatedDisk> replicatedDisks) {
            this.replicatedDisks = ReplicationConfigurationReplicatedDisksCopier.copy(replicatedDisks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicatedDisks(ReplicationConfigurationReplicatedDisk... replicatedDisks) {
            replicatedDisks(Arrays.asList(replicatedDisks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicatedDisks(Consumer<ReplicationConfigurationReplicatedDisk.Builder>... replicatedDisks) {
            replicatedDisks(Stream.of(replicatedDisks)
                    .map(c -> ReplicationConfigurationReplicatedDisk.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setReplicatedDisks(Collection<ReplicationConfigurationReplicatedDisk.BuilderImpl> replicatedDisks) {
            this.replicatedDisks = ReplicationConfigurationReplicatedDisksCopier.copyFromBuilder(replicatedDisks);
        }

        public final String getReplicationServerInstanceType() {
            return replicationServerInstanceType;
        }

        @Override
        public final Builder replicationServerInstanceType(String replicationServerInstanceType) {
            this.replicationServerInstanceType = replicationServerInstanceType;
            return this;
        }

        public final void setReplicationServerInstanceType(String replicationServerInstanceType) {
            this.replicationServerInstanceType = replicationServerInstanceType;
        }

        public final Collection<String> getReplicationServersSecurityGroupsIDs() {
            if (replicationServersSecurityGroupsIDs instanceof SdkAutoConstructList) {
                return null;
            }
            return replicationServersSecurityGroupsIDs;
        }

        @Override
        public final Builder replicationServersSecurityGroupsIDs(Collection<String> replicationServersSecurityGroupsIDs) {
            this.replicationServersSecurityGroupsIDs = ReplicationServersSecurityGroupsIDsCopier
                    .copy(replicationServersSecurityGroupsIDs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationServersSecurityGroupsIDs(String... replicationServersSecurityGroupsIDs) {
            replicationServersSecurityGroupsIDs(Arrays.asList(replicationServersSecurityGroupsIDs));
            return this;
        }

        public final void setReplicationServersSecurityGroupsIDs(Collection<String> replicationServersSecurityGroupsIDs) {
            this.replicationServersSecurityGroupsIDs = ReplicationServersSecurityGroupsIDsCopier
                    .copy(replicationServersSecurityGroupsIDs);
        }

        public final String getSourceServerID() {
            return sourceServerID;
        }

        @Override
        public final Builder sourceServerID(String sourceServerID) {
            this.sourceServerID = sourceServerID;
            return this;
        }

        public final void setSourceServerID(String sourceServerID) {
            this.sourceServerID = sourceServerID;
        }

        public final String getStagingAreaSubnetId() {
            return stagingAreaSubnetId;
        }

        @Override
        public final Builder stagingAreaSubnetId(String stagingAreaSubnetId) {
            this.stagingAreaSubnetId = stagingAreaSubnetId;
            return this;
        }

        public final void setStagingAreaSubnetId(String stagingAreaSubnetId) {
            this.stagingAreaSubnetId = stagingAreaSubnetId;
        }

        public final Map<String, String> getStagingAreaTags() {
            if (stagingAreaTags instanceof SdkAutoConstructMap) {
                return null;
            }
            return stagingAreaTags;
        }

        @Override
        public final Builder stagingAreaTags(Map<String, String> stagingAreaTags) {
            this.stagingAreaTags = TagsMapCopier.copy(stagingAreaTags);
            return this;
        }

        public final void setStagingAreaTags(Map<String, String> stagingAreaTags) {
            this.stagingAreaTags = TagsMapCopier.copy(stagingAreaTags);
        }

        public final Boolean getUseDedicatedReplicationServer() {
            return useDedicatedReplicationServer;
        }

        @Override
        public final Builder useDedicatedReplicationServer(Boolean useDedicatedReplicationServer) {
            this.useDedicatedReplicationServer = useDedicatedReplicationServer;
            return this;
        }

        public final void setUseDedicatedReplicationServer(Boolean useDedicatedReplicationServer) {
            this.useDedicatedReplicationServer = useDedicatedReplicationServer;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateReplicationConfigurationRequest build() {
            return new UpdateReplicationConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
