/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mgn.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum JobLogEvent {
    JOB_START("JOB_START"),
    SERVER_SKIPPED("SERVER_SKIPPED"),
    CLEANUP_START("CLEANUP_START"),
    CLEANUP_END("CLEANUP_END"),
    CLEANUP_FAIL("CLEANUP_FAIL"),
    SNAPSHOT_START("SNAPSHOT_START"),
    SNAPSHOT_END("SNAPSHOT_END"),
    SNAPSHOT_FAIL("SNAPSHOT_FAIL"),
    USING_PREVIOUS_SNAPSHOT("USING_PREVIOUS_SNAPSHOT"),
    CONVERSION_START("CONVERSION_START"),
    CONVERSION_END("CONVERSION_END"),
    CONVERSION_FAIL("CONVERSION_FAIL"),
    LAUNCH_START("LAUNCH_START"),
    LAUNCH_FAILED("LAUNCH_FAILED"),
    JOB_CANCEL("JOB_CANCEL"),
    JOB_END("JOB_END"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private JobLogEvent(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static JobLogEvent fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(JobLogEvent.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<JobLogEvent> knownValues() {
        return Stream.of(JobLogEvent.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

