/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mgn.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum LaunchStatus {
    PENDING("PENDING"),
    IN_PROGRESS("IN_PROGRESS"),
    LAUNCHED("LAUNCHED"),
    FAILED("FAILED"),
    TERMINATED("TERMINATED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private LaunchStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static LaunchStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(LaunchStatus.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<LaunchStatus> knownValues() {
        return Stream.of(LaunchStatus.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

