/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mgn.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.mgn.model.MgnResponse;
import software.amazon.awssdk.services.mgn.model.ReplicationConfigurationDataPlaneRouting;
import software.amazon.awssdk.services.mgn.model.ReplicationConfigurationDefaultLargeStagingDiskType;
import software.amazon.awssdk.services.mgn.model.ReplicationConfigurationEbsEncryption;
import software.amazon.awssdk.services.mgn.model.ReplicationServersSecurityGroupsIDsCopier;
import software.amazon.awssdk.services.mgn.model.TagsMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateReplicationConfigurationTemplateResponse
extends MgnResponse
implements ToCopyableBuilder<Builder, UpdateReplicationConfigurationTemplateResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(UpdateReplicationConfigurationTemplateResponse.getter(UpdateReplicationConfigurationTemplateResponse::arn)).setter(UpdateReplicationConfigurationTemplateResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<Boolean> ASSOCIATE_DEFAULT_SECURITY_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("associateDefaultSecurityGroup").getter(UpdateReplicationConfigurationTemplateResponse.getter(UpdateReplicationConfigurationTemplateResponse::associateDefaultSecurityGroup)).setter(UpdateReplicationConfigurationTemplateResponse.setter(Builder::associateDefaultSecurityGroup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associateDefaultSecurityGroup").build()}).build();
    private static final SdkField<Long> BANDWIDTH_THROTTLING_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("bandwidthThrottling").getter(UpdateReplicationConfigurationTemplateResponse.getter(UpdateReplicationConfigurationTemplateResponse::bandwidthThrottling)).setter(UpdateReplicationConfigurationTemplateResponse.setter(Builder::bandwidthThrottling)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bandwidthThrottling").build()}).build();
    private static final SdkField<Boolean> CREATE_PUBLIC_IP_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("createPublicIP").getter(UpdateReplicationConfigurationTemplateResponse.getter(UpdateReplicationConfigurationTemplateResponse::createPublicIP)).setter(UpdateReplicationConfigurationTemplateResponse.setter(Builder::createPublicIP)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createPublicIP").build()}).build();
    private static final SdkField<String> DATA_PLANE_ROUTING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dataPlaneRouting").getter(UpdateReplicationConfigurationTemplateResponse.getter(UpdateReplicationConfigurationTemplateResponse::dataPlaneRoutingAsString)).setter(UpdateReplicationConfigurationTemplateResponse.setter(Builder::dataPlaneRouting)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataPlaneRouting").build()}).build();
    private static final SdkField<String> DEFAULT_LARGE_STAGING_DISK_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("defaultLargeStagingDiskType").getter(UpdateReplicationConfigurationTemplateResponse.getter(UpdateReplicationConfigurationTemplateResponse::defaultLargeStagingDiskTypeAsString)).setter(UpdateReplicationConfigurationTemplateResponse.setter(Builder::defaultLargeStagingDiskType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultLargeStagingDiskType").build()}).build();
    private static final SdkField<String> EBS_ENCRYPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ebsEncryption").getter(UpdateReplicationConfigurationTemplateResponse.getter(UpdateReplicationConfigurationTemplateResponse::ebsEncryptionAsString)).setter(UpdateReplicationConfigurationTemplateResponse.setter(Builder::ebsEncryption)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ebsEncryption").build()}).build();
    private static final SdkField<String> EBS_ENCRYPTION_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ebsEncryptionKeyArn").getter(UpdateReplicationConfigurationTemplateResponse.getter(UpdateReplicationConfigurationTemplateResponse::ebsEncryptionKeyArn)).setter(UpdateReplicationConfigurationTemplateResponse.setter(Builder::ebsEncryptionKeyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ebsEncryptionKeyArn").build()}).build();
    private static final SdkField<String> REPLICATION_CONFIGURATION_TEMPLATE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("replicationConfigurationTemplateID").getter(UpdateReplicationConfigurationTemplateResponse.getter(UpdateReplicationConfigurationTemplateResponse::replicationConfigurationTemplateID)).setter(UpdateReplicationConfigurationTemplateResponse.setter(Builder::replicationConfigurationTemplateID)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicationConfigurationTemplateID").build()}).build();
    private static final SdkField<String> REPLICATION_SERVER_INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("replicationServerInstanceType").getter(UpdateReplicationConfigurationTemplateResponse.getter(UpdateReplicationConfigurationTemplateResponse::replicationServerInstanceType)).setter(UpdateReplicationConfigurationTemplateResponse.setter(Builder::replicationServerInstanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicationServerInstanceType").build()}).build();
    private static final SdkField<List<String>> REPLICATION_SERVERS_SECURITY_GROUPS_I_DS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("replicationServersSecurityGroupsIDs").getter(UpdateReplicationConfigurationTemplateResponse.getter(UpdateReplicationConfigurationTemplateResponse::replicationServersSecurityGroupsIDs)).setter(UpdateReplicationConfigurationTemplateResponse.setter(Builder::replicationServersSecurityGroupsIDs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicationServersSecurityGroupsIDs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STAGING_AREA_SUBNET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("stagingAreaSubnetId").getter(UpdateReplicationConfigurationTemplateResponse.getter(UpdateReplicationConfigurationTemplateResponse::stagingAreaSubnetId)).setter(UpdateReplicationConfigurationTemplateResponse.setter(Builder::stagingAreaSubnetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stagingAreaSubnetId").build()}).build();
    private static final SdkField<Map<String, String>> STAGING_AREA_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("stagingAreaTags").getter(UpdateReplicationConfigurationTemplateResponse.getter(UpdateReplicationConfigurationTemplateResponse::stagingAreaTags)).setter(UpdateReplicationConfigurationTemplateResponse.setter(Builder::stagingAreaTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stagingAreaTags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(UpdateReplicationConfigurationTemplateResponse.getter(UpdateReplicationConfigurationTemplateResponse::tags)).setter(UpdateReplicationConfigurationTemplateResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Boolean> USE_DEDICATED_REPLICATION_SERVER_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("useDedicatedReplicationServer").getter(UpdateReplicationConfigurationTemplateResponse.getter(UpdateReplicationConfigurationTemplateResponse::useDedicatedReplicationServer)).setter(UpdateReplicationConfigurationTemplateResponse.setter(Builder::useDedicatedReplicationServer)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("useDedicatedReplicationServer").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, ASSOCIATE_DEFAULT_SECURITY_GROUP_FIELD, BANDWIDTH_THROTTLING_FIELD, CREATE_PUBLIC_IP_FIELD, DATA_PLANE_ROUTING_FIELD, DEFAULT_LARGE_STAGING_DISK_TYPE_FIELD, EBS_ENCRYPTION_FIELD, EBS_ENCRYPTION_KEY_ARN_FIELD, REPLICATION_CONFIGURATION_TEMPLATE_ID_FIELD, REPLICATION_SERVER_INSTANCE_TYPE_FIELD, REPLICATION_SERVERS_SECURITY_GROUPS_I_DS_FIELD, STAGING_AREA_SUBNET_ID_FIELD, STAGING_AREA_TAGS_FIELD, TAGS_FIELD, USE_DEDICATED_REPLICATION_SERVER_FIELD));
    private final String arn;
    private final Boolean associateDefaultSecurityGroup;
    private final Long bandwidthThrottling;
    private final Boolean createPublicIP;
    private final String dataPlaneRouting;
    private final String defaultLargeStagingDiskType;
    private final String ebsEncryption;
    private final String ebsEncryptionKeyArn;
    private final String replicationConfigurationTemplateID;
    private final String replicationServerInstanceType;
    private final List<String> replicationServersSecurityGroupsIDs;
    private final String stagingAreaSubnetId;
    private final Map<String, String> stagingAreaTags;
    private final Map<String, String> tags;
    private final Boolean useDedicatedReplicationServer;

    private UpdateReplicationConfigurationTemplateResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.associateDefaultSecurityGroup = builder.associateDefaultSecurityGroup;
        this.bandwidthThrottling = builder.bandwidthThrottling;
        this.createPublicIP = builder.createPublicIP;
        this.dataPlaneRouting = builder.dataPlaneRouting;
        this.defaultLargeStagingDiskType = builder.defaultLargeStagingDiskType;
        this.ebsEncryption = builder.ebsEncryption;
        this.ebsEncryptionKeyArn = builder.ebsEncryptionKeyArn;
        this.replicationConfigurationTemplateID = builder.replicationConfigurationTemplateID;
        this.replicationServerInstanceType = builder.replicationServerInstanceType;
        this.replicationServersSecurityGroupsIDs = builder.replicationServersSecurityGroupsIDs;
        this.stagingAreaSubnetId = builder.stagingAreaSubnetId;
        this.stagingAreaTags = builder.stagingAreaTags;
        this.tags = builder.tags;
        this.useDedicatedReplicationServer = builder.useDedicatedReplicationServer;
    }

    public final String arn() {
        return this.arn;
    }

    public final Boolean associateDefaultSecurityGroup() {
        return this.associateDefaultSecurityGroup;
    }

    public final Long bandwidthThrottling() {
        return this.bandwidthThrottling;
    }

    public final Boolean createPublicIP() {
        return this.createPublicIP;
    }

    public final ReplicationConfigurationDataPlaneRouting dataPlaneRouting() {
        return ReplicationConfigurationDataPlaneRouting.fromValue(this.dataPlaneRouting);
    }

    public final String dataPlaneRoutingAsString() {
        return this.dataPlaneRouting;
    }

    public final ReplicationConfigurationDefaultLargeStagingDiskType defaultLargeStagingDiskType() {
        return ReplicationConfigurationDefaultLargeStagingDiskType.fromValue(this.defaultLargeStagingDiskType);
    }

    public final String defaultLargeStagingDiskTypeAsString() {
        return this.defaultLargeStagingDiskType;
    }

    public final ReplicationConfigurationEbsEncryption ebsEncryption() {
        return ReplicationConfigurationEbsEncryption.fromValue(this.ebsEncryption);
    }

    public final String ebsEncryptionAsString() {
        return this.ebsEncryption;
    }

    public final String ebsEncryptionKeyArn() {
        return this.ebsEncryptionKeyArn;
    }

    public final String replicationConfigurationTemplateID() {
        return this.replicationConfigurationTemplateID;
    }

    public final String replicationServerInstanceType() {
        return this.replicationServerInstanceType;
    }

    public final boolean hasReplicationServersSecurityGroupsIDs() {
        return this.replicationServersSecurityGroupsIDs != null && !(this.replicationServersSecurityGroupsIDs instanceof SdkAutoConstructList);
    }

    public final List<String> replicationServersSecurityGroupsIDs() {
        return this.replicationServersSecurityGroupsIDs;
    }

    public final String stagingAreaSubnetId() {
        return this.stagingAreaSubnetId;
    }

    public final boolean hasStagingAreaTags() {
        return this.stagingAreaTags != null && !(this.stagingAreaTags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> stagingAreaTags() {
        return this.stagingAreaTags;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final Boolean useDedicatedReplicationServer() {
        return this.useDedicatedReplicationServer;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.associateDefaultSecurityGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.bandwidthThrottling());
        hashCode = 31 * hashCode + Objects.hashCode(this.createPublicIP());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataPlaneRoutingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultLargeStagingDiskTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.ebsEncryptionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.ebsEncryptionKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationConfigurationTemplateID());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationServerInstanceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReplicationServersSecurityGroupsIDs() ? this.replicationServersSecurityGroupsIDs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.stagingAreaSubnetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStagingAreaTags() ? this.stagingAreaTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.useDedicatedReplicationServer());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateReplicationConfigurationTemplateResponse)) {
            return false;
        }
        UpdateReplicationConfigurationTemplateResponse other = (UpdateReplicationConfigurationTemplateResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.associateDefaultSecurityGroup(), other.associateDefaultSecurityGroup()) && Objects.equals(this.bandwidthThrottling(), other.bandwidthThrottling()) && Objects.equals(this.createPublicIP(), other.createPublicIP()) && Objects.equals(this.dataPlaneRoutingAsString(), other.dataPlaneRoutingAsString()) && Objects.equals(this.defaultLargeStagingDiskTypeAsString(), other.defaultLargeStagingDiskTypeAsString()) && Objects.equals(this.ebsEncryptionAsString(), other.ebsEncryptionAsString()) && Objects.equals(this.ebsEncryptionKeyArn(), other.ebsEncryptionKeyArn()) && Objects.equals(this.replicationConfigurationTemplateID(), other.replicationConfigurationTemplateID()) && Objects.equals(this.replicationServerInstanceType(), other.replicationServerInstanceType()) && this.hasReplicationServersSecurityGroupsIDs() == other.hasReplicationServersSecurityGroupsIDs() && Objects.equals(this.replicationServersSecurityGroupsIDs(), other.replicationServersSecurityGroupsIDs()) && Objects.equals(this.stagingAreaSubnetId(), other.stagingAreaSubnetId()) && this.hasStagingAreaTags() == other.hasStagingAreaTags() && Objects.equals(this.stagingAreaTags(), other.stagingAreaTags()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.useDedicatedReplicationServer(), other.useDedicatedReplicationServer());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateReplicationConfigurationTemplateResponse").add("Arn", (Object)this.arn()).add("AssociateDefaultSecurityGroup", (Object)this.associateDefaultSecurityGroup()).add("BandwidthThrottling", (Object)this.bandwidthThrottling()).add("CreatePublicIP", (Object)this.createPublicIP()).add("DataPlaneRouting", (Object)this.dataPlaneRoutingAsString()).add("DefaultLargeStagingDiskType", (Object)this.defaultLargeStagingDiskTypeAsString()).add("EbsEncryption", (Object)this.ebsEncryptionAsString()).add("EbsEncryptionKeyArn", (Object)this.ebsEncryptionKeyArn()).add("ReplicationConfigurationTemplateID", (Object)this.replicationConfigurationTemplateID()).add("ReplicationServerInstanceType", (Object)this.replicationServerInstanceType()).add("ReplicationServersSecurityGroupsIDs", this.hasReplicationServersSecurityGroupsIDs() ? this.replicationServersSecurityGroupsIDs() : null).add("StagingAreaSubnetId", (Object)this.stagingAreaSubnetId()).add("StagingAreaTags", (Object)(this.stagingAreaTags() == null ? null : "*** Sensitive Data Redacted ***")).add("Tags", (Object)(this.tags() == null ? null : "*** Sensitive Data Redacted ***")).add("UseDedicatedReplicationServer", (Object)this.useDedicatedReplicationServer()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "associateDefaultSecurityGroup": {
                return Optional.ofNullable(clazz.cast(this.associateDefaultSecurityGroup()));
            }
            case "bandwidthThrottling": {
                return Optional.ofNullable(clazz.cast(this.bandwidthThrottling()));
            }
            case "createPublicIP": {
                return Optional.ofNullable(clazz.cast(this.createPublicIP()));
            }
            case "dataPlaneRouting": {
                return Optional.ofNullable(clazz.cast(this.dataPlaneRoutingAsString()));
            }
            case "defaultLargeStagingDiskType": {
                return Optional.ofNullable(clazz.cast(this.defaultLargeStagingDiskTypeAsString()));
            }
            case "ebsEncryption": {
                return Optional.ofNullable(clazz.cast(this.ebsEncryptionAsString()));
            }
            case "ebsEncryptionKeyArn": {
                return Optional.ofNullable(clazz.cast(this.ebsEncryptionKeyArn()));
            }
            case "replicationConfigurationTemplateID": {
                return Optional.ofNullable(clazz.cast(this.replicationConfigurationTemplateID()));
            }
            case "replicationServerInstanceType": {
                return Optional.ofNullable(clazz.cast(this.replicationServerInstanceType()));
            }
            case "replicationServersSecurityGroupsIDs": {
                return Optional.ofNullable(clazz.cast(this.replicationServersSecurityGroupsIDs()));
            }
            case "stagingAreaSubnetId": {
                return Optional.ofNullable(clazz.cast(this.stagingAreaSubnetId()));
            }
            case "stagingAreaTags": {
                return Optional.ofNullable(clazz.cast(this.stagingAreaTags()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "useDedicatedReplicationServer": {
                return Optional.ofNullable(clazz.cast(this.useDedicatedReplicationServer()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateReplicationConfigurationTemplateResponse, T> g) {
        return obj -> g.apply((UpdateReplicationConfigurationTemplateResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MgnResponse.BuilderImpl
    implements Builder {
        private String arn;
        private Boolean associateDefaultSecurityGroup;
        private Long bandwidthThrottling;
        private Boolean createPublicIP;
        private String dataPlaneRouting;
        private String defaultLargeStagingDiskType;
        private String ebsEncryption;
        private String ebsEncryptionKeyArn;
        private String replicationConfigurationTemplateID;
        private String replicationServerInstanceType;
        private List<String> replicationServersSecurityGroupsIDs = DefaultSdkAutoConstructList.getInstance();
        private String stagingAreaSubnetId;
        private Map<String, String> stagingAreaTags = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private Boolean useDedicatedReplicationServer;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateReplicationConfigurationTemplateResponse model) {
            super(model);
            this.arn(model.arn);
            this.associateDefaultSecurityGroup(model.associateDefaultSecurityGroup);
            this.bandwidthThrottling(model.bandwidthThrottling);
            this.createPublicIP(model.createPublicIP);
            this.dataPlaneRouting(model.dataPlaneRouting);
            this.defaultLargeStagingDiskType(model.defaultLargeStagingDiskType);
            this.ebsEncryption(model.ebsEncryption);
            this.ebsEncryptionKeyArn(model.ebsEncryptionKeyArn);
            this.replicationConfigurationTemplateID(model.replicationConfigurationTemplateID);
            this.replicationServerInstanceType(model.replicationServerInstanceType);
            this.replicationServersSecurityGroupsIDs(model.replicationServersSecurityGroupsIDs);
            this.stagingAreaSubnetId(model.stagingAreaSubnetId);
            this.stagingAreaTags(model.stagingAreaTags);
            this.tags(model.tags);
            this.useDedicatedReplicationServer(model.useDedicatedReplicationServer);
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final Boolean getAssociateDefaultSecurityGroup() {
            return this.associateDefaultSecurityGroup;
        }

        @Override
        public final Builder associateDefaultSecurityGroup(Boolean associateDefaultSecurityGroup) {
            this.associateDefaultSecurityGroup = associateDefaultSecurityGroup;
            return this;
        }

        public final void setAssociateDefaultSecurityGroup(Boolean associateDefaultSecurityGroup) {
            this.associateDefaultSecurityGroup = associateDefaultSecurityGroup;
        }

        public final Long getBandwidthThrottling() {
            return this.bandwidthThrottling;
        }

        @Override
        public final Builder bandwidthThrottling(Long bandwidthThrottling) {
            this.bandwidthThrottling = bandwidthThrottling;
            return this;
        }

        public final void setBandwidthThrottling(Long bandwidthThrottling) {
            this.bandwidthThrottling = bandwidthThrottling;
        }

        public final Boolean getCreatePublicIP() {
            return this.createPublicIP;
        }

        @Override
        public final Builder createPublicIP(Boolean createPublicIP) {
            this.createPublicIP = createPublicIP;
            return this;
        }

        public final void setCreatePublicIP(Boolean createPublicIP) {
            this.createPublicIP = createPublicIP;
        }

        public final String getDataPlaneRouting() {
            return this.dataPlaneRouting;
        }

        @Override
        public final Builder dataPlaneRouting(String dataPlaneRouting) {
            this.dataPlaneRouting = dataPlaneRouting;
            return this;
        }

        @Override
        public final Builder dataPlaneRouting(ReplicationConfigurationDataPlaneRouting dataPlaneRouting) {
            this.dataPlaneRouting(dataPlaneRouting == null ? null : dataPlaneRouting.toString());
            return this;
        }

        public final void setDataPlaneRouting(String dataPlaneRouting) {
            this.dataPlaneRouting = dataPlaneRouting;
        }

        public final String getDefaultLargeStagingDiskType() {
            return this.defaultLargeStagingDiskType;
        }

        @Override
        public final Builder defaultLargeStagingDiskType(String defaultLargeStagingDiskType) {
            this.defaultLargeStagingDiskType = defaultLargeStagingDiskType;
            return this;
        }

        @Override
        public final Builder defaultLargeStagingDiskType(ReplicationConfigurationDefaultLargeStagingDiskType defaultLargeStagingDiskType) {
            this.defaultLargeStagingDiskType(defaultLargeStagingDiskType == null ? null : defaultLargeStagingDiskType.toString());
            return this;
        }

        public final void setDefaultLargeStagingDiskType(String defaultLargeStagingDiskType) {
            this.defaultLargeStagingDiskType = defaultLargeStagingDiskType;
        }

        public final String getEbsEncryption() {
            return this.ebsEncryption;
        }

        @Override
        public final Builder ebsEncryption(String ebsEncryption) {
            this.ebsEncryption = ebsEncryption;
            return this;
        }

        @Override
        public final Builder ebsEncryption(ReplicationConfigurationEbsEncryption ebsEncryption) {
            this.ebsEncryption(ebsEncryption == null ? null : ebsEncryption.toString());
            return this;
        }

        public final void setEbsEncryption(String ebsEncryption) {
            this.ebsEncryption = ebsEncryption;
        }

        public final String getEbsEncryptionKeyArn() {
            return this.ebsEncryptionKeyArn;
        }

        @Override
        public final Builder ebsEncryptionKeyArn(String ebsEncryptionKeyArn) {
            this.ebsEncryptionKeyArn = ebsEncryptionKeyArn;
            return this;
        }

        public final void setEbsEncryptionKeyArn(String ebsEncryptionKeyArn) {
            this.ebsEncryptionKeyArn = ebsEncryptionKeyArn;
        }

        public final String getReplicationConfigurationTemplateID() {
            return this.replicationConfigurationTemplateID;
        }

        @Override
        public final Builder replicationConfigurationTemplateID(String replicationConfigurationTemplateID) {
            this.replicationConfigurationTemplateID = replicationConfigurationTemplateID;
            return this;
        }

        public final void setReplicationConfigurationTemplateID(String replicationConfigurationTemplateID) {
            this.replicationConfigurationTemplateID = replicationConfigurationTemplateID;
        }

        public final String getReplicationServerInstanceType() {
            return this.replicationServerInstanceType;
        }

        @Override
        public final Builder replicationServerInstanceType(String replicationServerInstanceType) {
            this.replicationServerInstanceType = replicationServerInstanceType;
            return this;
        }

        public final void setReplicationServerInstanceType(String replicationServerInstanceType) {
            this.replicationServerInstanceType = replicationServerInstanceType;
        }

        public final Collection<String> getReplicationServersSecurityGroupsIDs() {
            if (this.replicationServersSecurityGroupsIDs instanceof SdkAutoConstructList) {
                return null;
            }
            return this.replicationServersSecurityGroupsIDs;
        }

        @Override
        public final Builder replicationServersSecurityGroupsIDs(Collection<String> replicationServersSecurityGroupsIDs) {
            this.replicationServersSecurityGroupsIDs = ReplicationServersSecurityGroupsIDsCopier.copy(replicationServersSecurityGroupsIDs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationServersSecurityGroupsIDs(String ... replicationServersSecurityGroupsIDs) {
            this.replicationServersSecurityGroupsIDs(Arrays.asList(replicationServersSecurityGroupsIDs));
            return this;
        }

        public final void setReplicationServersSecurityGroupsIDs(Collection<String> replicationServersSecurityGroupsIDs) {
            this.replicationServersSecurityGroupsIDs = ReplicationServersSecurityGroupsIDsCopier.copy(replicationServersSecurityGroupsIDs);
        }

        public final String getStagingAreaSubnetId() {
            return this.stagingAreaSubnetId;
        }

        @Override
        public final Builder stagingAreaSubnetId(String stagingAreaSubnetId) {
            this.stagingAreaSubnetId = stagingAreaSubnetId;
            return this;
        }

        public final void setStagingAreaSubnetId(String stagingAreaSubnetId) {
            this.stagingAreaSubnetId = stagingAreaSubnetId;
        }

        public final Map<String, String> getStagingAreaTags() {
            if (this.stagingAreaTags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.stagingAreaTags;
        }

        @Override
        public final Builder stagingAreaTags(Map<String, String> stagingAreaTags) {
            this.stagingAreaTags = TagsMapCopier.copy(stagingAreaTags);
            return this;
        }

        public final void setStagingAreaTags(Map<String, String> stagingAreaTags) {
            this.stagingAreaTags = TagsMapCopier.copy(stagingAreaTags);
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        public final Boolean getUseDedicatedReplicationServer() {
            return this.useDedicatedReplicationServer;
        }

        @Override
        public final Builder useDedicatedReplicationServer(Boolean useDedicatedReplicationServer) {
            this.useDedicatedReplicationServer = useDedicatedReplicationServer;
            return this;
        }

        public final void setUseDedicatedReplicationServer(Boolean useDedicatedReplicationServer) {
            this.useDedicatedReplicationServer = useDedicatedReplicationServer;
        }

        @Override
        public UpdateReplicationConfigurationTemplateResponse build() {
            return new UpdateReplicationConfigurationTemplateResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MgnResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateReplicationConfigurationTemplateResponse> {
        public Builder arn(String var1);

        public Builder associateDefaultSecurityGroup(Boolean var1);

        public Builder bandwidthThrottling(Long var1);

        public Builder createPublicIP(Boolean var1);

        public Builder dataPlaneRouting(String var1);

        public Builder dataPlaneRouting(ReplicationConfigurationDataPlaneRouting var1);

        public Builder defaultLargeStagingDiskType(String var1);

        public Builder defaultLargeStagingDiskType(ReplicationConfigurationDefaultLargeStagingDiskType var1);

        public Builder ebsEncryption(String var1);

        public Builder ebsEncryption(ReplicationConfigurationEbsEncryption var1);

        public Builder ebsEncryptionKeyArn(String var1);

        public Builder replicationConfigurationTemplateID(String var1);

        public Builder replicationServerInstanceType(String var1);

        public Builder replicationServersSecurityGroupsIDs(Collection<String> var1);

        public Builder replicationServersSecurityGroupsIDs(String ... var1);

        public Builder stagingAreaSubnetId(String var1);

        public Builder stagingAreaTags(Map<String, String> var1);

        public Builder tags(Map<String, String> var1);

        public Builder useDedicatedReplicationServer(Boolean var1);
    }
}

