/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mgn.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Lifecycle.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LifeCycle implements SdkPojo, Serializable, ToCopyableBuilder<LifeCycle.Builder, LifeCycle> {
    private static final SdkField<String> ADDED_TO_SERVICE_DATE_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("addedToServiceDateTime").getter(getter(LifeCycle::addedToServiceDateTime))
            .setter(setter(Builder::addedToServiceDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("addedToServiceDateTime").build())
            .build();

    private static final SdkField<String> ELAPSED_REPLICATION_DURATION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("elapsedReplicationDuration")
            .getter(getter(LifeCycle::elapsedReplicationDuration))
            .setter(setter(Builder::elapsedReplicationDuration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("elapsedReplicationDuration").build())
            .build();

    private static final SdkField<String> FIRST_BYTE_DATE_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("firstByteDateTime").getter(getter(LifeCycle::firstByteDateTime))
            .setter(setter(Builder::firstByteDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("firstByteDateTime").build()).build();

    private static final SdkField<LifeCycleLastCutover> LAST_CUTOVER_FIELD = SdkField
            .<LifeCycleLastCutover> builder(MarshallingType.SDK_POJO).memberName("lastCutover")
            .getter(getter(LifeCycle::lastCutover)).setter(setter(Builder::lastCutover))
            .constructor(LifeCycleLastCutover::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastCutover").build()).build();

    private static final SdkField<String> LAST_SEEN_BY_SERVICE_DATE_TIME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING).memberName("lastSeenByServiceDateTime")
            .getter(getter(LifeCycle::lastSeenByServiceDateTime)).setter(setter(Builder::lastSeenByServiceDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastSeenByServiceDateTime").build())
            .build();

    private static final SdkField<LifeCycleLastTest> LAST_TEST_FIELD = SdkField
            .<LifeCycleLastTest> builder(MarshallingType.SDK_POJO).memberName("lastTest").getter(getter(LifeCycle::lastTest))
            .setter(setter(Builder::lastTest)).constructor(LifeCycleLastTest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastTest").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("state")
            .getter(getter(LifeCycle::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ADDED_TO_SERVICE_DATE_TIME_FIELD, ELAPSED_REPLICATION_DURATION_FIELD, FIRST_BYTE_DATE_TIME_FIELD, LAST_CUTOVER_FIELD,
            LAST_SEEN_BY_SERVICE_DATE_TIME_FIELD, LAST_TEST_FIELD, STATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String addedToServiceDateTime;

    private final String elapsedReplicationDuration;

    private final String firstByteDateTime;

    private final LifeCycleLastCutover lastCutover;

    private final String lastSeenByServiceDateTime;

    private final LifeCycleLastTest lastTest;

    private final String state;

    private LifeCycle(BuilderImpl builder) {
        this.addedToServiceDateTime = builder.addedToServiceDateTime;
        this.elapsedReplicationDuration = builder.elapsedReplicationDuration;
        this.firstByteDateTime = builder.firstByteDateTime;
        this.lastCutover = builder.lastCutover;
        this.lastSeenByServiceDateTime = builder.lastSeenByServiceDateTime;
        this.lastTest = builder.lastTest;
        this.state = builder.state;
    }

    /**
     * <p>
     * Lifecycle added to service data and time.
     * </p>
     * 
     * @return Lifecycle added to service data and time.
     */
    public final String addedToServiceDateTime() {
        return addedToServiceDateTime;
    }

    /**
     * <p>
     * Lifecycle elapsed time and duration.
     * </p>
     * 
     * @return Lifecycle elapsed time and duration.
     */
    public final String elapsedReplicationDuration() {
        return elapsedReplicationDuration;
    }

    /**
     * <p>
     * Lifecycle replication initiation date and time.
     * </p>
     * 
     * @return Lifecycle replication initiation date and time.
     */
    public final String firstByteDateTime() {
        return firstByteDateTime;
    }

    /**
     * <p>
     * Lifecycle last Cutover.
     * </p>
     * 
     * @return Lifecycle last Cutover.
     */
    public final LifeCycleLastCutover lastCutover() {
        return lastCutover;
    }

    /**
     * <p>
     * Lifecycle last seen date and time.
     * </p>
     * 
     * @return Lifecycle last seen date and time.
     */
    public final String lastSeenByServiceDateTime() {
        return lastSeenByServiceDateTime;
    }

    /**
     * <p>
     * Lifecycle last Test.
     * </p>
     * 
     * @return Lifecycle last Test.
     */
    public final LifeCycleLastTest lastTest() {
        return lastTest;
    }

    /**
     * <p>
     * Lifecycle state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link LifeCycleState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return Lifecycle state.
     * @see LifeCycleState
     */
    public final LifeCycleState state() {
        return LifeCycleState.fromValue(state);
    }

    /**
     * <p>
     * Lifecycle state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link LifeCycleState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return Lifecycle state.
     * @see LifeCycleState
     */
    public final String stateAsString() {
        return state;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(addedToServiceDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(elapsedReplicationDuration());
        hashCode = 31 * hashCode + Objects.hashCode(firstByteDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastCutover());
        hashCode = 31 * hashCode + Objects.hashCode(lastSeenByServiceDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastTest());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LifeCycle)) {
            return false;
        }
        LifeCycle other = (LifeCycle) obj;
        return Objects.equals(addedToServiceDateTime(), other.addedToServiceDateTime())
                && Objects.equals(elapsedReplicationDuration(), other.elapsedReplicationDuration())
                && Objects.equals(firstByteDateTime(), other.firstByteDateTime())
                && Objects.equals(lastCutover(), other.lastCutover())
                && Objects.equals(lastSeenByServiceDateTime(), other.lastSeenByServiceDateTime())
                && Objects.equals(lastTest(), other.lastTest()) && Objects.equals(stateAsString(), other.stateAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LifeCycle").add("AddedToServiceDateTime", addedToServiceDateTime())
                .add("ElapsedReplicationDuration", elapsedReplicationDuration()).add("FirstByteDateTime", firstByteDateTime())
                .add("LastCutover", lastCutover()).add("LastSeenByServiceDateTime", lastSeenByServiceDateTime())
                .add("LastTest", lastTest()).add("State", stateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "addedToServiceDateTime":
            return Optional.ofNullable(clazz.cast(addedToServiceDateTime()));
        case "elapsedReplicationDuration":
            return Optional.ofNullable(clazz.cast(elapsedReplicationDuration()));
        case "firstByteDateTime":
            return Optional.ofNullable(clazz.cast(firstByteDateTime()));
        case "lastCutover":
            return Optional.ofNullable(clazz.cast(lastCutover()));
        case "lastSeenByServiceDateTime":
            return Optional.ofNullable(clazz.cast(lastSeenByServiceDateTime()));
        case "lastTest":
            return Optional.ofNullable(clazz.cast(lastTest()));
        case "state":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LifeCycle, T> g) {
        return obj -> g.apply((LifeCycle) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LifeCycle> {
        /**
         * <p>
         * Lifecycle added to service data and time.
         * </p>
         * 
         * @param addedToServiceDateTime
         *        Lifecycle added to service data and time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addedToServiceDateTime(String addedToServiceDateTime);

        /**
         * <p>
         * Lifecycle elapsed time and duration.
         * </p>
         * 
         * @param elapsedReplicationDuration
         *        Lifecycle elapsed time and duration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elapsedReplicationDuration(String elapsedReplicationDuration);

        /**
         * <p>
         * Lifecycle replication initiation date and time.
         * </p>
         * 
         * @param firstByteDateTime
         *        Lifecycle replication initiation date and time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firstByteDateTime(String firstByteDateTime);

        /**
         * <p>
         * Lifecycle last Cutover.
         * </p>
         * 
         * @param lastCutover
         *        Lifecycle last Cutover.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastCutover(LifeCycleLastCutover lastCutover);

        /**
         * <p>
         * Lifecycle last Cutover.
         * </p>
         * This is a convenience method that creates an instance of the {@link LifeCycleLastCutover.Builder} avoiding
         * the need to create one manually via {@link LifeCycleLastCutover#builder()}.
         *
         * When the {@link Consumer} completes, {@link LifeCycleLastCutover.Builder#build()} is called immediately and
         * its result is passed to {@link #lastCutover(LifeCycleLastCutover)}.
         * 
         * @param lastCutover
         *        a consumer that will call methods on {@link LifeCycleLastCutover.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lastCutover(LifeCycleLastCutover)
         */
        default Builder lastCutover(Consumer<LifeCycleLastCutover.Builder> lastCutover) {
            return lastCutover(LifeCycleLastCutover.builder().applyMutation(lastCutover).build());
        }

        /**
         * <p>
         * Lifecycle last seen date and time.
         * </p>
         * 
         * @param lastSeenByServiceDateTime
         *        Lifecycle last seen date and time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastSeenByServiceDateTime(String lastSeenByServiceDateTime);

        /**
         * <p>
         * Lifecycle last Test.
         * </p>
         * 
         * @param lastTest
         *        Lifecycle last Test.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastTest(LifeCycleLastTest lastTest);

        /**
         * <p>
         * Lifecycle last Test.
         * </p>
         * This is a convenience method that creates an instance of the {@link LifeCycleLastTest.Builder} avoiding the
         * need to create one manually via {@link LifeCycleLastTest#builder()}.
         *
         * When the {@link Consumer} completes, {@link LifeCycleLastTest.Builder#build()} is called immediately and its
         * result is passed to {@link #lastTest(LifeCycleLastTest)}.
         * 
         * @param lastTest
         *        a consumer that will call methods on {@link LifeCycleLastTest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lastTest(LifeCycleLastTest)
         */
        default Builder lastTest(Consumer<LifeCycleLastTest.Builder> lastTest) {
            return lastTest(LifeCycleLastTest.builder().applyMutation(lastTest).build());
        }

        /**
         * <p>
         * Lifecycle state.
         * </p>
         * 
         * @param state
         *        Lifecycle state.
         * @see LifeCycleState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LifeCycleState
         */
        Builder state(String state);

        /**
         * <p>
         * Lifecycle state.
         * </p>
         * 
         * @param state
         *        Lifecycle state.
         * @see LifeCycleState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LifeCycleState
         */
        Builder state(LifeCycleState state);
    }

    static final class BuilderImpl implements Builder {
        private String addedToServiceDateTime;

        private String elapsedReplicationDuration;

        private String firstByteDateTime;

        private LifeCycleLastCutover lastCutover;

        private String lastSeenByServiceDateTime;

        private LifeCycleLastTest lastTest;

        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(LifeCycle model) {
            addedToServiceDateTime(model.addedToServiceDateTime);
            elapsedReplicationDuration(model.elapsedReplicationDuration);
            firstByteDateTime(model.firstByteDateTime);
            lastCutover(model.lastCutover);
            lastSeenByServiceDateTime(model.lastSeenByServiceDateTime);
            lastTest(model.lastTest);
            state(model.state);
        }

        public final String getAddedToServiceDateTime() {
            return addedToServiceDateTime;
        }

        public final void setAddedToServiceDateTime(String addedToServiceDateTime) {
            this.addedToServiceDateTime = addedToServiceDateTime;
        }

        @Override
        public final Builder addedToServiceDateTime(String addedToServiceDateTime) {
            this.addedToServiceDateTime = addedToServiceDateTime;
            return this;
        }

        public final String getElapsedReplicationDuration() {
            return elapsedReplicationDuration;
        }

        public final void setElapsedReplicationDuration(String elapsedReplicationDuration) {
            this.elapsedReplicationDuration = elapsedReplicationDuration;
        }

        @Override
        public final Builder elapsedReplicationDuration(String elapsedReplicationDuration) {
            this.elapsedReplicationDuration = elapsedReplicationDuration;
            return this;
        }

        public final String getFirstByteDateTime() {
            return firstByteDateTime;
        }

        public final void setFirstByteDateTime(String firstByteDateTime) {
            this.firstByteDateTime = firstByteDateTime;
        }

        @Override
        public final Builder firstByteDateTime(String firstByteDateTime) {
            this.firstByteDateTime = firstByteDateTime;
            return this;
        }

        public final LifeCycleLastCutover.Builder getLastCutover() {
            return lastCutover != null ? lastCutover.toBuilder() : null;
        }

        public final void setLastCutover(LifeCycleLastCutover.BuilderImpl lastCutover) {
            this.lastCutover = lastCutover != null ? lastCutover.build() : null;
        }

        @Override
        public final Builder lastCutover(LifeCycleLastCutover lastCutover) {
            this.lastCutover = lastCutover;
            return this;
        }

        public final String getLastSeenByServiceDateTime() {
            return lastSeenByServiceDateTime;
        }

        public final void setLastSeenByServiceDateTime(String lastSeenByServiceDateTime) {
            this.lastSeenByServiceDateTime = lastSeenByServiceDateTime;
        }

        @Override
        public final Builder lastSeenByServiceDateTime(String lastSeenByServiceDateTime) {
            this.lastSeenByServiceDateTime = lastSeenByServiceDateTime;
            return this;
        }

        public final LifeCycleLastTest.Builder getLastTest() {
            return lastTest != null ? lastTest.toBuilder() : null;
        }

        public final void setLastTest(LifeCycleLastTest.BuilderImpl lastTest) {
            this.lastTest = lastTest != null ? lastTest.build() : null;
        }

        @Override
        public final Builder lastTest(LifeCycleLastTest lastTest) {
            this.lastTest = lastTest;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(LifeCycleState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        @Override
        public LifeCycle build() {
            return new LifeCycle(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
