/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mgn.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Export errors data.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExportErrorData implements SdkPojo, Serializable, ToCopyableBuilder<ExportErrorData.Builder, ExportErrorData> {
    private static final SdkField<String> RAW_ERROR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("rawError").getter(getter(ExportErrorData::rawError)).setter(setter(Builder::rawError))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rawError").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RAW_ERROR_FIELD));

    private static final long serialVersionUID = 1L;

    private final String rawError;

    private ExportErrorData(BuilderImpl builder) {
        this.rawError = builder.rawError;
    }

    /**
     * <p>
     * Export errors data raw error.
     * </p>
     * 
     * @return Export errors data raw error.
     */
    public final String rawError() {
        return rawError;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(rawError());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportErrorData)) {
            return false;
        }
        ExportErrorData other = (ExportErrorData) obj;
        return Objects.equals(rawError(), other.rawError());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExportErrorData").add("RawError", rawError()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "rawError":
            return Optional.ofNullable(clazz.cast(rawError()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExportErrorData, T> g) {
        return obj -> g.apply((ExportErrorData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExportErrorData> {
        /**
         * <p>
         * Export errors data raw error.
         * </p>
         * 
         * @param rawError
         *        Export errors data raw error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rawError(String rawError);
    }

    static final class BuilderImpl implements Builder {
        private String rawError;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportErrorData model) {
            rawError(model.rawError);
        }

        public final String getRawError() {
            return rawError;
        }

        public final void setRawError(String rawError) {
            this.rawError = rawError;
        }

        @Override
        public final Builder rawError(String rawError) {
            this.rawError = rawError;
            return this;
        }

        @Override
        public ExportErrorData build() {
            return new ExportErrorData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
