/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mgn.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociateSourceServersRequest extends MgnRequest implements
        ToCopyableBuilder<AssociateSourceServersRequest.Builder, AssociateSourceServersRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("applicationID").getter(getter(AssociateSourceServersRequest::applicationID))
            .setter(setter(Builder::applicationID))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationID").build()).build();

    private static final SdkField<List<String>> SOURCE_SERVER_I_DS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("sourceServerIDs")
            .getter(getter(AssociateSourceServersRequest::sourceServerIDs))
            .setter(setter(Builder::sourceServerIDs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceServerIDs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD,
            SOURCE_SERVER_I_DS_FIELD));

    private final String applicationID;

    private final List<String> sourceServerIDs;

    private AssociateSourceServersRequest(BuilderImpl builder) {
        super(builder);
        this.applicationID = builder.applicationID;
        this.sourceServerIDs = builder.sourceServerIDs;
    }

    /**
     * <p>
     * Application ID.
     * </p>
     * 
     * @return Application ID.
     */
    public final String applicationID() {
        return applicationID;
    }

    /**
     * For responses, this returns true if the service returned a value for the SourceServerIDs property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSourceServerIDs() {
        return sourceServerIDs != null && !(sourceServerIDs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Source server IDs list.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSourceServerIDs} method.
     * </p>
     * 
     * @return Source server IDs list.
     */
    public final List<String> sourceServerIDs() {
        return sourceServerIDs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationID());
        hashCode = 31 * hashCode + Objects.hashCode(hasSourceServerIDs() ? sourceServerIDs() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateSourceServersRequest)) {
            return false;
        }
        AssociateSourceServersRequest other = (AssociateSourceServersRequest) obj;
        return Objects.equals(applicationID(), other.applicationID()) && hasSourceServerIDs() == other.hasSourceServerIDs()
                && Objects.equals(sourceServerIDs(), other.sourceServerIDs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssociateSourceServersRequest").add("ApplicationID", applicationID())
                .add("SourceServerIDs", hasSourceServerIDs() ? sourceServerIDs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "applicationID":
            return Optional.ofNullable(clazz.cast(applicationID()));
        case "sourceServerIDs":
            return Optional.ofNullable(clazz.cast(sourceServerIDs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssociateSourceServersRequest, T> g) {
        return obj -> g.apply((AssociateSourceServersRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MgnRequest.Builder, SdkPojo, CopyableBuilder<Builder, AssociateSourceServersRequest> {
        /**
         * <p>
         * Application ID.
         * </p>
         * 
         * @param applicationID
         *        Application ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationID(String applicationID);

        /**
         * <p>
         * Source server IDs list.
         * </p>
         * 
         * @param sourceServerIDs
         *        Source server IDs list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceServerIDs(Collection<String> sourceServerIDs);

        /**
         * <p>
         * Source server IDs list.
         * </p>
         * 
         * @param sourceServerIDs
         *        Source server IDs list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceServerIDs(String... sourceServerIDs);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MgnRequest.BuilderImpl implements Builder {
        private String applicationID;

        private List<String> sourceServerIDs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateSourceServersRequest model) {
            super(model);
            applicationID(model.applicationID);
            sourceServerIDs(model.sourceServerIDs);
        }

        public final String getApplicationID() {
            return applicationID;
        }

        public final void setApplicationID(String applicationID) {
            this.applicationID = applicationID;
        }

        @Override
        public final Builder applicationID(String applicationID) {
            this.applicationID = applicationID;
            return this;
        }

        public final Collection<String> getSourceServerIDs() {
            if (sourceServerIDs instanceof SdkAutoConstructList) {
                return null;
            }
            return sourceServerIDs;
        }

        public final void setSourceServerIDs(Collection<String> sourceServerIDs) {
            this.sourceServerIDs = AssociateSourceServersRequestSourceServerIDsCopier.copy(sourceServerIDs);
        }

        @Override
        public final Builder sourceServerIDs(Collection<String> sourceServerIDs) {
            this.sourceServerIDs = AssociateSourceServersRequestSourceServerIDsCopier.copy(sourceServerIDs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceServerIDs(String... sourceServerIDs) {
            sourceServerIDs(Arrays.asList(sourceServerIDs));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateSourceServersRequest build() {
            return new AssociateSourceServersRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
