/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mgn.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ChangeServerLifeCycleStateRequest extends MgnRequest implements
        ToCopyableBuilder<ChangeServerLifeCycleStateRequest.Builder, ChangeServerLifeCycleStateRequest> {
    private static final SdkField<ChangeServerLifeCycleStateSourceServerLifecycle> LIFE_CYCLE_FIELD = SdkField
            .<ChangeServerLifeCycleStateSourceServerLifecycle> builder(MarshallingType.SDK_POJO).memberName("lifeCycle")
            .getter(getter(ChangeServerLifeCycleStateRequest::lifeCycle)).setter(setter(Builder::lifeCycle))
            .constructor(ChangeServerLifeCycleStateSourceServerLifecycle::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lifeCycle").build()).build();

    private static final SdkField<String> SOURCE_SERVER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceServerID").getter(getter(ChangeServerLifeCycleStateRequest::sourceServerID))
            .setter(setter(Builder::sourceServerID))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceServerID").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LIFE_CYCLE_FIELD,
            SOURCE_SERVER_ID_FIELD));

    private final ChangeServerLifeCycleStateSourceServerLifecycle lifeCycle;

    private final String sourceServerID;

    private ChangeServerLifeCycleStateRequest(BuilderImpl builder) {
        super(builder);
        this.lifeCycle = builder.lifeCycle;
        this.sourceServerID = builder.sourceServerID;
    }

    /**
     * <p>
     * The request to change the source server migration lifecycle state.
     * </p>
     * 
     * @return The request to change the source server migration lifecycle state.
     */
    public final ChangeServerLifeCycleStateSourceServerLifecycle lifeCycle() {
        return lifeCycle;
    }

    /**
     * <p>
     * The request to change the source server migration lifecycle state by source server ID.
     * </p>
     * 
     * @return The request to change the source server migration lifecycle state by source server ID.
     */
    public final String sourceServerID() {
        return sourceServerID;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(lifeCycle());
        hashCode = 31 * hashCode + Objects.hashCode(sourceServerID());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChangeServerLifeCycleStateRequest)) {
            return false;
        }
        ChangeServerLifeCycleStateRequest other = (ChangeServerLifeCycleStateRequest) obj;
        return Objects.equals(lifeCycle(), other.lifeCycle()) && Objects.equals(sourceServerID(), other.sourceServerID());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ChangeServerLifeCycleStateRequest").add("LifeCycle", lifeCycle())
                .add("SourceServerID", sourceServerID()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "lifeCycle":
            return Optional.ofNullable(clazz.cast(lifeCycle()));
        case "sourceServerID":
            return Optional.ofNullable(clazz.cast(sourceServerID()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ChangeServerLifeCycleStateRequest, T> g) {
        return obj -> g.apply((ChangeServerLifeCycleStateRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MgnRequest.Builder, SdkPojo, CopyableBuilder<Builder, ChangeServerLifeCycleStateRequest> {
        /**
         * <p>
         * The request to change the source server migration lifecycle state.
         * </p>
         * 
         * @param lifeCycle
         *        The request to change the source server migration lifecycle state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifeCycle(ChangeServerLifeCycleStateSourceServerLifecycle lifeCycle);

        /**
         * <p>
         * The request to change the source server migration lifecycle state.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ChangeServerLifeCycleStateSourceServerLifecycle.Builder} avoiding the need to create one manually via
         * {@link ChangeServerLifeCycleStateSourceServerLifecycle#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ChangeServerLifeCycleStateSourceServerLifecycle.Builder#build()}
         * is called immediately and its result is passed to
         * {@link #lifeCycle(ChangeServerLifeCycleStateSourceServerLifecycle)}.
         * 
         * @param lifeCycle
         *        a consumer that will call methods on {@link ChangeServerLifeCycleStateSourceServerLifecycle.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lifeCycle(ChangeServerLifeCycleStateSourceServerLifecycle)
         */
        default Builder lifeCycle(Consumer<ChangeServerLifeCycleStateSourceServerLifecycle.Builder> lifeCycle) {
            return lifeCycle(ChangeServerLifeCycleStateSourceServerLifecycle.builder().applyMutation(lifeCycle).build());
        }

        /**
         * <p>
         * The request to change the source server migration lifecycle state by source server ID.
         * </p>
         * 
         * @param sourceServerID
         *        The request to change the source server migration lifecycle state by source server ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceServerID(String sourceServerID);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MgnRequest.BuilderImpl implements Builder {
        private ChangeServerLifeCycleStateSourceServerLifecycle lifeCycle;

        private String sourceServerID;

        private BuilderImpl() {
        }

        private BuilderImpl(ChangeServerLifeCycleStateRequest model) {
            super(model);
            lifeCycle(model.lifeCycle);
            sourceServerID(model.sourceServerID);
        }

        public final ChangeServerLifeCycleStateSourceServerLifecycle.Builder getLifeCycle() {
            return lifeCycle != null ? lifeCycle.toBuilder() : null;
        }

        public final void setLifeCycle(ChangeServerLifeCycleStateSourceServerLifecycle.BuilderImpl lifeCycle) {
            this.lifeCycle = lifeCycle != null ? lifeCycle.build() : null;
        }

        @Override
        public final Builder lifeCycle(ChangeServerLifeCycleStateSourceServerLifecycle lifeCycle) {
            this.lifeCycle = lifeCycle;
            return this;
        }

        public final String getSourceServerID() {
            return sourceServerID;
        }

        public final void setSourceServerID(String sourceServerID) {
            this.sourceServerID = sourceServerID;
        }

        @Override
        public final Builder sourceServerID(String sourceServerID) {
            this.sourceServerID = sourceServerID;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ChangeServerLifeCycleStateRequest build() {
            return new ChangeServerLifeCycleStateRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
