/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mgn.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Import error data.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImportErrorData implements SdkPojo, Serializable, ToCopyableBuilder<ImportErrorData.Builder, ImportErrorData> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("applicationID").getter(getter(ImportErrorData::applicationID)).setter(setter(Builder::applicationID))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationID").build()).build();

    private static final SdkField<String> EC2_LAUNCH_TEMPLATE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ec2LaunchTemplateID").getter(getter(ImportErrorData::ec2LaunchTemplateID))
            .setter(setter(Builder::ec2LaunchTemplateID))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ec2LaunchTemplateID").build())
            .build();

    private static final SdkField<String> RAW_ERROR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("rawError").getter(getter(ImportErrorData::rawError)).setter(setter(Builder::rawError))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rawError").build()).build();

    private static final SdkField<Long> ROW_NUMBER_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("rowNumber")
            .getter(getter(ImportErrorData::rowNumber)).setter(setter(Builder::rowNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rowNumber").build()).build();

    private static final SdkField<String> SOURCE_SERVER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceServerID").getter(getter(ImportErrorData::sourceServerID)).setter(setter(Builder::sourceServerID))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceServerID").build()).build();

    private static final SdkField<String> WAVE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("waveID")
            .getter(getter(ImportErrorData::waveID)).setter(setter(Builder::waveID))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("waveID").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD,
            EC2_LAUNCH_TEMPLATE_ID_FIELD, RAW_ERROR_FIELD, ROW_NUMBER_FIELD, SOURCE_SERVER_ID_FIELD, WAVE_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String applicationID;

    private final String ec2LaunchTemplateID;

    private final String rawError;

    private final Long rowNumber;

    private final String sourceServerID;

    private final String waveID;

    private ImportErrorData(BuilderImpl builder) {
        this.applicationID = builder.applicationID;
        this.ec2LaunchTemplateID = builder.ec2LaunchTemplateID;
        this.rawError = builder.rawError;
        this.rowNumber = builder.rowNumber;
        this.sourceServerID = builder.sourceServerID;
        this.waveID = builder.waveID;
    }

    /**
     * <p>
     * Import error data application ID.
     * </p>
     * 
     * @return Import error data application ID.
     */
    public final String applicationID() {
        return applicationID;
    }

    /**
     * <p>
     * Import error data ec2 LaunchTemplate ID.
     * </p>
     * 
     * @return Import error data ec2 LaunchTemplate ID.
     */
    public final String ec2LaunchTemplateID() {
        return ec2LaunchTemplateID;
    }

    /**
     * <p>
     * Import error data raw error.
     * </p>
     * 
     * @return Import error data raw error.
     */
    public final String rawError() {
        return rawError;
    }

    /**
     * <p>
     * Import error data row number.
     * </p>
     * 
     * @return Import error data row number.
     */
    public final Long rowNumber() {
        return rowNumber;
    }

    /**
     * <p>
     * Import error data source server ID.
     * </p>
     * 
     * @return Import error data source server ID.
     */
    public final String sourceServerID() {
        return sourceServerID;
    }

    /**
     * <p>
     * Import error data wave id.
     * </p>
     * 
     * @return Import error data wave id.
     */
    public final String waveID() {
        return waveID;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(applicationID());
        hashCode = 31 * hashCode + Objects.hashCode(ec2LaunchTemplateID());
        hashCode = 31 * hashCode + Objects.hashCode(rawError());
        hashCode = 31 * hashCode + Objects.hashCode(rowNumber());
        hashCode = 31 * hashCode + Objects.hashCode(sourceServerID());
        hashCode = 31 * hashCode + Objects.hashCode(waveID());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportErrorData)) {
            return false;
        }
        ImportErrorData other = (ImportErrorData) obj;
        return Objects.equals(applicationID(), other.applicationID())
                && Objects.equals(ec2LaunchTemplateID(), other.ec2LaunchTemplateID())
                && Objects.equals(rawError(), other.rawError()) && Objects.equals(rowNumber(), other.rowNumber())
                && Objects.equals(sourceServerID(), other.sourceServerID()) && Objects.equals(waveID(), other.waveID());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ImportErrorData").add("ApplicationID", applicationID())
                .add("Ec2LaunchTemplateID", ec2LaunchTemplateID()).add("RawError", rawError()).add("RowNumber", rowNumber())
                .add("SourceServerID", sourceServerID()).add("WaveID", waveID()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "applicationID":
            return Optional.ofNullable(clazz.cast(applicationID()));
        case "ec2LaunchTemplateID":
            return Optional.ofNullable(clazz.cast(ec2LaunchTemplateID()));
        case "rawError":
            return Optional.ofNullable(clazz.cast(rawError()));
        case "rowNumber":
            return Optional.ofNullable(clazz.cast(rowNumber()));
        case "sourceServerID":
            return Optional.ofNullable(clazz.cast(sourceServerID()));
        case "waveID":
            return Optional.ofNullable(clazz.cast(waveID()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImportErrorData, T> g) {
        return obj -> g.apply((ImportErrorData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ImportErrorData> {
        /**
         * <p>
         * Import error data application ID.
         * </p>
         * 
         * @param applicationID
         *        Import error data application ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationID(String applicationID);

        /**
         * <p>
         * Import error data ec2 LaunchTemplate ID.
         * </p>
         * 
         * @param ec2LaunchTemplateID
         *        Import error data ec2 LaunchTemplate ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2LaunchTemplateID(String ec2LaunchTemplateID);

        /**
         * <p>
         * Import error data raw error.
         * </p>
         * 
         * @param rawError
         *        Import error data raw error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rawError(String rawError);

        /**
         * <p>
         * Import error data row number.
         * </p>
         * 
         * @param rowNumber
         *        Import error data row number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rowNumber(Long rowNumber);

        /**
         * <p>
         * Import error data source server ID.
         * </p>
         * 
         * @param sourceServerID
         *        Import error data source server ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceServerID(String sourceServerID);

        /**
         * <p>
         * Import error data wave id.
         * </p>
         * 
         * @param waveID
         *        Import error data wave id.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder waveID(String waveID);
    }

    static final class BuilderImpl implements Builder {
        private String applicationID;

        private String ec2LaunchTemplateID;

        private String rawError;

        private Long rowNumber;

        private String sourceServerID;

        private String waveID;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportErrorData model) {
            applicationID(model.applicationID);
            ec2LaunchTemplateID(model.ec2LaunchTemplateID);
            rawError(model.rawError);
            rowNumber(model.rowNumber);
            sourceServerID(model.sourceServerID);
            waveID(model.waveID);
        }

        public final String getApplicationID() {
            return applicationID;
        }

        public final void setApplicationID(String applicationID) {
            this.applicationID = applicationID;
        }

        @Override
        public final Builder applicationID(String applicationID) {
            this.applicationID = applicationID;
            return this;
        }

        public final String getEc2LaunchTemplateID() {
            return ec2LaunchTemplateID;
        }

        public final void setEc2LaunchTemplateID(String ec2LaunchTemplateID) {
            this.ec2LaunchTemplateID = ec2LaunchTemplateID;
        }

        @Override
        public final Builder ec2LaunchTemplateID(String ec2LaunchTemplateID) {
            this.ec2LaunchTemplateID = ec2LaunchTemplateID;
            return this;
        }

        public final String getRawError() {
            return rawError;
        }

        public final void setRawError(String rawError) {
            this.rawError = rawError;
        }

        @Override
        public final Builder rawError(String rawError) {
            this.rawError = rawError;
            return this;
        }

        public final Long getRowNumber() {
            return rowNumber;
        }

        public final void setRowNumber(Long rowNumber) {
            this.rowNumber = rowNumber;
        }

        @Override
        public final Builder rowNumber(Long rowNumber) {
            this.rowNumber = rowNumber;
            return this;
        }

        public final String getSourceServerID() {
            return sourceServerID;
        }

        public final void setSourceServerID(String sourceServerID) {
            this.sourceServerID = sourceServerID;
        }

        @Override
        public final Builder sourceServerID(String sourceServerID) {
            this.sourceServerID = sourceServerID;
            return this;
        }

        public final String getWaveID() {
            return waveID;
        }

        public final void setWaveID(String waveID) {
            this.waveID = waveID;
        }

        @Override
        public final Builder waveID(String waveID) {
            this.waveID = waveID;
            return this;
        }

        @Override
        public ImportErrorData build() {
            return new ImportErrorData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
