/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mgn;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.mgn.internal.MgnServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.mgn.model.AccessDeniedException;
import software.amazon.awssdk.services.mgn.model.ArchiveApplicationRequest;
import software.amazon.awssdk.services.mgn.model.ArchiveApplicationResponse;
import software.amazon.awssdk.services.mgn.model.ArchiveWaveRequest;
import software.amazon.awssdk.services.mgn.model.ArchiveWaveResponse;
import software.amazon.awssdk.services.mgn.model.AssociateApplicationsRequest;
import software.amazon.awssdk.services.mgn.model.AssociateApplicationsResponse;
import software.amazon.awssdk.services.mgn.model.AssociateSourceServersRequest;
import software.amazon.awssdk.services.mgn.model.AssociateSourceServersResponse;
import software.amazon.awssdk.services.mgn.model.ChangeServerLifeCycleStateRequest;
import software.amazon.awssdk.services.mgn.model.ChangeServerLifeCycleStateResponse;
import software.amazon.awssdk.services.mgn.model.ConflictException;
import software.amazon.awssdk.services.mgn.model.CreateApplicationRequest;
import software.amazon.awssdk.services.mgn.model.CreateApplicationResponse;
import software.amazon.awssdk.services.mgn.model.CreateConnectorRequest;
import software.amazon.awssdk.services.mgn.model.CreateConnectorResponse;
import software.amazon.awssdk.services.mgn.model.CreateLaunchConfigurationTemplateRequest;
import software.amazon.awssdk.services.mgn.model.CreateLaunchConfigurationTemplateResponse;
import software.amazon.awssdk.services.mgn.model.CreateReplicationConfigurationTemplateRequest;
import software.amazon.awssdk.services.mgn.model.CreateReplicationConfigurationTemplateResponse;
import software.amazon.awssdk.services.mgn.model.CreateWaveRequest;
import software.amazon.awssdk.services.mgn.model.CreateWaveResponse;
import software.amazon.awssdk.services.mgn.model.DeleteApplicationRequest;
import software.amazon.awssdk.services.mgn.model.DeleteApplicationResponse;
import software.amazon.awssdk.services.mgn.model.DeleteConnectorRequest;
import software.amazon.awssdk.services.mgn.model.DeleteConnectorResponse;
import software.amazon.awssdk.services.mgn.model.DeleteJobRequest;
import software.amazon.awssdk.services.mgn.model.DeleteJobResponse;
import software.amazon.awssdk.services.mgn.model.DeleteLaunchConfigurationTemplateRequest;
import software.amazon.awssdk.services.mgn.model.DeleteLaunchConfigurationTemplateResponse;
import software.amazon.awssdk.services.mgn.model.DeleteReplicationConfigurationTemplateRequest;
import software.amazon.awssdk.services.mgn.model.DeleteReplicationConfigurationTemplateResponse;
import software.amazon.awssdk.services.mgn.model.DeleteSourceServerRequest;
import software.amazon.awssdk.services.mgn.model.DeleteSourceServerResponse;
import software.amazon.awssdk.services.mgn.model.DeleteVcenterClientRequest;
import software.amazon.awssdk.services.mgn.model.DeleteVcenterClientResponse;
import software.amazon.awssdk.services.mgn.model.DeleteWaveRequest;
import software.amazon.awssdk.services.mgn.model.DeleteWaveResponse;
import software.amazon.awssdk.services.mgn.model.DescribeJobLogItemsRequest;
import software.amazon.awssdk.services.mgn.model.DescribeJobLogItemsResponse;
import software.amazon.awssdk.services.mgn.model.DescribeJobsRequest;
import software.amazon.awssdk.services.mgn.model.DescribeJobsResponse;
import software.amazon.awssdk.services.mgn.model.DescribeLaunchConfigurationTemplatesRequest;
import software.amazon.awssdk.services.mgn.model.DescribeLaunchConfigurationTemplatesResponse;
import software.amazon.awssdk.services.mgn.model.DescribeReplicationConfigurationTemplatesRequest;
import software.amazon.awssdk.services.mgn.model.DescribeReplicationConfigurationTemplatesResponse;
import software.amazon.awssdk.services.mgn.model.DescribeSourceServersRequest;
import software.amazon.awssdk.services.mgn.model.DescribeSourceServersResponse;
import software.amazon.awssdk.services.mgn.model.DescribeVcenterClientsRequest;
import software.amazon.awssdk.services.mgn.model.DescribeVcenterClientsResponse;
import software.amazon.awssdk.services.mgn.model.DisassociateApplicationsRequest;
import software.amazon.awssdk.services.mgn.model.DisassociateApplicationsResponse;
import software.amazon.awssdk.services.mgn.model.DisassociateSourceServersRequest;
import software.amazon.awssdk.services.mgn.model.DisassociateSourceServersResponse;
import software.amazon.awssdk.services.mgn.model.DisconnectFromServiceRequest;
import software.amazon.awssdk.services.mgn.model.DisconnectFromServiceResponse;
import software.amazon.awssdk.services.mgn.model.FinalizeCutoverRequest;
import software.amazon.awssdk.services.mgn.model.FinalizeCutoverResponse;
import software.amazon.awssdk.services.mgn.model.GetLaunchConfigurationRequest;
import software.amazon.awssdk.services.mgn.model.GetLaunchConfigurationResponse;
import software.amazon.awssdk.services.mgn.model.GetReplicationConfigurationRequest;
import software.amazon.awssdk.services.mgn.model.GetReplicationConfigurationResponse;
import software.amazon.awssdk.services.mgn.model.InitializeServiceRequest;
import software.amazon.awssdk.services.mgn.model.InitializeServiceResponse;
import software.amazon.awssdk.services.mgn.model.InternalServerException;
import software.amazon.awssdk.services.mgn.model.ListApplicationsRequest;
import software.amazon.awssdk.services.mgn.model.ListApplicationsResponse;
import software.amazon.awssdk.services.mgn.model.ListConnectorsRequest;
import software.amazon.awssdk.services.mgn.model.ListConnectorsResponse;
import software.amazon.awssdk.services.mgn.model.ListExportErrorsRequest;
import software.amazon.awssdk.services.mgn.model.ListExportErrorsResponse;
import software.amazon.awssdk.services.mgn.model.ListExportsRequest;
import software.amazon.awssdk.services.mgn.model.ListExportsResponse;
import software.amazon.awssdk.services.mgn.model.ListImportErrorsRequest;
import software.amazon.awssdk.services.mgn.model.ListImportErrorsResponse;
import software.amazon.awssdk.services.mgn.model.ListImportsRequest;
import software.amazon.awssdk.services.mgn.model.ListImportsResponse;
import software.amazon.awssdk.services.mgn.model.ListManagedAccountsRequest;
import software.amazon.awssdk.services.mgn.model.ListManagedAccountsResponse;
import software.amazon.awssdk.services.mgn.model.ListSourceServerActionsRequest;
import software.amazon.awssdk.services.mgn.model.ListSourceServerActionsResponse;
import software.amazon.awssdk.services.mgn.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.mgn.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.mgn.model.ListTemplateActionsRequest;
import software.amazon.awssdk.services.mgn.model.ListTemplateActionsResponse;
import software.amazon.awssdk.services.mgn.model.ListWavesRequest;
import software.amazon.awssdk.services.mgn.model.ListWavesResponse;
import software.amazon.awssdk.services.mgn.model.MarkAsArchivedRequest;
import software.amazon.awssdk.services.mgn.model.MarkAsArchivedResponse;
import software.amazon.awssdk.services.mgn.model.MgnException;
import software.amazon.awssdk.services.mgn.model.PauseReplicationRequest;
import software.amazon.awssdk.services.mgn.model.PauseReplicationResponse;
import software.amazon.awssdk.services.mgn.model.PutSourceServerActionRequest;
import software.amazon.awssdk.services.mgn.model.PutSourceServerActionResponse;
import software.amazon.awssdk.services.mgn.model.PutTemplateActionRequest;
import software.amazon.awssdk.services.mgn.model.PutTemplateActionResponse;
import software.amazon.awssdk.services.mgn.model.RemoveSourceServerActionRequest;
import software.amazon.awssdk.services.mgn.model.RemoveSourceServerActionResponse;
import software.amazon.awssdk.services.mgn.model.RemoveTemplateActionRequest;
import software.amazon.awssdk.services.mgn.model.RemoveTemplateActionResponse;
import software.amazon.awssdk.services.mgn.model.ResourceNotFoundException;
import software.amazon.awssdk.services.mgn.model.ResumeReplicationRequest;
import software.amazon.awssdk.services.mgn.model.ResumeReplicationResponse;
import software.amazon.awssdk.services.mgn.model.RetryDataReplicationRequest;
import software.amazon.awssdk.services.mgn.model.RetryDataReplicationResponse;
import software.amazon.awssdk.services.mgn.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.mgn.model.StartCutoverRequest;
import software.amazon.awssdk.services.mgn.model.StartCutoverResponse;
import software.amazon.awssdk.services.mgn.model.StartExportRequest;
import software.amazon.awssdk.services.mgn.model.StartExportResponse;
import software.amazon.awssdk.services.mgn.model.StartImportRequest;
import software.amazon.awssdk.services.mgn.model.StartImportResponse;
import software.amazon.awssdk.services.mgn.model.StartReplicationRequest;
import software.amazon.awssdk.services.mgn.model.StartReplicationResponse;
import software.amazon.awssdk.services.mgn.model.StartTestRequest;
import software.amazon.awssdk.services.mgn.model.StartTestResponse;
import software.amazon.awssdk.services.mgn.model.StopReplicationRequest;
import software.amazon.awssdk.services.mgn.model.StopReplicationResponse;
import software.amazon.awssdk.services.mgn.model.TagResourceRequest;
import software.amazon.awssdk.services.mgn.model.TagResourceResponse;
import software.amazon.awssdk.services.mgn.model.TerminateTargetInstancesRequest;
import software.amazon.awssdk.services.mgn.model.TerminateTargetInstancesResponse;
import software.amazon.awssdk.services.mgn.model.ThrottlingException;
import software.amazon.awssdk.services.mgn.model.UnarchiveApplicationRequest;
import software.amazon.awssdk.services.mgn.model.UnarchiveApplicationResponse;
import software.amazon.awssdk.services.mgn.model.UnarchiveWaveRequest;
import software.amazon.awssdk.services.mgn.model.UnarchiveWaveResponse;
import software.amazon.awssdk.services.mgn.model.UninitializedAccountException;
import software.amazon.awssdk.services.mgn.model.UntagResourceRequest;
import software.amazon.awssdk.services.mgn.model.UntagResourceResponse;
import software.amazon.awssdk.services.mgn.model.UpdateApplicationRequest;
import software.amazon.awssdk.services.mgn.model.UpdateApplicationResponse;
import software.amazon.awssdk.services.mgn.model.UpdateConnectorRequest;
import software.amazon.awssdk.services.mgn.model.UpdateConnectorResponse;
import software.amazon.awssdk.services.mgn.model.UpdateLaunchConfigurationRequest;
import software.amazon.awssdk.services.mgn.model.UpdateLaunchConfigurationResponse;
import software.amazon.awssdk.services.mgn.model.UpdateLaunchConfigurationTemplateRequest;
import software.amazon.awssdk.services.mgn.model.UpdateLaunchConfigurationTemplateResponse;
import software.amazon.awssdk.services.mgn.model.UpdateReplicationConfigurationRequest;
import software.amazon.awssdk.services.mgn.model.UpdateReplicationConfigurationResponse;
import software.amazon.awssdk.services.mgn.model.UpdateReplicationConfigurationTemplateRequest;
import software.amazon.awssdk.services.mgn.model.UpdateReplicationConfigurationTemplateResponse;
import software.amazon.awssdk.services.mgn.model.UpdateSourceServerReplicationTypeRequest;
import software.amazon.awssdk.services.mgn.model.UpdateSourceServerReplicationTypeResponse;
import software.amazon.awssdk.services.mgn.model.UpdateSourceServerRequest;
import software.amazon.awssdk.services.mgn.model.UpdateSourceServerResponse;
import software.amazon.awssdk.services.mgn.model.UpdateWaveRequest;
import software.amazon.awssdk.services.mgn.model.UpdateWaveResponse;
import software.amazon.awssdk.services.mgn.model.ValidationException;
import software.amazon.awssdk.services.mgn.transform.ArchiveApplicationRequestMarshaller;
import software.amazon.awssdk.services.mgn.transform.ArchiveWaveRequestMarshaller;
import software.amazon.awssdk.services.mgn.transform.AssociateApplicationsRequestMarshaller;
import software.amazon.awssdk.services.mgn.transform.AssociateSourceServersRequestMarshaller;
import software.amazon.awssdk.services.mgn.transform.ChangeServerLifeCycleStateRequestMarshaller;
import software.amazon.awssdk.services.mgn.transform.CreateApplicationRequestMarshaller;
import software.amazon.awssdk.services.mgn.transform.CreateConnectorRequestMarshaller;
import software.amazon.awssdk.services.mgn.transform.CreateLaunchConfigurationTemplateRequestMarshaller;
import software.amazon.awssdk.services.mgn.transform.CreateReplicationConfigurationTemplateRequestMarshaller;
import software.amazon.awssdk.services.mgn.transform.CreateWaveRequestMarshaller;
import software.amazon.awssdk.services.mgn.transform.DeleteApplicationRequestMarshaller;
import software.amazon.awssdk.services.mgn.transform.DeleteConnectorRequestMarshaller;
import software.amazon.awssdk.services.mgn.transform.DeleteJobRequestMarshaller;
import software.amazon.awssdk.services.mgn.transform.DeleteLaunchConfigurationTemplateRequestMarshaller;
import software.amazon.awssdk.services.mgn.transform.DeleteReplicationConfigurationTemplateRequestMarshaller;
import software.amazon.awssdk.services.mgn.transform.DeleteSourceServerRequestMarshaller;
import software.amazon.awssdk.services.mgn.transform.DeleteVcenterClientRequestMarshaller;
import software.amazon.awssdk.services.mgn.transform.DeleteWaveRequestMarshaller;
import software.amazon.awssdk.services.mgn.transform.DescribeJobLogItemsRequestMarshaller;
import software.amazon.awssdk.services.mgn.transform.DescribeJobsRequestMarshaller;
import software.amazon.awssdk.services.mgn.transform.DescribeLaunchConfigurationTemplatesRequestMarshaller;
import software.amazon.awssdk.services.mgn.transform.DescribeReplicationConfigurationTemplatesRequestMarshaller;
import software.amazon.awssdk.services.mgn.transform.DescribeSourceServersRequestMarshaller;
import software.amazon.awssdk.services.mgn.transform.DescribeVcenterClientsRequestMarshaller;
import software.amazon.awssdk.services.mgn.transform.DisassociateApplicationsRequestMarshaller;
import software.amazon.awssdk.services.mgn.transform.DisassociateSourceServersRequestMarshaller;
import software.amazon.awssdk.services.mgn.transform.DisconnectFromServiceRequestMarshaller;
import software.amazon.awssdk.services.mgn.transform.FinalizeCutoverRequestMarshaller;
import software.amazon.awssdk.services.mgn.transform.GetLaunchConfigurationRequestMarshaller;
import software.amazon.awssdk.services.mgn.transform.GetReplicationConfigurationRequestMarshaller;
import software.amazon.awssdk.services.mgn.transform.InitializeServiceRequestMarshaller;
import software.amazon.awssdk.services.mgn.transform.ListApplicationsRequestMarshaller;
import software.amazon.awssdk.services.mgn.transform.ListConnectorsRequestMarshaller;
import software.amazon.awssdk.services.mgn.transform.ListExportErrorsRequestMarshaller;
import software.amazon.awssdk.services.mgn.transform.ListExportsRequestMarshaller;
import software.amazon.awssdk.services.mgn.transform.ListImportErrorsRequestMarshaller;
import software.amazon.awssdk.services.mgn.transform.ListImportsRequestMarshaller;
import software.amazon.awssdk.services.mgn.transform.ListManagedAccountsRequestMarshaller;
import software.amazon.awssdk.services.mgn.transform.ListSourceServerActionsRequestMarshaller;
import software.amazon.awssdk.services.mgn.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.mgn.transform.ListTemplateActionsRequestMarshaller;
import software.amazon.awssdk.services.mgn.transform.ListWavesRequestMarshaller;
import software.amazon.awssdk.services.mgn.transform.MarkAsArchivedRequestMarshaller;
import software.amazon.awssdk.services.mgn.transform.PauseReplicationRequestMarshaller;
import software.amazon.awssdk.services.mgn.transform.PutSourceServerActionRequestMarshaller;
import software.amazon.awssdk.services.mgn.transform.PutTemplateActionRequestMarshaller;
import software.amazon.awssdk.services.mgn.transform.RemoveSourceServerActionRequestMarshaller;
import software.amazon.awssdk.services.mgn.transform.RemoveTemplateActionRequestMarshaller;
import software.amazon.awssdk.services.mgn.transform.ResumeReplicationRequestMarshaller;
import software.amazon.awssdk.services.mgn.transform.RetryDataReplicationRequestMarshaller;
import software.amazon.awssdk.services.mgn.transform.StartCutoverRequestMarshaller;
import software.amazon.awssdk.services.mgn.transform.StartExportRequestMarshaller;
import software.amazon.awssdk.services.mgn.transform.StartImportRequestMarshaller;
import software.amazon.awssdk.services.mgn.transform.StartReplicationRequestMarshaller;
import software.amazon.awssdk.services.mgn.transform.StartTestRequestMarshaller;
import software.amazon.awssdk.services.mgn.transform.StopReplicationRequestMarshaller;
import software.amazon.awssdk.services.mgn.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.mgn.transform.TerminateTargetInstancesRequestMarshaller;
import software.amazon.awssdk.services.mgn.transform.UnarchiveApplicationRequestMarshaller;
import software.amazon.awssdk.services.mgn.transform.UnarchiveWaveRequestMarshaller;
import software.amazon.awssdk.services.mgn.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.mgn.transform.UpdateApplicationRequestMarshaller;
import software.amazon.awssdk.services.mgn.transform.UpdateConnectorRequestMarshaller;
import software.amazon.awssdk.services.mgn.transform.UpdateLaunchConfigurationRequestMarshaller;
import software.amazon.awssdk.services.mgn.transform.UpdateLaunchConfigurationTemplateRequestMarshaller;
import software.amazon.awssdk.services.mgn.transform.UpdateReplicationConfigurationRequestMarshaller;
import software.amazon.awssdk.services.mgn.transform.UpdateReplicationConfigurationTemplateRequestMarshaller;
import software.amazon.awssdk.services.mgn.transform.UpdateSourceServerReplicationTypeRequestMarshaller;
import software.amazon.awssdk.services.mgn.transform.UpdateSourceServerRequestMarshaller;
import software.amazon.awssdk.services.mgn.transform.UpdateWaveRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

/**
 * Internal implementation of {@link MgnClient}.
 *
 * @see MgnClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultMgnClient implements MgnClient {
    private static final Logger log = Logger.loggerFor(DefaultMgnClient.class);

    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder()
            .serviceProtocol(AwsServiceProtocol.REST_JSON).build();

    private final SyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultMgnClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option(SdkClientOption.SDK_CLIENT, this).build();
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    /**
     * <p>
     * Archive application.
     * </p>
     *
     * @param archiveApplicationRequest
     * @return Result of the ArchiveApplication operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ServiceQuotaExceededException
     *         The request could not be completed because its exceeded the service quota.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.ArchiveApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/ArchiveApplication" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ArchiveApplicationResponse archiveApplication(ArchiveApplicationRequest archiveApplicationRequest)
            throws UninitializedAccountException, ResourceNotFoundException, ServiceQuotaExceededException, ConflictException,
            AwsServiceException, SdkClientException, MgnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ArchiveApplicationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ArchiveApplicationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(archiveApplicationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, archiveApplicationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "mgn");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ArchiveApplication");

            return clientHandler.execute(new ClientExecutionParams<ArchiveApplicationRequest, ArchiveApplicationResponse>()
                    .withOperationName("ArchiveApplication").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(archiveApplicationRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ArchiveApplicationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Archive wave.
     * </p>
     *
     * @param archiveWaveRequest
     * @return Result of the ArchiveWave operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ServiceQuotaExceededException
     *         The request could not be completed because its exceeded the service quota.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.ArchiveWave
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/ArchiveWave" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ArchiveWaveResponse archiveWave(ArchiveWaveRequest archiveWaveRequest) throws UninitializedAccountException,
            ResourceNotFoundException, ServiceQuotaExceededException, ConflictException, AwsServiceException, SdkClientException,
            MgnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ArchiveWaveResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ArchiveWaveResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(archiveWaveRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, archiveWaveRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "mgn");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ArchiveWave");

            return clientHandler.execute(new ClientExecutionParams<ArchiveWaveRequest, ArchiveWaveResponse>()
                    .withOperationName("ArchiveWave").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(archiveWaveRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ArchiveWaveRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Associate applications to wave.
     * </p>
     *
     * @param associateApplicationsRequest
     * @return Result of the AssociateApplications operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ServiceQuotaExceededException
     *         The request could not be completed because its exceeded the service quota.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.AssociateApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/AssociateApplications" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public AssociateApplicationsResponse associateApplications(AssociateApplicationsRequest associateApplicationsRequest)
            throws UninitializedAccountException, ResourceNotFoundException, ServiceQuotaExceededException, ConflictException,
            AwsServiceException, SdkClientException, MgnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AssociateApplicationsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AssociateApplicationsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associateApplicationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associateApplicationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "mgn");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateApplications");

            return clientHandler.execute(new ClientExecutionParams<AssociateApplicationsRequest, AssociateApplicationsResponse>()
                    .withOperationName("AssociateApplications").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(associateApplicationsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new AssociateApplicationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Associate source servers to application.
     * </p>
     *
     * @param associateSourceServersRequest
     * @return Result of the AssociateSourceServers operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ServiceQuotaExceededException
     *         The request could not be completed because its exceeded the service quota.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.AssociateSourceServers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/AssociateSourceServers" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public AssociateSourceServersResponse associateSourceServers(AssociateSourceServersRequest associateSourceServersRequest)
            throws UninitializedAccountException, ResourceNotFoundException, ServiceQuotaExceededException, ConflictException,
            AwsServiceException, SdkClientException, MgnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AssociateSourceServersResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AssociateSourceServersResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associateSourceServersRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associateSourceServersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "mgn");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateSourceServers");

            return clientHandler
                    .execute(new ClientExecutionParams<AssociateSourceServersRequest, AssociateSourceServersResponse>()
                            .withOperationName("AssociateSourceServers").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(associateSourceServersRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AssociateSourceServersRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Allows the user to set the SourceServer.LifeCycle.state property for specific Source Server IDs to one of the
     * following: READY_FOR_TEST or READY_FOR_CUTOVER. This command only works if the Source Server is already
     * launchable (dataReplicationInfo.lagDuration is not null.)
     * </p>
     *
     * @param changeServerLifeCycleStateRequest
     * @return Result of the ChangeServerLifeCycleState operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.ChangeServerLifeCycleState
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/ChangeServerLifeCycleState"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ChangeServerLifeCycleStateResponse changeServerLifeCycleState(
            ChangeServerLifeCycleStateRequest changeServerLifeCycleStateRequest) throws UninitializedAccountException,
            ResourceNotFoundException, ValidationException, ConflictException, AwsServiceException, SdkClientException,
            MgnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ChangeServerLifeCycleStateResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ChangeServerLifeCycleStateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(changeServerLifeCycleStateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, changeServerLifeCycleStateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "mgn");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ChangeServerLifeCycleState");

            return clientHandler
                    .execute(new ClientExecutionParams<ChangeServerLifeCycleStateRequest, ChangeServerLifeCycleStateResponse>()
                            .withOperationName("ChangeServerLifeCycleState").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(changeServerLifeCycleStateRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ChangeServerLifeCycleStateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Create application.
     * </p>
     *
     * @param createApplicationRequest
     * @return Result of the CreateApplication operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ServiceQuotaExceededException
     *         The request could not be completed because its exceeded the service quota.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.CreateApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/CreateApplication" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateApplicationResponse createApplication(CreateApplicationRequest createApplicationRequest)
            throws UninitializedAccountException, ServiceQuotaExceededException, ConflictException, AwsServiceException,
            SdkClientException, MgnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateApplicationResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateApplicationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createApplicationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createApplicationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "mgn");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateApplication");

            return clientHandler.execute(new ClientExecutionParams<CreateApplicationRequest, CreateApplicationResponse>()
                    .withOperationName("CreateApplication").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createApplicationRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateApplicationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Create Connector.
     * </p>
     *
     * @param createConnectorRequest
     * @return Result of the CreateConnector operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.CreateConnector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/CreateConnector" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateConnectorResponse createConnector(CreateConnectorRequest createConnectorRequest)
            throws UninitializedAccountException, ValidationException, AwsServiceException, SdkClientException, MgnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateConnectorResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateConnectorResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createConnectorRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createConnectorRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "mgn");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateConnector");

            return clientHandler.execute(new ClientExecutionParams<CreateConnectorRequest, CreateConnectorResponse>()
                    .withOperationName("CreateConnector").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createConnectorRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateConnectorRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new Launch Configuration Template.
     * </p>
     *
     * @param createLaunchConfigurationTemplateRequest
     * @return Result of the CreateLaunchConfigurationTemplate operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws AccessDeniedException
     *         Operating denied due to a file permission or access check error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.CreateLaunchConfigurationTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/CreateLaunchConfigurationTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateLaunchConfigurationTemplateResponse createLaunchConfigurationTemplate(
            CreateLaunchConfigurationTemplateRequest createLaunchConfigurationTemplateRequest)
            throws UninitializedAccountException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, MgnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateLaunchConfigurationTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateLaunchConfigurationTemplateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createLaunchConfigurationTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createLaunchConfigurationTemplateRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "mgn");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateLaunchConfigurationTemplate");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateLaunchConfigurationTemplateRequest, CreateLaunchConfigurationTemplateResponse>()
                            .withOperationName("CreateLaunchConfigurationTemplate").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createLaunchConfigurationTemplateRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateLaunchConfigurationTemplateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new ReplicationConfigurationTemplate.
     * </p>
     *
     * @param createReplicationConfigurationTemplateRequest
     * @return Result of the CreateReplicationConfigurationTemplate operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws AccessDeniedException
     *         Operating denied due to a file permission or access check error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.CreateReplicationConfigurationTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/CreateReplicationConfigurationTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateReplicationConfigurationTemplateResponse createReplicationConfigurationTemplate(
            CreateReplicationConfigurationTemplateRequest createReplicationConfigurationTemplateRequest)
            throws UninitializedAccountException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, MgnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateReplicationConfigurationTemplateResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, CreateReplicationConfigurationTemplateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createReplicationConfigurationTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createReplicationConfigurationTemplateRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "mgn");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateReplicationConfigurationTemplate");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateReplicationConfigurationTemplateRequest, CreateReplicationConfigurationTemplateResponse>()
                            .withOperationName("CreateReplicationConfigurationTemplate").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration)
                            .withInput(createReplicationConfigurationTemplateRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateReplicationConfigurationTemplateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Create wave.
     * </p>
     *
     * @param createWaveRequest
     * @return Result of the CreateWave operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ServiceQuotaExceededException
     *         The request could not be completed because its exceeded the service quota.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.CreateWave
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/CreateWave" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateWaveResponse createWave(CreateWaveRequest createWaveRequest) throws UninitializedAccountException,
            ServiceQuotaExceededException, ConflictException, AwsServiceException, SdkClientException, MgnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateWaveResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateWaveResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createWaveRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createWaveRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "mgn");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateWave");

            return clientHandler.execute(new ClientExecutionParams<CreateWaveRequest, CreateWaveResponse>()
                    .withOperationName("CreateWave").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(createWaveRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateWaveRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Delete application.
     * </p>
     *
     * @param deleteApplicationRequest
     * @return Result of the DeleteApplication operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.DeleteApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DeleteApplication" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteApplicationResponse deleteApplication(DeleteApplicationRequest deleteApplicationRequest)
            throws UninitializedAccountException, ResourceNotFoundException, ConflictException, AwsServiceException,
            SdkClientException, MgnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteApplicationResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteApplicationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteApplicationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteApplicationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "mgn");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteApplication");

            return clientHandler.execute(new ClientExecutionParams<DeleteApplicationRequest, DeleteApplicationResponse>()
                    .withOperationName("DeleteApplication").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteApplicationRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteApplicationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Delete Connector.
     * </p>
     *
     * @param deleteConnectorRequest
     * @return Result of the DeleteConnector operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.DeleteConnector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DeleteConnector" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteConnectorResponse deleteConnector(DeleteConnectorRequest deleteConnectorRequest)
            throws UninitializedAccountException, ResourceNotFoundException, ValidationException, AwsServiceException,
            SdkClientException, MgnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteConnectorResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteConnectorResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteConnectorRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteConnectorRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "mgn");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteConnector");

            return clientHandler.execute(new ClientExecutionParams<DeleteConnectorRequest, DeleteConnectorResponse>()
                    .withOperationName("DeleteConnector").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteConnectorRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteConnectorRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a single Job by ID.
     * </p>
     *
     * @param deleteJobRequest
     * @return Result of the DeleteJob operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.DeleteJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DeleteJob" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteJobResponse deleteJob(DeleteJobRequest deleteJobRequest) throws UninitializedAccountException,
            ResourceNotFoundException, ConflictException, AwsServiceException, SdkClientException, MgnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteJobResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteJobResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "mgn");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteJob");

            return clientHandler.execute(new ClientExecutionParams<DeleteJobRequest, DeleteJobResponse>()
                    .withOperationName("DeleteJob").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(deleteJobRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a single Launch Configuration Template by ID.
     * </p>
     *
     * @param deleteLaunchConfigurationTemplateRequest
     * @return Result of the DeleteLaunchConfigurationTemplate operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.DeleteLaunchConfigurationTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DeleteLaunchConfigurationTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteLaunchConfigurationTemplateResponse deleteLaunchConfigurationTemplate(
            DeleteLaunchConfigurationTemplateRequest deleteLaunchConfigurationTemplateRequest)
            throws UninitializedAccountException, ResourceNotFoundException, ConflictException, AwsServiceException,
            SdkClientException, MgnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteLaunchConfigurationTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteLaunchConfigurationTemplateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteLaunchConfigurationTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteLaunchConfigurationTemplateRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "mgn");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteLaunchConfigurationTemplate");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteLaunchConfigurationTemplateRequest, DeleteLaunchConfigurationTemplateResponse>()
                            .withOperationName("DeleteLaunchConfigurationTemplate").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteLaunchConfigurationTemplateRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteLaunchConfigurationTemplateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a single Replication Configuration Template by ID
     * </p>
     *
     * @param deleteReplicationConfigurationTemplateRequest
     * @return Result of the DeleteReplicationConfigurationTemplate operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.DeleteReplicationConfigurationTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DeleteReplicationConfigurationTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteReplicationConfigurationTemplateResponse deleteReplicationConfigurationTemplate(
            DeleteReplicationConfigurationTemplateRequest deleteReplicationConfigurationTemplateRequest)
            throws UninitializedAccountException, ResourceNotFoundException, ConflictException, AwsServiceException,
            SdkClientException, MgnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteReplicationConfigurationTemplateResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, DeleteReplicationConfigurationTemplateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteReplicationConfigurationTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteReplicationConfigurationTemplateRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "mgn");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteReplicationConfigurationTemplate");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteReplicationConfigurationTemplateRequest, DeleteReplicationConfigurationTemplateResponse>()
                            .withOperationName("DeleteReplicationConfigurationTemplate").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration)
                            .withInput(deleteReplicationConfigurationTemplateRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteReplicationConfigurationTemplateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a single source server by ID.
     * </p>
     *
     * @param deleteSourceServerRequest
     * @return Result of the DeleteSourceServer operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.DeleteSourceServer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DeleteSourceServer" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteSourceServerResponse deleteSourceServer(DeleteSourceServerRequest deleteSourceServerRequest)
            throws UninitializedAccountException, ResourceNotFoundException, ConflictException, AwsServiceException,
            SdkClientException, MgnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteSourceServerResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteSourceServerResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteSourceServerRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteSourceServerRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "mgn");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteSourceServer");

            return clientHandler.execute(new ClientExecutionParams<DeleteSourceServerRequest, DeleteSourceServerResponse>()
                    .withOperationName("DeleteSourceServer").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteSourceServerRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteSourceServerRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a given vCenter client by ID.
     * </p>
     *
     * @param deleteVcenterClientRequest
     * @return Result of the DeleteVcenterClient operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.DeleteVcenterClient
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DeleteVcenterClient" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteVcenterClientResponse deleteVcenterClient(DeleteVcenterClientRequest deleteVcenterClientRequest)
            throws UninitializedAccountException, ResourceNotFoundException, ValidationException, AwsServiceException,
            SdkClientException, MgnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteVcenterClientResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteVcenterClientResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteVcenterClientRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteVcenterClientRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "mgn");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteVcenterClient");

            return clientHandler.execute(new ClientExecutionParams<DeleteVcenterClientRequest, DeleteVcenterClientResponse>()
                    .withOperationName("DeleteVcenterClient").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteVcenterClientRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteVcenterClientRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Delete wave.
     * </p>
     *
     * @param deleteWaveRequest
     * @return Result of the DeleteWave operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.DeleteWave
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DeleteWave" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteWaveResponse deleteWave(DeleteWaveRequest deleteWaveRequest) throws UninitializedAccountException,
            ResourceNotFoundException, ConflictException, AwsServiceException, SdkClientException, MgnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteWaveResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteWaveResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteWaveRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteWaveRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "mgn");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteWave");

            return clientHandler.execute(new ClientExecutionParams<DeleteWaveRequest, DeleteWaveResponse>()
                    .withOperationName("DeleteWave").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(deleteWaveRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteWaveRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves detailed job log items with paging.
     * </p>
     *
     * @param describeJobLogItemsRequest
     * @return Result of the DescribeJobLogItems operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.DescribeJobLogItems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DescribeJobLogItems" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DescribeJobLogItemsResponse describeJobLogItems(DescribeJobLogItemsRequest describeJobLogItemsRequest)
            throws UninitializedAccountException, ValidationException, AwsServiceException, SdkClientException, MgnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeJobLogItemsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeJobLogItemsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeJobLogItemsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeJobLogItemsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "mgn");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeJobLogItems");

            return clientHandler.execute(new ClientExecutionParams<DescribeJobLogItemsRequest, DescribeJobLogItemsResponse>()
                    .withOperationName("DescribeJobLogItems").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeJobLogItemsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeJobLogItemsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of Jobs. Use the JobsID and fromDate and toData filters to limit which jobs are returned. The
     * response is sorted by creationDataTime - latest date first. Jobs are normally created by the StartTest,
     * StartCutover, and TerminateTargetInstances APIs. Jobs are also created by DiagnosticLaunch and
     * TerminateDiagnosticInstances, which are APIs available only to *Support* and only used in response to relevant
     * support tickets.
     * </p>
     *
     * @param describeJobsRequest
     * @return Result of the DescribeJobs operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.DescribeJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DescribeJobs" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DescribeJobsResponse describeJobs(DescribeJobsRequest describeJobsRequest) throws UninitializedAccountException,
            ValidationException, AwsServiceException, SdkClientException, MgnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeJobsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeJobsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeJobsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeJobsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "mgn");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeJobs");

            return clientHandler.execute(new ClientExecutionParams<DescribeJobsRequest, DescribeJobsResponse>()
                    .withOperationName("DescribeJobs").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeJobsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeJobsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all Launch Configuration Templates, filtered by Launch Configuration Template IDs
     * </p>
     *
     * @param describeLaunchConfigurationTemplatesRequest
     * @return Result of the DescribeLaunchConfigurationTemplates operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.DescribeLaunchConfigurationTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DescribeLaunchConfigurationTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeLaunchConfigurationTemplatesResponse describeLaunchConfigurationTemplates(
            DescribeLaunchConfigurationTemplatesRequest describeLaunchConfigurationTemplatesRequest)
            throws UninitializedAccountException, ResourceNotFoundException, ValidationException, AwsServiceException,
            SdkClientException, MgnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeLaunchConfigurationTemplatesResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, DescribeLaunchConfigurationTemplatesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeLaunchConfigurationTemplatesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeLaunchConfigurationTemplatesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "mgn");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeLaunchConfigurationTemplates");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeLaunchConfigurationTemplatesRequest, DescribeLaunchConfigurationTemplatesResponse>()
                            .withOperationName("DescribeLaunchConfigurationTemplates").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeLaunchConfigurationTemplatesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeLaunchConfigurationTemplatesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all ReplicationConfigurationTemplates, filtered by Source Server IDs.
     * </p>
     *
     * @param describeReplicationConfigurationTemplatesRequest
     * @return Result of the DescribeReplicationConfigurationTemplates operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.DescribeReplicationConfigurationTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DescribeReplicationConfigurationTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeReplicationConfigurationTemplatesResponse describeReplicationConfigurationTemplates(
            DescribeReplicationConfigurationTemplatesRequest describeReplicationConfigurationTemplatesRequest)
            throws UninitializedAccountException, ResourceNotFoundException, ValidationException, AwsServiceException,
            SdkClientException, MgnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeReplicationConfigurationTemplatesResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, DescribeReplicationConfigurationTemplatesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                describeReplicationConfigurationTemplatesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeReplicationConfigurationTemplatesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "mgn");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeReplicationConfigurationTemplates");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeReplicationConfigurationTemplatesRequest, DescribeReplicationConfigurationTemplatesResponse>()
                            .withOperationName("DescribeReplicationConfigurationTemplates")
                            .withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withInput(describeReplicationConfigurationTemplatesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeReplicationConfigurationTemplatesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves all SourceServers or multiple SourceServers by ID.
     * </p>
     *
     * @param describeSourceServersRequest
     * @return Result of the DescribeSourceServers operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.DescribeSourceServers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DescribeSourceServers" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DescribeSourceServersResponse describeSourceServers(DescribeSourceServersRequest describeSourceServersRequest)
            throws UninitializedAccountException, ValidationException, AwsServiceException, SdkClientException, MgnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeSourceServersResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeSourceServersResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeSourceServersRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeSourceServersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "mgn");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeSourceServers");

            return clientHandler.execute(new ClientExecutionParams<DescribeSourceServersRequest, DescribeSourceServersResponse>()
                    .withOperationName("DescribeSourceServers").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeSourceServersRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeSourceServersRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of the installed vCenter clients.
     * </p>
     *
     * @param describeVcenterClientsRequest
     * @return Result of the DescribeVcenterClients operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.DescribeVcenterClients
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DescribeVcenterClients" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DescribeVcenterClientsResponse describeVcenterClients(DescribeVcenterClientsRequest describeVcenterClientsRequest)
            throws UninitializedAccountException, ResourceNotFoundException, ValidationException, AwsServiceException,
            SdkClientException, MgnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeVcenterClientsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeVcenterClientsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeVcenterClientsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeVcenterClientsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "mgn");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeVcenterClients");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeVcenterClientsRequest, DescribeVcenterClientsResponse>()
                            .withOperationName("DescribeVcenterClients").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeVcenterClientsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeVcenterClientsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Disassociate applications from wave.
     * </p>
     *
     * @param disassociateApplicationsRequest
     * @return Result of the DisassociateApplications operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.DisassociateApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DisassociateApplications" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DisassociateApplicationsResponse disassociateApplications(
            DisassociateApplicationsRequest disassociateApplicationsRequest) throws UninitializedAccountException,
            ResourceNotFoundException, ConflictException, AwsServiceException, SdkClientException, MgnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DisassociateApplicationsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DisassociateApplicationsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(disassociateApplicationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, disassociateApplicationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "mgn");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisassociateApplications");

            return clientHandler
                    .execute(new ClientExecutionParams<DisassociateApplicationsRequest, DisassociateApplicationsResponse>()
                            .withOperationName("DisassociateApplications").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(disassociateApplicationsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DisassociateApplicationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Disassociate source servers from application.
     * </p>
     *
     * @param disassociateSourceServersRequest
     * @return Result of the DisassociateSourceServers operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.DisassociateSourceServers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DisassociateSourceServers" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DisassociateSourceServersResponse disassociateSourceServers(
            DisassociateSourceServersRequest disassociateSourceServersRequest) throws UninitializedAccountException,
            ResourceNotFoundException, ConflictException, AwsServiceException, SdkClientException, MgnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DisassociateSourceServersResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DisassociateSourceServersResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(disassociateSourceServersRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, disassociateSourceServersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "mgn");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisassociateSourceServers");

            return clientHandler
                    .execute(new ClientExecutionParams<DisassociateSourceServersRequest, DisassociateSourceServersResponse>()
                            .withOperationName("DisassociateSourceServers").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(disassociateSourceServersRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DisassociateSourceServersRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Disconnects specific Source Servers from Application Migration Service. Data replication is stopped immediately.
     * All AWS resources created by Application Migration Service for enabling the replication of these source servers
     * will be terminated / deleted within 90 minutes. Launched Test or Cutover instances will NOT be terminated. If the
     * agent on the source server has not been prevented from communicating with the Application Migration Service
     * service, then it will receive a command to uninstall itself (within approximately 10 minutes). The following
     * properties of the SourceServer will be changed immediately: dataReplicationInfo.dataReplicationState will be set
     * to DISCONNECTED; The totalStorageBytes property for each of dataReplicationInfo.replicatedDisks will be set to
     * zero; dataReplicationInfo.lagDuration and dataReplicationInfo.lagDuration will be nullified.
     * </p>
     *
     * @param disconnectFromServiceRequest
     * @return Result of the DisconnectFromService operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.DisconnectFromService
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DisconnectFromService" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DisconnectFromServiceResponse disconnectFromService(DisconnectFromServiceRequest disconnectFromServiceRequest)
            throws UninitializedAccountException, ResourceNotFoundException, ConflictException, AwsServiceException,
            SdkClientException, MgnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DisconnectFromServiceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DisconnectFromServiceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(disconnectFromServiceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, disconnectFromServiceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "mgn");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisconnectFromService");

            return clientHandler.execute(new ClientExecutionParams<DisconnectFromServiceRequest, DisconnectFromServiceResponse>()
                    .withOperationName("DisconnectFromService").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(disconnectFromServiceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DisconnectFromServiceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Finalizes the cutover immediately for specific Source Servers. All AWS resources created by Application Migration
     * Service for enabling the replication of these source servers will be terminated / deleted within 90 minutes.
     * Launched Test or Cutover instances will NOT be terminated. The AWS Replication Agent will receive a command to
     * uninstall itself (within 10 minutes). The following properties of the SourceServer will be changed immediately:
     * dataReplicationInfo.dataReplicationState will be changed to DISCONNECTED; The SourceServer.lifeCycle.state will
     * be changed to CUTOVER; The totalStorageBytes property fo each of dataReplicationInfo.replicatedDisks will be set
     * to zero; dataReplicationInfo.lagDuration and dataReplicationInfo.lagDuration will be nullified.
     * </p>
     *
     * @param finalizeCutoverRequest
     * @return Result of the FinalizeCutover operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.FinalizeCutover
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/FinalizeCutover" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public FinalizeCutoverResponse finalizeCutover(FinalizeCutoverRequest finalizeCutoverRequest)
            throws UninitializedAccountException, ResourceNotFoundException, ValidationException, ConflictException,
            AwsServiceException, SdkClientException, MgnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<FinalizeCutoverResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                FinalizeCutoverResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(finalizeCutoverRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, finalizeCutoverRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "mgn");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "FinalizeCutover");

            return clientHandler.execute(new ClientExecutionParams<FinalizeCutoverRequest, FinalizeCutoverResponse>()
                    .withOperationName("FinalizeCutover").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(finalizeCutoverRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new FinalizeCutoverRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all LaunchConfigurations available, filtered by Source Server IDs.
     * </p>
     *
     * @param getLaunchConfigurationRequest
     * @return Result of the GetLaunchConfiguration operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.GetLaunchConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/GetLaunchConfiguration" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetLaunchConfigurationResponse getLaunchConfiguration(GetLaunchConfigurationRequest getLaunchConfigurationRequest)
            throws UninitializedAccountException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            MgnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetLaunchConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetLaunchConfigurationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getLaunchConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getLaunchConfigurationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "mgn");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetLaunchConfiguration");

            return clientHandler
                    .execute(new ClientExecutionParams<GetLaunchConfigurationRequest, GetLaunchConfigurationResponse>()
                            .withOperationName("GetLaunchConfiguration").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(getLaunchConfigurationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetLaunchConfigurationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all ReplicationConfigurations, filtered by Source Server ID.
     * </p>
     *
     * @param getReplicationConfigurationRequest
     * @return Result of the GetReplicationConfiguration operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.GetReplicationConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/GetReplicationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetReplicationConfigurationResponse getReplicationConfiguration(
            GetReplicationConfigurationRequest getReplicationConfigurationRequest) throws UninitializedAccountException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, MgnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetReplicationConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetReplicationConfigurationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getReplicationConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getReplicationConfigurationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "mgn");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetReplicationConfiguration");

            return clientHandler
                    .execute(new ClientExecutionParams<GetReplicationConfigurationRequest, GetReplicationConfigurationResponse>()
                            .withOperationName("GetReplicationConfiguration").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(getReplicationConfigurationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetReplicationConfigurationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Initialize Application Migration Service.
     * </p>
     *
     * @param initializeServiceRequest
     * @return Result of the InitializeService operation returned by the service.
     * @throws ValidationException
     *         Validate exception.
     * @throws AccessDeniedException
     *         Operating denied due to a file permission or access check error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.InitializeService
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/InitializeService" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public InitializeServiceResponse initializeService(InitializeServiceRequest initializeServiceRequest)
            throws ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, MgnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<InitializeServiceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                InitializeServiceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(initializeServiceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, initializeServiceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "mgn");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "InitializeService");

            return clientHandler.execute(new ClientExecutionParams<InitializeServiceRequest, InitializeServiceResponse>()
                    .withOperationName("InitializeService").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(initializeServiceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new InitializeServiceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves all applications or multiple applications by ID.
     * </p>
     *
     * @param listApplicationsRequest
     * @return Result of the ListApplications operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.ListApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/ListApplications" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListApplicationsResponse listApplications(ListApplicationsRequest listApplicationsRequest)
            throws UninitializedAccountException, AwsServiceException, SdkClientException, MgnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListApplicationsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListApplicationsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listApplicationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listApplicationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "mgn");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListApplications");

            return clientHandler.execute(new ClientExecutionParams<ListApplicationsRequest, ListApplicationsResponse>()
                    .withOperationName("ListApplications").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listApplicationsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListApplicationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * List Connectors.
     * </p>
     *
     * @param listConnectorsRequest
     * @return Result of the ListConnectors operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.ListConnectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/ListConnectors" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListConnectorsResponse listConnectors(ListConnectorsRequest listConnectorsRequest)
            throws UninitializedAccountException, ValidationException, AwsServiceException, SdkClientException, MgnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListConnectorsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListConnectorsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listConnectorsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listConnectorsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "mgn");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListConnectors");

            return clientHandler.execute(new ClientExecutionParams<ListConnectorsRequest, ListConnectorsResponse>()
                    .withOperationName("ListConnectors").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listConnectorsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListConnectorsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * List export errors.
     * </p>
     *
     * @param listExportErrorsRequest
     *        List export errors request.
     * @return Result of the ListExportErrors operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.ListExportErrors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/ListExportErrors" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListExportErrorsResponse listExportErrors(ListExportErrorsRequest listExportErrorsRequest)
            throws UninitializedAccountException, ValidationException, AwsServiceException, SdkClientException, MgnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListExportErrorsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListExportErrorsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listExportErrorsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listExportErrorsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "mgn");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListExportErrors");

            return clientHandler.execute(new ClientExecutionParams<ListExportErrorsRequest, ListExportErrorsResponse>()
                    .withOperationName("ListExportErrors").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listExportErrorsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListExportErrorsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * List exports.
     * </p>
     *
     * @param listExportsRequest
     *        List export request.
     * @return Result of the ListExports operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.ListExports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/ListExports" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListExportsResponse listExports(ListExportsRequest listExportsRequest) throws UninitializedAccountException,
            AwsServiceException, SdkClientException, MgnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListExportsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListExportsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listExportsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listExportsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "mgn");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListExports");

            return clientHandler.execute(new ClientExecutionParams<ListExportsRequest, ListExportsResponse>()
                    .withOperationName("ListExports").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(listExportsRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListExportsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * List import errors.
     * </p>
     *
     * @param listImportErrorsRequest
     *        List import errors request.
     * @return Result of the ListImportErrors operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.ListImportErrors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/ListImportErrors" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListImportErrorsResponse listImportErrors(ListImportErrorsRequest listImportErrorsRequest)
            throws UninitializedAccountException, ValidationException, AwsServiceException, SdkClientException, MgnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListImportErrorsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListImportErrorsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listImportErrorsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listImportErrorsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "mgn");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListImportErrors");

            return clientHandler.execute(new ClientExecutionParams<ListImportErrorsRequest, ListImportErrorsResponse>()
                    .withOperationName("ListImportErrors").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listImportErrorsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListImportErrorsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * List imports.
     * </p>
     *
     * @param listImportsRequest
     *        List imports request.
     * @return Result of the ListImports operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.ListImports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/ListImports" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListImportsResponse listImports(ListImportsRequest listImportsRequest) throws UninitializedAccountException,
            ValidationException, AwsServiceException, SdkClientException, MgnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListImportsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListImportsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listImportsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listImportsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "mgn");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListImports");

            return clientHandler.execute(new ClientExecutionParams<ListImportsRequest, ListImportsResponse>()
                    .withOperationName("ListImports").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(listImportsRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListImportsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * List Managed Accounts.
     * </p>
     *
     * @param listManagedAccountsRequest
     *        List managed accounts request.
     * @return Result of the ListManagedAccounts operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.ListManagedAccounts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/ListManagedAccounts" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListManagedAccountsResponse listManagedAccounts(ListManagedAccountsRequest listManagedAccountsRequest)
            throws UninitializedAccountException, ValidationException, AwsServiceException, SdkClientException, MgnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListManagedAccountsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListManagedAccountsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listManagedAccountsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listManagedAccountsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "mgn");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListManagedAccounts");

            return clientHandler.execute(new ClientExecutionParams<ListManagedAccountsRequest, ListManagedAccountsResponse>()
                    .withOperationName("ListManagedAccounts").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listManagedAccountsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListManagedAccountsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * List source server post migration custom actions.
     * </p>
     *
     * @param listSourceServerActionsRequest
     * @return Result of the ListSourceServerActions operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.ListSourceServerActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/ListSourceServerActions" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListSourceServerActionsResponse listSourceServerActions(ListSourceServerActionsRequest listSourceServerActionsRequest)
            throws UninitializedAccountException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            MgnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListSourceServerActionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListSourceServerActionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listSourceServerActionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listSourceServerActionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "mgn");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListSourceServerActions");

            return clientHandler
                    .execute(new ClientExecutionParams<ListSourceServerActionsRequest, ListSourceServerActionsResponse>()
                            .withOperationName("ListSourceServerActions").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listSourceServerActionsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListSourceServerActionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * List all tags for your Application Migration Service resources.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ThrottlingException
     *         Reached throttling quota exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws AccessDeniedException
     *         Operating denied due to a file permission or access check error.
     * @throws InternalServerException
     *         The server encountered an unexpected condition that prevented it from fulfilling the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/ListTagsForResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException,
            InternalServerException, AwsServiceException, SdkClientException, MgnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListTagsForResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTagsForResourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "mgn");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");

            return clientHandler.execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                    .withOperationName("ListTagsForResource").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listTagsForResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * List template post migration custom actions.
     * </p>
     *
     * @param listTemplateActionsRequest
     * @return Result of the ListTemplateActions operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.ListTemplateActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/ListTemplateActions" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListTemplateActionsResponse listTemplateActions(ListTemplateActionsRequest listTemplateActionsRequest)
            throws UninitializedAccountException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            MgnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListTemplateActionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListTemplateActionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTemplateActionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTemplateActionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "mgn");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTemplateActions");

            return clientHandler.execute(new ClientExecutionParams<ListTemplateActionsRequest, ListTemplateActionsResponse>()
                    .withOperationName("ListTemplateActions").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listTemplateActionsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListTemplateActionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves all waves or multiple waves by ID.
     * </p>
     *
     * @param listWavesRequest
     * @return Result of the ListWaves operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.ListWaves
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/ListWaves" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListWavesResponse listWaves(ListWavesRequest listWavesRequest) throws UninitializedAccountException,
            AwsServiceException, SdkClientException, MgnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListWavesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListWavesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listWavesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listWavesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "mgn");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListWaves");

            return clientHandler.execute(new ClientExecutionParams<ListWavesRequest, ListWavesResponse>()
                    .withOperationName("ListWaves").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(listWavesRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListWavesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Archives specific Source Servers by setting the SourceServer.isArchived property to true for specified
     * SourceServers by ID. This command only works for SourceServers with a lifecycle. state which equals DISCONNECTED
     * or CUTOVER.
     * </p>
     *
     * @param markAsArchivedRequest
     * @return Result of the MarkAsArchived operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.MarkAsArchived
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/MarkAsArchived" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public MarkAsArchivedResponse markAsArchived(MarkAsArchivedRequest markAsArchivedRequest)
            throws UninitializedAccountException, ResourceNotFoundException, ConflictException, AwsServiceException,
            SdkClientException, MgnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<MarkAsArchivedResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                MarkAsArchivedResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(markAsArchivedRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, markAsArchivedRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "mgn");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "MarkAsArchived");

            return clientHandler.execute(new ClientExecutionParams<MarkAsArchivedRequest, MarkAsArchivedResponse>()
                    .withOperationName("MarkAsArchived").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(markAsArchivedRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new MarkAsArchivedRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Pause Replication.
     * </p>
     *
     * @param pauseReplicationRequest
     * @return Result of the PauseReplication operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws ServiceQuotaExceededException
     *         The request could not be completed because its exceeded the service quota.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.PauseReplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/PauseReplication" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public PauseReplicationResponse pauseReplication(PauseReplicationRequest pauseReplicationRequest)
            throws UninitializedAccountException, ResourceNotFoundException, ValidationException, ServiceQuotaExceededException,
            ConflictException, AwsServiceException, SdkClientException, MgnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PauseReplicationResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                PauseReplicationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(pauseReplicationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, pauseReplicationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "mgn");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PauseReplication");

            return clientHandler.execute(new ClientExecutionParams<PauseReplicationRequest, PauseReplicationResponse>()
                    .withOperationName("PauseReplication").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(pauseReplicationRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new PauseReplicationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Put source server post migration custom action.
     * </p>
     *
     * @param putSourceServerActionRequest
     * @return Result of the PutSourceServerAction operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.PutSourceServerAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/PutSourceServerAction" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public PutSourceServerActionResponse putSourceServerAction(PutSourceServerActionRequest putSourceServerActionRequest)
            throws UninitializedAccountException, ResourceNotFoundException, ValidationException, ConflictException,
            AwsServiceException, SdkClientException, MgnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PutSourceServerActionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, PutSourceServerActionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putSourceServerActionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putSourceServerActionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "mgn");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutSourceServerAction");

            return clientHandler.execute(new ClientExecutionParams<PutSourceServerActionRequest, PutSourceServerActionResponse>()
                    .withOperationName("PutSourceServerAction").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(putSourceServerActionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new PutSourceServerActionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Put template post migration custom action.
     * </p>
     *
     * @param putTemplateActionRequest
     * @return Result of the PutTemplateAction operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.PutTemplateAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/PutTemplateAction" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public PutTemplateActionResponse putTemplateAction(PutTemplateActionRequest putTemplateActionRequest)
            throws UninitializedAccountException, ResourceNotFoundException, ValidationException, ConflictException,
            AwsServiceException, SdkClientException, MgnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PutTemplateActionResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                PutTemplateActionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putTemplateActionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putTemplateActionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "mgn");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutTemplateAction");

            return clientHandler.execute(new ClientExecutionParams<PutTemplateActionRequest, PutTemplateActionResponse>()
                    .withOperationName("PutTemplateAction").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(putTemplateActionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new PutTemplateActionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Remove source server post migration custom action.
     * </p>
     *
     * @param removeSourceServerActionRequest
     * @return Result of the RemoveSourceServerAction operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.RemoveSourceServerAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/RemoveSourceServerAction" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public RemoveSourceServerActionResponse removeSourceServerAction(
            RemoveSourceServerActionRequest removeSourceServerActionRequest) throws UninitializedAccountException,
            ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, MgnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<RemoveSourceServerActionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, RemoveSourceServerActionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(removeSourceServerActionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, removeSourceServerActionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "mgn");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RemoveSourceServerAction");

            return clientHandler
                    .execute(new ClientExecutionParams<RemoveSourceServerActionRequest, RemoveSourceServerActionResponse>()
                            .withOperationName("RemoveSourceServerAction").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(removeSourceServerActionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new RemoveSourceServerActionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Remove template post migration custom action.
     * </p>
     *
     * @param removeTemplateActionRequest
     * @return Result of the RemoveTemplateAction operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.RemoveTemplateAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/RemoveTemplateAction" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public RemoveTemplateActionResponse removeTemplateAction(RemoveTemplateActionRequest removeTemplateActionRequest)
            throws UninitializedAccountException, ResourceNotFoundException, ValidationException, AwsServiceException,
            SdkClientException, MgnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<RemoveTemplateActionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, RemoveTemplateActionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(removeTemplateActionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, removeTemplateActionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "mgn");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RemoveTemplateAction");

            return clientHandler.execute(new ClientExecutionParams<RemoveTemplateActionRequest, RemoveTemplateActionResponse>()
                    .withOperationName("RemoveTemplateAction").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(removeTemplateActionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new RemoveTemplateActionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Resume Replication.
     * </p>
     *
     * @param resumeReplicationRequest
     * @return Result of the ResumeReplication operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws ServiceQuotaExceededException
     *         The request could not be completed because its exceeded the service quota.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.ResumeReplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/ResumeReplication" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ResumeReplicationResponse resumeReplication(ResumeReplicationRequest resumeReplicationRequest)
            throws UninitializedAccountException, ResourceNotFoundException, ValidationException, ServiceQuotaExceededException,
            ConflictException, AwsServiceException, SdkClientException, MgnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ResumeReplicationResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ResumeReplicationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(resumeReplicationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, resumeReplicationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "mgn");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ResumeReplication");

            return clientHandler.execute(new ClientExecutionParams<ResumeReplicationRequest, ResumeReplicationResponse>()
                    .withOperationName("ResumeReplication").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(resumeReplicationRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ResumeReplicationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Causes the data replication initiation sequence to begin immediately upon next Handshake for specified
     * SourceServer IDs, regardless of when the previous initiation started. This command will not work if the
     * SourceServer is not stalled or is in a DISCONNECTED or STOPPED state.
     * </p>
     *
     * @param retryDataReplicationRequest
     * @return Result of the RetryDataReplication operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.RetryDataReplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/RetryDataReplication" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public RetryDataReplicationResponse retryDataReplication(RetryDataReplicationRequest retryDataReplicationRequest)
            throws UninitializedAccountException, ResourceNotFoundException, ValidationException, AwsServiceException,
            SdkClientException, MgnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<RetryDataReplicationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, RetryDataReplicationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(retryDataReplicationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, retryDataReplicationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "mgn");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RetryDataReplication");

            return clientHandler.execute(new ClientExecutionParams<RetryDataReplicationRequest, RetryDataReplicationResponse>()
                    .withOperationName("RetryDataReplication").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(retryDataReplicationRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new RetryDataReplicationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Launches a Cutover Instance for specific Source Servers. This command starts a LAUNCH job whose initiatedBy
     * property is StartCutover and changes the SourceServer.lifeCycle.state property to CUTTING_OVER.
     * </p>
     *
     * @param startCutoverRequest
     * @return Result of the StartCutover operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.StartCutover
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/StartCutover" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public StartCutoverResponse startCutover(StartCutoverRequest startCutoverRequest) throws UninitializedAccountException,
            ValidationException, ConflictException, AwsServiceException, SdkClientException, MgnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StartCutoverResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                StartCutoverResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startCutoverRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startCutoverRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "mgn");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartCutover");

            return clientHandler.execute(new ClientExecutionParams<StartCutoverRequest, StartCutoverResponse>()
                    .withOperationName("StartCutover").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(startCutoverRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new StartCutoverRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Start export.
     * </p>
     *
     * @param startExportRequest
     *        Start export request.
     * @return Result of the StartExport operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws ServiceQuotaExceededException
     *         The request could not be completed because its exceeded the service quota.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.StartExport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/StartExport" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public StartExportResponse startExport(StartExportRequest startExportRequest) throws UninitializedAccountException,
            ValidationException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, MgnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StartExportResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                StartExportResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startExportRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startExportRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "mgn");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartExport");

            return clientHandler.execute(new ClientExecutionParams<StartExportRequest, StartExportResponse>()
                    .withOperationName("StartExport").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(startExportRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new StartExportRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Start import.
     * </p>
     *
     * @param startImportRequest
     *        Start import request.
     * @return Result of the StartImport operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws ServiceQuotaExceededException
     *         The request could not be completed because its exceeded the service quota.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.StartImport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/StartImport" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public StartImportResponse startImport(StartImportRequest startImportRequest) throws UninitializedAccountException,
            ResourceNotFoundException, ValidationException, ServiceQuotaExceededException, ConflictException,
            AwsServiceException, SdkClientException, MgnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StartImportResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                StartImportResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startImportRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startImportRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "mgn");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartImport");

            return clientHandler.execute(new ClientExecutionParams<StartImportRequest, StartImportResponse>()
                    .withOperationName("StartImport").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(startImportRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new StartImportRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Starts replication for SNAPSHOT_SHIPPING agents.
     * </p>
     *
     * @param startReplicationRequest
     * @return Result of the StartReplication operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws ServiceQuotaExceededException
     *         The request could not be completed because its exceeded the service quota.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.StartReplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/StartReplication" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public StartReplicationResponse startReplication(StartReplicationRequest startReplicationRequest)
            throws UninitializedAccountException, ResourceNotFoundException, ValidationException, ServiceQuotaExceededException,
            ConflictException, AwsServiceException, SdkClientException, MgnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StartReplicationResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                StartReplicationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startReplicationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startReplicationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "mgn");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartReplication");

            return clientHandler.execute(new ClientExecutionParams<StartReplicationRequest, StartReplicationResponse>()
                    .withOperationName("StartReplication").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(startReplicationRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new StartReplicationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Launches a Test Instance for specific Source Servers. This command starts a LAUNCH job whose initiatedBy property
     * is StartTest and changes the SourceServer.lifeCycle.state property to TESTING.
     * </p>
     *
     * @param startTestRequest
     * @return Result of the StartTest operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.StartTest
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/StartTest" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public StartTestResponse startTest(StartTestRequest startTestRequest) throws UninitializedAccountException,
            ValidationException, ConflictException, AwsServiceException, SdkClientException, MgnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StartTestResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                StartTestResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startTestRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startTestRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "mgn");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartTest");

            return clientHandler.execute(new ClientExecutionParams<StartTestRequest, StartTestResponse>()
                    .withOperationName("StartTest").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(startTestRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new StartTestRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Stop Replication.
     * </p>
     *
     * @param stopReplicationRequest
     * @return Result of the StopReplication operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws ServiceQuotaExceededException
     *         The request could not be completed because its exceeded the service quota.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.StopReplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/StopReplication" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public StopReplicationResponse stopReplication(StopReplicationRequest stopReplicationRequest)
            throws UninitializedAccountException, ResourceNotFoundException, ValidationException, ServiceQuotaExceededException,
            ConflictException, AwsServiceException, SdkClientException, MgnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StopReplicationResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                StopReplicationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(stopReplicationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, stopReplicationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "mgn");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StopReplication");

            return clientHandler.execute(new ClientExecutionParams<StopReplicationRequest, StopReplicationResponse>()
                    .withOperationName("StopReplication").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(stopReplicationRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new StopReplicationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Adds or overwrites only the specified tags for the specified Application Migration Service resource or resources.
     * When you specify an existing tag key, the value is overwritten with the new value. Each resource can have a
     * maximum of 50 tags. Each tag consists of a key and optional value.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ThrottlingException
     *         Reached throttling quota exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws AccessDeniedException
     *         Operating denied due to a file permission or access check error.
     * @throws InternalServerException
     *         The server encountered an unexpected condition that prevented it from fulfilling the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ResourceNotFoundException,
            ThrottlingException, ValidationException, AccessDeniedException, InternalServerException, AwsServiceException,
            SdkClientException, MgnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                TagResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "mgn");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");

            return clientHandler.execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                    .withOperationName("TagResource").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(tagResourceRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new TagResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Starts a job that terminates specific launched EC2 Test and Cutover instances. This command will not work for any
     * Source Server with a lifecycle.state of TESTING, CUTTING_OVER, or CUTOVER.
     * </p>
     *
     * @param terminateTargetInstancesRequest
     * @return Result of the TerminateTargetInstances operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.TerminateTargetInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/TerminateTargetInstances" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public TerminateTargetInstancesResponse terminateTargetInstances(
            TerminateTargetInstancesRequest terminateTargetInstancesRequest) throws UninitializedAccountException,
            ValidationException, ConflictException, AwsServiceException, SdkClientException, MgnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<TerminateTargetInstancesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, TerminateTargetInstancesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(terminateTargetInstancesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, terminateTargetInstancesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "mgn");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TerminateTargetInstances");

            return clientHandler
                    .execute(new ClientExecutionParams<TerminateTargetInstancesRequest, TerminateTargetInstancesResponse>()
                            .withOperationName("TerminateTargetInstances").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(terminateTargetInstancesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new TerminateTargetInstancesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Unarchive application.
     * </p>
     *
     * @param unarchiveApplicationRequest
     * @return Result of the UnarchiveApplication operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ServiceQuotaExceededException
     *         The request could not be completed because its exceeded the service quota.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.UnarchiveApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/UnarchiveApplication" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UnarchiveApplicationResponse unarchiveApplication(UnarchiveApplicationRequest unarchiveApplicationRequest)
            throws UninitializedAccountException, ResourceNotFoundException, ServiceQuotaExceededException, AwsServiceException,
            SdkClientException, MgnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UnarchiveApplicationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UnarchiveApplicationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(unarchiveApplicationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, unarchiveApplicationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "mgn");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UnarchiveApplication");

            return clientHandler.execute(new ClientExecutionParams<UnarchiveApplicationRequest, UnarchiveApplicationResponse>()
                    .withOperationName("UnarchiveApplication").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(unarchiveApplicationRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UnarchiveApplicationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Unarchive wave.
     * </p>
     *
     * @param unarchiveWaveRequest
     * @return Result of the UnarchiveWave operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ServiceQuotaExceededException
     *         The request could not be completed because its exceeded the service quota.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.UnarchiveWave
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/UnarchiveWave" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UnarchiveWaveResponse unarchiveWave(UnarchiveWaveRequest unarchiveWaveRequest) throws UninitializedAccountException,
            ResourceNotFoundException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, MgnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UnarchiveWaveResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UnarchiveWaveResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(unarchiveWaveRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, unarchiveWaveRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "mgn");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UnarchiveWave");

            return clientHandler.execute(new ClientExecutionParams<UnarchiveWaveRequest, UnarchiveWaveResponse>()
                    .withOperationName("UnarchiveWave").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(unarchiveWaveRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UnarchiveWaveRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified set of tags from the specified set of Application Migration Service resources.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ThrottlingException
     *         Reached throttling quota exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws AccessDeniedException
     *         Operating denied due to a file permission or access check error.
     * @throws InternalServerException
     *         The server encountered an unexpected condition that prevented it from fulfilling the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ResourceNotFoundException,
            ThrottlingException, ValidationException, AccessDeniedException, InternalServerException, AwsServiceException,
            SdkClientException, MgnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UntagResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "mgn");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");

            return clientHandler.execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                    .withOperationName("UntagResource").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(untagResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Update application.
     * </p>
     *
     * @param updateApplicationRequest
     * @return Result of the UpdateApplication operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.UpdateApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/UpdateApplication" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateApplicationResponse updateApplication(UpdateApplicationRequest updateApplicationRequest)
            throws UninitializedAccountException, ResourceNotFoundException, ConflictException, AwsServiceException,
            SdkClientException, MgnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateApplicationResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateApplicationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateApplicationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateApplicationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "mgn");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateApplication");

            return clientHandler.execute(new ClientExecutionParams<UpdateApplicationRequest, UpdateApplicationResponse>()
                    .withOperationName("UpdateApplication").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateApplicationRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateApplicationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Update Connector.
     * </p>
     *
     * @param updateConnectorRequest
     * @return Result of the UpdateConnector operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.UpdateConnector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/UpdateConnector" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateConnectorResponse updateConnector(UpdateConnectorRequest updateConnectorRequest)
            throws UninitializedAccountException, ResourceNotFoundException, ValidationException, AwsServiceException,
            SdkClientException, MgnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateConnectorResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateConnectorResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateConnectorRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateConnectorRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "mgn");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateConnector");

            return clientHandler.execute(new ClientExecutionParams<UpdateConnectorRequest, UpdateConnectorResponse>()
                    .withOperationName("UpdateConnector").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateConnectorRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateConnectorRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates multiple LaunchConfigurations by Source Server ID.
     * </p>
     * <note>
     * <p>
     * bootMode valid values are <code>LEGACY_BIOS | UEFI</code>
     * </p>
     * </note>
     *
     * @param updateLaunchConfigurationRequest
     * @return Result of the UpdateLaunchConfiguration operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.UpdateLaunchConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/UpdateLaunchConfiguration" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UpdateLaunchConfigurationResponse updateLaunchConfiguration(
            UpdateLaunchConfigurationRequest updateLaunchConfigurationRequest) throws UninitializedAccountException,
            ResourceNotFoundException, ValidationException, ConflictException, AwsServiceException, SdkClientException,
            MgnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateLaunchConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateLaunchConfigurationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateLaunchConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateLaunchConfigurationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "mgn");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateLaunchConfiguration");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateLaunchConfigurationRequest, UpdateLaunchConfigurationResponse>()
                            .withOperationName("UpdateLaunchConfiguration").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(updateLaunchConfigurationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateLaunchConfigurationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates an existing Launch Configuration Template by ID.
     * </p>
     *
     * @param updateLaunchConfigurationTemplateRequest
     * @return Result of the UpdateLaunchConfigurationTemplate operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws AccessDeniedException
     *         Operating denied due to a file permission or access check error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.UpdateLaunchConfigurationTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/UpdateLaunchConfigurationTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateLaunchConfigurationTemplateResponse updateLaunchConfigurationTemplate(
            UpdateLaunchConfigurationTemplateRequest updateLaunchConfigurationTemplateRequest)
            throws UninitializedAccountException, ResourceNotFoundException, ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, MgnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateLaunchConfigurationTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateLaunchConfigurationTemplateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateLaunchConfigurationTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateLaunchConfigurationTemplateRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "mgn");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateLaunchConfigurationTemplate");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateLaunchConfigurationTemplateRequest, UpdateLaunchConfigurationTemplateResponse>()
                            .withOperationName("UpdateLaunchConfigurationTemplate").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(updateLaunchConfigurationTemplateRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateLaunchConfigurationTemplateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Allows you to update multiple ReplicationConfigurations by Source Server ID.
     * </p>
     *
     * @param updateReplicationConfigurationRequest
     * @return Result of the UpdateReplicationConfiguration operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws AccessDeniedException
     *         Operating denied due to a file permission or access check error.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.UpdateReplicationConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/UpdateReplicationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateReplicationConfigurationResponse updateReplicationConfiguration(
            UpdateReplicationConfigurationRequest updateReplicationConfigurationRequest) throws UninitializedAccountException,
            ResourceNotFoundException, ValidationException, AccessDeniedException, ConflictException, AwsServiceException,
            SdkClientException, MgnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateReplicationConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateReplicationConfigurationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateReplicationConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateReplicationConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "mgn");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateReplicationConfiguration");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateReplicationConfigurationRequest, UpdateReplicationConfigurationResponse>()
                            .withOperationName("UpdateReplicationConfiguration").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(updateReplicationConfigurationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateReplicationConfigurationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates multiple ReplicationConfigurationTemplates by ID.
     * </p>
     *
     * @param updateReplicationConfigurationTemplateRequest
     * @return Result of the UpdateReplicationConfigurationTemplate operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws AccessDeniedException
     *         Operating denied due to a file permission or access check error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.UpdateReplicationConfigurationTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/UpdateReplicationConfigurationTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateReplicationConfigurationTemplateResponse updateReplicationConfigurationTemplate(
            UpdateReplicationConfigurationTemplateRequest updateReplicationConfigurationTemplateRequest)
            throws UninitializedAccountException, ResourceNotFoundException, ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, MgnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateReplicationConfigurationTemplateResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, UpdateReplicationConfigurationTemplateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateReplicationConfigurationTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateReplicationConfigurationTemplateRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "mgn");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateReplicationConfigurationTemplate");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateReplicationConfigurationTemplateRequest, UpdateReplicationConfigurationTemplateResponse>()
                            .withOperationName("UpdateReplicationConfigurationTemplate").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration)
                            .withInput(updateReplicationConfigurationTemplateRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateReplicationConfigurationTemplateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Update Source Server.
     * </p>
     *
     * @param updateSourceServerRequest
     * @return Result of the UpdateSourceServer operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.UpdateSourceServer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/UpdateSourceServer" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateSourceServerResponse updateSourceServer(UpdateSourceServerRequest updateSourceServerRequest)
            throws UninitializedAccountException, ResourceNotFoundException, ConflictException, AwsServiceException,
            SdkClientException, MgnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateSourceServerResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateSourceServerResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateSourceServerRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateSourceServerRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "mgn");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateSourceServer");

            return clientHandler.execute(new ClientExecutionParams<UpdateSourceServerRequest, UpdateSourceServerResponse>()
                    .withOperationName("UpdateSourceServer").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateSourceServerRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateSourceServerRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Allows you to change between the AGENT_BASED replication type and the SNAPSHOT_SHIPPING replication type.
     * </p>
     *
     * @param updateSourceServerReplicationTypeRequest
     * @return Result of the UpdateSourceServerReplicationType operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.UpdateSourceServerReplicationType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/UpdateSourceServerReplicationType"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateSourceServerReplicationTypeResponse updateSourceServerReplicationType(
            UpdateSourceServerReplicationTypeRequest updateSourceServerReplicationTypeRequest)
            throws UninitializedAccountException, ResourceNotFoundException, ValidationException, ConflictException,
            AwsServiceException, SdkClientException, MgnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateSourceServerReplicationTypeResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateSourceServerReplicationTypeResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateSourceServerReplicationTypeRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateSourceServerReplicationTypeRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "mgn");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateSourceServerReplicationType");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateSourceServerReplicationTypeRequest, UpdateSourceServerReplicationTypeResponse>()
                            .withOperationName("UpdateSourceServerReplicationType").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(updateSourceServerReplicationTypeRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateSourceServerReplicationTypeRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Update wave.
     * </p>
     *
     * @param updateWaveRequest
     * @return Result of the UpdateWave operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.UpdateWave
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/UpdateWave" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateWaveResponse updateWave(UpdateWaveRequest updateWaveRequest) throws UninitializedAccountException,
            ResourceNotFoundException, ConflictException, AwsServiceException, SdkClientException, MgnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateWaveResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateWaveResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateWaveRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateWaveRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "mgn");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateWave");

            return clientHandler.execute(new ClientExecutionParams<UpdateWaveRequest, UpdateWaveResponse>()
                    .withOperationName("UpdateWave").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(updateWaveRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateWaveRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option(SdkClientOption.RETRY_STRATEGY, AwsRetryStrategy.forRetryMode(retryMode));
        } else {
            Consumer<RetryStrategy.Builder<?, ?>> configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder<?, ?> defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option(SdkClientOption.RETRY_STRATEGY, defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option(SdkClientOption.RETRY_STRATEGY, retryStrategy);
                }
            }
        }
        configuration.option(SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List<SdkPlugin> plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        if (plugins.isEmpty()) {
            return configuration.build();
        }
        MgnServiceClientConfigurationBuilder serviceConfigBuilder = new MgnServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient(serviceConfigBuilder);
        }
        updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(MgnException::builder)
                .protocol(AwsJsonProtocol.REST_JSON)
                .protocolVersion("1.1")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException")
                                .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).httpStatusCode(402).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InternalServerException")
                                .exceptionBuilderSupplier(InternalServerException::builder).httpStatusCode(500).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceNotFoundException")
                                .exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ValidationException")
                                .exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ThrottlingException")
                                .exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(429).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("UninitializedAccountException")
                                .exceptionBuilderSupplier(UninitializedAccountException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AccessDeniedException")
                                .exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(403).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ConflictException")
                                .exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(409).build());
    }

    @Override
    public final MgnServiceClientConfiguration serviceClientConfiguration() {
        return new MgnServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
