/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mgn.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Launch template disk configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LaunchTemplateDiskConf implements SdkPojo, Serializable,
        ToCopyableBuilder<LaunchTemplateDiskConf.Builder, LaunchTemplateDiskConf> {
    private static final SdkField<Long> IOPS_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("iops")
            .getter(getter(LaunchTemplateDiskConf::iops)).setter(setter(Builder::iops))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iops").build()).build();

    private static final SdkField<Long> THROUGHPUT_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("throughput")
            .getter(getter(LaunchTemplateDiskConf::throughput)).setter(setter(Builder::throughput))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("throughput").build()).build();

    private static final SdkField<String> VOLUME_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("volumeType").getter(getter(LaunchTemplateDiskConf::volumeTypeAsString))
            .setter(setter(Builder::volumeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("volumeType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IOPS_FIELD, THROUGHPUT_FIELD,
            VOLUME_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long iops;

    private final Long throughput;

    private final String volumeType;

    private LaunchTemplateDiskConf(BuilderImpl builder) {
        this.iops = builder.iops;
        this.throughput = builder.throughput;
        this.volumeType = builder.volumeType;
    }

    /**
     * <p>
     * Launch template disk iops configuration.
     * </p>
     * 
     * @return Launch template disk iops configuration.
     */
    public final Long iops() {
        return iops;
    }

    /**
     * <p>
     * Launch template disk throughput configuration.
     * </p>
     * 
     * @return Launch template disk throughput configuration.
     */
    public final Long throughput() {
        return throughput;
    }

    /**
     * <p>
     * Launch template disk volume type configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #volumeType} will
     * return {@link VolumeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #volumeTypeAsString}.
     * </p>
     * 
     * @return Launch template disk volume type configuration.
     * @see VolumeType
     */
    public final VolumeType volumeType() {
        return VolumeType.fromValue(volumeType);
    }

    /**
     * <p>
     * Launch template disk volume type configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #volumeType} will
     * return {@link VolumeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #volumeTypeAsString}.
     * </p>
     * 
     * @return Launch template disk volume type configuration.
     * @see VolumeType
     */
    public final String volumeTypeAsString() {
        return volumeType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(iops());
        hashCode = 31 * hashCode + Objects.hashCode(throughput());
        hashCode = 31 * hashCode + Objects.hashCode(volumeTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LaunchTemplateDiskConf)) {
            return false;
        }
        LaunchTemplateDiskConf other = (LaunchTemplateDiskConf) obj;
        return Objects.equals(iops(), other.iops()) && Objects.equals(throughput(), other.throughput())
                && Objects.equals(volumeTypeAsString(), other.volumeTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LaunchTemplateDiskConf").add("Iops", iops()).add("Throughput", throughput())
                .add("VolumeType", volumeTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "iops":
            return Optional.ofNullable(clazz.cast(iops()));
        case "throughput":
            return Optional.ofNullable(clazz.cast(throughput()));
        case "volumeType":
            return Optional.ofNullable(clazz.cast(volumeTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LaunchTemplateDiskConf, T> g) {
        return obj -> g.apply((LaunchTemplateDiskConf) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LaunchTemplateDiskConf> {
        /**
         * <p>
         * Launch template disk iops configuration.
         * </p>
         * 
         * @param iops
         *        Launch template disk iops configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iops(Long iops);

        /**
         * <p>
         * Launch template disk throughput configuration.
         * </p>
         * 
         * @param throughput
         *        Launch template disk throughput configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder throughput(Long throughput);

        /**
         * <p>
         * Launch template disk volume type configuration.
         * </p>
         * 
         * @param volumeType
         *        Launch template disk volume type configuration.
         * @see VolumeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VolumeType
         */
        Builder volumeType(String volumeType);

        /**
         * <p>
         * Launch template disk volume type configuration.
         * </p>
         * 
         * @param volumeType
         *        Launch template disk volume type configuration.
         * @see VolumeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VolumeType
         */
        Builder volumeType(VolumeType volumeType);
    }

    static final class BuilderImpl implements Builder {
        private Long iops;

        private Long throughput;

        private String volumeType;

        private BuilderImpl() {
        }

        private BuilderImpl(LaunchTemplateDiskConf model) {
            iops(model.iops);
            throughput(model.throughput);
            volumeType(model.volumeType);
        }

        public final Long getIops() {
            return iops;
        }

        public final void setIops(Long iops) {
            this.iops = iops;
        }

        @Override
        public final Builder iops(Long iops) {
            this.iops = iops;
            return this;
        }

        public final Long getThroughput() {
            return throughput;
        }

        public final void setThroughput(Long throughput) {
            this.throughput = throughput;
        }

        @Override
        public final Builder throughput(Long throughput) {
            this.throughput = throughput;
            return this;
        }

        public final String getVolumeType() {
            return volumeType;
        }

        public final void setVolumeType(String volumeType) {
            this.volumeType = volumeType;
        }

        @Override
        public final Builder volumeType(String volumeType) {
            this.volumeType = volumeType;
            return this;
        }

        @Override
        public final Builder volumeType(VolumeType volumeType) {
            this.volumeType(volumeType == null ? null : volumeType.toString());
            return this;
        }

        @Override
        public LaunchTemplateDiskConf build() {
            return new LaunchTemplateDiskConf(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
