/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mgn.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Application aggregated status.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ApplicationAggregatedStatus implements SdkPojo, Serializable,
        ToCopyableBuilder<ApplicationAggregatedStatus.Builder, ApplicationAggregatedStatus> {
    private static final SdkField<String> HEALTH_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("healthStatus").getter(getter(ApplicationAggregatedStatus::healthStatusAsString))
            .setter(setter(Builder::healthStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("healthStatus").build()).build();

    private static final SdkField<String> LAST_UPDATE_DATE_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lastUpdateDateTime").getter(getter(ApplicationAggregatedStatus::lastUpdateDateTime))
            .setter(setter(Builder::lastUpdateDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdateDateTime").build())
            .build();

    private static final SdkField<String> PROGRESS_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("progressStatus").getter(getter(ApplicationAggregatedStatus::progressStatusAsString))
            .setter(setter(Builder::progressStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("progressStatus").build()).build();

    private static final SdkField<Long> TOTAL_SOURCE_SERVERS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("totalSourceServers").getter(getter(ApplicationAggregatedStatus::totalSourceServers))
            .setter(setter(Builder::totalSourceServers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalSourceServers").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HEALTH_STATUS_FIELD,
            LAST_UPDATE_DATE_TIME_FIELD, PROGRESS_STATUS_FIELD, TOTAL_SOURCE_SERVERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String healthStatus;

    private final String lastUpdateDateTime;

    private final String progressStatus;

    private final Long totalSourceServers;

    private ApplicationAggregatedStatus(BuilderImpl builder) {
        this.healthStatus = builder.healthStatus;
        this.lastUpdateDateTime = builder.lastUpdateDateTime;
        this.progressStatus = builder.progressStatus;
        this.totalSourceServers = builder.totalSourceServers;
    }

    /**
     * <p>
     * Application aggregated status health status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #healthStatus} will
     * return {@link ApplicationHealthStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #healthStatusAsString}.
     * </p>
     * 
     * @return Application aggregated status health status.
     * @see ApplicationHealthStatus
     */
    public final ApplicationHealthStatus healthStatus() {
        return ApplicationHealthStatus.fromValue(healthStatus);
    }

    /**
     * <p>
     * Application aggregated status health status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #healthStatus} will
     * return {@link ApplicationHealthStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #healthStatusAsString}.
     * </p>
     * 
     * @return Application aggregated status health status.
     * @see ApplicationHealthStatus
     */
    public final String healthStatusAsString() {
        return healthStatus;
    }

    /**
     * <p>
     * Application aggregated status last update dateTime.
     * </p>
     * 
     * @return Application aggregated status last update dateTime.
     */
    public final String lastUpdateDateTime() {
        return lastUpdateDateTime;
    }

    /**
     * <p>
     * Application aggregated status progress status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #progressStatus}
     * will return {@link ApplicationProgressStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #progressStatusAsString}.
     * </p>
     * 
     * @return Application aggregated status progress status.
     * @see ApplicationProgressStatus
     */
    public final ApplicationProgressStatus progressStatus() {
        return ApplicationProgressStatus.fromValue(progressStatus);
    }

    /**
     * <p>
     * Application aggregated status progress status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #progressStatus}
     * will return {@link ApplicationProgressStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #progressStatusAsString}.
     * </p>
     * 
     * @return Application aggregated status progress status.
     * @see ApplicationProgressStatus
     */
    public final String progressStatusAsString() {
        return progressStatus;
    }

    /**
     * <p>
     * Application aggregated status total source servers amount.
     * </p>
     * 
     * @return Application aggregated status total source servers amount.
     */
    public final Long totalSourceServers() {
        return totalSourceServers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(healthStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdateDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(progressStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(totalSourceServers());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationAggregatedStatus)) {
            return false;
        }
        ApplicationAggregatedStatus other = (ApplicationAggregatedStatus) obj;
        return Objects.equals(healthStatusAsString(), other.healthStatusAsString())
                && Objects.equals(lastUpdateDateTime(), other.lastUpdateDateTime())
                && Objects.equals(progressStatusAsString(), other.progressStatusAsString())
                && Objects.equals(totalSourceServers(), other.totalSourceServers());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ApplicationAggregatedStatus").add("HealthStatus", healthStatusAsString())
                .add("LastUpdateDateTime", lastUpdateDateTime()).add("ProgressStatus", progressStatusAsString())
                .add("TotalSourceServers", totalSourceServers()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "healthStatus":
            return Optional.ofNullable(clazz.cast(healthStatusAsString()));
        case "lastUpdateDateTime":
            return Optional.ofNullable(clazz.cast(lastUpdateDateTime()));
        case "progressStatus":
            return Optional.ofNullable(clazz.cast(progressStatusAsString()));
        case "totalSourceServers":
            return Optional.ofNullable(clazz.cast(totalSourceServers()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("healthStatus", HEALTH_STATUS_FIELD);
        map.put("lastUpdateDateTime", LAST_UPDATE_DATE_TIME_FIELD);
        map.put("progressStatus", PROGRESS_STATUS_FIELD);
        map.put("totalSourceServers", TOTAL_SOURCE_SERVERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ApplicationAggregatedStatus, T> g) {
        return obj -> g.apply((ApplicationAggregatedStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ApplicationAggregatedStatus> {
        /**
         * <p>
         * Application aggregated status health status.
         * </p>
         * 
         * @param healthStatus
         *        Application aggregated status health status.
         * @see ApplicationHealthStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApplicationHealthStatus
         */
        Builder healthStatus(String healthStatus);

        /**
         * <p>
         * Application aggregated status health status.
         * </p>
         * 
         * @param healthStatus
         *        Application aggregated status health status.
         * @see ApplicationHealthStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApplicationHealthStatus
         */
        Builder healthStatus(ApplicationHealthStatus healthStatus);

        /**
         * <p>
         * Application aggregated status last update dateTime.
         * </p>
         * 
         * @param lastUpdateDateTime
         *        Application aggregated status last update dateTime.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdateDateTime(String lastUpdateDateTime);

        /**
         * <p>
         * Application aggregated status progress status.
         * </p>
         * 
         * @param progressStatus
         *        Application aggregated status progress status.
         * @see ApplicationProgressStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApplicationProgressStatus
         */
        Builder progressStatus(String progressStatus);

        /**
         * <p>
         * Application aggregated status progress status.
         * </p>
         * 
         * @param progressStatus
         *        Application aggregated status progress status.
         * @see ApplicationProgressStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApplicationProgressStatus
         */
        Builder progressStatus(ApplicationProgressStatus progressStatus);

        /**
         * <p>
         * Application aggregated status total source servers amount.
         * </p>
         * 
         * @param totalSourceServers
         *        Application aggregated status total source servers amount.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalSourceServers(Long totalSourceServers);
    }

    static final class BuilderImpl implements Builder {
        private String healthStatus;

        private String lastUpdateDateTime;

        private String progressStatus;

        private Long totalSourceServers;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationAggregatedStatus model) {
            healthStatus(model.healthStatus);
            lastUpdateDateTime(model.lastUpdateDateTime);
            progressStatus(model.progressStatus);
            totalSourceServers(model.totalSourceServers);
        }

        public final String getHealthStatus() {
            return healthStatus;
        }

        public final void setHealthStatus(String healthStatus) {
            this.healthStatus = healthStatus;
        }

        @Override
        public final Builder healthStatus(String healthStatus) {
            this.healthStatus = healthStatus;
            return this;
        }

        @Override
        public final Builder healthStatus(ApplicationHealthStatus healthStatus) {
            this.healthStatus(healthStatus == null ? null : healthStatus.toString());
            return this;
        }

        public final String getLastUpdateDateTime() {
            return lastUpdateDateTime;
        }

        public final void setLastUpdateDateTime(String lastUpdateDateTime) {
            this.lastUpdateDateTime = lastUpdateDateTime;
        }

        @Override
        public final Builder lastUpdateDateTime(String lastUpdateDateTime) {
            this.lastUpdateDateTime = lastUpdateDateTime;
            return this;
        }

        public final String getProgressStatus() {
            return progressStatus;
        }

        public final void setProgressStatus(String progressStatus) {
            this.progressStatus = progressStatus;
        }

        @Override
        public final Builder progressStatus(String progressStatus) {
            this.progressStatus = progressStatus;
            return this;
        }

        @Override
        public final Builder progressStatus(ApplicationProgressStatus progressStatus) {
            this.progressStatus(progressStatus == null ? null : progressStatus.toString());
            return this;
        }

        public final Long getTotalSourceServers() {
            return totalSourceServers;
        }

        public final void setTotalSourceServers(Long totalSourceServers) {
            this.totalSourceServers = totalSourceServers;
        }

        @Override
        public final Builder totalSourceServers(Long totalSourceServers) {
            this.totalSourceServers = totalSourceServers;
            return this;
        }

        @Override
        public ApplicationAggregatedStatus build() {
            return new ApplicationAggregatedStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
