/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mgn.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Request to filter Source Servers list.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeSourceServersRequestFilters implements SdkPojo, Serializable,
        ToCopyableBuilder<DescribeSourceServersRequestFilters.Builder, DescribeSourceServersRequestFilters> {
    private static final SdkField<List<String>> APPLICATION_I_DS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("applicationIDs")
            .getter(getter(DescribeSourceServersRequestFilters::applicationIDs))
            .setter(setter(Builder::applicationIDs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationIDs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> IS_ARCHIVED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isArchived").getter(getter(DescribeSourceServersRequestFilters::isArchived))
            .setter(setter(Builder::isArchived))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isArchived").build()).build();

    private static final SdkField<List<String>> LIFE_CYCLE_STATES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("lifeCycleStates")
            .getter(getter(DescribeSourceServersRequestFilters::lifeCycleStatesAsStrings))
            .setter(setter(Builder::lifeCycleStatesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lifeCycleStates").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> REPLICATION_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("replicationTypes")
            .getter(getter(DescribeSourceServersRequestFilters::replicationTypesAsStrings))
            .setter(setter(Builder::replicationTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicationTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SOURCE_SERVER_I_DS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("sourceServerIDs")
            .getter(getter(DescribeSourceServersRequestFilters::sourceServerIDs))
            .setter(setter(Builder::sourceServerIDs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceServerIDs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_I_DS_FIELD,
            IS_ARCHIVED_FIELD, LIFE_CYCLE_STATES_FIELD, REPLICATION_TYPES_FIELD, SOURCE_SERVER_I_DS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> applicationIDs;

    private final Boolean isArchived;

    private final List<String> lifeCycleStates;

    private final List<String> replicationTypes;

    private final List<String> sourceServerIDs;

    private DescribeSourceServersRequestFilters(BuilderImpl builder) {
        this.applicationIDs = builder.applicationIDs;
        this.isArchived = builder.isArchived;
        this.lifeCycleStates = builder.lifeCycleStates;
        this.replicationTypes = builder.replicationTypes;
        this.sourceServerIDs = builder.sourceServerIDs;
    }

    /**
     * For responses, this returns true if the service returned a value for the ApplicationIDs property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasApplicationIDs() {
        return applicationIDs != null && !(applicationIDs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Request to filter Source Servers list by application IDs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasApplicationIDs} method.
     * </p>
     * 
     * @return Request to filter Source Servers list by application IDs.
     */
    public final List<String> applicationIDs() {
        return applicationIDs;
    }

    /**
     * <p>
     * Request to filter Source Servers list by archived.
     * </p>
     * 
     * @return Request to filter Source Servers list by archived.
     */
    public final Boolean isArchived() {
        return isArchived;
    }

    /**
     * <p>
     * Request to filter Source Servers list by life cycle states.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLifeCycleStates} method.
     * </p>
     * 
     * @return Request to filter Source Servers list by life cycle states.
     */
    public final List<LifeCycleState> lifeCycleStates() {
        return LifeCycleStatesCopier.copyStringToEnum(lifeCycleStates);
    }

    /**
     * For responses, this returns true if the service returned a value for the LifeCycleStates property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasLifeCycleStates() {
        return lifeCycleStates != null && !(lifeCycleStates instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Request to filter Source Servers list by life cycle states.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLifeCycleStates} method.
     * </p>
     * 
     * @return Request to filter Source Servers list by life cycle states.
     */
    public final List<String> lifeCycleStatesAsStrings() {
        return lifeCycleStates;
    }

    /**
     * <p>
     * Request to filter Source Servers list by replication type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReplicationTypes} method.
     * </p>
     * 
     * @return Request to filter Source Servers list by replication type.
     */
    public final List<ReplicationType> replicationTypes() {
        return ReplicationTypesCopier.copyStringToEnum(replicationTypes);
    }

    /**
     * For responses, this returns true if the service returned a value for the ReplicationTypes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasReplicationTypes() {
        return replicationTypes != null && !(replicationTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Request to filter Source Servers list by replication type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReplicationTypes} method.
     * </p>
     * 
     * @return Request to filter Source Servers list by replication type.
     */
    public final List<String> replicationTypesAsStrings() {
        return replicationTypes;
    }

    /**
     * For responses, this returns true if the service returned a value for the SourceServerIDs property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSourceServerIDs() {
        return sourceServerIDs != null && !(sourceServerIDs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Request to filter Source Servers list by Source Server ID.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSourceServerIDs} method.
     * </p>
     * 
     * @return Request to filter Source Servers list by Source Server ID.
     */
    public final List<String> sourceServerIDs() {
        return sourceServerIDs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasApplicationIDs() ? applicationIDs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(isArchived());
        hashCode = 31 * hashCode + Objects.hashCode(hasLifeCycleStates() ? lifeCycleStatesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasReplicationTypes() ? replicationTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSourceServerIDs() ? sourceServerIDs() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSourceServersRequestFilters)) {
            return false;
        }
        DescribeSourceServersRequestFilters other = (DescribeSourceServersRequestFilters) obj;
        return hasApplicationIDs() == other.hasApplicationIDs() && Objects.equals(applicationIDs(), other.applicationIDs())
                && Objects.equals(isArchived(), other.isArchived()) && hasLifeCycleStates() == other.hasLifeCycleStates()
                && Objects.equals(lifeCycleStatesAsStrings(), other.lifeCycleStatesAsStrings())
                && hasReplicationTypes() == other.hasReplicationTypes()
                && Objects.equals(replicationTypesAsStrings(), other.replicationTypesAsStrings())
                && hasSourceServerIDs() == other.hasSourceServerIDs()
                && Objects.equals(sourceServerIDs(), other.sourceServerIDs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeSourceServersRequestFilters")
                .add("ApplicationIDs", hasApplicationIDs() ? applicationIDs() : null).add("IsArchived", isArchived())
                .add("LifeCycleStates", hasLifeCycleStates() ? lifeCycleStatesAsStrings() : null)
                .add("ReplicationTypes", hasReplicationTypes() ? replicationTypesAsStrings() : null)
                .add("SourceServerIDs", hasSourceServerIDs() ? sourceServerIDs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "applicationIDs":
            return Optional.ofNullable(clazz.cast(applicationIDs()));
        case "isArchived":
            return Optional.ofNullable(clazz.cast(isArchived()));
        case "lifeCycleStates":
            return Optional.ofNullable(clazz.cast(lifeCycleStatesAsStrings()));
        case "replicationTypes":
            return Optional.ofNullable(clazz.cast(replicationTypesAsStrings()));
        case "sourceServerIDs":
            return Optional.ofNullable(clazz.cast(sourceServerIDs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("applicationIDs", APPLICATION_I_DS_FIELD);
        map.put("isArchived", IS_ARCHIVED_FIELD);
        map.put("lifeCycleStates", LIFE_CYCLE_STATES_FIELD);
        map.put("replicationTypes", REPLICATION_TYPES_FIELD);
        map.put("sourceServerIDs", SOURCE_SERVER_I_DS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeSourceServersRequestFilters, T> g) {
        return obj -> g.apply((DescribeSourceServersRequestFilters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DescribeSourceServersRequestFilters> {
        /**
         * <p>
         * Request to filter Source Servers list by application IDs.
         * </p>
         * 
         * @param applicationIDs
         *        Request to filter Source Servers list by application IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationIDs(Collection<String> applicationIDs);

        /**
         * <p>
         * Request to filter Source Servers list by application IDs.
         * </p>
         * 
         * @param applicationIDs
         *        Request to filter Source Servers list by application IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationIDs(String... applicationIDs);

        /**
         * <p>
         * Request to filter Source Servers list by archived.
         * </p>
         * 
         * @param isArchived
         *        Request to filter Source Servers list by archived.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isArchived(Boolean isArchived);

        /**
         * <p>
         * Request to filter Source Servers list by life cycle states.
         * </p>
         * 
         * @param lifeCycleStates
         *        Request to filter Source Servers list by life cycle states.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifeCycleStatesWithStrings(Collection<String> lifeCycleStates);

        /**
         * <p>
         * Request to filter Source Servers list by life cycle states.
         * </p>
         * 
         * @param lifeCycleStates
         *        Request to filter Source Servers list by life cycle states.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifeCycleStatesWithStrings(String... lifeCycleStates);

        /**
         * <p>
         * Request to filter Source Servers list by life cycle states.
         * </p>
         * 
         * @param lifeCycleStates
         *        Request to filter Source Servers list by life cycle states.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifeCycleStates(Collection<LifeCycleState> lifeCycleStates);

        /**
         * <p>
         * Request to filter Source Servers list by life cycle states.
         * </p>
         * 
         * @param lifeCycleStates
         *        Request to filter Source Servers list by life cycle states.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifeCycleStates(LifeCycleState... lifeCycleStates);

        /**
         * <p>
         * Request to filter Source Servers list by replication type.
         * </p>
         * 
         * @param replicationTypes
         *        Request to filter Source Servers list by replication type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationTypesWithStrings(Collection<String> replicationTypes);

        /**
         * <p>
         * Request to filter Source Servers list by replication type.
         * </p>
         * 
         * @param replicationTypes
         *        Request to filter Source Servers list by replication type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationTypesWithStrings(String... replicationTypes);

        /**
         * <p>
         * Request to filter Source Servers list by replication type.
         * </p>
         * 
         * @param replicationTypes
         *        Request to filter Source Servers list by replication type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationTypes(Collection<ReplicationType> replicationTypes);

        /**
         * <p>
         * Request to filter Source Servers list by replication type.
         * </p>
         * 
         * @param replicationTypes
         *        Request to filter Source Servers list by replication type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationTypes(ReplicationType... replicationTypes);

        /**
         * <p>
         * Request to filter Source Servers list by Source Server ID.
         * </p>
         * 
         * @param sourceServerIDs
         *        Request to filter Source Servers list by Source Server ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceServerIDs(Collection<String> sourceServerIDs);

        /**
         * <p>
         * Request to filter Source Servers list by Source Server ID.
         * </p>
         * 
         * @param sourceServerIDs
         *        Request to filter Source Servers list by Source Server ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceServerIDs(String... sourceServerIDs);
    }

    static final class BuilderImpl implements Builder {
        private List<String> applicationIDs = DefaultSdkAutoConstructList.getInstance();

        private Boolean isArchived;

        private List<String> lifeCycleStates = DefaultSdkAutoConstructList.getInstance();

        private List<String> replicationTypes = DefaultSdkAutoConstructList.getInstance();

        private List<String> sourceServerIDs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSourceServersRequestFilters model) {
            applicationIDs(model.applicationIDs);
            isArchived(model.isArchived);
            lifeCycleStatesWithStrings(model.lifeCycleStates);
            replicationTypesWithStrings(model.replicationTypes);
            sourceServerIDs(model.sourceServerIDs);
        }

        public final Collection<String> getApplicationIDs() {
            if (applicationIDs instanceof SdkAutoConstructList) {
                return null;
            }
            return applicationIDs;
        }

        public final void setApplicationIDs(Collection<String> applicationIDs) {
            this.applicationIDs = DescribeSourceServersRequestApplicationIDsCopier.copy(applicationIDs);
        }

        @Override
        public final Builder applicationIDs(Collection<String> applicationIDs) {
            this.applicationIDs = DescribeSourceServersRequestApplicationIDsCopier.copy(applicationIDs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applicationIDs(String... applicationIDs) {
            applicationIDs(Arrays.asList(applicationIDs));
            return this;
        }

        public final Boolean getIsArchived() {
            return isArchived;
        }

        public final void setIsArchived(Boolean isArchived) {
            this.isArchived = isArchived;
        }

        @Override
        public final Builder isArchived(Boolean isArchived) {
            this.isArchived = isArchived;
            return this;
        }

        public final Collection<String> getLifeCycleStates() {
            if (lifeCycleStates instanceof SdkAutoConstructList) {
                return null;
            }
            return lifeCycleStates;
        }

        public final void setLifeCycleStates(Collection<String> lifeCycleStates) {
            this.lifeCycleStates = LifeCycleStatesCopier.copy(lifeCycleStates);
        }

        @Override
        public final Builder lifeCycleStatesWithStrings(Collection<String> lifeCycleStates) {
            this.lifeCycleStates = LifeCycleStatesCopier.copy(lifeCycleStates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lifeCycleStatesWithStrings(String... lifeCycleStates) {
            lifeCycleStatesWithStrings(Arrays.asList(lifeCycleStates));
            return this;
        }

        @Override
        public final Builder lifeCycleStates(Collection<LifeCycleState> lifeCycleStates) {
            this.lifeCycleStates = LifeCycleStatesCopier.copyEnumToString(lifeCycleStates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lifeCycleStates(LifeCycleState... lifeCycleStates) {
            lifeCycleStates(Arrays.asList(lifeCycleStates));
            return this;
        }

        public final Collection<String> getReplicationTypes() {
            if (replicationTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return replicationTypes;
        }

        public final void setReplicationTypes(Collection<String> replicationTypes) {
            this.replicationTypes = ReplicationTypesCopier.copy(replicationTypes);
        }

        @Override
        public final Builder replicationTypesWithStrings(Collection<String> replicationTypes) {
            this.replicationTypes = ReplicationTypesCopier.copy(replicationTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationTypesWithStrings(String... replicationTypes) {
            replicationTypesWithStrings(Arrays.asList(replicationTypes));
            return this;
        }

        @Override
        public final Builder replicationTypes(Collection<ReplicationType> replicationTypes) {
            this.replicationTypes = ReplicationTypesCopier.copyEnumToString(replicationTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationTypes(ReplicationType... replicationTypes) {
            replicationTypes(Arrays.asList(replicationTypes));
            return this;
        }

        public final Collection<String> getSourceServerIDs() {
            if (sourceServerIDs instanceof SdkAutoConstructList) {
                return null;
            }
            return sourceServerIDs;
        }

        public final void setSourceServerIDs(Collection<String> sourceServerIDs) {
            this.sourceServerIDs = DescribeSourceServersRequestFiltersIDsCopier.copy(sourceServerIDs);
        }

        @Override
        public final Builder sourceServerIDs(Collection<String> sourceServerIDs) {
            this.sourceServerIDs = DescribeSourceServersRequestFiltersIDsCopier.copy(sourceServerIDs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceServerIDs(String... sourceServerIDs) {
            sourceServerIDs(Arrays.asList(sourceServerIDs));
            return this;
        }

        @Override
        public DescribeSourceServersRequestFilters build() {
            return new DescribeSourceServersRequestFilters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
