/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mgn.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Export task error.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExportTaskError implements SdkPojo, Serializable, ToCopyableBuilder<ExportTaskError.Builder, ExportTaskError> {
    private static final SdkField<ExportErrorData> ERROR_DATA_FIELD = SdkField
            .<ExportErrorData> builder(MarshallingType.SDK_POJO).memberName("errorData")
            .getter(getter(ExportTaskError::errorData)).setter(setter(Builder::errorData)).constructor(ExportErrorData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorData").build()).build();

    private static final SdkField<String> ERROR_DATE_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("errorDateTime").getter(getter(ExportTaskError::errorDateTime)).setter(setter(Builder::errorDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorDateTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERROR_DATA_FIELD,
            ERROR_DATE_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ExportErrorData errorData;

    private final String errorDateTime;

    private ExportTaskError(BuilderImpl builder) {
        this.errorData = builder.errorData;
        this.errorDateTime = builder.errorDateTime;
    }

    /**
     * <p>
     * Export task error data.
     * </p>
     * 
     * @return Export task error data.
     */
    public final ExportErrorData errorData() {
        return errorData;
    }

    /**
     * <p>
     * Export task error datetime.
     * </p>
     * 
     * @return Export task error datetime.
     */
    public final String errorDateTime() {
        return errorDateTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(errorData());
        hashCode = 31 * hashCode + Objects.hashCode(errorDateTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportTaskError)) {
            return false;
        }
        ExportTaskError other = (ExportTaskError) obj;
        return Objects.equals(errorData(), other.errorData()) && Objects.equals(errorDateTime(), other.errorDateTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExportTaskError").add("ErrorData", errorData()).add("ErrorDateTime", errorDateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "errorData":
            return Optional.ofNullable(clazz.cast(errorData()));
        case "errorDateTime":
            return Optional.ofNullable(clazz.cast(errorDateTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("errorData", ERROR_DATA_FIELD);
        map.put("errorDateTime", ERROR_DATE_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExportTaskError, T> g) {
        return obj -> g.apply((ExportTaskError) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExportTaskError> {
        /**
         * <p>
         * Export task error data.
         * </p>
         * 
         * @param errorData
         *        Export task error data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorData(ExportErrorData errorData);

        /**
         * <p>
         * Export task error data.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExportErrorData.Builder} avoiding the
         * need to create one manually via {@link ExportErrorData#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExportErrorData.Builder#build()} is called immediately and its
         * result is passed to {@link #errorData(ExportErrorData)}.
         * 
         * @param errorData
         *        a consumer that will call methods on {@link ExportErrorData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errorData(ExportErrorData)
         */
        default Builder errorData(Consumer<ExportErrorData.Builder> errorData) {
            return errorData(ExportErrorData.builder().applyMutation(errorData).build());
        }

        /**
         * <p>
         * Export task error datetime.
         * </p>
         * 
         * @param errorDateTime
         *        Export task error datetime.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorDateTime(String errorDateTime);
    }

    static final class BuilderImpl implements Builder {
        private ExportErrorData errorData;

        private String errorDateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportTaskError model) {
            errorData(model.errorData);
            errorDateTime(model.errorDateTime);
        }

        public final ExportErrorData.Builder getErrorData() {
            return errorData != null ? errorData.toBuilder() : null;
        }

        public final void setErrorData(ExportErrorData.BuilderImpl errorData) {
            this.errorData = errorData != null ? errorData.build() : null;
        }

        @Override
        public final Builder errorData(ExportErrorData errorData) {
            this.errorData = errorData;
            return this;
        }

        public final String getErrorDateTime() {
            return errorDateTime;
        }

        public final void setErrorDateTime(String errorDateTime) {
            this.errorDateTime = errorDateTime;
        }

        @Override
        public final Builder errorDateTime(String errorDateTime) {
            this.errorDateTime = errorDateTime;
            return this;
        }

        @Override
        public ExportTaskError build() {
            return new ExportTaskError(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
