/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mgn.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Import task summery waves.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImportTaskSummaryWaves implements SdkPojo, Serializable,
        ToCopyableBuilder<ImportTaskSummaryWaves.Builder, ImportTaskSummaryWaves> {
    private static final SdkField<Long> CREATED_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("createdCount").getter(getter(ImportTaskSummaryWaves::createdCount))
            .setter(setter(Builder::createdCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdCount").build()).build();

    private static final SdkField<Long> MODIFIED_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("modifiedCount").getter(getter(ImportTaskSummaryWaves::modifiedCount))
            .setter(setter(Builder::modifiedCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modifiedCount").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_COUNT_FIELD,
            MODIFIED_COUNT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Long createdCount;

    private final Long modifiedCount;

    private ImportTaskSummaryWaves(BuilderImpl builder) {
        this.createdCount = builder.createdCount;
        this.modifiedCount = builder.modifiedCount;
    }

    /**
     * <p>
     * Import task summery waves created count.
     * </p>
     * 
     * @return Import task summery waves created count.
     */
    public final Long createdCount() {
        return createdCount;
    }

    /**
     * <p>
     * Import task summery waves modified count.
     * </p>
     * 
     * @return Import task summery waves modified count.
     */
    public final Long modifiedCount() {
        return modifiedCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(createdCount());
        hashCode = 31 * hashCode + Objects.hashCode(modifiedCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportTaskSummaryWaves)) {
            return false;
        }
        ImportTaskSummaryWaves other = (ImportTaskSummaryWaves) obj;
        return Objects.equals(createdCount(), other.createdCount()) && Objects.equals(modifiedCount(), other.modifiedCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ImportTaskSummaryWaves").add("CreatedCount", createdCount())
                .add("ModifiedCount", modifiedCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "createdCount":
            return Optional.ofNullable(clazz.cast(createdCount()));
        case "modifiedCount":
            return Optional.ofNullable(clazz.cast(modifiedCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("createdCount", CREATED_COUNT_FIELD);
        map.put("modifiedCount", MODIFIED_COUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ImportTaskSummaryWaves, T> g) {
        return obj -> g.apply((ImportTaskSummaryWaves) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ImportTaskSummaryWaves> {
        /**
         * <p>
         * Import task summery waves created count.
         * </p>
         * 
         * @param createdCount
         *        Import task summery waves created count.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdCount(Long createdCount);

        /**
         * <p>
         * Import task summery waves modified count.
         * </p>
         * 
         * @param modifiedCount
         *        Import task summery waves modified count.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modifiedCount(Long modifiedCount);
    }

    static final class BuilderImpl implements Builder {
        private Long createdCount;

        private Long modifiedCount;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportTaskSummaryWaves model) {
            createdCount(model.createdCount);
            modifiedCount(model.modifiedCount);
        }

        public final Long getCreatedCount() {
            return createdCount;
        }

        public final void setCreatedCount(Long createdCount) {
            this.createdCount = createdCount;
        }

        @Override
        public final Builder createdCount(Long createdCount) {
            this.createdCount = createdCount;
            return this;
        }

        public final Long getModifiedCount() {
            return modifiedCount;
        }

        public final void setModifiedCount(Long modifiedCount) {
            this.modifiedCount = modifiedCount;
        }

        @Override
        public final Builder modifiedCount(Long modifiedCount) {
            this.modifiedCount = modifiedCount;
            return this;
        }

        @Override
        public ImportTaskSummaryWaves build() {
            return new ImportTaskSummaryWaves(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
