/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mgn.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Launch Status of the Job Post Launch Actions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class JobPostLaunchActionsLaunchStatus implements SdkPojo, Serializable,
        ToCopyableBuilder<JobPostLaunchActionsLaunchStatus.Builder, JobPostLaunchActionsLaunchStatus> {
    private static final SdkField<String> EXECUTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("executionID").getter(getter(JobPostLaunchActionsLaunchStatus::executionID))
            .setter(setter(Builder::executionID))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionID").build()).build();

    private static final SdkField<String> EXECUTION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("executionStatus").getter(getter(JobPostLaunchActionsLaunchStatus::executionStatusAsString))
            .setter(setter(Builder::executionStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionStatus").build()).build();

    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("failureReason").getter(getter(JobPostLaunchActionsLaunchStatus::failureReason))
            .setter(setter(Builder::failureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureReason").build()).build();

    private static final SdkField<SsmDocument> SSM_DOCUMENT_FIELD = SdkField.<SsmDocument> builder(MarshallingType.SDK_POJO)
            .memberName("ssmDocument").getter(getter(JobPostLaunchActionsLaunchStatus::ssmDocument))
            .setter(setter(Builder::ssmDocument)).constructor(SsmDocument::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ssmDocument").build()).build();

    private static final SdkField<String> SSM_DOCUMENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ssmDocumentType").getter(getter(JobPostLaunchActionsLaunchStatus::ssmDocumentTypeAsString))
            .setter(setter(Builder::ssmDocumentType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ssmDocumentType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXECUTION_ID_FIELD,
            EXECUTION_STATUS_FIELD, FAILURE_REASON_FIELD, SSM_DOCUMENT_FIELD, SSM_DOCUMENT_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String executionID;

    private final String executionStatus;

    private final String failureReason;

    private final SsmDocument ssmDocument;

    private final String ssmDocumentType;

    private JobPostLaunchActionsLaunchStatus(BuilderImpl builder) {
        this.executionID = builder.executionID;
        this.executionStatus = builder.executionStatus;
        this.failureReason = builder.failureReason;
        this.ssmDocument = builder.ssmDocument;
        this.ssmDocumentType = builder.ssmDocumentType;
    }

    /**
     * <p>
     * AWS Systems Manager Document's execution ID of the of the Job Post Launch Actions.
     * </p>
     * 
     * @return AWS Systems Manager Document's execution ID of the of the Job Post Launch Actions.
     */
    public final String executionID() {
        return executionID;
    }

    /**
     * <p>
     * AWS Systems Manager Document's execution status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #executionStatus}
     * will return {@link PostLaunchActionExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #executionStatusAsString}.
     * </p>
     * 
     * @return AWS Systems Manager Document's execution status.
     * @see PostLaunchActionExecutionStatus
     */
    public final PostLaunchActionExecutionStatus executionStatus() {
        return PostLaunchActionExecutionStatus.fromValue(executionStatus);
    }

    /**
     * <p>
     * AWS Systems Manager Document's execution status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #executionStatus}
     * will return {@link PostLaunchActionExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #executionStatusAsString}.
     * </p>
     * 
     * @return AWS Systems Manager Document's execution status.
     * @see PostLaunchActionExecutionStatus
     */
    public final String executionStatusAsString() {
        return executionStatus;
    }

    /**
     * <p>
     * AWS Systems Manager Document's failure reason.
     * </p>
     * 
     * @return AWS Systems Manager Document's failure reason.
     */
    public final String failureReason() {
        return failureReason;
    }

    /**
     * <p>
     * AWS Systems Manager's Document of the of the Job Post Launch Actions.
     * </p>
     * 
     * @return AWS Systems Manager's Document of the of the Job Post Launch Actions.
     */
    public final SsmDocument ssmDocument() {
        return ssmDocument;
    }

    /**
     * <p>
     * AWS Systems Manager Document type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ssmDocumentType}
     * will return {@link SsmDocumentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #ssmDocumentTypeAsString}.
     * </p>
     * 
     * @return AWS Systems Manager Document type.
     * @see SsmDocumentType
     */
    public final SsmDocumentType ssmDocumentType() {
        return SsmDocumentType.fromValue(ssmDocumentType);
    }

    /**
     * <p>
     * AWS Systems Manager Document type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ssmDocumentType}
     * will return {@link SsmDocumentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #ssmDocumentTypeAsString}.
     * </p>
     * 
     * @return AWS Systems Manager Document type.
     * @see SsmDocumentType
     */
    public final String ssmDocumentTypeAsString() {
        return ssmDocumentType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(executionID());
        hashCode = 31 * hashCode + Objects.hashCode(executionStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(ssmDocument());
        hashCode = 31 * hashCode + Objects.hashCode(ssmDocumentTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobPostLaunchActionsLaunchStatus)) {
            return false;
        }
        JobPostLaunchActionsLaunchStatus other = (JobPostLaunchActionsLaunchStatus) obj;
        return Objects.equals(executionID(), other.executionID())
                && Objects.equals(executionStatusAsString(), other.executionStatusAsString())
                && Objects.equals(failureReason(), other.failureReason()) && Objects.equals(ssmDocument(), other.ssmDocument())
                && Objects.equals(ssmDocumentTypeAsString(), other.ssmDocumentTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("JobPostLaunchActionsLaunchStatus").add("ExecutionID", executionID())
                .add("ExecutionStatus", executionStatusAsString()).add("FailureReason", failureReason())
                .add("SsmDocument", ssmDocument()).add("SsmDocumentType", ssmDocumentTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "executionID":
            return Optional.ofNullable(clazz.cast(executionID()));
        case "executionStatus":
            return Optional.ofNullable(clazz.cast(executionStatusAsString()));
        case "failureReason":
            return Optional.ofNullable(clazz.cast(failureReason()));
        case "ssmDocument":
            return Optional.ofNullable(clazz.cast(ssmDocument()));
        case "ssmDocumentType":
            return Optional.ofNullable(clazz.cast(ssmDocumentTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("executionID", EXECUTION_ID_FIELD);
        map.put("executionStatus", EXECUTION_STATUS_FIELD);
        map.put("failureReason", FAILURE_REASON_FIELD);
        map.put("ssmDocument", SSM_DOCUMENT_FIELD);
        map.put("ssmDocumentType", SSM_DOCUMENT_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<JobPostLaunchActionsLaunchStatus, T> g) {
        return obj -> g.apply((JobPostLaunchActionsLaunchStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, JobPostLaunchActionsLaunchStatus> {
        /**
         * <p>
         * AWS Systems Manager Document's execution ID of the of the Job Post Launch Actions.
         * </p>
         * 
         * @param executionID
         *        AWS Systems Manager Document's execution ID of the of the Job Post Launch Actions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionID(String executionID);

        /**
         * <p>
         * AWS Systems Manager Document's execution status.
         * </p>
         * 
         * @param executionStatus
         *        AWS Systems Manager Document's execution status.
         * @see PostLaunchActionExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PostLaunchActionExecutionStatus
         */
        Builder executionStatus(String executionStatus);

        /**
         * <p>
         * AWS Systems Manager Document's execution status.
         * </p>
         * 
         * @param executionStatus
         *        AWS Systems Manager Document's execution status.
         * @see PostLaunchActionExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PostLaunchActionExecutionStatus
         */
        Builder executionStatus(PostLaunchActionExecutionStatus executionStatus);

        /**
         * <p>
         * AWS Systems Manager Document's failure reason.
         * </p>
         * 
         * @param failureReason
         *        AWS Systems Manager Document's failure reason.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(String failureReason);

        /**
         * <p>
         * AWS Systems Manager's Document of the of the Job Post Launch Actions.
         * </p>
         * 
         * @param ssmDocument
         *        AWS Systems Manager's Document of the of the Job Post Launch Actions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ssmDocument(SsmDocument ssmDocument);

        /**
         * <p>
         * AWS Systems Manager's Document of the of the Job Post Launch Actions.
         * </p>
         * This is a convenience method that creates an instance of the {@link SsmDocument.Builder} avoiding the need to
         * create one manually via {@link SsmDocument#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SsmDocument.Builder#build()} is called immediately and its result
         * is passed to {@link #ssmDocument(SsmDocument)}.
         * 
         * @param ssmDocument
         *        a consumer that will call methods on {@link SsmDocument.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ssmDocument(SsmDocument)
         */
        default Builder ssmDocument(Consumer<SsmDocument.Builder> ssmDocument) {
            return ssmDocument(SsmDocument.builder().applyMutation(ssmDocument).build());
        }

        /**
         * <p>
         * AWS Systems Manager Document type.
         * </p>
         * 
         * @param ssmDocumentType
         *        AWS Systems Manager Document type.
         * @see SsmDocumentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SsmDocumentType
         */
        Builder ssmDocumentType(String ssmDocumentType);

        /**
         * <p>
         * AWS Systems Manager Document type.
         * </p>
         * 
         * @param ssmDocumentType
         *        AWS Systems Manager Document type.
         * @see SsmDocumentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SsmDocumentType
         */
        Builder ssmDocumentType(SsmDocumentType ssmDocumentType);
    }

    static final class BuilderImpl implements Builder {
        private String executionID;

        private String executionStatus;

        private String failureReason;

        private SsmDocument ssmDocument;

        private String ssmDocumentType;

        private BuilderImpl() {
        }

        private BuilderImpl(JobPostLaunchActionsLaunchStatus model) {
            executionID(model.executionID);
            executionStatus(model.executionStatus);
            failureReason(model.failureReason);
            ssmDocument(model.ssmDocument);
            ssmDocumentType(model.ssmDocumentType);
        }

        public final String getExecutionID() {
            return executionID;
        }

        public final void setExecutionID(String executionID) {
            this.executionID = executionID;
        }

        @Override
        public final Builder executionID(String executionID) {
            this.executionID = executionID;
            return this;
        }

        public final String getExecutionStatus() {
            return executionStatus;
        }

        public final void setExecutionStatus(String executionStatus) {
            this.executionStatus = executionStatus;
        }

        @Override
        public final Builder executionStatus(String executionStatus) {
            this.executionStatus = executionStatus;
            return this;
        }

        @Override
        public final Builder executionStatus(PostLaunchActionExecutionStatus executionStatus) {
            this.executionStatus(executionStatus == null ? null : executionStatus.toString());
            return this;
        }

        public final String getFailureReason() {
            return failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final SsmDocument.Builder getSsmDocument() {
            return ssmDocument != null ? ssmDocument.toBuilder() : null;
        }

        public final void setSsmDocument(SsmDocument.BuilderImpl ssmDocument) {
            this.ssmDocument = ssmDocument != null ? ssmDocument.build() : null;
        }

        @Override
        public final Builder ssmDocument(SsmDocument ssmDocument) {
            this.ssmDocument = ssmDocument;
            return this;
        }

        public final String getSsmDocumentType() {
            return ssmDocumentType;
        }

        public final void setSsmDocumentType(String ssmDocumentType) {
            this.ssmDocumentType = ssmDocumentType;
        }

        @Override
        public final Builder ssmDocumentType(String ssmDocumentType) {
            this.ssmDocumentType = ssmDocumentType;
            return this;
        }

        @Override
        public final Builder ssmDocumentType(SsmDocumentType ssmDocumentType) {
            this.ssmDocumentType(ssmDocumentType == null ? null : ssmDocumentType.toString());
            return this;
        }

        @Override
        public JobPostLaunchActionsLaunchStatus build() {
            return new JobPostLaunchActionsLaunchStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
