/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mgn.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Lifecycle last Test.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LifeCycleLastTest implements SdkPojo, Serializable,
        ToCopyableBuilder<LifeCycleLastTest.Builder, LifeCycleLastTest> {
    private static final SdkField<LifeCycleLastTestFinalized> FINALIZED_FIELD = SdkField
            .<LifeCycleLastTestFinalized> builder(MarshallingType.SDK_POJO).memberName("finalized")
            .getter(getter(LifeCycleLastTest::finalized)).setter(setter(Builder::finalized))
            .constructor(LifeCycleLastTestFinalized::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("finalized").build()).build();

    private static final SdkField<LifeCycleLastTestInitiated> INITIATED_FIELD = SdkField
            .<LifeCycleLastTestInitiated> builder(MarshallingType.SDK_POJO).memberName("initiated")
            .getter(getter(LifeCycleLastTest::initiated)).setter(setter(Builder::initiated))
            .constructor(LifeCycleLastTestInitiated::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("initiated").build()).build();

    private static final SdkField<LifeCycleLastTestReverted> REVERTED_FIELD = SdkField
            .<LifeCycleLastTestReverted> builder(MarshallingType.SDK_POJO).memberName("reverted")
            .getter(getter(LifeCycleLastTest::reverted)).setter(setter(Builder::reverted))
            .constructor(LifeCycleLastTestReverted::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reverted").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FINALIZED_FIELD,
            INITIATED_FIELD, REVERTED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final LifeCycleLastTestFinalized finalized;

    private final LifeCycleLastTestInitiated initiated;

    private final LifeCycleLastTestReverted reverted;

    private LifeCycleLastTest(BuilderImpl builder) {
        this.finalized = builder.finalized;
        this.initiated = builder.initiated;
        this.reverted = builder.reverted;
    }

    /**
     * <p>
     * Lifecycle last Test finalized.
     * </p>
     * 
     * @return Lifecycle last Test finalized.
     */
    public final LifeCycleLastTestFinalized finalized() {
        return finalized;
    }

    /**
     * <p>
     * Lifecycle last Test initiated.
     * </p>
     * 
     * @return Lifecycle last Test initiated.
     */
    public final LifeCycleLastTestInitiated initiated() {
        return initiated;
    }

    /**
     * <p>
     * Lifecycle last Test reverted.
     * </p>
     * 
     * @return Lifecycle last Test reverted.
     */
    public final LifeCycleLastTestReverted reverted() {
        return reverted;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(finalized());
        hashCode = 31 * hashCode + Objects.hashCode(initiated());
        hashCode = 31 * hashCode + Objects.hashCode(reverted());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LifeCycleLastTest)) {
            return false;
        }
        LifeCycleLastTest other = (LifeCycleLastTest) obj;
        return Objects.equals(finalized(), other.finalized()) && Objects.equals(initiated(), other.initiated())
                && Objects.equals(reverted(), other.reverted());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LifeCycleLastTest").add("Finalized", finalized()).add("Initiated", initiated())
                .add("Reverted", reverted()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "finalized":
            return Optional.ofNullable(clazz.cast(finalized()));
        case "initiated":
            return Optional.ofNullable(clazz.cast(initiated()));
        case "reverted":
            return Optional.ofNullable(clazz.cast(reverted()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("finalized", FINALIZED_FIELD);
        map.put("initiated", INITIATED_FIELD);
        map.put("reverted", REVERTED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LifeCycleLastTest, T> g) {
        return obj -> g.apply((LifeCycleLastTest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LifeCycleLastTest> {
        /**
         * <p>
         * Lifecycle last Test finalized.
         * </p>
         * 
         * @param finalized
         *        Lifecycle last Test finalized.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder finalized(LifeCycleLastTestFinalized finalized);

        /**
         * <p>
         * Lifecycle last Test finalized.
         * </p>
         * This is a convenience method that creates an instance of the {@link LifeCycleLastTestFinalized.Builder}
         * avoiding the need to create one manually via {@link LifeCycleLastTestFinalized#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LifeCycleLastTestFinalized.Builder#build()} is called immediately
         * and its result is passed to {@link #finalized(LifeCycleLastTestFinalized)}.
         * 
         * @param finalized
         *        a consumer that will call methods on {@link LifeCycleLastTestFinalized.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #finalized(LifeCycleLastTestFinalized)
         */
        default Builder finalized(Consumer<LifeCycleLastTestFinalized.Builder> finalized) {
            return finalized(LifeCycleLastTestFinalized.builder().applyMutation(finalized).build());
        }

        /**
         * <p>
         * Lifecycle last Test initiated.
         * </p>
         * 
         * @param initiated
         *        Lifecycle last Test initiated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder initiated(LifeCycleLastTestInitiated initiated);

        /**
         * <p>
         * Lifecycle last Test initiated.
         * </p>
         * This is a convenience method that creates an instance of the {@link LifeCycleLastTestInitiated.Builder}
         * avoiding the need to create one manually via {@link LifeCycleLastTestInitiated#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LifeCycleLastTestInitiated.Builder#build()} is called immediately
         * and its result is passed to {@link #initiated(LifeCycleLastTestInitiated)}.
         * 
         * @param initiated
         *        a consumer that will call methods on {@link LifeCycleLastTestInitiated.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #initiated(LifeCycleLastTestInitiated)
         */
        default Builder initiated(Consumer<LifeCycleLastTestInitiated.Builder> initiated) {
            return initiated(LifeCycleLastTestInitiated.builder().applyMutation(initiated).build());
        }

        /**
         * <p>
         * Lifecycle last Test reverted.
         * </p>
         * 
         * @param reverted
         *        Lifecycle last Test reverted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reverted(LifeCycleLastTestReverted reverted);

        /**
         * <p>
         * Lifecycle last Test reverted.
         * </p>
         * This is a convenience method that creates an instance of the {@link LifeCycleLastTestReverted.Builder}
         * avoiding the need to create one manually via {@link LifeCycleLastTestReverted#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LifeCycleLastTestReverted.Builder#build()} is called immediately
         * and its result is passed to {@link #reverted(LifeCycleLastTestReverted)}.
         * 
         * @param reverted
         *        a consumer that will call methods on {@link LifeCycleLastTestReverted.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #reverted(LifeCycleLastTestReverted)
         */
        default Builder reverted(Consumer<LifeCycleLastTestReverted.Builder> reverted) {
            return reverted(LifeCycleLastTestReverted.builder().applyMutation(reverted).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private LifeCycleLastTestFinalized finalized;

        private LifeCycleLastTestInitiated initiated;

        private LifeCycleLastTestReverted reverted;

        private BuilderImpl() {
        }

        private BuilderImpl(LifeCycleLastTest model) {
            finalized(model.finalized);
            initiated(model.initiated);
            reverted(model.reverted);
        }

        public final LifeCycleLastTestFinalized.Builder getFinalized() {
            return finalized != null ? finalized.toBuilder() : null;
        }

        public final void setFinalized(LifeCycleLastTestFinalized.BuilderImpl finalized) {
            this.finalized = finalized != null ? finalized.build() : null;
        }

        @Override
        public final Builder finalized(LifeCycleLastTestFinalized finalized) {
            this.finalized = finalized;
            return this;
        }

        public final LifeCycleLastTestInitiated.Builder getInitiated() {
            return initiated != null ? initiated.toBuilder() : null;
        }

        public final void setInitiated(LifeCycleLastTestInitiated.BuilderImpl initiated) {
            this.initiated = initiated != null ? initiated.build() : null;
        }

        @Override
        public final Builder initiated(LifeCycleLastTestInitiated initiated) {
            this.initiated = initiated;
            return this;
        }

        public final LifeCycleLastTestReverted.Builder getReverted() {
            return reverted != null ? reverted.toBuilder() : null;
        }

        public final void setReverted(LifeCycleLastTestReverted.BuilderImpl reverted) {
            this.reverted = reverted != null ? reverted.build() : null;
        }

        @Override
        public final Builder reverted(LifeCycleLastTestReverted reverted) {
            this.reverted = reverted;
            return this;
        }

        @Override
        public LifeCycleLastTest build() {
            return new LifeCycleLastTest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
