/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mgn.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Waves list filters.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListWavesRequestFilters implements SdkPojo, Serializable,
        ToCopyableBuilder<ListWavesRequestFilters.Builder, ListWavesRequestFilters> {
    private static final SdkField<Boolean> IS_ARCHIVED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isArchived").getter(getter(ListWavesRequestFilters::isArchived)).setter(setter(Builder::isArchived))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isArchived").build()).build();

    private static final SdkField<List<String>> WAVE_I_DS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("waveIDs")
            .getter(getter(ListWavesRequestFilters::waveIDs))
            .setter(setter(Builder::waveIDs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("waveIDs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IS_ARCHIVED_FIELD,
            WAVE_I_DS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean isArchived;

    private final List<String> waveIDs;

    private ListWavesRequestFilters(BuilderImpl builder) {
        this.isArchived = builder.isArchived;
        this.waveIDs = builder.waveIDs;
    }

    /**
     * <p>
     * Filter waves list by archival status.
     * </p>
     * 
     * @return Filter waves list by archival status.
     */
    public final Boolean isArchived() {
        return isArchived;
    }

    /**
     * For responses, this returns true if the service returned a value for the WaveIDs property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasWaveIDs() {
        return waveIDs != null && !(waveIDs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Filter waves list by wave ID.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasWaveIDs} method.
     * </p>
     * 
     * @return Filter waves list by wave ID.
     */
    public final List<String> waveIDs() {
        return waveIDs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(isArchived());
        hashCode = 31 * hashCode + Objects.hashCode(hasWaveIDs() ? waveIDs() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListWavesRequestFilters)) {
            return false;
        }
        ListWavesRequestFilters other = (ListWavesRequestFilters) obj;
        return Objects.equals(isArchived(), other.isArchived()) && hasWaveIDs() == other.hasWaveIDs()
                && Objects.equals(waveIDs(), other.waveIDs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListWavesRequestFilters").add("IsArchived", isArchived())
                .add("WaveIDs", hasWaveIDs() ? waveIDs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "isArchived":
            return Optional.ofNullable(clazz.cast(isArchived()));
        case "waveIDs":
            return Optional.ofNullable(clazz.cast(waveIDs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("isArchived", IS_ARCHIVED_FIELD);
        map.put("waveIDs", WAVE_I_DS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListWavesRequestFilters, T> g) {
        return obj -> g.apply((ListWavesRequestFilters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ListWavesRequestFilters> {
        /**
         * <p>
         * Filter waves list by archival status.
         * </p>
         * 
         * @param isArchived
         *        Filter waves list by archival status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isArchived(Boolean isArchived);

        /**
         * <p>
         * Filter waves list by wave ID.
         * </p>
         * 
         * @param waveIDs
         *        Filter waves list by wave ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder waveIDs(Collection<String> waveIDs);

        /**
         * <p>
         * Filter waves list by wave ID.
         * </p>
         * 
         * @param waveIDs
         *        Filter waves list by wave ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder waveIDs(String... waveIDs);
    }

    static final class BuilderImpl implements Builder {
        private Boolean isArchived;

        private List<String> waveIDs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListWavesRequestFilters model) {
            isArchived(model.isArchived);
            waveIDs(model.waveIDs);
        }

        public final Boolean getIsArchived() {
            return isArchived;
        }

        public final void setIsArchived(Boolean isArchived) {
            this.isArchived = isArchived;
        }

        @Override
        public final Builder isArchived(Boolean isArchived) {
            this.isArchived = isArchived;
            return this;
        }

        public final Collection<String> getWaveIDs() {
            if (waveIDs instanceof SdkAutoConstructList) {
                return null;
            }
            return waveIDs;
        }

        public final void setWaveIDs(Collection<String> waveIDs) {
            this.waveIDs = WaveIDsFilterCopier.copy(waveIDs);
        }

        @Override
        public final Builder waveIDs(Collection<String> waveIDs) {
            this.waveIDs = WaveIDsFilterCopier.copy(waveIDs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder waveIDs(String... waveIDs) {
            waveIDs(Arrays.asList(waveIDs));
            return this;
        }

        @Override
        public ListWavesRequestFilters build() {
            return new ListWavesRequestFilters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
