/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mgn.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Network interface.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NetworkInterface implements SdkPojo, Serializable,
        ToCopyableBuilder<NetworkInterface.Builder, NetworkInterface> {
    private static final SdkField<List<String>> IPS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ips")
            .getter(getter(NetworkInterface::ips))
            .setter(setter(Builder::ips))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ips").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> IS_PRIMARY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isPrimary").getter(getter(NetworkInterface::isPrimary)).setter(setter(Builder::isPrimary))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isPrimary").build()).build();

    private static final SdkField<String> MAC_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("macAddress").getter(getter(NetworkInterface::macAddress)).setter(setter(Builder::macAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("macAddress").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IPS_FIELD, IS_PRIMARY_FIELD,
            MAC_ADDRESS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> ips;

    private final Boolean isPrimary;

    private final String macAddress;

    private NetworkInterface(BuilderImpl builder) {
        this.ips = builder.ips;
        this.isPrimary = builder.isPrimary;
        this.macAddress = builder.macAddress;
    }

    /**
     * For responses, this returns true if the service returned a value for the Ips property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasIps() {
        return ips != null && !(ips instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Network interface IPs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIps} method.
     * </p>
     * 
     * @return Network interface IPs.
     */
    public final List<String> ips() {
        return ips;
    }

    /**
     * <p>
     * Network interface primary IP.
     * </p>
     * 
     * @return Network interface primary IP.
     */
    public final Boolean isPrimary() {
        return isPrimary;
    }

    /**
     * <p>
     * Network interface Mac address.
     * </p>
     * 
     * @return Network interface Mac address.
     */
    public final String macAddress() {
        return macAddress;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasIps() ? ips() : null);
        hashCode = 31 * hashCode + Objects.hashCode(isPrimary());
        hashCode = 31 * hashCode + Objects.hashCode(macAddress());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkInterface)) {
            return false;
        }
        NetworkInterface other = (NetworkInterface) obj;
        return hasIps() == other.hasIps() && Objects.equals(ips(), other.ips()) && Objects.equals(isPrimary(), other.isPrimary())
                && Objects.equals(macAddress(), other.macAddress());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NetworkInterface").add("Ips", hasIps() ? ips() : null).add("IsPrimary", isPrimary())
                .add("MacAddress", macAddress()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ips":
            return Optional.ofNullable(clazz.cast(ips()));
        case "isPrimary":
            return Optional.ofNullable(clazz.cast(isPrimary()));
        case "macAddress":
            return Optional.ofNullable(clazz.cast(macAddress()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ips", IPS_FIELD);
        map.put("isPrimary", IS_PRIMARY_FIELD);
        map.put("macAddress", MAC_ADDRESS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NetworkInterface, T> g) {
        return obj -> g.apply((NetworkInterface) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NetworkInterface> {
        /**
         * <p>
         * Network interface IPs.
         * </p>
         * 
         * @param ips
         *        Network interface IPs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ips(Collection<String> ips);

        /**
         * <p>
         * Network interface IPs.
         * </p>
         * 
         * @param ips
         *        Network interface IPs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ips(String... ips);

        /**
         * <p>
         * Network interface primary IP.
         * </p>
         * 
         * @param isPrimary
         *        Network interface primary IP.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isPrimary(Boolean isPrimary);

        /**
         * <p>
         * Network interface Mac address.
         * </p>
         * 
         * @param macAddress
         *        Network interface Mac address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder macAddress(String macAddress);
    }

    static final class BuilderImpl implements Builder {
        private List<String> ips = DefaultSdkAutoConstructList.getInstance();

        private Boolean isPrimary;

        private String macAddress;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkInterface model) {
            ips(model.ips);
            isPrimary(model.isPrimary);
            macAddress(model.macAddress);
        }

        public final Collection<String> getIps() {
            if (ips instanceof SdkAutoConstructList) {
                return null;
            }
            return ips;
        }

        public final void setIps(Collection<String> ips) {
            this.ips = IPsListCopier.copy(ips);
        }

        @Override
        public final Builder ips(Collection<String> ips) {
            this.ips = IPsListCopier.copy(ips);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ips(String... ips) {
            ips(Arrays.asList(ips));
            return this;
        }

        public final Boolean getIsPrimary() {
            return isPrimary;
        }

        public final void setIsPrimary(Boolean isPrimary) {
            this.isPrimary = isPrimary;
        }

        @Override
        public final Builder isPrimary(Boolean isPrimary) {
            this.isPrimary = isPrimary;
            return this;
        }

        public final String getMacAddress() {
            return macAddress;
        }

        public final void setMacAddress(String macAddress) {
            this.macAddress = macAddress;
        }

        @Override
        public final Builder macAddress(String macAddress) {
            this.macAddress = macAddress;
            return this;
        }

        @Override
        public NetworkInterface build() {
            return new NetworkInterface(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
