/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mgn.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Replication Configuration replicated disk.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReplicationConfigurationReplicatedDisk implements SdkPojo, Serializable,
        ToCopyableBuilder<ReplicationConfigurationReplicatedDisk.Builder, ReplicationConfigurationReplicatedDisk> {
    private static final SdkField<String> DEVICE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("deviceName").getter(getter(ReplicationConfigurationReplicatedDisk::deviceName))
            .setter(setter(Builder::deviceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceName").build()).build();

    private static final SdkField<Long> IOPS_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("iops")
            .getter(getter(ReplicationConfigurationReplicatedDisk::iops)).setter(setter(Builder::iops))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iops").build()).build();

    private static final SdkField<Boolean> IS_BOOT_DISK_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isBootDisk").getter(getter(ReplicationConfigurationReplicatedDisk::isBootDisk))
            .setter(setter(Builder::isBootDisk))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isBootDisk").build()).build();

    private static final SdkField<String> STAGING_DISK_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("stagingDiskType").getter(getter(ReplicationConfigurationReplicatedDisk::stagingDiskTypeAsString))
            .setter(setter(Builder::stagingDiskType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stagingDiskType").build()).build();

    private static final SdkField<Long> THROUGHPUT_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("throughput")
            .getter(getter(ReplicationConfigurationReplicatedDisk::throughput)).setter(setter(Builder::throughput))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("throughput").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_NAME_FIELD, IOPS_FIELD,
            IS_BOOT_DISK_FIELD, STAGING_DISK_TYPE_FIELD, THROUGHPUT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String deviceName;

    private final Long iops;

    private final Boolean isBootDisk;

    private final String stagingDiskType;

    private final Long throughput;

    private ReplicationConfigurationReplicatedDisk(BuilderImpl builder) {
        this.deviceName = builder.deviceName;
        this.iops = builder.iops;
        this.isBootDisk = builder.isBootDisk;
        this.stagingDiskType = builder.stagingDiskType;
        this.throughput = builder.throughput;
    }

    /**
     * <p>
     * Replication Configuration replicated disk device name.
     * </p>
     * 
     * @return Replication Configuration replicated disk device name.
     */
    public final String deviceName() {
        return deviceName;
    }

    /**
     * <p>
     * Replication Configuration replicated disk IOPs.
     * </p>
     * 
     * @return Replication Configuration replicated disk IOPs.
     */
    public final Long iops() {
        return iops;
    }

    /**
     * <p>
     * Replication Configuration replicated disk boot disk.
     * </p>
     * 
     * @return Replication Configuration replicated disk boot disk.
     */
    public final Boolean isBootDisk() {
        return isBootDisk;
    }

    /**
     * <p>
     * Replication Configuration replicated disk staging disk type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #stagingDiskType}
     * will return {@link ReplicationConfigurationReplicatedDiskStagingDiskType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #stagingDiskTypeAsString}.
     * </p>
     * 
     * @return Replication Configuration replicated disk staging disk type.
     * @see ReplicationConfigurationReplicatedDiskStagingDiskType
     */
    public final ReplicationConfigurationReplicatedDiskStagingDiskType stagingDiskType() {
        return ReplicationConfigurationReplicatedDiskStagingDiskType.fromValue(stagingDiskType);
    }

    /**
     * <p>
     * Replication Configuration replicated disk staging disk type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #stagingDiskType}
     * will return {@link ReplicationConfigurationReplicatedDiskStagingDiskType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #stagingDiskTypeAsString}.
     * </p>
     * 
     * @return Replication Configuration replicated disk staging disk type.
     * @see ReplicationConfigurationReplicatedDiskStagingDiskType
     */
    public final String stagingDiskTypeAsString() {
        return stagingDiskType;
    }

    /**
     * <p>
     * Replication Configuration replicated disk throughput.
     * </p>
     * 
     * @return Replication Configuration replicated disk throughput.
     */
    public final Long throughput() {
        return throughput;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(deviceName());
        hashCode = 31 * hashCode + Objects.hashCode(iops());
        hashCode = 31 * hashCode + Objects.hashCode(isBootDisk());
        hashCode = 31 * hashCode + Objects.hashCode(stagingDiskTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(throughput());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplicationConfigurationReplicatedDisk)) {
            return false;
        }
        ReplicationConfigurationReplicatedDisk other = (ReplicationConfigurationReplicatedDisk) obj;
        return Objects.equals(deviceName(), other.deviceName()) && Objects.equals(iops(), other.iops())
                && Objects.equals(isBootDisk(), other.isBootDisk())
                && Objects.equals(stagingDiskTypeAsString(), other.stagingDiskTypeAsString())
                && Objects.equals(throughput(), other.throughput());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReplicationConfigurationReplicatedDisk").add("DeviceName", deviceName()).add("Iops", iops())
                .add("IsBootDisk", isBootDisk()).add("StagingDiskType", stagingDiskTypeAsString())
                .add("Throughput", throughput()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "deviceName":
            return Optional.ofNullable(clazz.cast(deviceName()));
        case "iops":
            return Optional.ofNullable(clazz.cast(iops()));
        case "isBootDisk":
            return Optional.ofNullable(clazz.cast(isBootDisk()));
        case "stagingDiskType":
            return Optional.ofNullable(clazz.cast(stagingDiskTypeAsString()));
        case "throughput":
            return Optional.ofNullable(clazz.cast(throughput()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("deviceName", DEVICE_NAME_FIELD);
        map.put("iops", IOPS_FIELD);
        map.put("isBootDisk", IS_BOOT_DISK_FIELD);
        map.put("stagingDiskType", STAGING_DISK_TYPE_FIELD);
        map.put("throughput", THROUGHPUT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReplicationConfigurationReplicatedDisk, T> g) {
        return obj -> g.apply((ReplicationConfigurationReplicatedDisk) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReplicationConfigurationReplicatedDisk> {
        /**
         * <p>
         * Replication Configuration replicated disk device name.
         * </p>
         * 
         * @param deviceName
         *        Replication Configuration replicated disk device name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceName(String deviceName);

        /**
         * <p>
         * Replication Configuration replicated disk IOPs.
         * </p>
         * 
         * @param iops
         *        Replication Configuration replicated disk IOPs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iops(Long iops);

        /**
         * <p>
         * Replication Configuration replicated disk boot disk.
         * </p>
         * 
         * @param isBootDisk
         *        Replication Configuration replicated disk boot disk.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isBootDisk(Boolean isBootDisk);

        /**
         * <p>
         * Replication Configuration replicated disk staging disk type.
         * </p>
         * 
         * @param stagingDiskType
         *        Replication Configuration replicated disk staging disk type.
         * @see ReplicationConfigurationReplicatedDiskStagingDiskType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReplicationConfigurationReplicatedDiskStagingDiskType
         */
        Builder stagingDiskType(String stagingDiskType);

        /**
         * <p>
         * Replication Configuration replicated disk staging disk type.
         * </p>
         * 
         * @param stagingDiskType
         *        Replication Configuration replicated disk staging disk type.
         * @see ReplicationConfigurationReplicatedDiskStagingDiskType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReplicationConfigurationReplicatedDiskStagingDiskType
         */
        Builder stagingDiskType(ReplicationConfigurationReplicatedDiskStagingDiskType stagingDiskType);

        /**
         * <p>
         * Replication Configuration replicated disk throughput.
         * </p>
         * 
         * @param throughput
         *        Replication Configuration replicated disk throughput.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder throughput(Long throughput);
    }

    static final class BuilderImpl implements Builder {
        private String deviceName;

        private Long iops;

        private Boolean isBootDisk;

        private String stagingDiskType;

        private Long throughput;

        private BuilderImpl() {
        }

        private BuilderImpl(ReplicationConfigurationReplicatedDisk model) {
            deviceName(model.deviceName);
            iops(model.iops);
            isBootDisk(model.isBootDisk);
            stagingDiskType(model.stagingDiskType);
            throughput(model.throughput);
        }

        public final String getDeviceName() {
            return deviceName;
        }

        public final void setDeviceName(String deviceName) {
            this.deviceName = deviceName;
        }

        @Override
        public final Builder deviceName(String deviceName) {
            this.deviceName = deviceName;
            return this;
        }

        public final Long getIops() {
            return iops;
        }

        public final void setIops(Long iops) {
            this.iops = iops;
        }

        @Override
        public final Builder iops(Long iops) {
            this.iops = iops;
            return this;
        }

        public final Boolean getIsBootDisk() {
            return isBootDisk;
        }

        public final void setIsBootDisk(Boolean isBootDisk) {
            this.isBootDisk = isBootDisk;
        }

        @Override
        public final Builder isBootDisk(Boolean isBootDisk) {
            this.isBootDisk = isBootDisk;
            return this;
        }

        public final String getStagingDiskType() {
            return stagingDiskType;
        }

        public final void setStagingDiskType(String stagingDiskType) {
            this.stagingDiskType = stagingDiskType;
        }

        @Override
        public final Builder stagingDiskType(String stagingDiskType) {
            this.stagingDiskType = stagingDiskType;
            return this;
        }

        @Override
        public final Builder stagingDiskType(ReplicationConfigurationReplicatedDiskStagingDiskType stagingDiskType) {
            this.stagingDiskType(stagingDiskType == null ? null : stagingDiskType.toString());
            return this;
        }

        public final Long getThroughput() {
            return throughput;
        }

        public final void setThroughput(Long throughput) {
            this.throughput = throughput;
        }

        @Override
        public final Builder throughput(Long throughput) {
            this.throughput = throughput;
            return this;
        }

        @Override
        public ReplicationConfigurationReplicatedDisk build() {
            return new ReplicationConfigurationReplicatedDisk(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
