/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mgn.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * AWS Systems Manager Document external parameter.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SsmExternalParameter implements SdkPojo, Serializable,
        ToCopyableBuilder<SsmExternalParameter.Builder, SsmExternalParameter> {
    private static final SdkField<String> DYNAMIC_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dynamicPath").getter(getter(SsmExternalParameter::dynamicPath)).setter(setter(Builder::dynamicPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dynamicPath").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DYNAMIC_PATH_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String dynamicPath;

    private final Type type;

    private SsmExternalParameter(BuilderImpl builder) {
        this.dynamicPath = builder.dynamicPath;
        this.type = builder.type;
    }

    /**
     * <p>
     * AWS Systems Manager Document external parameters dynamic path.
     * </p>
     * 
     * @return AWS Systems Manager Document external parameters dynamic path.
     */
    public final String dynamicPath() {
        return dynamicPath;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dynamicPath());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SsmExternalParameter)) {
            return false;
        }
        SsmExternalParameter other = (SsmExternalParameter) obj;
        return Objects.equals(dynamicPath(), other.dynamicPath());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SsmExternalParameter").add("DynamicPath", dynamicPath()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "dynamicPath":
            return Optional.ofNullable(clazz.cast(dynamicPath()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #dynamicPath()} initialized to the given value.
     *
     * <p>
     * AWS Systems Manager Document external parameters dynamic path.
     * </p>
     * 
     * @param dynamicPath
     *        AWS Systems Manager Document external parameters dynamic path.
     */
    public static SsmExternalParameter fromDynamicPath(String dynamicPath) {
        return builder().dynamicPath(dynamicPath).build();
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("dynamicPath", DYNAMIC_PATH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SsmExternalParameter, T> g) {
        return obj -> g.apply((SsmExternalParameter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SsmExternalParameter> {
        /**
         * <p>
         * AWS Systems Manager Document external parameters dynamic path.
         * </p>
         * 
         * @param dynamicPath
         *        AWS Systems Manager Document external parameters dynamic path.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dynamicPath(String dynamicPath);
    }

    static final class BuilderImpl implements Builder {
        private String dynamicPath;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(SsmExternalParameter model) {
            dynamicPath(model.dynamicPath);
        }

        public final String getDynamicPath() {
            return dynamicPath;
        }

        public final void setDynamicPath(String dynamicPath) {
            Object oldValue = this.dynamicPath;
            this.dynamicPath = dynamicPath;
            handleUnionValueChange(Type.DYNAMIC_PATH, oldValue, this.dynamicPath);
        }

        @Override
        public final Builder dynamicPath(String dynamicPath) {
            Object oldValue = this.dynamicPath;
            this.dynamicPath = dynamicPath;
            handleUnionValueChange(Type.DYNAMIC_PATH, oldValue, this.dynamicPath);
            return this;
        }

        @Override
        public SsmExternalParameter build() {
            return new SsmExternalParameter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see SsmExternalParameter#type()
     */
    public enum Type {
        DYNAMIC_PATH,

        UNKNOWN_TO_SDK_VERSION
    }
}
