/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mgn.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class TemplateActionDocument implements SdkPojo, Serializable,
        ToCopyableBuilder<TemplateActionDocument.Builder, TemplateActionDocument> {
    private static final SdkField<String> ACTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("actionID").getter(getter(TemplateActionDocument::actionID)).setter(setter(Builder::actionID))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionID").build()).build();

    private static final SdkField<String> ACTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("actionName").getter(getter(TemplateActionDocument::actionName)).setter(setter(Builder::actionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionName").build()).build();

    private static final SdkField<Boolean> ACTIVE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("active").getter(getter(TemplateActionDocument::active)).setter(setter(Builder::active))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("active").build()).build();

    private static final SdkField<String> CATEGORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("category").getter(getter(TemplateActionDocument::categoryAsString)).setter(setter(Builder::category))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("category").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(TemplateActionDocument::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> DOCUMENT_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("documentIdentifier").getter(getter(TemplateActionDocument::documentIdentifier))
            .setter(setter(Builder::documentIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("documentIdentifier").build())
            .build();

    private static final SdkField<String> DOCUMENT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("documentVersion").getter(getter(TemplateActionDocument::documentVersion))
            .setter(setter(Builder::documentVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("documentVersion").build()).build();

    private static final SdkField<Map<String, SsmExternalParameter>> EXTERNAL_PARAMETERS_FIELD = SdkField
            .<Map<String, SsmExternalParameter>> builder(MarshallingType.MAP)
            .memberName("externalParameters")
            .getter(getter(TemplateActionDocument::externalParameters))
            .setter(setter(Builder::externalParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("externalParameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<SsmExternalParameter> builder(MarshallingType.SDK_POJO)
                                            .constructor(SsmExternalParameter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Boolean> MUST_SUCCEED_FOR_CUTOVER_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("mustSucceedForCutover").getter(getter(TemplateActionDocument::mustSucceedForCutover))
            .setter(setter(Builder::mustSucceedForCutover))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mustSucceedForCutover").build())
            .build();

    private static final SdkField<String> OPERATING_SYSTEM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("operatingSystem").getter(getter(TemplateActionDocument::operatingSystem))
            .setter(setter(Builder::operatingSystem))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operatingSystem").build()).build();

    private static final SdkField<Integer> ORDER_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("order")
            .getter(getter(TemplateActionDocument::order)).setter(setter(Builder::order))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("order").build()).build();

    private static final SdkField<Map<String, List<SsmParameterStoreParameter>>> PARAMETERS_FIELD = SdkField
            .<Map<String, List<SsmParameterStoreParameter>>> builder(MarshallingType.MAP)
            .memberName("parameters")
            .getter(getter(TemplateActionDocument::parameters))
            .setter(setter(Builder::parameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<List<SsmParameterStoreParameter>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<SsmParameterStoreParameter> builder(
                                                                            MarshallingType.SDK_POJO)
                                                                            .constructor(SsmParameterStoreParameter::builder)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final SdkField<Integer> TIMEOUT_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("timeoutSeconds").getter(getter(TemplateActionDocument::timeoutSeconds))
            .setter(setter(Builder::timeoutSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeoutSeconds").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_ID_FIELD,
            ACTION_NAME_FIELD, ACTIVE_FIELD, CATEGORY_FIELD, DESCRIPTION_FIELD, DOCUMENT_IDENTIFIER_FIELD,
            DOCUMENT_VERSION_FIELD, EXTERNAL_PARAMETERS_FIELD, MUST_SUCCEED_FOR_CUTOVER_FIELD, OPERATING_SYSTEM_FIELD,
            ORDER_FIELD, PARAMETERS_FIELD, TIMEOUT_SECONDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String actionID;

    private final String actionName;

    private final Boolean active;

    private final String category;

    private final String description;

    private final String documentIdentifier;

    private final String documentVersion;

    private final Map<String, SsmExternalParameter> externalParameters;

    private final Boolean mustSucceedForCutover;

    private final String operatingSystem;

    private final Integer order;

    private final Map<String, List<SsmParameterStoreParameter>> parameters;

    private final Integer timeoutSeconds;

    private TemplateActionDocument(BuilderImpl builder) {
        this.actionID = builder.actionID;
        this.actionName = builder.actionName;
        this.active = builder.active;
        this.category = builder.category;
        this.description = builder.description;
        this.documentIdentifier = builder.documentIdentifier;
        this.documentVersion = builder.documentVersion;
        this.externalParameters = builder.externalParameters;
        this.mustSucceedForCutover = builder.mustSucceedForCutover;
        this.operatingSystem = builder.operatingSystem;
        this.order = builder.order;
        this.parameters = builder.parameters;
        this.timeoutSeconds = builder.timeoutSeconds;
    }

    /**
     * <p>
     * Template post migration custom action ID.
     * </p>
     * 
     * @return Template post migration custom action ID.
     */
    public final String actionID() {
        return actionID;
    }

    /**
     * <p>
     * Template post migration custom action name.
     * </p>
     * 
     * @return Template post migration custom action name.
     */
    public final String actionName() {
        return actionName;
    }

    /**
     * <p>
     * Template post migration custom action active status.
     * </p>
     * 
     * @return Template post migration custom action active status.
     */
    public final Boolean active() {
        return active;
    }

    /**
     * <p>
     * Template post migration custom action category.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #category} will
     * return {@link ActionCategory#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #categoryAsString}.
     * </p>
     * 
     * @return Template post migration custom action category.
     * @see ActionCategory
     */
    public final ActionCategory category() {
        return ActionCategory.fromValue(category);
    }

    /**
     * <p>
     * Template post migration custom action category.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #category} will
     * return {@link ActionCategory#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #categoryAsString}.
     * </p>
     * 
     * @return Template post migration custom action category.
     * @see ActionCategory
     */
    public final String categoryAsString() {
        return category;
    }

    /**
     * <p>
     * Template post migration custom action description.
     * </p>
     * 
     * @return Template post migration custom action description.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Template post migration custom action document identifier.
     * </p>
     * 
     * @return Template post migration custom action document identifier.
     */
    public final String documentIdentifier() {
        return documentIdentifier;
    }

    /**
     * <p>
     * Template post migration custom action document version.
     * </p>
     * 
     * @return Template post migration custom action document version.
     */
    public final String documentVersion() {
        return documentVersion;
    }

    /**
     * For responses, this returns true if the service returned a value for the ExternalParameters property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasExternalParameters() {
        return externalParameters != null && !(externalParameters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Template post migration custom action external parameters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExternalParameters} method.
     * </p>
     * 
     * @return Template post migration custom action external parameters.
     */
    public final Map<String, SsmExternalParameter> externalParameters() {
        return externalParameters;
    }

    /**
     * <p>
     * Template post migration custom action must succeed for cutover.
     * </p>
     * 
     * @return Template post migration custom action must succeed for cutover.
     */
    public final Boolean mustSucceedForCutover() {
        return mustSucceedForCutover;
    }

    /**
     * <p>
     * Operating system eligible for this template post migration custom action.
     * </p>
     * 
     * @return Operating system eligible for this template post migration custom action.
     */
    public final String operatingSystem() {
        return operatingSystem;
    }

    /**
     * <p>
     * Template post migration custom action order.
     * </p>
     * 
     * @return Template post migration custom action order.
     */
    public final Integer order() {
        return order;
    }

    /**
     * For responses, this returns true if the service returned a value for the Parameters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasParameters() {
        return parameters != null && !(parameters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Template post migration custom action parameters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasParameters} method.
     * </p>
     * 
     * @return Template post migration custom action parameters.
     */
    public final Map<String, List<SsmParameterStoreParameter>> parameters() {
        return parameters;
    }

    /**
     * <p>
     * Template post migration custom action timeout in seconds.
     * </p>
     * 
     * @return Template post migration custom action timeout in seconds.
     */
    public final Integer timeoutSeconds() {
        return timeoutSeconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(actionID());
        hashCode = 31 * hashCode + Objects.hashCode(actionName());
        hashCode = 31 * hashCode + Objects.hashCode(active());
        hashCode = 31 * hashCode + Objects.hashCode(categoryAsString());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(documentIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(documentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(hasExternalParameters() ? externalParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(mustSucceedForCutover());
        hashCode = 31 * hashCode + Objects.hashCode(operatingSystem());
        hashCode = 31 * hashCode + Objects.hashCode(order());
        hashCode = 31 * hashCode + Objects.hashCode(hasParameters() ? parameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(timeoutSeconds());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TemplateActionDocument)) {
            return false;
        }
        TemplateActionDocument other = (TemplateActionDocument) obj;
        return Objects.equals(actionID(), other.actionID()) && Objects.equals(actionName(), other.actionName())
                && Objects.equals(active(), other.active()) && Objects.equals(categoryAsString(), other.categoryAsString())
                && Objects.equals(description(), other.description())
                && Objects.equals(documentIdentifier(), other.documentIdentifier())
                && Objects.equals(documentVersion(), other.documentVersion())
                && hasExternalParameters() == other.hasExternalParameters()
                && Objects.equals(externalParameters(), other.externalParameters())
                && Objects.equals(mustSucceedForCutover(), other.mustSucceedForCutover())
                && Objects.equals(operatingSystem(), other.operatingSystem()) && Objects.equals(order(), other.order())
                && hasParameters() == other.hasParameters() && Objects.equals(parameters(), other.parameters())
                && Objects.equals(timeoutSeconds(), other.timeoutSeconds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TemplateActionDocument").add("ActionID", actionID()).add("ActionName", actionName())
                .add("Active", active()).add("Category", categoryAsString()).add("Description", description())
                .add("DocumentIdentifier", documentIdentifier()).add("DocumentVersion", documentVersion())
                .add("ExternalParameters", hasExternalParameters() ? externalParameters() : null)
                .add("MustSucceedForCutover", mustSucceedForCutover()).add("OperatingSystem", operatingSystem())
                .add("Order", order()).add("Parameters", hasParameters() ? parameters() : null)
                .add("TimeoutSeconds", timeoutSeconds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "actionID":
            return Optional.ofNullable(clazz.cast(actionID()));
        case "actionName":
            return Optional.ofNullable(clazz.cast(actionName()));
        case "active":
            return Optional.ofNullable(clazz.cast(active()));
        case "category":
            return Optional.ofNullable(clazz.cast(categoryAsString()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "documentIdentifier":
            return Optional.ofNullable(clazz.cast(documentIdentifier()));
        case "documentVersion":
            return Optional.ofNullable(clazz.cast(documentVersion()));
        case "externalParameters":
            return Optional.ofNullable(clazz.cast(externalParameters()));
        case "mustSucceedForCutover":
            return Optional.ofNullable(clazz.cast(mustSucceedForCutover()));
        case "operatingSystem":
            return Optional.ofNullable(clazz.cast(operatingSystem()));
        case "order":
            return Optional.ofNullable(clazz.cast(order()));
        case "parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        case "timeoutSeconds":
            return Optional.ofNullable(clazz.cast(timeoutSeconds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("actionID", ACTION_ID_FIELD);
        map.put("actionName", ACTION_NAME_FIELD);
        map.put("active", ACTIVE_FIELD);
        map.put("category", CATEGORY_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("documentIdentifier", DOCUMENT_IDENTIFIER_FIELD);
        map.put("documentVersion", DOCUMENT_VERSION_FIELD);
        map.put("externalParameters", EXTERNAL_PARAMETERS_FIELD);
        map.put("mustSucceedForCutover", MUST_SUCCEED_FOR_CUTOVER_FIELD);
        map.put("operatingSystem", OPERATING_SYSTEM_FIELD);
        map.put("order", ORDER_FIELD);
        map.put("parameters", PARAMETERS_FIELD);
        map.put("timeoutSeconds", TIMEOUT_SECONDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TemplateActionDocument, T> g) {
        return obj -> g.apply((TemplateActionDocument) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TemplateActionDocument> {
        /**
         * <p>
         * Template post migration custom action ID.
         * </p>
         * 
         * @param actionID
         *        Template post migration custom action ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionID(String actionID);

        /**
         * <p>
         * Template post migration custom action name.
         * </p>
         * 
         * @param actionName
         *        Template post migration custom action name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionName(String actionName);

        /**
         * <p>
         * Template post migration custom action active status.
         * </p>
         * 
         * @param active
         *        Template post migration custom action active status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder active(Boolean active);

        /**
         * <p>
         * Template post migration custom action category.
         * </p>
         * 
         * @param category
         *        Template post migration custom action category.
         * @see ActionCategory
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActionCategory
         */
        Builder category(String category);

        /**
         * <p>
         * Template post migration custom action category.
         * </p>
         * 
         * @param category
         *        Template post migration custom action category.
         * @see ActionCategory
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActionCategory
         */
        Builder category(ActionCategory category);

        /**
         * <p>
         * Template post migration custom action description.
         * </p>
         * 
         * @param description
         *        Template post migration custom action description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Template post migration custom action document identifier.
         * </p>
         * 
         * @param documentIdentifier
         *        Template post migration custom action document identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentIdentifier(String documentIdentifier);

        /**
         * <p>
         * Template post migration custom action document version.
         * </p>
         * 
         * @param documentVersion
         *        Template post migration custom action document version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentVersion(String documentVersion);

        /**
         * <p>
         * Template post migration custom action external parameters.
         * </p>
         * 
         * @param externalParameters
         *        Template post migration custom action external parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalParameters(Map<String, SsmExternalParameter> externalParameters);

        /**
         * <p>
         * Template post migration custom action must succeed for cutover.
         * </p>
         * 
         * @param mustSucceedForCutover
         *        Template post migration custom action must succeed for cutover.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mustSucceedForCutover(Boolean mustSucceedForCutover);

        /**
         * <p>
         * Operating system eligible for this template post migration custom action.
         * </p>
         * 
         * @param operatingSystem
         *        Operating system eligible for this template post migration custom action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operatingSystem(String operatingSystem);

        /**
         * <p>
         * Template post migration custom action order.
         * </p>
         * 
         * @param order
         *        Template post migration custom action order.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder order(Integer order);

        /**
         * <p>
         * Template post migration custom action parameters.
         * </p>
         * 
         * @param parameters
         *        Template post migration custom action parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Map<String, ? extends Collection<SsmParameterStoreParameter>> parameters);

        /**
         * <p>
         * Template post migration custom action timeout in seconds.
         * </p>
         * 
         * @param timeoutSeconds
         *        Template post migration custom action timeout in seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeoutSeconds(Integer timeoutSeconds);
    }

    static final class BuilderImpl implements Builder {
        private String actionID;

        private String actionName;

        private Boolean active;

        private String category;

        private String description;

        private String documentIdentifier;

        private String documentVersion;

        private Map<String, SsmExternalParameter> externalParameters = DefaultSdkAutoConstructMap.getInstance();

        private Boolean mustSucceedForCutover;

        private String operatingSystem;

        private Integer order;

        private Map<String, List<SsmParameterStoreParameter>> parameters = DefaultSdkAutoConstructMap.getInstance();

        private Integer timeoutSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(TemplateActionDocument model) {
            actionID(model.actionID);
            actionName(model.actionName);
            active(model.active);
            category(model.category);
            description(model.description);
            documentIdentifier(model.documentIdentifier);
            documentVersion(model.documentVersion);
            externalParameters(model.externalParameters);
            mustSucceedForCutover(model.mustSucceedForCutover);
            operatingSystem(model.operatingSystem);
            order(model.order);
            parameters(model.parameters);
            timeoutSeconds(model.timeoutSeconds);
        }

        public final String getActionID() {
            return actionID;
        }

        public final void setActionID(String actionID) {
            this.actionID = actionID;
        }

        @Override
        public final Builder actionID(String actionID) {
            this.actionID = actionID;
            return this;
        }

        public final String getActionName() {
            return actionName;
        }

        public final void setActionName(String actionName) {
            this.actionName = actionName;
        }

        @Override
        public final Builder actionName(String actionName) {
            this.actionName = actionName;
            return this;
        }

        public final Boolean getActive() {
            return active;
        }

        public final void setActive(Boolean active) {
            this.active = active;
        }

        @Override
        public final Builder active(Boolean active) {
            this.active = active;
            return this;
        }

        public final String getCategory() {
            return category;
        }

        public final void setCategory(String category) {
            this.category = category;
        }

        @Override
        public final Builder category(String category) {
            this.category = category;
            return this;
        }

        @Override
        public final Builder category(ActionCategory category) {
            this.category(category == null ? null : category.toString());
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDocumentIdentifier() {
            return documentIdentifier;
        }

        public final void setDocumentIdentifier(String documentIdentifier) {
            this.documentIdentifier = documentIdentifier;
        }

        @Override
        public final Builder documentIdentifier(String documentIdentifier) {
            this.documentIdentifier = documentIdentifier;
            return this;
        }

        public final String getDocumentVersion() {
            return documentVersion;
        }

        public final void setDocumentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
        }

        @Override
        public final Builder documentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
            return this;
        }

        public final Map<String, SsmExternalParameter.Builder> getExternalParameters() {
            Map<String, SsmExternalParameter.Builder> result = SsmDocumentExternalParametersCopier
                    .copyToBuilder(this.externalParameters);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setExternalParameters(Map<String, SsmExternalParameter.BuilderImpl> externalParameters) {
            this.externalParameters = SsmDocumentExternalParametersCopier.copyFromBuilder(externalParameters);
        }

        @Override
        public final Builder externalParameters(Map<String, SsmExternalParameter> externalParameters) {
            this.externalParameters = SsmDocumentExternalParametersCopier.copy(externalParameters);
            return this;
        }

        public final Boolean getMustSucceedForCutover() {
            return mustSucceedForCutover;
        }

        public final void setMustSucceedForCutover(Boolean mustSucceedForCutover) {
            this.mustSucceedForCutover = mustSucceedForCutover;
        }

        @Override
        public final Builder mustSucceedForCutover(Boolean mustSucceedForCutover) {
            this.mustSucceedForCutover = mustSucceedForCutover;
            return this;
        }

        public final String getOperatingSystem() {
            return operatingSystem;
        }

        public final void setOperatingSystem(String operatingSystem) {
            this.operatingSystem = operatingSystem;
        }

        @Override
        public final Builder operatingSystem(String operatingSystem) {
            this.operatingSystem = operatingSystem;
            return this;
        }

        public final Integer getOrder() {
            return order;
        }

        public final void setOrder(Integer order) {
            this.order = order;
        }

        @Override
        public final Builder order(Integer order) {
            this.order = order;
            return this;
        }

        public final Map<String, List<SsmParameterStoreParameter.Builder>> getParameters() {
            Map<String, List<SsmParameterStoreParameter.Builder>> result = SsmDocumentParametersCopier
                    .copyToBuilder(this.parameters);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setParameters(Map<String, ? extends Collection<SsmParameterStoreParameter.BuilderImpl>> parameters) {
            this.parameters = SsmDocumentParametersCopier.copyFromBuilder(parameters);
        }

        @Override
        public final Builder parameters(Map<String, ? extends Collection<SsmParameterStoreParameter>> parameters) {
            this.parameters = SsmDocumentParametersCopier.copy(parameters);
            return this;
        }

        public final Integer getTimeoutSeconds() {
            return timeoutSeconds;
        }

        public final void setTimeoutSeconds(Integer timeoutSeconds) {
            this.timeoutSeconds = timeoutSeconds;
        }

        @Override
        public final Builder timeoutSeconds(Integer timeoutSeconds) {
            this.timeoutSeconds = timeoutSeconds;
            return this;
        }

        @Override
        public TemplateActionDocument build() {
            return new TemplateActionDocument(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
