/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mgn.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateLaunchConfigurationTemplateRequest extends MgnRequest implements
        ToCopyableBuilder<UpdateLaunchConfigurationTemplateRequest.Builder, UpdateLaunchConfigurationTemplateRequest> {
    private static final SdkField<Boolean> ASSOCIATE_PUBLIC_IP_ADDRESS_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("associatePublicIpAddress")
            .getter(getter(UpdateLaunchConfigurationTemplateRequest::associatePublicIpAddress))
            .setter(setter(Builder::associatePublicIpAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associatePublicIpAddress").build())
            .build();

    private static final SdkField<String> BOOT_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("bootMode").getter(getter(UpdateLaunchConfigurationTemplateRequest::bootModeAsString))
            .setter(setter(Builder::bootMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bootMode").build()).build();

    private static final SdkField<Boolean> COPY_PRIVATE_IP_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("copyPrivateIp").getter(getter(UpdateLaunchConfigurationTemplateRequest::copyPrivateIp))
            .setter(setter(Builder::copyPrivateIp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("copyPrivateIp").build()).build();

    private static final SdkField<Boolean> COPY_TAGS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("copyTags").getter(getter(UpdateLaunchConfigurationTemplateRequest::copyTags))
            .setter(setter(Builder::copyTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("copyTags").build()).build();

    private static final SdkField<Boolean> ENABLE_MAP_AUTO_TAGGING_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("enableMapAutoTagging").getter(getter(UpdateLaunchConfigurationTemplateRequest::enableMapAutoTagging))
            .setter(setter(Builder::enableMapAutoTagging))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableMapAutoTagging").build())
            .build();

    private static final SdkField<LaunchTemplateDiskConf> LARGE_VOLUME_CONF_FIELD = SdkField
            .<LaunchTemplateDiskConf> builder(MarshallingType.SDK_POJO).memberName("largeVolumeConf")
            .getter(getter(UpdateLaunchConfigurationTemplateRequest::largeVolumeConf)).setter(setter(Builder::largeVolumeConf))
            .constructor(LaunchTemplateDiskConf::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("largeVolumeConf").build()).build();

    private static final SdkField<String> LAUNCH_CONFIGURATION_TEMPLATE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("launchConfigurationTemplateID")
            .getter(getter(UpdateLaunchConfigurationTemplateRequest::launchConfigurationTemplateID))
            .setter(setter(Builder::launchConfigurationTemplateID))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchConfigurationTemplateID")
                    .build()).build();

    private static final SdkField<String> LAUNCH_DISPOSITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("launchDisposition").getter(getter(UpdateLaunchConfigurationTemplateRequest::launchDispositionAsString))
            .setter(setter(Builder::launchDisposition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchDisposition").build()).build();

    private static final SdkField<Licensing> LICENSING_FIELD = SdkField.<Licensing> builder(MarshallingType.SDK_POJO)
            .memberName("licensing").getter(getter(UpdateLaunchConfigurationTemplateRequest::licensing))
            .setter(setter(Builder::licensing)).constructor(Licensing::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("licensing").build()).build();

    private static final SdkField<String> MAP_AUTO_TAGGING_MPE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("mapAutoTaggingMpeID").getter(getter(UpdateLaunchConfigurationTemplateRequest::mapAutoTaggingMpeID))
            .setter(setter(Builder::mapAutoTaggingMpeID))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mapAutoTaggingMpeID").build())
            .build();

    private static final SdkField<PostLaunchActions> POST_LAUNCH_ACTIONS_FIELD = SdkField
            .<PostLaunchActions> builder(MarshallingType.SDK_POJO).memberName("postLaunchActions")
            .getter(getter(UpdateLaunchConfigurationTemplateRequest::postLaunchActions))
            .setter(setter(Builder::postLaunchActions)).constructor(PostLaunchActions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("postLaunchActions").build()).build();

    private static final SdkField<LaunchTemplateDiskConf> SMALL_VOLUME_CONF_FIELD = SdkField
            .<LaunchTemplateDiskConf> builder(MarshallingType.SDK_POJO).memberName("smallVolumeConf")
            .getter(getter(UpdateLaunchConfigurationTemplateRequest::smallVolumeConf)).setter(setter(Builder::smallVolumeConf))
            .constructor(LaunchTemplateDiskConf::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("smallVolumeConf").build()).build();

    private static final SdkField<Long> SMALL_VOLUME_MAX_SIZE_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("smallVolumeMaxSize").getter(getter(UpdateLaunchConfigurationTemplateRequest::smallVolumeMaxSize))
            .setter(setter(Builder::smallVolumeMaxSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("smallVolumeMaxSize").build())
            .build();

    private static final SdkField<String> TARGET_INSTANCE_TYPE_RIGHT_SIZING_METHOD_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("targetInstanceTypeRightSizingMethod")
            .getter(getter(UpdateLaunchConfigurationTemplateRequest::targetInstanceTypeRightSizingMethodAsString))
            .setter(setter(Builder::targetInstanceTypeRightSizingMethod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("targetInstanceTypeRightSizingMethod").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ASSOCIATE_PUBLIC_IP_ADDRESS_FIELD, BOOT_MODE_FIELD, COPY_PRIVATE_IP_FIELD, COPY_TAGS_FIELD,
            ENABLE_MAP_AUTO_TAGGING_FIELD, LARGE_VOLUME_CONF_FIELD, LAUNCH_CONFIGURATION_TEMPLATE_ID_FIELD,
            LAUNCH_DISPOSITION_FIELD, LICENSING_FIELD, MAP_AUTO_TAGGING_MPE_ID_FIELD, POST_LAUNCH_ACTIONS_FIELD,
            SMALL_VOLUME_CONF_FIELD, SMALL_VOLUME_MAX_SIZE_FIELD, TARGET_INSTANCE_TYPE_RIGHT_SIZING_METHOD_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Boolean associatePublicIpAddress;

    private final String bootMode;

    private final Boolean copyPrivateIp;

    private final Boolean copyTags;

    private final Boolean enableMapAutoTagging;

    private final LaunchTemplateDiskConf largeVolumeConf;

    private final String launchConfigurationTemplateID;

    private final String launchDisposition;

    private final Licensing licensing;

    private final String mapAutoTaggingMpeID;

    private final PostLaunchActions postLaunchActions;

    private final LaunchTemplateDiskConf smallVolumeConf;

    private final Long smallVolumeMaxSize;

    private final String targetInstanceTypeRightSizingMethod;

    private UpdateLaunchConfigurationTemplateRequest(BuilderImpl builder) {
        super(builder);
        this.associatePublicIpAddress = builder.associatePublicIpAddress;
        this.bootMode = builder.bootMode;
        this.copyPrivateIp = builder.copyPrivateIp;
        this.copyTags = builder.copyTags;
        this.enableMapAutoTagging = builder.enableMapAutoTagging;
        this.largeVolumeConf = builder.largeVolumeConf;
        this.launchConfigurationTemplateID = builder.launchConfigurationTemplateID;
        this.launchDisposition = builder.launchDisposition;
        this.licensing = builder.licensing;
        this.mapAutoTaggingMpeID = builder.mapAutoTaggingMpeID;
        this.postLaunchActions = builder.postLaunchActions;
        this.smallVolumeConf = builder.smallVolumeConf;
        this.smallVolumeMaxSize = builder.smallVolumeMaxSize;
        this.targetInstanceTypeRightSizingMethod = builder.targetInstanceTypeRightSizingMethod;
    }

    /**
     * <p>
     * Associate public Ip address.
     * </p>
     * 
     * @return Associate public Ip address.
     */
    public final Boolean associatePublicIpAddress() {
        return associatePublicIpAddress;
    }

    /**
     * <p>
     * Launch configuration template boot mode.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #bootMode} will
     * return {@link BootMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #bootModeAsString}.
     * </p>
     * 
     * @return Launch configuration template boot mode.
     * @see BootMode
     */
    public final BootMode bootMode() {
        return BootMode.fromValue(bootMode);
    }

    /**
     * <p>
     * Launch configuration template boot mode.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #bootMode} will
     * return {@link BootMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #bootModeAsString}.
     * </p>
     * 
     * @return Launch configuration template boot mode.
     * @see BootMode
     */
    public final String bootModeAsString() {
        return bootMode;
    }

    /**
     * <p>
     * Copy private Ip.
     * </p>
     * 
     * @return Copy private Ip.
     */
    public final Boolean copyPrivateIp() {
        return copyPrivateIp;
    }

    /**
     * <p>
     * Copy tags.
     * </p>
     * 
     * @return Copy tags.
     */
    public final Boolean copyTags() {
        return copyTags;
    }

    /**
     * <p>
     * Enable map auto tagging.
     * </p>
     * 
     * @return Enable map auto tagging.
     */
    public final Boolean enableMapAutoTagging() {
        return enableMapAutoTagging;
    }

    /**
     * <p>
     * Large volume config.
     * </p>
     * 
     * @return Large volume config.
     */
    public final LaunchTemplateDiskConf largeVolumeConf() {
        return largeVolumeConf;
    }

    /**
     * <p>
     * Launch Configuration Template ID.
     * </p>
     * 
     * @return Launch Configuration Template ID.
     */
    public final String launchConfigurationTemplateID() {
        return launchConfigurationTemplateID;
    }

    /**
     * <p>
     * Launch disposition.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #launchDisposition}
     * will return {@link LaunchDisposition#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #launchDispositionAsString}.
     * </p>
     * 
     * @return Launch disposition.
     * @see LaunchDisposition
     */
    public final LaunchDisposition launchDisposition() {
        return LaunchDisposition.fromValue(launchDisposition);
    }

    /**
     * <p>
     * Launch disposition.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #launchDisposition}
     * will return {@link LaunchDisposition#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #launchDispositionAsString}.
     * </p>
     * 
     * @return Launch disposition.
     * @see LaunchDisposition
     */
    public final String launchDispositionAsString() {
        return launchDisposition;
    }

    /**
     * Returns the value of the Licensing property for this object.
     * 
     * @return The value of the Licensing property for this object.
     */
    public final Licensing licensing() {
        return licensing;
    }

    /**
     * <p>
     * Launch configuration template map auto tagging MPE ID.
     * </p>
     * 
     * @return Launch configuration template map auto tagging MPE ID.
     */
    public final String mapAutoTaggingMpeID() {
        return mapAutoTaggingMpeID;
    }

    /**
     * <p>
     * Post Launch Action to execute on the Test or Cutover instance.
     * </p>
     * 
     * @return Post Launch Action to execute on the Test or Cutover instance.
     */
    public final PostLaunchActions postLaunchActions() {
        return postLaunchActions;
    }

    /**
     * <p>
     * Small volume config.
     * </p>
     * 
     * @return Small volume config.
     */
    public final LaunchTemplateDiskConf smallVolumeConf() {
        return smallVolumeConf;
    }

    /**
     * <p>
     * Small volume maximum size.
     * </p>
     * 
     * @return Small volume maximum size.
     */
    public final Long smallVolumeMaxSize() {
        return smallVolumeMaxSize;
    }

    /**
     * <p>
     * Target instance type right-sizing method.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #targetInstanceTypeRightSizingMethod} will return
     * {@link TargetInstanceTypeRightSizingMethod#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #targetInstanceTypeRightSizingMethodAsString}.
     * </p>
     * 
     * @return Target instance type right-sizing method.
     * @see TargetInstanceTypeRightSizingMethod
     */
    public final TargetInstanceTypeRightSizingMethod targetInstanceTypeRightSizingMethod() {
        return TargetInstanceTypeRightSizingMethod.fromValue(targetInstanceTypeRightSizingMethod);
    }

    /**
     * <p>
     * Target instance type right-sizing method.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #targetInstanceTypeRightSizingMethod} will return
     * {@link TargetInstanceTypeRightSizingMethod#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #targetInstanceTypeRightSizingMethodAsString}.
     * </p>
     * 
     * @return Target instance type right-sizing method.
     * @see TargetInstanceTypeRightSizingMethod
     */
    public final String targetInstanceTypeRightSizingMethodAsString() {
        return targetInstanceTypeRightSizingMethod;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(associatePublicIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(bootModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(copyPrivateIp());
        hashCode = 31 * hashCode + Objects.hashCode(copyTags());
        hashCode = 31 * hashCode + Objects.hashCode(enableMapAutoTagging());
        hashCode = 31 * hashCode + Objects.hashCode(largeVolumeConf());
        hashCode = 31 * hashCode + Objects.hashCode(launchConfigurationTemplateID());
        hashCode = 31 * hashCode + Objects.hashCode(launchDispositionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(licensing());
        hashCode = 31 * hashCode + Objects.hashCode(mapAutoTaggingMpeID());
        hashCode = 31 * hashCode + Objects.hashCode(postLaunchActions());
        hashCode = 31 * hashCode + Objects.hashCode(smallVolumeConf());
        hashCode = 31 * hashCode + Objects.hashCode(smallVolumeMaxSize());
        hashCode = 31 * hashCode + Objects.hashCode(targetInstanceTypeRightSizingMethodAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateLaunchConfigurationTemplateRequest)) {
            return false;
        }
        UpdateLaunchConfigurationTemplateRequest other = (UpdateLaunchConfigurationTemplateRequest) obj;
        return Objects.equals(associatePublicIpAddress(), other.associatePublicIpAddress())
                && Objects.equals(bootModeAsString(), other.bootModeAsString())
                && Objects.equals(copyPrivateIp(), other.copyPrivateIp())
                && Objects.equals(copyTags(), other.copyTags())
                && Objects.equals(enableMapAutoTagging(), other.enableMapAutoTagging())
                && Objects.equals(largeVolumeConf(), other.largeVolumeConf())
                && Objects.equals(launchConfigurationTemplateID(), other.launchConfigurationTemplateID())
                && Objects.equals(launchDispositionAsString(), other.launchDispositionAsString())
                && Objects.equals(licensing(), other.licensing())
                && Objects.equals(mapAutoTaggingMpeID(), other.mapAutoTaggingMpeID())
                && Objects.equals(postLaunchActions(), other.postLaunchActions())
                && Objects.equals(smallVolumeConf(), other.smallVolumeConf())
                && Objects.equals(smallVolumeMaxSize(), other.smallVolumeMaxSize())
                && Objects.equals(targetInstanceTypeRightSizingMethodAsString(),
                        other.targetInstanceTypeRightSizingMethodAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateLaunchConfigurationTemplateRequest")
                .add("AssociatePublicIpAddress", associatePublicIpAddress()).add("BootMode", bootModeAsString())
                .add("CopyPrivateIp", copyPrivateIp()).add("CopyTags", copyTags())
                .add("EnableMapAutoTagging", enableMapAutoTagging()).add("LargeVolumeConf", largeVolumeConf())
                .add("LaunchConfigurationTemplateID", launchConfigurationTemplateID())
                .add("LaunchDisposition", launchDispositionAsString()).add("Licensing", licensing())
                .add("MapAutoTaggingMpeID", mapAutoTaggingMpeID()).add("PostLaunchActions", postLaunchActions())
                .add("SmallVolumeConf", smallVolumeConf()).add("SmallVolumeMaxSize", smallVolumeMaxSize())
                .add("TargetInstanceTypeRightSizingMethod", targetInstanceTypeRightSizingMethodAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "associatePublicIpAddress":
            return Optional.ofNullable(clazz.cast(associatePublicIpAddress()));
        case "bootMode":
            return Optional.ofNullable(clazz.cast(bootModeAsString()));
        case "copyPrivateIp":
            return Optional.ofNullable(clazz.cast(copyPrivateIp()));
        case "copyTags":
            return Optional.ofNullable(clazz.cast(copyTags()));
        case "enableMapAutoTagging":
            return Optional.ofNullable(clazz.cast(enableMapAutoTagging()));
        case "largeVolumeConf":
            return Optional.ofNullable(clazz.cast(largeVolumeConf()));
        case "launchConfigurationTemplateID":
            return Optional.ofNullable(clazz.cast(launchConfigurationTemplateID()));
        case "launchDisposition":
            return Optional.ofNullable(clazz.cast(launchDispositionAsString()));
        case "licensing":
            return Optional.ofNullable(clazz.cast(licensing()));
        case "mapAutoTaggingMpeID":
            return Optional.ofNullable(clazz.cast(mapAutoTaggingMpeID()));
        case "postLaunchActions":
            return Optional.ofNullable(clazz.cast(postLaunchActions()));
        case "smallVolumeConf":
            return Optional.ofNullable(clazz.cast(smallVolumeConf()));
        case "smallVolumeMaxSize":
            return Optional.ofNullable(clazz.cast(smallVolumeMaxSize()));
        case "targetInstanceTypeRightSizingMethod":
            return Optional.ofNullable(clazz.cast(targetInstanceTypeRightSizingMethodAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("associatePublicIpAddress", ASSOCIATE_PUBLIC_IP_ADDRESS_FIELD);
        map.put("bootMode", BOOT_MODE_FIELD);
        map.put("copyPrivateIp", COPY_PRIVATE_IP_FIELD);
        map.put("copyTags", COPY_TAGS_FIELD);
        map.put("enableMapAutoTagging", ENABLE_MAP_AUTO_TAGGING_FIELD);
        map.put("largeVolumeConf", LARGE_VOLUME_CONF_FIELD);
        map.put("launchConfigurationTemplateID", LAUNCH_CONFIGURATION_TEMPLATE_ID_FIELD);
        map.put("launchDisposition", LAUNCH_DISPOSITION_FIELD);
        map.put("licensing", LICENSING_FIELD);
        map.put("mapAutoTaggingMpeID", MAP_AUTO_TAGGING_MPE_ID_FIELD);
        map.put("postLaunchActions", POST_LAUNCH_ACTIONS_FIELD);
        map.put("smallVolumeConf", SMALL_VOLUME_CONF_FIELD);
        map.put("smallVolumeMaxSize", SMALL_VOLUME_MAX_SIZE_FIELD);
        map.put("targetInstanceTypeRightSizingMethod", TARGET_INSTANCE_TYPE_RIGHT_SIZING_METHOD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateLaunchConfigurationTemplateRequest, T> g) {
        return obj -> g.apply((UpdateLaunchConfigurationTemplateRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MgnRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateLaunchConfigurationTemplateRequest> {
        /**
         * <p>
         * Associate public Ip address.
         * </p>
         * 
         * @param associatePublicIpAddress
         *        Associate public Ip address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatePublicIpAddress(Boolean associatePublicIpAddress);

        /**
         * <p>
         * Launch configuration template boot mode.
         * </p>
         * 
         * @param bootMode
         *        Launch configuration template boot mode.
         * @see BootMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BootMode
         */
        Builder bootMode(String bootMode);

        /**
         * <p>
         * Launch configuration template boot mode.
         * </p>
         * 
         * @param bootMode
         *        Launch configuration template boot mode.
         * @see BootMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BootMode
         */
        Builder bootMode(BootMode bootMode);

        /**
         * <p>
         * Copy private Ip.
         * </p>
         * 
         * @param copyPrivateIp
         *        Copy private Ip.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder copyPrivateIp(Boolean copyPrivateIp);

        /**
         * <p>
         * Copy tags.
         * </p>
         * 
         * @param copyTags
         *        Copy tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder copyTags(Boolean copyTags);

        /**
         * <p>
         * Enable map auto tagging.
         * </p>
         * 
         * @param enableMapAutoTagging
         *        Enable map auto tagging.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableMapAutoTagging(Boolean enableMapAutoTagging);

        /**
         * <p>
         * Large volume config.
         * </p>
         * 
         * @param largeVolumeConf
         *        Large volume config.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder largeVolumeConf(LaunchTemplateDiskConf largeVolumeConf);

        /**
         * <p>
         * Large volume config.
         * </p>
         * This is a convenience method that creates an instance of the {@link LaunchTemplateDiskConf.Builder} avoiding
         * the need to create one manually via {@link LaunchTemplateDiskConf#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LaunchTemplateDiskConf.Builder#build()} is called immediately and
         * its result is passed to {@link #largeVolumeConf(LaunchTemplateDiskConf)}.
         * 
         * @param largeVolumeConf
         *        a consumer that will call methods on {@link LaunchTemplateDiskConf.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #largeVolumeConf(LaunchTemplateDiskConf)
         */
        default Builder largeVolumeConf(Consumer<LaunchTemplateDiskConf.Builder> largeVolumeConf) {
            return largeVolumeConf(LaunchTemplateDiskConf.builder().applyMutation(largeVolumeConf).build());
        }

        /**
         * <p>
         * Launch Configuration Template ID.
         * </p>
         * 
         * @param launchConfigurationTemplateID
         *        Launch Configuration Template ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchConfigurationTemplateID(String launchConfigurationTemplateID);

        /**
         * <p>
         * Launch disposition.
         * </p>
         * 
         * @param launchDisposition
         *        Launch disposition.
         * @see LaunchDisposition
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LaunchDisposition
         */
        Builder launchDisposition(String launchDisposition);

        /**
         * <p>
         * Launch disposition.
         * </p>
         * 
         * @param launchDisposition
         *        Launch disposition.
         * @see LaunchDisposition
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LaunchDisposition
         */
        Builder launchDisposition(LaunchDisposition launchDisposition);

        /**
         * Sets the value of the Licensing property for this object.
         *
         * @param licensing
         *        The new value for the Licensing property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licensing(Licensing licensing);

        /**
         * Sets the value of the Licensing property for this object.
         *
         * This is a convenience method that creates an instance of the {@link Licensing.Builder} avoiding the need to
         * create one manually via {@link Licensing#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Licensing.Builder#build()} is called immediately and its result
         * is passed to {@link #licensing(Licensing)}.
         * 
         * @param licensing
         *        a consumer that will call methods on {@link Licensing.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #licensing(Licensing)
         */
        default Builder licensing(Consumer<Licensing.Builder> licensing) {
            return licensing(Licensing.builder().applyMutation(licensing).build());
        }

        /**
         * <p>
         * Launch configuration template map auto tagging MPE ID.
         * </p>
         * 
         * @param mapAutoTaggingMpeID
         *        Launch configuration template map auto tagging MPE ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mapAutoTaggingMpeID(String mapAutoTaggingMpeID);

        /**
         * <p>
         * Post Launch Action to execute on the Test or Cutover instance.
         * </p>
         * 
         * @param postLaunchActions
         *        Post Launch Action to execute on the Test or Cutover instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder postLaunchActions(PostLaunchActions postLaunchActions);

        /**
         * <p>
         * Post Launch Action to execute on the Test or Cutover instance.
         * </p>
         * This is a convenience method that creates an instance of the {@link PostLaunchActions.Builder} avoiding the
         * need to create one manually via {@link PostLaunchActions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PostLaunchActions.Builder#build()} is called immediately and its
         * result is passed to {@link #postLaunchActions(PostLaunchActions)}.
         * 
         * @param postLaunchActions
         *        a consumer that will call methods on {@link PostLaunchActions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #postLaunchActions(PostLaunchActions)
         */
        default Builder postLaunchActions(Consumer<PostLaunchActions.Builder> postLaunchActions) {
            return postLaunchActions(PostLaunchActions.builder().applyMutation(postLaunchActions).build());
        }

        /**
         * <p>
         * Small volume config.
         * </p>
         * 
         * @param smallVolumeConf
         *        Small volume config.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder smallVolumeConf(LaunchTemplateDiskConf smallVolumeConf);

        /**
         * <p>
         * Small volume config.
         * </p>
         * This is a convenience method that creates an instance of the {@link LaunchTemplateDiskConf.Builder} avoiding
         * the need to create one manually via {@link LaunchTemplateDiskConf#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LaunchTemplateDiskConf.Builder#build()} is called immediately and
         * its result is passed to {@link #smallVolumeConf(LaunchTemplateDiskConf)}.
         * 
         * @param smallVolumeConf
         *        a consumer that will call methods on {@link LaunchTemplateDiskConf.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #smallVolumeConf(LaunchTemplateDiskConf)
         */
        default Builder smallVolumeConf(Consumer<LaunchTemplateDiskConf.Builder> smallVolumeConf) {
            return smallVolumeConf(LaunchTemplateDiskConf.builder().applyMutation(smallVolumeConf).build());
        }

        /**
         * <p>
         * Small volume maximum size.
         * </p>
         * 
         * @param smallVolumeMaxSize
         *        Small volume maximum size.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder smallVolumeMaxSize(Long smallVolumeMaxSize);

        /**
         * <p>
         * Target instance type right-sizing method.
         * </p>
         * 
         * @param targetInstanceTypeRightSizingMethod
         *        Target instance type right-sizing method.
         * @see TargetInstanceTypeRightSizingMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetInstanceTypeRightSizingMethod
         */
        Builder targetInstanceTypeRightSizingMethod(String targetInstanceTypeRightSizingMethod);

        /**
         * <p>
         * Target instance type right-sizing method.
         * </p>
         * 
         * @param targetInstanceTypeRightSizingMethod
         *        Target instance type right-sizing method.
         * @see TargetInstanceTypeRightSizingMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetInstanceTypeRightSizingMethod
         */
        Builder targetInstanceTypeRightSizingMethod(TargetInstanceTypeRightSizingMethod targetInstanceTypeRightSizingMethod);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MgnRequest.BuilderImpl implements Builder {
        private Boolean associatePublicIpAddress;

        private String bootMode;

        private Boolean copyPrivateIp;

        private Boolean copyTags;

        private Boolean enableMapAutoTagging;

        private LaunchTemplateDiskConf largeVolumeConf;

        private String launchConfigurationTemplateID;

        private String launchDisposition;

        private Licensing licensing;

        private String mapAutoTaggingMpeID;

        private PostLaunchActions postLaunchActions;

        private LaunchTemplateDiskConf smallVolumeConf;

        private Long smallVolumeMaxSize;

        private String targetInstanceTypeRightSizingMethod;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateLaunchConfigurationTemplateRequest model) {
            super(model);
            associatePublicIpAddress(model.associatePublicIpAddress);
            bootMode(model.bootMode);
            copyPrivateIp(model.copyPrivateIp);
            copyTags(model.copyTags);
            enableMapAutoTagging(model.enableMapAutoTagging);
            largeVolumeConf(model.largeVolumeConf);
            launchConfigurationTemplateID(model.launchConfigurationTemplateID);
            launchDisposition(model.launchDisposition);
            licensing(model.licensing);
            mapAutoTaggingMpeID(model.mapAutoTaggingMpeID);
            postLaunchActions(model.postLaunchActions);
            smallVolumeConf(model.smallVolumeConf);
            smallVolumeMaxSize(model.smallVolumeMaxSize);
            targetInstanceTypeRightSizingMethod(model.targetInstanceTypeRightSizingMethod);
        }

        public final Boolean getAssociatePublicIpAddress() {
            return associatePublicIpAddress;
        }

        public final void setAssociatePublicIpAddress(Boolean associatePublicIpAddress) {
            this.associatePublicIpAddress = associatePublicIpAddress;
        }

        @Override
        public final Builder associatePublicIpAddress(Boolean associatePublicIpAddress) {
            this.associatePublicIpAddress = associatePublicIpAddress;
            return this;
        }

        public final String getBootMode() {
            return bootMode;
        }

        public final void setBootMode(String bootMode) {
            this.bootMode = bootMode;
        }

        @Override
        public final Builder bootMode(String bootMode) {
            this.bootMode = bootMode;
            return this;
        }

        @Override
        public final Builder bootMode(BootMode bootMode) {
            this.bootMode(bootMode == null ? null : bootMode.toString());
            return this;
        }

        public final Boolean getCopyPrivateIp() {
            return copyPrivateIp;
        }

        public final void setCopyPrivateIp(Boolean copyPrivateIp) {
            this.copyPrivateIp = copyPrivateIp;
        }

        @Override
        public final Builder copyPrivateIp(Boolean copyPrivateIp) {
            this.copyPrivateIp = copyPrivateIp;
            return this;
        }

        public final Boolean getCopyTags() {
            return copyTags;
        }

        public final void setCopyTags(Boolean copyTags) {
            this.copyTags = copyTags;
        }

        @Override
        public final Builder copyTags(Boolean copyTags) {
            this.copyTags = copyTags;
            return this;
        }

        public final Boolean getEnableMapAutoTagging() {
            return enableMapAutoTagging;
        }

        public final void setEnableMapAutoTagging(Boolean enableMapAutoTagging) {
            this.enableMapAutoTagging = enableMapAutoTagging;
        }

        @Override
        public final Builder enableMapAutoTagging(Boolean enableMapAutoTagging) {
            this.enableMapAutoTagging = enableMapAutoTagging;
            return this;
        }

        public final LaunchTemplateDiskConf.Builder getLargeVolumeConf() {
            return largeVolumeConf != null ? largeVolumeConf.toBuilder() : null;
        }

        public final void setLargeVolumeConf(LaunchTemplateDiskConf.BuilderImpl largeVolumeConf) {
            this.largeVolumeConf = largeVolumeConf != null ? largeVolumeConf.build() : null;
        }

        @Override
        public final Builder largeVolumeConf(LaunchTemplateDiskConf largeVolumeConf) {
            this.largeVolumeConf = largeVolumeConf;
            return this;
        }

        public final String getLaunchConfigurationTemplateID() {
            return launchConfigurationTemplateID;
        }

        public final void setLaunchConfigurationTemplateID(String launchConfigurationTemplateID) {
            this.launchConfigurationTemplateID = launchConfigurationTemplateID;
        }

        @Override
        public final Builder launchConfigurationTemplateID(String launchConfigurationTemplateID) {
            this.launchConfigurationTemplateID = launchConfigurationTemplateID;
            return this;
        }

        public final String getLaunchDisposition() {
            return launchDisposition;
        }

        public final void setLaunchDisposition(String launchDisposition) {
            this.launchDisposition = launchDisposition;
        }

        @Override
        public final Builder launchDisposition(String launchDisposition) {
            this.launchDisposition = launchDisposition;
            return this;
        }

        @Override
        public final Builder launchDisposition(LaunchDisposition launchDisposition) {
            this.launchDisposition(launchDisposition == null ? null : launchDisposition.toString());
            return this;
        }

        public final Licensing.Builder getLicensing() {
            return licensing != null ? licensing.toBuilder() : null;
        }

        public final void setLicensing(Licensing.BuilderImpl licensing) {
            this.licensing = licensing != null ? licensing.build() : null;
        }

        @Override
        public final Builder licensing(Licensing licensing) {
            this.licensing = licensing;
            return this;
        }

        public final String getMapAutoTaggingMpeID() {
            return mapAutoTaggingMpeID;
        }

        public final void setMapAutoTaggingMpeID(String mapAutoTaggingMpeID) {
            this.mapAutoTaggingMpeID = mapAutoTaggingMpeID;
        }

        @Override
        public final Builder mapAutoTaggingMpeID(String mapAutoTaggingMpeID) {
            this.mapAutoTaggingMpeID = mapAutoTaggingMpeID;
            return this;
        }

        public final PostLaunchActions.Builder getPostLaunchActions() {
            return postLaunchActions != null ? postLaunchActions.toBuilder() : null;
        }

        public final void setPostLaunchActions(PostLaunchActions.BuilderImpl postLaunchActions) {
            this.postLaunchActions = postLaunchActions != null ? postLaunchActions.build() : null;
        }

        @Override
        public final Builder postLaunchActions(PostLaunchActions postLaunchActions) {
            this.postLaunchActions = postLaunchActions;
            return this;
        }

        public final LaunchTemplateDiskConf.Builder getSmallVolumeConf() {
            return smallVolumeConf != null ? smallVolumeConf.toBuilder() : null;
        }

        public final void setSmallVolumeConf(LaunchTemplateDiskConf.BuilderImpl smallVolumeConf) {
            this.smallVolumeConf = smallVolumeConf != null ? smallVolumeConf.build() : null;
        }

        @Override
        public final Builder smallVolumeConf(LaunchTemplateDiskConf smallVolumeConf) {
            this.smallVolumeConf = smallVolumeConf;
            return this;
        }

        public final Long getSmallVolumeMaxSize() {
            return smallVolumeMaxSize;
        }

        public final void setSmallVolumeMaxSize(Long smallVolumeMaxSize) {
            this.smallVolumeMaxSize = smallVolumeMaxSize;
        }

        @Override
        public final Builder smallVolumeMaxSize(Long smallVolumeMaxSize) {
            this.smallVolumeMaxSize = smallVolumeMaxSize;
            return this;
        }

        public final String getTargetInstanceTypeRightSizingMethod() {
            return targetInstanceTypeRightSizingMethod;
        }

        public final void setTargetInstanceTypeRightSizingMethod(String targetInstanceTypeRightSizingMethod) {
            this.targetInstanceTypeRightSizingMethod = targetInstanceTypeRightSizingMethod;
        }

        @Override
        public final Builder targetInstanceTypeRightSizingMethod(String targetInstanceTypeRightSizingMethod) {
            this.targetInstanceTypeRightSizingMethod = targetInstanceTypeRightSizingMethod;
            return this;
        }

        @Override
        public final Builder targetInstanceTypeRightSizingMethod(
                TargetInstanceTypeRightSizingMethod targetInstanceTypeRightSizingMethod) {
            this.targetInstanceTypeRightSizingMethod(targetInstanceTypeRightSizingMethod == null ? null
                    : targetInstanceTypeRightSizingMethod.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateLaunchConfigurationTemplateRequest build() {
            return new UpdateLaunchConfigurationTemplateRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
