/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mgn.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateWaveResponse extends MgnResponse implements
        ToCopyableBuilder<UpdateWaveResponse.Builder, UpdateWaveResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(UpdateWaveResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> CREATION_DATE_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("creationDateTime").getter(getter(UpdateWaveResponse::creationDateTime))
            .setter(setter(Builder::creationDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDateTime").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(UpdateWaveResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Boolean> IS_ARCHIVED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isArchived").getter(getter(UpdateWaveResponse::isArchived)).setter(setter(Builder::isArchived))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isArchived").build()).build();

    private static final SdkField<String> LAST_MODIFIED_DATE_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lastModifiedDateTime").getter(getter(UpdateWaveResponse::lastModifiedDateTime))
            .setter(setter(Builder::lastModifiedDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedDateTime").build())
            .build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(UpdateWaveResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(UpdateWaveResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<WaveAggregatedStatus> WAVE_AGGREGATED_STATUS_FIELD = SdkField
            .<WaveAggregatedStatus> builder(MarshallingType.SDK_POJO).memberName("waveAggregatedStatus")
            .getter(getter(UpdateWaveResponse::waveAggregatedStatus)).setter(setter(Builder::waveAggregatedStatus))
            .constructor(WaveAggregatedStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("waveAggregatedStatus").build())
            .build();

    private static final SdkField<String> WAVE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("waveID")
            .getter(getter(UpdateWaveResponse::waveID)).setter(setter(Builder::waveID))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("waveID").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            CREATION_DATE_TIME_FIELD, DESCRIPTION_FIELD, IS_ARCHIVED_FIELD, LAST_MODIFIED_DATE_TIME_FIELD, NAME_FIELD,
            TAGS_FIELD, WAVE_AGGREGATED_STATUS_FIELD, WAVE_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String arn;

    private final String creationDateTime;

    private final String description;

    private final Boolean isArchived;

    private final String lastModifiedDateTime;

    private final String name;

    private final Map<String, String> tags;

    private final WaveAggregatedStatus waveAggregatedStatus;

    private final String waveID;

    private UpdateWaveResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.creationDateTime = builder.creationDateTime;
        this.description = builder.description;
        this.isArchived = builder.isArchived;
        this.lastModifiedDateTime = builder.lastModifiedDateTime;
        this.name = builder.name;
        this.tags = builder.tags;
        this.waveAggregatedStatus = builder.waveAggregatedStatus;
        this.waveID = builder.waveID;
    }

    /**
     * <p>
     * Wave ARN.
     * </p>
     * 
     * @return Wave ARN.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * Wave creation dateTime.
     * </p>
     * 
     * @return Wave creation dateTime.
     */
    public final String creationDateTime() {
        return creationDateTime;
    }

    /**
     * <p>
     * Wave description.
     * </p>
     * 
     * @return Wave description.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Wave archival status.
     * </p>
     * 
     * @return Wave archival status.
     */
    public final Boolean isArchived() {
        return isArchived;
    }

    /**
     * <p>
     * Wave last modified dateTime.
     * </p>
     * 
     * @return Wave last modified dateTime.
     */
    public final String lastModifiedDateTime() {
        return lastModifiedDateTime;
    }

    /**
     * <p>
     * Wave name.
     * </p>
     * 
     * @return Wave name.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Wave tags.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Wave tags.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * Wave aggregated status.
     * </p>
     * 
     * @return Wave aggregated status.
     */
    public final WaveAggregatedStatus waveAggregatedStatus() {
        return waveAggregatedStatus;
    }

    /**
     * <p>
     * Wave ID.
     * </p>
     * 
     * @return Wave ID.
     */
    public final String waveID() {
        return waveID;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(isArchived());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(waveAggregatedStatus());
        hashCode = 31 * hashCode + Objects.hashCode(waveID());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateWaveResponse)) {
            return false;
        }
        UpdateWaveResponse other = (UpdateWaveResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(creationDateTime(), other.creationDateTime())
                && Objects.equals(description(), other.description()) && Objects.equals(isArchived(), other.isArchived())
                && Objects.equals(lastModifiedDateTime(), other.lastModifiedDateTime()) && Objects.equals(name(), other.name())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(waveAggregatedStatus(), other.waveAggregatedStatus())
                && Objects.equals(waveID(), other.waveID());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateWaveResponse").add("Arn", arn()).add("CreationDateTime", creationDateTime())
                .add("Description", description()).add("IsArchived", isArchived())
                .add("LastModifiedDateTime", lastModifiedDateTime()).add("Name", name())
                .add("Tags", tags() == null ? null : "*** Sensitive Data Redacted ***")
                .add("WaveAggregatedStatus", waveAggregatedStatus()).add("WaveID", waveID()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "creationDateTime":
            return Optional.ofNullable(clazz.cast(creationDateTime()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "isArchived":
            return Optional.ofNullable(clazz.cast(isArchived()));
        case "lastModifiedDateTime":
            return Optional.ofNullable(clazz.cast(lastModifiedDateTime()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "waveAggregatedStatus":
            return Optional.ofNullable(clazz.cast(waveAggregatedStatus()));
        case "waveID":
            return Optional.ofNullable(clazz.cast(waveID()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("arn", ARN_FIELD);
        map.put("creationDateTime", CREATION_DATE_TIME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("isArchived", IS_ARCHIVED_FIELD);
        map.put("lastModifiedDateTime", LAST_MODIFIED_DATE_TIME_FIELD);
        map.put("name", NAME_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("waveAggregatedStatus", WAVE_AGGREGATED_STATUS_FIELD);
        map.put("waveID", WAVE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateWaveResponse, T> g) {
        return obj -> g.apply((UpdateWaveResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MgnResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateWaveResponse> {
        /**
         * <p>
         * Wave ARN.
         * </p>
         * 
         * @param arn
         *        Wave ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * Wave creation dateTime.
         * </p>
         * 
         * @param creationDateTime
         *        Wave creation dateTime.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDateTime(String creationDateTime);

        /**
         * <p>
         * Wave description.
         * </p>
         * 
         * @param description
         *        Wave description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Wave archival status.
         * </p>
         * 
         * @param isArchived
         *        Wave archival status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isArchived(Boolean isArchived);

        /**
         * <p>
         * Wave last modified dateTime.
         * </p>
         * 
         * @param lastModifiedDateTime
         *        Wave last modified dateTime.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedDateTime(String lastModifiedDateTime);

        /**
         * <p>
         * Wave name.
         * </p>
         * 
         * @param name
         *        Wave name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Wave tags.
         * </p>
         * 
         * @param tags
         *        Wave tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * Wave aggregated status.
         * </p>
         * 
         * @param waveAggregatedStatus
         *        Wave aggregated status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder waveAggregatedStatus(WaveAggregatedStatus waveAggregatedStatus);

        /**
         * <p>
         * Wave aggregated status.
         * </p>
         * This is a convenience method that creates an instance of the {@link WaveAggregatedStatus.Builder} avoiding
         * the need to create one manually via {@link WaveAggregatedStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WaveAggregatedStatus.Builder#build()} is called immediately and
         * its result is passed to {@link #waveAggregatedStatus(WaveAggregatedStatus)}.
         * 
         * @param waveAggregatedStatus
         *        a consumer that will call methods on {@link WaveAggregatedStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #waveAggregatedStatus(WaveAggregatedStatus)
         */
        default Builder waveAggregatedStatus(Consumer<WaveAggregatedStatus.Builder> waveAggregatedStatus) {
            return waveAggregatedStatus(WaveAggregatedStatus.builder().applyMutation(waveAggregatedStatus).build());
        }

        /**
         * <p>
         * Wave ID.
         * </p>
         * 
         * @param waveID
         *        Wave ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder waveID(String waveID);
    }

    static final class BuilderImpl extends MgnResponse.BuilderImpl implements Builder {
        private String arn;

        private String creationDateTime;

        private String description;

        private Boolean isArchived;

        private String lastModifiedDateTime;

        private String name;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private WaveAggregatedStatus waveAggregatedStatus;

        private String waveID;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateWaveResponse model) {
            super(model);
            arn(model.arn);
            creationDateTime(model.creationDateTime);
            description(model.description);
            isArchived(model.isArchived);
            lastModifiedDateTime(model.lastModifiedDateTime);
            name(model.name);
            tags(model.tags);
            waveAggregatedStatus(model.waveAggregatedStatus);
            waveID(model.waveID);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getCreationDateTime() {
            return creationDateTime;
        }

        public final void setCreationDateTime(String creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        @Override
        public final Builder creationDateTime(String creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Boolean getIsArchived() {
            return isArchived;
        }

        public final void setIsArchived(Boolean isArchived) {
            this.isArchived = isArchived;
        }

        @Override
        public final Builder isArchived(Boolean isArchived) {
            this.isArchived = isArchived;
            return this;
        }

        public final String getLastModifiedDateTime() {
            return lastModifiedDateTime;
        }

        public final void setLastModifiedDateTime(String lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
        }

        @Override
        public final Builder lastModifiedDateTime(String lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        public final WaveAggregatedStatus.Builder getWaveAggregatedStatus() {
            return waveAggregatedStatus != null ? waveAggregatedStatus.toBuilder() : null;
        }

        public final void setWaveAggregatedStatus(WaveAggregatedStatus.BuilderImpl waveAggregatedStatus) {
            this.waveAggregatedStatus = waveAggregatedStatus != null ? waveAggregatedStatus.build() : null;
        }

        @Override
        public final Builder waveAggregatedStatus(WaveAggregatedStatus waveAggregatedStatus) {
            this.waveAggregatedStatus = waveAggregatedStatus;
            return this;
        }

        public final String getWaveID() {
            return waveID;
        }

        public final void setWaveID(String waveID) {
            this.waveID = waveID;
        }

        @Override
        public final Builder waveID(String waveID) {
            this.waveID = waveID;
            return this;
        }

        @Override
        public UpdateWaveResponse build() {
            return new UpdateWaveResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
