/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mgn.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * vCenter client.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VcenterClient implements SdkPojo, Serializable, ToCopyableBuilder<VcenterClient.Builder, VcenterClient> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(VcenterClient::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> DATACENTER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("datacenterName").getter(getter(VcenterClient::datacenterName)).setter(setter(Builder::datacenterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datacenterName").build()).build();

    private static final SdkField<String> HOSTNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("hostname").getter(getter(VcenterClient::hostname)).setter(setter(Builder::hostname))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hostname").build()).build();

    private static final SdkField<String> LAST_SEEN_DATETIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lastSeenDatetime").getter(getter(VcenterClient::lastSeenDatetime))
            .setter(setter(Builder::lastSeenDatetime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastSeenDatetime").build()).build();

    private static final SdkField<Map<String, String>> SOURCE_SERVER_TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("sourceServerTags")
            .getter(getter(VcenterClient::sourceServerTags))
            .setter(setter(Builder::sourceServerTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceServerTags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(VcenterClient::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> VCENTER_CLIENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("vcenterClientID").getter(getter(VcenterClient::vcenterClientID))
            .setter(setter(Builder::vcenterClientID))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vcenterClientID").build()).build();

    private static final SdkField<String> VCENTER_UUID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("vcenterUUID").getter(getter(VcenterClient::vcenterUUID)).setter(setter(Builder::vcenterUUID))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vcenterUUID").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            DATACENTER_NAME_FIELD, HOSTNAME_FIELD, LAST_SEEN_DATETIME_FIELD, SOURCE_SERVER_TAGS_FIELD, TAGS_FIELD,
            VCENTER_CLIENT_ID_FIELD, VCENTER_UUID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String datacenterName;

    private final String hostname;

    private final String lastSeenDatetime;

    private final Map<String, String> sourceServerTags;

    private final Map<String, String> tags;

    private final String vcenterClientID;

    private final String vcenterUUID;

    private VcenterClient(BuilderImpl builder) {
        this.arn = builder.arn;
        this.datacenterName = builder.datacenterName;
        this.hostname = builder.hostname;
        this.lastSeenDatetime = builder.lastSeenDatetime;
        this.sourceServerTags = builder.sourceServerTags;
        this.tags = builder.tags;
        this.vcenterClientID = builder.vcenterClientID;
        this.vcenterUUID = builder.vcenterUUID;
    }

    /**
     * <p>
     * Arn of vCenter client.
     * </p>
     * 
     * @return Arn of vCenter client.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * Datacenter name of vCenter client.
     * </p>
     * 
     * @return Datacenter name of vCenter client.
     */
    public final String datacenterName() {
        return datacenterName;
    }

    /**
     * <p>
     * Hostname of vCenter client .
     * </p>
     * 
     * @return Hostname of vCenter client .
     */
    public final String hostname() {
        return hostname;
    }

    /**
     * <p>
     * Last seen time of vCenter client.
     * </p>
     * 
     * @return Last seen time of vCenter client.
     */
    public final String lastSeenDatetime() {
        return lastSeenDatetime;
    }

    /**
     * For responses, this returns true if the service returned a value for the SourceServerTags property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSourceServerTags() {
        return sourceServerTags != null && !(sourceServerTags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Tags for Source Server of vCenter client.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSourceServerTags} method.
     * </p>
     * 
     * @return Tags for Source Server of vCenter client.
     */
    public final Map<String, String> sourceServerTags() {
        return sourceServerTags;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Tags for vCenter client.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Tags for vCenter client.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * ID of vCenter client.
     * </p>
     * 
     * @return ID of vCenter client.
     */
    public final String vcenterClientID() {
        return vcenterClientID;
    }

    /**
     * <p>
     * Vcenter UUID of vCenter client.
     * </p>
     * 
     * @return Vcenter UUID of vCenter client.
     */
    public final String vcenterUUID() {
        return vcenterUUID;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(datacenterName());
        hashCode = 31 * hashCode + Objects.hashCode(hostname());
        hashCode = 31 * hashCode + Objects.hashCode(lastSeenDatetime());
        hashCode = 31 * hashCode + Objects.hashCode(hasSourceServerTags() ? sourceServerTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(vcenterClientID());
        hashCode = 31 * hashCode + Objects.hashCode(vcenterUUID());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VcenterClient)) {
            return false;
        }
        VcenterClient other = (VcenterClient) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(datacenterName(), other.datacenterName())
                && Objects.equals(hostname(), other.hostname()) && Objects.equals(lastSeenDatetime(), other.lastSeenDatetime())
                && hasSourceServerTags() == other.hasSourceServerTags()
                && Objects.equals(sourceServerTags(), other.sourceServerTags()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(vcenterClientID(), other.vcenterClientID())
                && Objects.equals(vcenterUUID(), other.vcenterUUID());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VcenterClient").add("Arn", arn()).add("DatacenterName", datacenterName())
                .add("Hostname", hostname()).add("LastSeenDatetime", lastSeenDatetime())
                .add("SourceServerTags", sourceServerTags() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Tags", tags() == null ? null : "*** Sensitive Data Redacted ***").add("VcenterClientID", vcenterClientID())
                .add("VcenterUUID", vcenterUUID()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "datacenterName":
            return Optional.ofNullable(clazz.cast(datacenterName()));
        case "hostname":
            return Optional.ofNullable(clazz.cast(hostname()));
        case "lastSeenDatetime":
            return Optional.ofNullable(clazz.cast(lastSeenDatetime()));
        case "sourceServerTags":
            return Optional.ofNullable(clazz.cast(sourceServerTags()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "vcenterClientID":
            return Optional.ofNullable(clazz.cast(vcenterClientID()));
        case "vcenterUUID":
            return Optional.ofNullable(clazz.cast(vcenterUUID()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("arn", ARN_FIELD);
        map.put("datacenterName", DATACENTER_NAME_FIELD);
        map.put("hostname", HOSTNAME_FIELD);
        map.put("lastSeenDatetime", LAST_SEEN_DATETIME_FIELD);
        map.put("sourceServerTags", SOURCE_SERVER_TAGS_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("vcenterClientID", VCENTER_CLIENT_ID_FIELD);
        map.put("vcenterUUID", VCENTER_UUID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VcenterClient, T> g) {
        return obj -> g.apply((VcenterClient) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VcenterClient> {
        /**
         * <p>
         * Arn of vCenter client.
         * </p>
         * 
         * @param arn
         *        Arn of vCenter client.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * Datacenter name of vCenter client.
         * </p>
         * 
         * @param datacenterName
         *        Datacenter name of vCenter client.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datacenterName(String datacenterName);

        /**
         * <p>
         * Hostname of vCenter client .
         * </p>
         * 
         * @param hostname
         *        Hostname of vCenter client .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostname(String hostname);

        /**
         * <p>
         * Last seen time of vCenter client.
         * </p>
         * 
         * @param lastSeenDatetime
         *        Last seen time of vCenter client.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastSeenDatetime(String lastSeenDatetime);

        /**
         * <p>
         * Tags for Source Server of vCenter client.
         * </p>
         * 
         * @param sourceServerTags
         *        Tags for Source Server of vCenter client.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceServerTags(Map<String, String> sourceServerTags);

        /**
         * <p>
         * Tags for vCenter client.
         * </p>
         * 
         * @param tags
         *        Tags for vCenter client.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * ID of vCenter client.
         * </p>
         * 
         * @param vcenterClientID
         *        ID of vCenter client.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vcenterClientID(String vcenterClientID);

        /**
         * <p>
         * Vcenter UUID of vCenter client.
         * </p>
         * 
         * @param vcenterUUID
         *        Vcenter UUID of vCenter client.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vcenterUUID(String vcenterUUID);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String datacenterName;

        private String hostname;

        private String lastSeenDatetime;

        private Map<String, String> sourceServerTags = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String vcenterClientID;

        private String vcenterUUID;

        private BuilderImpl() {
        }

        private BuilderImpl(VcenterClient model) {
            arn(model.arn);
            datacenterName(model.datacenterName);
            hostname(model.hostname);
            lastSeenDatetime(model.lastSeenDatetime);
            sourceServerTags(model.sourceServerTags);
            tags(model.tags);
            vcenterClientID(model.vcenterClientID);
            vcenterUUID(model.vcenterUUID);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getDatacenterName() {
            return datacenterName;
        }

        public final void setDatacenterName(String datacenterName) {
            this.datacenterName = datacenterName;
        }

        @Override
        public final Builder datacenterName(String datacenterName) {
            this.datacenterName = datacenterName;
            return this;
        }

        public final String getHostname() {
            return hostname;
        }

        public final void setHostname(String hostname) {
            this.hostname = hostname;
        }

        @Override
        public final Builder hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public final String getLastSeenDatetime() {
            return lastSeenDatetime;
        }

        public final void setLastSeenDatetime(String lastSeenDatetime) {
            this.lastSeenDatetime = lastSeenDatetime;
        }

        @Override
        public final Builder lastSeenDatetime(String lastSeenDatetime) {
            this.lastSeenDatetime = lastSeenDatetime;
            return this;
        }

        public final Map<String, String> getSourceServerTags() {
            if (sourceServerTags instanceof SdkAutoConstructMap) {
                return null;
            }
            return sourceServerTags;
        }

        public final void setSourceServerTags(Map<String, String> sourceServerTags) {
            this.sourceServerTags = TagsMapCopier.copy(sourceServerTags);
        }

        @Override
        public final Builder sourceServerTags(Map<String, String> sourceServerTags) {
            this.sourceServerTags = TagsMapCopier.copy(sourceServerTags);
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        public final String getVcenterClientID() {
            return vcenterClientID;
        }

        public final void setVcenterClientID(String vcenterClientID) {
            this.vcenterClientID = vcenterClientID;
        }

        @Override
        public final Builder vcenterClientID(String vcenterClientID) {
            this.vcenterClientID = vcenterClientID;
            return this;
        }

        public final String getVcenterUUID() {
            return vcenterUUID;
        }

        public final void setVcenterUUID(String vcenterUUID) {
            this.vcenterUUID = vcenterUUID;
        }

        @Override
        public final Builder vcenterUUID(String vcenterUUID) {
            this.vcenterUUID = vcenterUUID;
            return this;
        }

        @Override
        public VcenterClient build() {
            return new VcenterClient(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
