/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mgn.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Wave aggregated status.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WaveAggregatedStatus implements SdkPojo, Serializable,
        ToCopyableBuilder<WaveAggregatedStatus.Builder, WaveAggregatedStatus> {
    private static final SdkField<String> HEALTH_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("healthStatus").getter(getter(WaveAggregatedStatus::healthStatusAsString))
            .setter(setter(Builder::healthStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("healthStatus").build()).build();

    private static final SdkField<String> LAST_UPDATE_DATE_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lastUpdateDateTime").getter(getter(WaveAggregatedStatus::lastUpdateDateTime))
            .setter(setter(Builder::lastUpdateDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdateDateTime").build())
            .build();

    private static final SdkField<String> PROGRESS_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("progressStatus").getter(getter(WaveAggregatedStatus::progressStatusAsString))
            .setter(setter(Builder::progressStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("progressStatus").build()).build();

    private static final SdkField<String> REPLICATION_STARTED_DATE_TIME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("replicationStartedDateTime")
            .getter(getter(WaveAggregatedStatus::replicationStartedDateTime))
            .setter(setter(Builder::replicationStartedDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicationStartedDateTime").build())
            .build();

    private static final SdkField<Long> TOTAL_APPLICATIONS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("totalApplications").getter(getter(WaveAggregatedStatus::totalApplications))
            .setter(setter(Builder::totalApplications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalApplications").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HEALTH_STATUS_FIELD,
            LAST_UPDATE_DATE_TIME_FIELD, PROGRESS_STATUS_FIELD, REPLICATION_STARTED_DATE_TIME_FIELD, TOTAL_APPLICATIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String healthStatus;

    private final String lastUpdateDateTime;

    private final String progressStatus;

    private final String replicationStartedDateTime;

    private final Long totalApplications;

    private WaveAggregatedStatus(BuilderImpl builder) {
        this.healthStatus = builder.healthStatus;
        this.lastUpdateDateTime = builder.lastUpdateDateTime;
        this.progressStatus = builder.progressStatus;
        this.replicationStartedDateTime = builder.replicationStartedDateTime;
        this.totalApplications = builder.totalApplications;
    }

    /**
     * <p>
     * Wave aggregated status health status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #healthStatus} will
     * return {@link WaveHealthStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #healthStatusAsString}.
     * </p>
     * 
     * @return Wave aggregated status health status.
     * @see WaveHealthStatus
     */
    public final WaveHealthStatus healthStatus() {
        return WaveHealthStatus.fromValue(healthStatus);
    }

    /**
     * <p>
     * Wave aggregated status health status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #healthStatus} will
     * return {@link WaveHealthStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #healthStatusAsString}.
     * </p>
     * 
     * @return Wave aggregated status health status.
     * @see WaveHealthStatus
     */
    public final String healthStatusAsString() {
        return healthStatus;
    }

    /**
     * <p>
     * Wave aggregated status last update dateTime.
     * </p>
     * 
     * @return Wave aggregated status last update dateTime.
     */
    public final String lastUpdateDateTime() {
        return lastUpdateDateTime;
    }

    /**
     * <p>
     * Wave aggregated status progress status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #progressStatus}
     * will return {@link WaveProgressStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #progressStatusAsString}.
     * </p>
     * 
     * @return Wave aggregated status progress status.
     * @see WaveProgressStatus
     */
    public final WaveProgressStatus progressStatus() {
        return WaveProgressStatus.fromValue(progressStatus);
    }

    /**
     * <p>
     * Wave aggregated status progress status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #progressStatus}
     * will return {@link WaveProgressStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #progressStatusAsString}.
     * </p>
     * 
     * @return Wave aggregated status progress status.
     * @see WaveProgressStatus
     */
    public final String progressStatusAsString() {
        return progressStatus;
    }

    /**
     * <p>
     * DateTime marking when the first source server in the wave started replication.
     * </p>
     * 
     * @return DateTime marking when the first source server in the wave started replication.
     */
    public final String replicationStartedDateTime() {
        return replicationStartedDateTime;
    }

    /**
     * <p>
     * Wave aggregated status total applications amount.
     * </p>
     * 
     * @return Wave aggregated status total applications amount.
     */
    public final Long totalApplications() {
        return totalApplications;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(healthStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdateDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(progressStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(replicationStartedDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(totalApplications());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WaveAggregatedStatus)) {
            return false;
        }
        WaveAggregatedStatus other = (WaveAggregatedStatus) obj;
        return Objects.equals(healthStatusAsString(), other.healthStatusAsString())
                && Objects.equals(lastUpdateDateTime(), other.lastUpdateDateTime())
                && Objects.equals(progressStatusAsString(), other.progressStatusAsString())
                && Objects.equals(replicationStartedDateTime(), other.replicationStartedDateTime())
                && Objects.equals(totalApplications(), other.totalApplications());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WaveAggregatedStatus").add("HealthStatus", healthStatusAsString())
                .add("LastUpdateDateTime", lastUpdateDateTime()).add("ProgressStatus", progressStatusAsString())
                .add("ReplicationStartedDateTime", replicationStartedDateTime()).add("TotalApplications", totalApplications())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "healthStatus":
            return Optional.ofNullable(clazz.cast(healthStatusAsString()));
        case "lastUpdateDateTime":
            return Optional.ofNullable(clazz.cast(lastUpdateDateTime()));
        case "progressStatus":
            return Optional.ofNullable(clazz.cast(progressStatusAsString()));
        case "replicationStartedDateTime":
            return Optional.ofNullable(clazz.cast(replicationStartedDateTime()));
        case "totalApplications":
            return Optional.ofNullable(clazz.cast(totalApplications()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("healthStatus", HEALTH_STATUS_FIELD);
        map.put("lastUpdateDateTime", LAST_UPDATE_DATE_TIME_FIELD);
        map.put("progressStatus", PROGRESS_STATUS_FIELD);
        map.put("replicationStartedDateTime", REPLICATION_STARTED_DATE_TIME_FIELD);
        map.put("totalApplications", TOTAL_APPLICATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WaveAggregatedStatus, T> g) {
        return obj -> g.apply((WaveAggregatedStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WaveAggregatedStatus> {
        /**
         * <p>
         * Wave aggregated status health status.
         * </p>
         * 
         * @param healthStatus
         *        Wave aggregated status health status.
         * @see WaveHealthStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WaveHealthStatus
         */
        Builder healthStatus(String healthStatus);

        /**
         * <p>
         * Wave aggregated status health status.
         * </p>
         * 
         * @param healthStatus
         *        Wave aggregated status health status.
         * @see WaveHealthStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WaveHealthStatus
         */
        Builder healthStatus(WaveHealthStatus healthStatus);

        /**
         * <p>
         * Wave aggregated status last update dateTime.
         * </p>
         * 
         * @param lastUpdateDateTime
         *        Wave aggregated status last update dateTime.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdateDateTime(String lastUpdateDateTime);

        /**
         * <p>
         * Wave aggregated status progress status.
         * </p>
         * 
         * @param progressStatus
         *        Wave aggregated status progress status.
         * @see WaveProgressStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WaveProgressStatus
         */
        Builder progressStatus(String progressStatus);

        /**
         * <p>
         * Wave aggregated status progress status.
         * </p>
         * 
         * @param progressStatus
         *        Wave aggregated status progress status.
         * @see WaveProgressStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WaveProgressStatus
         */
        Builder progressStatus(WaveProgressStatus progressStatus);

        /**
         * <p>
         * DateTime marking when the first source server in the wave started replication.
         * </p>
         * 
         * @param replicationStartedDateTime
         *        DateTime marking when the first source server in the wave started replication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationStartedDateTime(String replicationStartedDateTime);

        /**
         * <p>
         * Wave aggregated status total applications amount.
         * </p>
         * 
         * @param totalApplications
         *        Wave aggregated status total applications amount.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalApplications(Long totalApplications);
    }

    static final class BuilderImpl implements Builder {
        private String healthStatus;

        private String lastUpdateDateTime;

        private String progressStatus;

        private String replicationStartedDateTime;

        private Long totalApplications;

        private BuilderImpl() {
        }

        private BuilderImpl(WaveAggregatedStatus model) {
            healthStatus(model.healthStatus);
            lastUpdateDateTime(model.lastUpdateDateTime);
            progressStatus(model.progressStatus);
            replicationStartedDateTime(model.replicationStartedDateTime);
            totalApplications(model.totalApplications);
        }

        public final String getHealthStatus() {
            return healthStatus;
        }

        public final void setHealthStatus(String healthStatus) {
            this.healthStatus = healthStatus;
        }

        @Override
        public final Builder healthStatus(String healthStatus) {
            this.healthStatus = healthStatus;
            return this;
        }

        @Override
        public final Builder healthStatus(WaveHealthStatus healthStatus) {
            this.healthStatus(healthStatus == null ? null : healthStatus.toString());
            return this;
        }

        public final String getLastUpdateDateTime() {
            return lastUpdateDateTime;
        }

        public final void setLastUpdateDateTime(String lastUpdateDateTime) {
            this.lastUpdateDateTime = lastUpdateDateTime;
        }

        @Override
        public final Builder lastUpdateDateTime(String lastUpdateDateTime) {
            this.lastUpdateDateTime = lastUpdateDateTime;
            return this;
        }

        public final String getProgressStatus() {
            return progressStatus;
        }

        public final void setProgressStatus(String progressStatus) {
            this.progressStatus = progressStatus;
        }

        @Override
        public final Builder progressStatus(String progressStatus) {
            this.progressStatus = progressStatus;
            return this;
        }

        @Override
        public final Builder progressStatus(WaveProgressStatus progressStatus) {
            this.progressStatus(progressStatus == null ? null : progressStatus.toString());
            return this;
        }

        public final String getReplicationStartedDateTime() {
            return replicationStartedDateTime;
        }

        public final void setReplicationStartedDateTime(String replicationStartedDateTime) {
            this.replicationStartedDateTime = replicationStartedDateTime;
        }

        @Override
        public final Builder replicationStartedDateTime(String replicationStartedDateTime) {
            this.replicationStartedDateTime = replicationStartedDateTime;
            return this;
        }

        public final Long getTotalApplications() {
            return totalApplications;
        }

        public final void setTotalApplications(Long totalApplications) {
            this.totalApplications = totalApplications;
        }

        @Override
        public final Builder totalApplications(Long totalApplications) {
            this.totalApplications = totalApplications;
            return this;
        }

        @Override
        public WaveAggregatedStatus build() {
            return new WaveAggregatedStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
