/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mgn.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mgn.model.MgnRequest;
import software.amazon.awssdk.services.mgn.model.SourceServerConnectorAction;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateSourceServerRequest
extends MgnRequest
implements ToCopyableBuilder<Builder, UpdateSourceServerRequest> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accountID").getter(UpdateSourceServerRequest.getter(UpdateSourceServerRequest::accountID)).setter(UpdateSourceServerRequest.setter(Builder::accountID)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountID").build()}).build();
    private static final SdkField<SourceServerConnectorAction> CONNECTOR_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("connectorAction").getter(UpdateSourceServerRequest.getter(UpdateSourceServerRequest::connectorAction)).setter(UpdateSourceServerRequest.setter(Builder::connectorAction)).constructor(SourceServerConnectorAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorAction").build()}).build();
    private static final SdkField<String> SOURCE_SERVER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceServerID").getter(UpdateSourceServerRequest.getter(UpdateSourceServerRequest::sourceServerID)).setter(UpdateSourceServerRequest.setter(Builder::sourceServerID)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceServerID").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, CONNECTOR_ACTION_FIELD, SOURCE_SERVER_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateSourceServerRequest.memberNameToFieldInitializer();
    private final String accountID;
    private final SourceServerConnectorAction connectorAction;
    private final String sourceServerID;

    private UpdateSourceServerRequest(BuilderImpl builder) {
        super(builder);
        this.accountID = builder.accountID;
        this.connectorAction = builder.connectorAction;
        this.sourceServerID = builder.sourceServerID;
    }

    public final String accountID() {
        return this.accountID;
    }

    public final SourceServerConnectorAction connectorAction() {
        return this.connectorAction;
    }

    public final String sourceServerID() {
        return this.sourceServerID;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.accountID());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectorAction());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceServerID());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSourceServerRequest)) {
            return false;
        }
        UpdateSourceServerRequest other = (UpdateSourceServerRequest)((Object)obj);
        return Objects.equals(this.accountID(), other.accountID()) && Objects.equals(this.connectorAction(), other.connectorAction()) && Objects.equals(this.sourceServerID(), other.sourceServerID());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateSourceServerRequest").add("AccountID", (Object)this.accountID()).add("ConnectorAction", (Object)this.connectorAction()).add("SourceServerID", (Object)this.sourceServerID()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accountID": {
                return Optional.ofNullable(clazz.cast(this.accountID()));
            }
            case "connectorAction": {
                return Optional.ofNullable(clazz.cast(this.connectorAction()));
            }
            case "sourceServerID": {
                return Optional.ofNullable(clazz.cast(this.sourceServerID()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("accountID", ACCOUNT_ID_FIELD);
        map.put("connectorAction", CONNECTOR_ACTION_FIELD);
        map.put("sourceServerID", SOURCE_SERVER_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateSourceServerRequest, T> g) {
        return obj -> g.apply((UpdateSourceServerRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MgnRequest.BuilderImpl
    implements Builder {
        private String accountID;
        private SourceServerConnectorAction connectorAction;
        private String sourceServerID;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSourceServerRequest model) {
            super(model);
            this.accountID(model.accountID);
            this.connectorAction(model.connectorAction);
            this.sourceServerID(model.sourceServerID);
        }

        public final String getAccountID() {
            return this.accountID;
        }

        public final void setAccountID(String accountID) {
            this.accountID = accountID;
        }

        @Override
        public final Builder accountID(String accountID) {
            this.accountID = accountID;
            return this;
        }

        public final SourceServerConnectorAction.Builder getConnectorAction() {
            return this.connectorAction != null ? this.connectorAction.toBuilder() : null;
        }

        public final void setConnectorAction(SourceServerConnectorAction.BuilderImpl connectorAction) {
            this.connectorAction = connectorAction != null ? connectorAction.build() : null;
        }

        @Override
        public final Builder connectorAction(SourceServerConnectorAction connectorAction) {
            this.connectorAction = connectorAction;
            return this;
        }

        public final String getSourceServerID() {
            return this.sourceServerID;
        }

        public final void setSourceServerID(String sourceServerID) {
            this.sourceServerID = sourceServerID;
        }

        @Override
        public final Builder sourceServerID(String sourceServerID) {
            this.sourceServerID = sourceServerID;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateSourceServerRequest build() {
            return new UpdateSourceServerRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends MgnRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateSourceServerRequest> {
        public Builder accountID(String var1);

        public Builder connectorAction(SourceServerConnectorAction var1);

        default public Builder connectorAction(Consumer<SourceServerConnectorAction.Builder> connectorAction) {
            return this.connectorAction((SourceServerConnectorAction)((SourceServerConnectorAction.Builder)SourceServerConnectorAction.builder().applyMutation(connectorAction)).build());
        }

        public Builder sourceServerID(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

