/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mgn.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateConnectorRequest extends MgnRequest implements
        ToCopyableBuilder<UpdateConnectorRequest.Builder, UpdateConnectorRequest> {
    private static final SdkField<String> CONNECTOR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("connectorID").getter(getter(UpdateConnectorRequest::connectorID)).setter(setter(Builder::connectorID))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorID").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(UpdateConnectorRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<ConnectorSsmCommandConfig> SSM_COMMAND_CONFIG_FIELD = SdkField
            .<ConnectorSsmCommandConfig> builder(MarshallingType.SDK_POJO).memberName("ssmCommandConfig")
            .getter(getter(UpdateConnectorRequest::ssmCommandConfig)).setter(setter(Builder::ssmCommandConfig))
            .constructor(ConnectorSsmCommandConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ssmCommandConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTOR_ID_FIELD,
            NAME_FIELD, SSM_COMMAND_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String connectorID;

    private final String name;

    private final ConnectorSsmCommandConfig ssmCommandConfig;

    private UpdateConnectorRequest(BuilderImpl builder) {
        super(builder);
        this.connectorID = builder.connectorID;
        this.name = builder.name;
        this.ssmCommandConfig = builder.ssmCommandConfig;
    }

    /**
     * <p>
     * Update Connector request connector ID.
     * </p>
     * 
     * @return Update Connector request connector ID.
     */
    public final String connectorID() {
        return connectorID;
    }

    /**
     * <p>
     * Update Connector request name.
     * </p>
     * 
     * @return Update Connector request name.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Update Connector request SSM command config.
     * </p>
     * 
     * @return Update Connector request SSM command config.
     */
    public final ConnectorSsmCommandConfig ssmCommandConfig() {
        return ssmCommandConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(connectorID());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(ssmCommandConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateConnectorRequest)) {
            return false;
        }
        UpdateConnectorRequest other = (UpdateConnectorRequest) obj;
        return Objects.equals(connectorID(), other.connectorID()) && Objects.equals(name(), other.name())
                && Objects.equals(ssmCommandConfig(), other.ssmCommandConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateConnectorRequest").add("ConnectorID", connectorID()).add("Name", name())
                .add("SsmCommandConfig", ssmCommandConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "connectorID":
            return Optional.ofNullable(clazz.cast(connectorID()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "ssmCommandConfig":
            return Optional.ofNullable(clazz.cast(ssmCommandConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("connectorID", CONNECTOR_ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("ssmCommandConfig", SSM_COMMAND_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateConnectorRequest, T> g) {
        return obj -> g.apply((UpdateConnectorRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends MgnRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateConnectorRequest> {
        /**
         * <p>
         * Update Connector request connector ID.
         * </p>
         * 
         * @param connectorID
         *        Update Connector request connector ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectorID(String connectorID);

        /**
         * <p>
         * Update Connector request name.
         * </p>
         * 
         * @param name
         *        Update Connector request name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Update Connector request SSM command config.
         * </p>
         * 
         * @param ssmCommandConfig
         *        Update Connector request SSM command config.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ssmCommandConfig(ConnectorSsmCommandConfig ssmCommandConfig);

        /**
         * <p>
         * Update Connector request SSM command config.
         * </p>
         * This is a convenience method that creates an instance of the {@link ConnectorSsmCommandConfig.Builder}
         * avoiding the need to create one manually via {@link ConnectorSsmCommandConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConnectorSsmCommandConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #ssmCommandConfig(ConnectorSsmCommandConfig)}.
         * 
         * @param ssmCommandConfig
         *        a consumer that will call methods on {@link ConnectorSsmCommandConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ssmCommandConfig(ConnectorSsmCommandConfig)
         */
        default Builder ssmCommandConfig(Consumer<ConnectorSsmCommandConfig.Builder> ssmCommandConfig) {
            return ssmCommandConfig(ConnectorSsmCommandConfig.builder().applyMutation(ssmCommandConfig).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MgnRequest.BuilderImpl implements Builder {
        private String connectorID;

        private String name;

        private ConnectorSsmCommandConfig ssmCommandConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateConnectorRequest model) {
            super(model);
            connectorID(model.connectorID);
            name(model.name);
            ssmCommandConfig(model.ssmCommandConfig);
        }

        public final String getConnectorID() {
            return connectorID;
        }

        public final void setConnectorID(String connectorID) {
            this.connectorID = connectorID;
        }

        @Override
        public final Builder connectorID(String connectorID) {
            this.connectorID = connectorID;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final ConnectorSsmCommandConfig.Builder getSsmCommandConfig() {
            return ssmCommandConfig != null ? ssmCommandConfig.toBuilder() : null;
        }

        public final void setSsmCommandConfig(ConnectorSsmCommandConfig.BuilderImpl ssmCommandConfig) {
            this.ssmCommandConfig = ssmCommandConfig != null ? ssmCommandConfig.build() : null;
        }

        @Override
        public final Builder ssmCommandConfig(ConnectorSsmCommandConfig ssmCommandConfig) {
            this.ssmCommandConfig = ssmCommandConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateConnectorRequest build() {
            return new UpdateConnectorRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
