/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhub.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary of the AWS resource used for access control that is implicitly linked to your AWS account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProgressUpdateStreamSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ProgressUpdateStreamSummary.Builder, ProgressUpdateStreamSummary> {
    private static final SdkField<String> PROGRESS_UPDATE_STREAM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProgressUpdateStreamName").getter(getter(ProgressUpdateStreamSummary::progressUpdateStreamName))
            .setter(setter(Builder::progressUpdateStreamName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProgressUpdateStreamName").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(PROGRESS_UPDATE_STREAM_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String progressUpdateStreamName;

    private ProgressUpdateStreamSummary(BuilderImpl builder) {
        this.progressUpdateStreamName = builder.progressUpdateStreamName;
    }

    /**
     * <p>
     * The name of the ProgressUpdateStream. <i>Do not store personal data in this field.</i>
     * </p>
     * 
     * @return The name of the ProgressUpdateStream. <i>Do not store personal data in this field.</i>
     */
    public final String progressUpdateStreamName() {
        return progressUpdateStreamName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(progressUpdateStreamName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProgressUpdateStreamSummary)) {
            return false;
        }
        ProgressUpdateStreamSummary other = (ProgressUpdateStreamSummary) obj;
        return Objects.equals(progressUpdateStreamName(), other.progressUpdateStreamName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProgressUpdateStreamSummary").add("ProgressUpdateStreamName", progressUpdateStreamName())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProgressUpdateStreamName":
            return Optional.ofNullable(clazz.cast(progressUpdateStreamName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProgressUpdateStreamSummary, T> g) {
        return obj -> g.apply((ProgressUpdateStreamSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProgressUpdateStreamSummary> {
        /**
         * <p>
         * The name of the ProgressUpdateStream. <i>Do not store personal data in this field.</i>
         * </p>
         * 
         * @param progressUpdateStreamName
         *        The name of the ProgressUpdateStream. <i>Do not store personal data in this field.</i>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder progressUpdateStreamName(String progressUpdateStreamName);
    }

    static final class BuilderImpl implements Builder {
        private String progressUpdateStreamName;

        private BuilderImpl() {
        }

        private BuilderImpl(ProgressUpdateStreamSummary model) {
            progressUpdateStreamName(model.progressUpdateStreamName);
        }

        public final String getProgressUpdateStreamName() {
            return progressUpdateStreamName;
        }

        public final void setProgressUpdateStreamName(String progressUpdateStreamName) {
            this.progressUpdateStreamName = progressUpdateStreamName;
        }

        @Override
        @Transient
        public final Builder progressUpdateStreamName(String progressUpdateStreamName) {
            this.progressUpdateStreamName = progressUpdateStreamName;
            return this;
        }

        @Override
        public ProgressUpdateStreamSummary build() {
            return new ProgressUpdateStreamSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
