/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.migrationhub.model.MigrationHubRequest;
import software.amazon.awssdk.services.migrationhub.model.ResourceAttribute;
import software.amazon.awssdk.services.migrationhub.model.ResourceAttributeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutResourceAttributesRequest
extends MigrationHubRequest
implements ToCopyableBuilder<Builder, PutResourceAttributesRequest> {
    private static final SdkField<String> PROGRESS_UPDATE_STREAM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProgressUpdateStream").getter(PutResourceAttributesRequest.getter(PutResourceAttributesRequest::progressUpdateStream)).setter(PutResourceAttributesRequest.setter(Builder::progressUpdateStream)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProgressUpdateStream").build()}).build();
    private static final SdkField<String> MIGRATION_TASK_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MigrationTaskName").getter(PutResourceAttributesRequest.getter(PutResourceAttributesRequest::migrationTaskName)).setter(PutResourceAttributesRequest.setter(Builder::migrationTaskName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MigrationTaskName").build()}).build();
    private static final SdkField<List<ResourceAttribute>> RESOURCE_ATTRIBUTE_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResourceAttributeList").getter(PutResourceAttributesRequest.getter(PutResourceAttributesRequest::resourceAttributeList)).setter(PutResourceAttributesRequest.setter(Builder::resourceAttributeList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceAttributeList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourceAttribute::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(PutResourceAttributesRequest.getter(PutResourceAttributesRequest::dryRun)).setter(PutResourceAttributesRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROGRESS_UPDATE_STREAM_FIELD, MIGRATION_TASK_NAME_FIELD, RESOURCE_ATTRIBUTE_LIST_FIELD, DRY_RUN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ProgressUpdateStream", PROGRESS_UPDATE_STREAM_FIELD);
            this.put("MigrationTaskName", MIGRATION_TASK_NAME_FIELD);
            this.put("ResourceAttributeList", RESOURCE_ATTRIBUTE_LIST_FIELD);
            this.put("DryRun", DRY_RUN_FIELD);
        }
    });
    private final String progressUpdateStream;
    private final String migrationTaskName;
    private final List<ResourceAttribute> resourceAttributeList;
    private final Boolean dryRun;

    private PutResourceAttributesRequest(BuilderImpl builder) {
        super(builder);
        this.progressUpdateStream = builder.progressUpdateStream;
        this.migrationTaskName = builder.migrationTaskName;
        this.resourceAttributeList = builder.resourceAttributeList;
        this.dryRun = builder.dryRun;
    }

    public final String progressUpdateStream() {
        return this.progressUpdateStream;
    }

    public final String migrationTaskName() {
        return this.migrationTaskName;
    }

    public final boolean hasResourceAttributeList() {
        return this.resourceAttributeList != null && !(this.resourceAttributeList instanceof SdkAutoConstructList);
    }

    public final List<ResourceAttribute> resourceAttributeList() {
        return this.resourceAttributeList;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.progressUpdateStream());
        hashCode = 31 * hashCode + Objects.hashCode(this.migrationTaskName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceAttributeList() ? this.resourceAttributeList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutResourceAttributesRequest)) {
            return false;
        }
        PutResourceAttributesRequest other = (PutResourceAttributesRequest)((Object)obj);
        return Objects.equals(this.progressUpdateStream(), other.progressUpdateStream()) && Objects.equals(this.migrationTaskName(), other.migrationTaskName()) && this.hasResourceAttributeList() == other.hasResourceAttributeList() && Objects.equals(this.resourceAttributeList(), other.resourceAttributeList()) && Objects.equals(this.dryRun(), other.dryRun());
    }

    public final String toString() {
        return ToString.builder((String)"PutResourceAttributesRequest").add("ProgressUpdateStream", (Object)this.progressUpdateStream()).add("MigrationTaskName", (Object)this.migrationTaskName()).add("ResourceAttributeList", this.hasResourceAttributeList() ? this.resourceAttributeList() : null).add("DryRun", (Object)this.dryRun()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProgressUpdateStream": {
                return Optional.ofNullable(clazz.cast(this.progressUpdateStream()));
            }
            case "MigrationTaskName": {
                return Optional.ofNullable(clazz.cast(this.migrationTaskName()));
            }
            case "ResourceAttributeList": {
                return Optional.ofNullable(clazz.cast(this.resourceAttributeList()));
            }
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<PutResourceAttributesRequest, T> g) {
        return obj -> g.apply((PutResourceAttributesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MigrationHubRequest.BuilderImpl
    implements Builder {
        private String progressUpdateStream;
        private String migrationTaskName;
        private List<ResourceAttribute> resourceAttributeList = DefaultSdkAutoConstructList.getInstance();
        private Boolean dryRun;

        private BuilderImpl() {
        }

        private BuilderImpl(PutResourceAttributesRequest model) {
            super(model);
            this.progressUpdateStream(model.progressUpdateStream);
            this.migrationTaskName(model.migrationTaskName);
            this.resourceAttributeList(model.resourceAttributeList);
            this.dryRun(model.dryRun);
        }

        public final String getProgressUpdateStream() {
            return this.progressUpdateStream;
        }

        public final void setProgressUpdateStream(String progressUpdateStream) {
            this.progressUpdateStream = progressUpdateStream;
        }

        @Override
        public final Builder progressUpdateStream(String progressUpdateStream) {
            this.progressUpdateStream = progressUpdateStream;
            return this;
        }

        public final String getMigrationTaskName() {
            return this.migrationTaskName;
        }

        public final void setMigrationTaskName(String migrationTaskName) {
            this.migrationTaskName = migrationTaskName;
        }

        @Override
        public final Builder migrationTaskName(String migrationTaskName) {
            this.migrationTaskName = migrationTaskName;
            return this;
        }

        public final List<ResourceAttribute.Builder> getResourceAttributeList() {
            List<ResourceAttribute.Builder> result = ResourceAttributeListCopier.copyToBuilder(this.resourceAttributeList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceAttributeList(Collection<ResourceAttribute.BuilderImpl> resourceAttributeList) {
            this.resourceAttributeList = ResourceAttributeListCopier.copyFromBuilder(resourceAttributeList);
        }

        @Override
        public final Builder resourceAttributeList(Collection<ResourceAttribute> resourceAttributeList) {
            this.resourceAttributeList = ResourceAttributeListCopier.copy(resourceAttributeList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceAttributeList(ResourceAttribute ... resourceAttributeList) {
            this.resourceAttributeList(Arrays.asList(resourceAttributeList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceAttributeList(Consumer<ResourceAttribute.Builder> ... resourceAttributeList) {
            this.resourceAttributeList(Stream.of(resourceAttributeList).map(c -> (ResourceAttribute)((ResourceAttribute.Builder)ResourceAttribute.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutResourceAttributesRequest build() {
            return new PutResourceAttributesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends MigrationHubRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutResourceAttributesRequest> {
        public Builder progressUpdateStream(String var1);

        public Builder migrationTaskName(String var1);

        public Builder resourceAttributeList(Collection<ResourceAttribute> var1);

        public Builder resourceAttributeList(ResourceAttribute ... var1);

        public Builder resourceAttributeList(Consumer<ResourceAttribute.Builder> ... var1);

        public Builder dryRun(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

