/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Object representing the on-premises resource being migrated.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DiscoveredResource implements SdkPojo, Serializable,
        ToCopyableBuilder<DiscoveredResource.Builder, DiscoveredResource> {
    private static final SdkField<String> CONFIGURATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConfigurationId").getter(getter(DiscoveredResource::configurationId))
            .setter(setter(Builder::configurationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationId").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(DiscoveredResource::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_ID_FIELD,
            DESCRIPTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String configurationId;

    private final String description;

    private DiscoveredResource(BuilderImpl builder) {
        this.configurationId = builder.configurationId;
        this.description = builder.description;
    }

    /**
     * <p>
     * The configurationId in Application Discovery Service that uniquely identifies the on-premise resource.
     * </p>
     * 
     * @return The configurationId in Application Discovery Service that uniquely identifies the on-premise resource.
     */
    public final String configurationId() {
        return configurationId;
    }

    /**
     * <p>
     * A description that can be free-form text to record additional detail about the discovered resource for clarity or
     * later reference.
     * </p>
     * 
     * @return A description that can be free-form text to record additional detail about the discovered resource for
     *         clarity or later reference.
     */
    public final String description() {
        return description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(configurationId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DiscoveredResource)) {
            return false;
        }
        DiscoveredResource other = (DiscoveredResource) obj;
        return Objects.equals(configurationId(), other.configurationId()) && Objects.equals(description(), other.description());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DiscoveredResource").add("ConfigurationId", configurationId()).add("Description", description())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfigurationId":
            return Optional.ofNullable(clazz.cast(configurationId()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ConfigurationId", CONFIGURATION_ID_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DiscoveredResource, T> g) {
        return obj -> g.apply((DiscoveredResource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DiscoveredResource> {
        /**
         * <p>
         * The configurationId in Application Discovery Service that uniquely identifies the on-premise resource.
         * </p>
         * 
         * @param configurationId
         *        The configurationId in Application Discovery Service that uniquely identifies the on-premise resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationId(String configurationId);

        /**
         * <p>
         * A description that can be free-form text to record additional detail about the discovered resource for
         * clarity or later reference.
         * </p>
         * 
         * @param description
         *        A description that can be free-form text to record additional detail about the discovered resource for
         *        clarity or later reference.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);
    }

    static final class BuilderImpl implements Builder {
        private String configurationId;

        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(DiscoveredResource model) {
            configurationId(model.configurationId);
            description(model.description);
        }

        public final String getConfigurationId() {
            return configurationId;
        }

        public final void setConfigurationId(String configurationId) {
            this.configurationId = configurationId;
        }

        @Override
        public final Builder configurationId(String configurationId) {
            this.configurationId = configurationId;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public DiscoveredResource build() {
            return new DiscoveredResource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
