/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListApplicationStatesRequest extends MigrationHubRequest implements
        ToCopyableBuilder<ListApplicationStatesRequest.Builder, ListApplicationStatesRequest> {
    private static final SdkField<List<String>> APPLICATION_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ApplicationIds")
            .getter(getter(ListApplicationStatesRequest::applicationIds))
            .setter(setter(Builder::applicationIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListApplicationStatesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListApplicationStatesRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_IDS_FIELD,
            NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<String> applicationIds;

    private final String nextToken;

    private final Integer maxResults;

    private ListApplicationStatesRequest(BuilderImpl builder) {
        super(builder);
        this.applicationIds = builder.applicationIds;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * For responses, this returns true if the service returned a value for the ApplicationIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasApplicationIds() {
        return applicationIds != null && !(applicationIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The configurationIds from the Application Discovery Service that uniquely identifies your applications.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasApplicationIds} method.
     * </p>
     * 
     * @return The configurationIds from the Application Discovery Service that uniquely identifies your applications.
     */
    public final List<String> applicationIds() {
        return applicationIds;
    }

    /**
     * <p>
     * If a <code>NextToken</code> was returned by a previous call, there are more results available. To retrieve the
     * next page of results, make the call again using the returned token in <code>NextToken</code>.
     * </p>
     * 
     * @return If a <code>NextToken</code> was returned by a previous call, there are more results available. To
     *         retrieve the next page of results, make the call again using the returned token in <code>NextToken</code>
     *         .
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * Maximum number of results to be returned per page.
     * </p>
     * 
     * @return Maximum number of results to be returned per page.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasApplicationIds() ? applicationIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListApplicationStatesRequest)) {
            return false;
        }
        ListApplicationStatesRequest other = (ListApplicationStatesRequest) obj;
        return hasApplicationIds() == other.hasApplicationIds() && Objects.equals(applicationIds(), other.applicationIds())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListApplicationStatesRequest")
                .add("ApplicationIds", hasApplicationIds() ? applicationIds() : null).add("NextToken", nextToken())
                .add("MaxResults", maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationIds":
            return Optional.ofNullable(clazz.cast(applicationIds()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ApplicationIds", APPLICATION_IDS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListApplicationStatesRequest, T> g) {
        return obj -> g.apply((ListApplicationStatesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MigrationHubRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListApplicationStatesRequest> {
        /**
         * <p>
         * The configurationIds from the Application Discovery Service that uniquely identifies your applications.
         * </p>
         * 
         * @param applicationIds
         *        The configurationIds from the Application Discovery Service that uniquely identifies your
         *        applications.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationIds(Collection<String> applicationIds);

        /**
         * <p>
         * The configurationIds from the Application Discovery Service that uniquely identifies your applications.
         * </p>
         * 
         * @param applicationIds
         *        The configurationIds from the Application Discovery Service that uniquely identifies your
         *        applications.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationIds(String... applicationIds);

        /**
         * <p>
         * If a <code>NextToken</code> was returned by a previous call, there are more results available. To retrieve
         * the next page of results, make the call again using the returned token in <code>NextToken</code>.
         * </p>
         * 
         * @param nextToken
         *        If a <code>NextToken</code> was returned by a previous call, there are more results available. To
         *        retrieve the next page of results, make the call again using the returned token in
         *        <code>NextToken</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Maximum number of results to be returned per page.
         * </p>
         * 
         * @param maxResults
         *        Maximum number of results to be returned per page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MigrationHubRequest.BuilderImpl implements Builder {
        private List<String> applicationIds = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListApplicationStatesRequest model) {
            super(model);
            applicationIds(model.applicationIds);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final Collection<String> getApplicationIds() {
            if (applicationIds instanceof SdkAutoConstructList) {
                return null;
            }
            return applicationIds;
        }

        public final void setApplicationIds(Collection<String> applicationIds) {
            this.applicationIds = ApplicationIdsCopier.copy(applicationIds);
        }

        @Override
        public final Builder applicationIds(Collection<String> applicationIds) {
            this.applicationIds = ApplicationIdsCopier.copy(applicationIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applicationIds(String... applicationIds) {
            applicationIds(Arrays.asList(applicationIds));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListApplicationStatesRequest build() {
            return new ListApplicationStatesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
