/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListApplicationStatesResponse extends MigrationHubResponse implements
        ToCopyableBuilder<ListApplicationStatesResponse.Builder, ListApplicationStatesResponse> {
    private static final SdkField<List<ApplicationState>> APPLICATION_STATE_LIST_FIELD = SdkField
            .<List<ApplicationState>> builder(MarshallingType.LIST)
            .memberName("ApplicationStateList")
            .getter(getter(ListApplicationStatesResponse::applicationStateList))
            .setter(setter(Builder::applicationStateList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationStateList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ApplicationState> builder(MarshallingType.SDK_POJO)
                                            .constructor(ApplicationState::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListApplicationStatesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_STATE_LIST_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<ApplicationState> applicationStateList;

    private final String nextToken;

    private ListApplicationStatesResponse(BuilderImpl builder) {
        super(builder);
        this.applicationStateList = builder.applicationStateList;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ApplicationStateList property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasApplicationStateList() {
        return applicationStateList != null && !(applicationStateList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of Applications that exist in Application Discovery Service.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasApplicationStateList} method.
     * </p>
     * 
     * @return A list of Applications that exist in Application Discovery Service.
     */
    public final List<ApplicationState> applicationStateList() {
        return applicationStateList;
    }

    /**
     * <p>
     * If a <code>NextToken</code> was returned by a previous call, there are more results available. To retrieve the
     * next page of results, make the call again using the returned token in <code>NextToken</code>.
     * </p>
     * 
     * @return If a <code>NextToken</code> was returned by a previous call, there are more results available. To
     *         retrieve the next page of results, make the call again using the returned token in <code>NextToken</code>
     *         .
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasApplicationStateList() ? applicationStateList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListApplicationStatesResponse)) {
            return false;
        }
        ListApplicationStatesResponse other = (ListApplicationStatesResponse) obj;
        return hasApplicationStateList() == other.hasApplicationStateList()
                && Objects.equals(applicationStateList(), other.applicationStateList())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListApplicationStatesResponse")
                .add("ApplicationStateList", hasApplicationStateList() ? applicationStateList() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationStateList":
            return Optional.ofNullable(clazz.cast(applicationStateList()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ApplicationStateList", APPLICATION_STATE_LIST_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListApplicationStatesResponse, T> g) {
        return obj -> g.apply((ListApplicationStatesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MigrationHubResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListApplicationStatesResponse> {
        /**
         * <p>
         * A list of Applications that exist in Application Discovery Service.
         * </p>
         * 
         * @param applicationStateList
         *        A list of Applications that exist in Application Discovery Service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationStateList(Collection<ApplicationState> applicationStateList);

        /**
         * <p>
         * A list of Applications that exist in Application Discovery Service.
         * </p>
         * 
         * @param applicationStateList
         *        A list of Applications that exist in Application Discovery Service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationStateList(ApplicationState... applicationStateList);

        /**
         * <p>
         * A list of Applications that exist in Application Discovery Service.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.migrationhub.model.ApplicationState.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.migrationhub.model.ApplicationState#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.migrationhub.model.ApplicationState.Builder#build()} is called
         * immediately and its result is passed to {@link #applicationStateList(List<ApplicationState>)}.
         * 
         * @param applicationStateList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.migrationhub.model.ApplicationState.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #applicationStateList(java.util.Collection<ApplicationState>)
         */
        Builder applicationStateList(Consumer<ApplicationState.Builder>... applicationStateList);

        /**
         * <p>
         * If a <code>NextToken</code> was returned by a previous call, there are more results available. To retrieve
         * the next page of results, make the call again using the returned token in <code>NextToken</code>.
         * </p>
         * 
         * @param nextToken
         *        If a <code>NextToken</code> was returned by a previous call, there are more results available. To
         *        retrieve the next page of results, make the call again using the returned token in
         *        <code>NextToken</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends MigrationHubResponse.BuilderImpl implements Builder {
        private List<ApplicationState> applicationStateList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListApplicationStatesResponse model) {
            super(model);
            applicationStateList(model.applicationStateList);
            nextToken(model.nextToken);
        }

        public final List<ApplicationState.Builder> getApplicationStateList() {
            List<ApplicationState.Builder> result = ApplicationStateListCopier.copyToBuilder(this.applicationStateList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setApplicationStateList(Collection<ApplicationState.BuilderImpl> applicationStateList) {
            this.applicationStateList = ApplicationStateListCopier.copyFromBuilder(applicationStateList);
        }

        @Override
        public final Builder applicationStateList(Collection<ApplicationState> applicationStateList) {
            this.applicationStateList = ApplicationStateListCopier.copy(applicationStateList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applicationStateList(ApplicationState... applicationStateList) {
            applicationStateList(Arrays.asList(applicationStateList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applicationStateList(Consumer<ApplicationState.Builder>... applicationStateList) {
            applicationStateList(Stream.of(applicationStateList).map(c -> ApplicationState.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListApplicationStatesResponse build() {
            return new ListApplicationStatesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
