/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListMigrationTasksResponse extends MigrationHubResponse implements
        ToCopyableBuilder<ListMigrationTasksResponse.Builder, ListMigrationTasksResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListMigrationTasksResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<MigrationTaskSummary>> MIGRATION_TASK_SUMMARY_LIST_FIELD = SdkField
            .<List<MigrationTaskSummary>> builder(MarshallingType.LIST)
            .memberName("MigrationTaskSummaryList")
            .getter(getter(ListMigrationTasksResponse::migrationTaskSummaryList))
            .setter(setter(Builder::migrationTaskSummaryList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MigrationTaskSummaryList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MigrationTaskSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(MigrationTaskSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            MIGRATION_TASK_SUMMARY_LIST_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final List<MigrationTaskSummary> migrationTaskSummaryList;

    private ListMigrationTasksResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.migrationTaskSummaryList = builder.migrationTaskSummaryList;
    }

    /**
     * <p>
     * If there are more migration tasks than the max result, return the next token to be passed to the next call as a
     * bookmark of where to start from.
     * </p>
     * 
     * @return If there are more migration tasks than the max result, return the next token to be passed to the next
     *         call as a bookmark of where to start from.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the MigrationTaskSummaryList property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasMigrationTaskSummaryList() {
        return migrationTaskSummaryList != null && !(migrationTaskSummaryList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Lists the migration task's summary which includes: <code>MigrationTaskName</code>, <code>ProgressPercent</code>,
     * <code>ProgressUpdateStream</code>, <code>Status</code>, and the <code>UpdateDateTime</code> for each task.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMigrationTaskSummaryList} method.
     * </p>
     * 
     * @return Lists the migration task's summary which includes: <code>MigrationTaskName</code>,
     *         <code>ProgressPercent</code>, <code>ProgressUpdateStream</code>, <code>Status</code>, and the
     *         <code>UpdateDateTime</code> for each task.
     */
    public final List<MigrationTaskSummary> migrationTaskSummaryList() {
        return migrationTaskSummaryList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasMigrationTaskSummaryList() ? migrationTaskSummaryList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMigrationTasksResponse)) {
            return false;
        }
        ListMigrationTasksResponse other = (ListMigrationTasksResponse) obj;
        return Objects.equals(nextToken(), other.nextToken())
                && hasMigrationTaskSummaryList() == other.hasMigrationTaskSummaryList()
                && Objects.equals(migrationTaskSummaryList(), other.migrationTaskSummaryList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListMigrationTasksResponse").add("NextToken", nextToken())
                .add("MigrationTaskSummaryList", hasMigrationTaskSummaryList() ? migrationTaskSummaryList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MigrationTaskSummaryList":
            return Optional.ofNullable(clazz.cast(migrationTaskSummaryList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("MigrationTaskSummaryList", MIGRATION_TASK_SUMMARY_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListMigrationTasksResponse, T> g) {
        return obj -> g.apply((ListMigrationTasksResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MigrationHubResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListMigrationTasksResponse> {
        /**
         * <p>
         * If there are more migration tasks than the max result, return the next token to be passed to the next call as
         * a bookmark of where to start from.
         * </p>
         * 
         * @param nextToken
         *        If there are more migration tasks than the max result, return the next token to be passed to the next
         *        call as a bookmark of where to start from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Lists the migration task's summary which includes: <code>MigrationTaskName</code>,
         * <code>ProgressPercent</code>, <code>ProgressUpdateStream</code>, <code>Status</code>, and the
         * <code>UpdateDateTime</code> for each task.
         * </p>
         * 
         * @param migrationTaskSummaryList
         *        Lists the migration task's summary which includes: <code>MigrationTaskName</code>,
         *        <code>ProgressPercent</code>, <code>ProgressUpdateStream</code>, <code>Status</code>, and the
         *        <code>UpdateDateTime</code> for each task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder migrationTaskSummaryList(Collection<MigrationTaskSummary> migrationTaskSummaryList);

        /**
         * <p>
         * Lists the migration task's summary which includes: <code>MigrationTaskName</code>,
         * <code>ProgressPercent</code>, <code>ProgressUpdateStream</code>, <code>Status</code>, and the
         * <code>UpdateDateTime</code> for each task.
         * </p>
         * 
         * @param migrationTaskSummaryList
         *        Lists the migration task's summary which includes: <code>MigrationTaskName</code>,
         *        <code>ProgressPercent</code>, <code>ProgressUpdateStream</code>, <code>Status</code>, and the
         *        <code>UpdateDateTime</code> for each task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder migrationTaskSummaryList(MigrationTaskSummary... migrationTaskSummaryList);

        /**
         * <p>
         * Lists the migration task's summary which includes: <code>MigrationTaskName</code>,
         * <code>ProgressPercent</code>, <code>ProgressUpdateStream</code>, <code>Status</code>, and the
         * <code>UpdateDateTime</code> for each task.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.migrationhub.model.MigrationTaskSummary.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.migrationhub.model.MigrationTaskSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.migrationhub.model.MigrationTaskSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #migrationTaskSummaryList(List<MigrationTaskSummary>)}.
         * 
         * @param migrationTaskSummaryList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.migrationhub.model.MigrationTaskSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #migrationTaskSummaryList(java.util.Collection<MigrationTaskSummary>)
         */
        Builder migrationTaskSummaryList(Consumer<MigrationTaskSummary.Builder>... migrationTaskSummaryList);
    }

    static final class BuilderImpl extends MigrationHubResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<MigrationTaskSummary> migrationTaskSummaryList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListMigrationTasksResponse model) {
            super(model);
            nextToken(model.nextToken);
            migrationTaskSummaryList(model.migrationTaskSummaryList);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<MigrationTaskSummary.Builder> getMigrationTaskSummaryList() {
            List<MigrationTaskSummary.Builder> result = MigrationTaskSummaryListCopier
                    .copyToBuilder(this.migrationTaskSummaryList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMigrationTaskSummaryList(Collection<MigrationTaskSummary.BuilderImpl> migrationTaskSummaryList) {
            this.migrationTaskSummaryList = MigrationTaskSummaryListCopier.copyFromBuilder(migrationTaskSummaryList);
        }

        @Override
        public final Builder migrationTaskSummaryList(Collection<MigrationTaskSummary> migrationTaskSummaryList) {
            this.migrationTaskSummaryList = MigrationTaskSummaryListCopier.copy(migrationTaskSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder migrationTaskSummaryList(MigrationTaskSummary... migrationTaskSummaryList) {
            migrationTaskSummaryList(Arrays.asList(migrationTaskSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder migrationTaskSummaryList(Consumer<MigrationTaskSummary.Builder>... migrationTaskSummaryList) {
            migrationTaskSummaryList(Stream.of(migrationTaskSummaryList)
                    .map(c -> MigrationTaskSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListMigrationTasksResponse build() {
            return new ListMigrationTasksResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
