/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhub.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A migration-task progress update.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MigrationTaskUpdate implements SdkPojo, Serializable,
        ToCopyableBuilder<MigrationTaskUpdate.Builder, MigrationTaskUpdate> {
    private static final SdkField<Instant> UPDATE_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("UpdateDateTime").getter(getter(MigrationTaskUpdate::updateDateTime))
            .setter(setter(Builder::updateDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateDateTime").build()).build();

    private static final SdkField<String> UPDATE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UpdateType").getter(getter(MigrationTaskUpdate::updateTypeAsString)).setter(setter(Builder::updateType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateType").build()).build();

    private static final SdkField<Task> MIGRATION_TASK_STATE_FIELD = SdkField.<Task> builder(MarshallingType.SDK_POJO)
            .memberName("MigrationTaskState").getter(getter(MigrationTaskUpdate::migrationTaskState))
            .setter(setter(Builder::migrationTaskState)).constructor(Task::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MigrationTaskState").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UPDATE_DATE_TIME_FIELD,
            UPDATE_TYPE_FIELD, MIGRATION_TASK_STATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Instant updateDateTime;

    private final String updateType;

    private final Task migrationTaskState;

    private MigrationTaskUpdate(BuilderImpl builder) {
        this.updateDateTime = builder.updateDateTime;
        this.updateType = builder.updateType;
        this.migrationTaskState = builder.migrationTaskState;
    }

    /**
     * <p>
     * The timestamp for the update.
     * </p>
     * 
     * @return The timestamp for the update.
     */
    public final Instant updateDateTime() {
        return updateDateTime;
    }

    /**
     * <p>
     * The type of the update.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #updateType} will
     * return {@link UpdateType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #updateTypeAsString}.
     * </p>
     * 
     * @return The type of the update.
     * @see UpdateType
     */
    public final UpdateType updateType() {
        return UpdateType.fromValue(updateType);
    }

    /**
     * <p>
     * The type of the update.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #updateType} will
     * return {@link UpdateType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #updateTypeAsString}.
     * </p>
     * 
     * @return The type of the update.
     * @see UpdateType
     */
    public final String updateTypeAsString() {
        return updateType;
    }

    /**
     * Returns the value of the MigrationTaskState property for this object.
     * 
     * @return The value of the MigrationTaskState property for this object.
     */
    public final Task migrationTaskState() {
        return migrationTaskState;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(updateDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(updateTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(migrationTaskState());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MigrationTaskUpdate)) {
            return false;
        }
        MigrationTaskUpdate other = (MigrationTaskUpdate) obj;
        return Objects.equals(updateDateTime(), other.updateDateTime())
                && Objects.equals(updateTypeAsString(), other.updateTypeAsString())
                && Objects.equals(migrationTaskState(), other.migrationTaskState());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MigrationTaskUpdate").add("UpdateDateTime", updateDateTime())
                .add("UpdateType", updateTypeAsString()).add("MigrationTaskState", migrationTaskState()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UpdateDateTime":
            return Optional.ofNullable(clazz.cast(updateDateTime()));
        case "UpdateType":
            return Optional.ofNullable(clazz.cast(updateTypeAsString()));
        case "MigrationTaskState":
            return Optional.ofNullable(clazz.cast(migrationTaskState()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("UpdateDateTime", UPDATE_DATE_TIME_FIELD);
        map.put("UpdateType", UPDATE_TYPE_FIELD);
        map.put("MigrationTaskState", MIGRATION_TASK_STATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MigrationTaskUpdate, T> g) {
        return obj -> g.apply((MigrationTaskUpdate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MigrationTaskUpdate> {
        /**
         * <p>
         * The timestamp for the update.
         * </p>
         * 
         * @param updateDateTime
         *        The timestamp for the update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateDateTime(Instant updateDateTime);

        /**
         * <p>
         * The type of the update.
         * </p>
         * 
         * @param updateType
         *        The type of the update.
         * @see UpdateType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UpdateType
         */
        Builder updateType(String updateType);

        /**
         * <p>
         * The type of the update.
         * </p>
         * 
         * @param updateType
         *        The type of the update.
         * @see UpdateType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UpdateType
         */
        Builder updateType(UpdateType updateType);

        /**
         * Sets the value of the MigrationTaskState property for this object.
         *
         * @param migrationTaskState
         *        The new value for the MigrationTaskState property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder migrationTaskState(Task migrationTaskState);

        /**
         * Sets the value of the MigrationTaskState property for this object.
         *
         * This is a convenience method that creates an instance of the {@link Task.Builder} avoiding the need to create
         * one manually via {@link Task#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Task.Builder#build()} is called immediately and its result is
         * passed to {@link #migrationTaskState(Task)}.
         * 
         * @param migrationTaskState
         *        a consumer that will call methods on {@link Task.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #migrationTaskState(Task)
         */
        default Builder migrationTaskState(Consumer<Task.Builder> migrationTaskState) {
            return migrationTaskState(Task.builder().applyMutation(migrationTaskState).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Instant updateDateTime;

        private String updateType;

        private Task migrationTaskState;

        private BuilderImpl() {
        }

        private BuilderImpl(MigrationTaskUpdate model) {
            updateDateTime(model.updateDateTime);
            updateType(model.updateType);
            migrationTaskState(model.migrationTaskState);
        }

        public final Instant getUpdateDateTime() {
            return updateDateTime;
        }

        public final void setUpdateDateTime(Instant updateDateTime) {
            this.updateDateTime = updateDateTime;
        }

        @Override
        public final Builder updateDateTime(Instant updateDateTime) {
            this.updateDateTime = updateDateTime;
            return this;
        }

        public final String getUpdateType() {
            return updateType;
        }

        public final void setUpdateType(String updateType) {
            this.updateType = updateType;
        }

        @Override
        public final Builder updateType(String updateType) {
            this.updateType = updateType;
            return this;
        }

        @Override
        public final Builder updateType(UpdateType updateType) {
            this.updateType(updateType == null ? null : updateType.toString());
            return this;
        }

        public final Task.Builder getMigrationTaskState() {
            return migrationTaskState != null ? migrationTaskState.toBuilder() : null;
        }

        public final void setMigrationTaskState(Task.BuilderImpl migrationTaskState) {
            this.migrationTaskState = migrationTaskState != null ? migrationTaskState.build() : null;
        }

        @Override
        public final Builder migrationTaskState(Task migrationTaskState) {
            this.migrationTaskState = migrationTaskState;
            return this;
        }

        @Override
        public MigrationTaskUpdate build() {
            return new MigrationTaskUpdate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
