/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhub.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociateSourceResourceRequest extends MigrationHubRequest implements
        ToCopyableBuilder<AssociateSourceResourceRequest.Builder, AssociateSourceResourceRequest> {
    private static final SdkField<String> PROGRESS_UPDATE_STREAM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProgressUpdateStream").getter(getter(AssociateSourceResourceRequest::progressUpdateStream))
            .setter(setter(Builder::progressUpdateStream))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProgressUpdateStream").build())
            .build();

    private static final SdkField<String> MIGRATION_TASK_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MigrationTaskName").getter(getter(AssociateSourceResourceRequest::migrationTaskName))
            .setter(setter(Builder::migrationTaskName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MigrationTaskName").build()).build();

    private static final SdkField<SourceResource> SOURCE_RESOURCE_FIELD = SdkField
            .<SourceResource> builder(MarshallingType.SDK_POJO).memberName("SourceResource")
            .getter(getter(AssociateSourceResourceRequest::sourceResource)).setter(setter(Builder::sourceResource))
            .constructor(SourceResource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceResource").build()).build();

    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DryRun").getter(getter(AssociateSourceResourceRequest::dryRun)).setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROGRESS_UPDATE_STREAM_FIELD,
            MIGRATION_TASK_NAME_FIELD, SOURCE_RESOURCE_FIELD, DRY_RUN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String progressUpdateStream;

    private final String migrationTaskName;

    private final SourceResource sourceResource;

    private final Boolean dryRun;

    private AssociateSourceResourceRequest(BuilderImpl builder) {
        super(builder);
        this.progressUpdateStream = builder.progressUpdateStream;
        this.migrationTaskName = builder.migrationTaskName;
        this.sourceResource = builder.sourceResource;
        this.dryRun = builder.dryRun;
    }

    /**
     * <p>
     * The name of the progress-update stream, which is used for access control as well as a namespace for
     * migration-task names that is implicitly linked to your AWS account. The progress-update stream must uniquely
     * identify the migration tool as it is used for all updates made by the tool; however, it does not need to be
     * unique for each AWS account because it is scoped to the AWS account.
     * </p>
     * 
     * @return The name of the progress-update stream, which is used for access control as well as a namespace for
     *         migration-task names that is implicitly linked to your AWS account. The progress-update stream must
     *         uniquely identify the migration tool as it is used for all updates made by the tool; however, it does not
     *         need to be unique for each AWS account because it is scoped to the AWS account.
     */
    public final String progressUpdateStream() {
        return progressUpdateStream;
    }

    /**
     * <p>
     * A unique identifier that references the migration task. <i>Do not include sensitive data in this field.</i>
     * </p>
     * 
     * @return A unique identifier that references the migration task. <i>Do not include sensitive data in this
     *         field.</i>
     */
    public final String migrationTaskName() {
        return migrationTaskName;
    }

    /**
     * <p>
     * The source resource that you want to associate.
     * </p>
     * 
     * @return The source resource that you want to associate.
     */
    public final SourceResource sourceResource() {
        return sourceResource;
    }

    /**
     * <p>
     * This is an optional parameter that you can use to test whether the call will succeed. Set this parameter to
     * <code>true</code> to verify that you have the permissions that are required to make the call, and that you have
     * specified the other parameters in the call correctly.
     * </p>
     * 
     * @return This is an optional parameter that you can use to test whether the call will succeed. Set this parameter
     *         to <code>true</code> to verify that you have the permissions that are required to make the call, and that
     *         you have specified the other parameters in the call correctly.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(progressUpdateStream());
        hashCode = 31 * hashCode + Objects.hashCode(migrationTaskName());
        hashCode = 31 * hashCode + Objects.hashCode(sourceResource());
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateSourceResourceRequest)) {
            return false;
        }
        AssociateSourceResourceRequest other = (AssociateSourceResourceRequest) obj;
        return Objects.equals(progressUpdateStream(), other.progressUpdateStream())
                && Objects.equals(migrationTaskName(), other.migrationTaskName())
                && Objects.equals(sourceResource(), other.sourceResource()) && Objects.equals(dryRun(), other.dryRun());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssociateSourceResourceRequest").add("ProgressUpdateStream", progressUpdateStream())
                .add("MigrationTaskName", migrationTaskName()).add("SourceResource", sourceResource()).add("DryRun", dryRun())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProgressUpdateStream":
            return Optional.ofNullable(clazz.cast(progressUpdateStream()));
        case "MigrationTaskName":
            return Optional.ofNullable(clazz.cast(migrationTaskName()));
        case "SourceResource":
            return Optional.ofNullable(clazz.cast(sourceResource()));
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ProgressUpdateStream", PROGRESS_UPDATE_STREAM_FIELD);
        map.put("MigrationTaskName", MIGRATION_TASK_NAME_FIELD);
        map.put("SourceResource", SOURCE_RESOURCE_FIELD);
        map.put("DryRun", DRY_RUN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssociateSourceResourceRequest, T> g) {
        return obj -> g.apply((AssociateSourceResourceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends MigrationHubRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, AssociateSourceResourceRequest> {
        /**
         * <p>
         * The name of the progress-update stream, which is used for access control as well as a namespace for
         * migration-task names that is implicitly linked to your AWS account. The progress-update stream must uniquely
         * identify the migration tool as it is used for all updates made by the tool; however, it does not need to be
         * unique for each AWS account because it is scoped to the AWS account.
         * </p>
         * 
         * @param progressUpdateStream
         *        The name of the progress-update stream, which is used for access control as well as a namespace for
         *        migration-task names that is implicitly linked to your AWS account. The progress-update stream must
         *        uniquely identify the migration tool as it is used for all updates made by the tool; however, it does
         *        not need to be unique for each AWS account because it is scoped to the AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder progressUpdateStream(String progressUpdateStream);

        /**
         * <p>
         * A unique identifier that references the migration task. <i>Do not include sensitive data in this field.</i>
         * </p>
         * 
         * @param migrationTaskName
         *        A unique identifier that references the migration task. <i>Do not include sensitive data in this
         *        field.</i>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder migrationTaskName(String migrationTaskName);

        /**
         * <p>
         * The source resource that you want to associate.
         * </p>
         * 
         * @param sourceResource
         *        The source resource that you want to associate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceResource(SourceResource sourceResource);

        /**
         * <p>
         * The source resource that you want to associate.
         * </p>
         * This is a convenience method that creates an instance of the {@link SourceResource.Builder} avoiding the need
         * to create one manually via {@link SourceResource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SourceResource.Builder#build()} is called immediately and its
         * result is passed to {@link #sourceResource(SourceResource)}.
         * 
         * @param sourceResource
         *        a consumer that will call methods on {@link SourceResource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceResource(SourceResource)
         */
        default Builder sourceResource(Consumer<SourceResource.Builder> sourceResource) {
            return sourceResource(SourceResource.builder().applyMutation(sourceResource).build());
        }

        /**
         * <p>
         * This is an optional parameter that you can use to test whether the call will succeed. Set this parameter to
         * <code>true</code> to verify that you have the permissions that are required to make the call, and that you
         * have specified the other parameters in the call correctly.
         * </p>
         * 
         * @param dryRun
         *        This is an optional parameter that you can use to test whether the call will succeed. Set this
         *        parameter to <code>true</code> to verify that you have the permissions that are required to make the
         *        call, and that you have specified the other parameters in the call correctly.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MigrationHubRequest.BuilderImpl implements Builder {
        private String progressUpdateStream;

        private String migrationTaskName;

        private SourceResource sourceResource;

        private Boolean dryRun;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateSourceResourceRequest model) {
            super(model);
            progressUpdateStream(model.progressUpdateStream);
            migrationTaskName(model.migrationTaskName);
            sourceResource(model.sourceResource);
            dryRun(model.dryRun);
        }

        public final String getProgressUpdateStream() {
            return progressUpdateStream;
        }

        public final void setProgressUpdateStream(String progressUpdateStream) {
            this.progressUpdateStream = progressUpdateStream;
        }

        @Override
        public final Builder progressUpdateStream(String progressUpdateStream) {
            this.progressUpdateStream = progressUpdateStream;
            return this;
        }

        public final String getMigrationTaskName() {
            return migrationTaskName;
        }

        public final void setMigrationTaskName(String migrationTaskName) {
            this.migrationTaskName = migrationTaskName;
        }

        @Override
        public final Builder migrationTaskName(String migrationTaskName) {
            this.migrationTaskName = migrationTaskName;
            return this;
        }

        public final SourceResource.Builder getSourceResource() {
            return sourceResource != null ? sourceResource.toBuilder() : null;
        }

        public final void setSourceResource(SourceResource.BuilderImpl sourceResource) {
            this.sourceResource = sourceResource != null ? sourceResource.build() : null;
        }

        @Override
        public final Builder sourceResource(SourceResource sourceResource) {
            this.sourceResource = sourceResource;
            return this;
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateSourceResourceRequest build() {
            return new AssociateSourceResourceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
