/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhub.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeApplicationStateResponse extends MigrationHubResponse implements
        ToCopyableBuilder<DescribeApplicationStateResponse.Builder, DescribeApplicationStateResponse> {
    private static final SdkField<String> APPLICATION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationStatus").getter(getter(DescribeApplicationStateResponse::applicationStatusAsString))
            .setter(setter(Builder::applicationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationStatus").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdatedTime").getter(getter(DescribeApplicationStateResponse::lastUpdatedTime))
            .setter(setter(Builder::lastUpdatedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_STATUS_FIELD,
            LAST_UPDATED_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String applicationStatus;

    private final Instant lastUpdatedTime;

    private DescribeApplicationStateResponse(BuilderImpl builder) {
        super(builder);
        this.applicationStatus = builder.applicationStatus;
        this.lastUpdatedTime = builder.lastUpdatedTime;
    }

    /**
     * <p>
     * Status of the application - Not Started, In-Progress, Complete.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #applicationStatus}
     * will return {@link ApplicationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #applicationStatusAsString}.
     * </p>
     * 
     * @return Status of the application - Not Started, In-Progress, Complete.
     * @see ApplicationStatus
     */
    public final ApplicationStatus applicationStatus() {
        return ApplicationStatus.fromValue(applicationStatus);
    }

    /**
     * <p>
     * Status of the application - Not Started, In-Progress, Complete.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #applicationStatus}
     * will return {@link ApplicationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #applicationStatusAsString}.
     * </p>
     * 
     * @return Status of the application - Not Started, In-Progress, Complete.
     * @see ApplicationStatus
     */
    public final String applicationStatusAsString() {
        return applicationStatus;
    }

    /**
     * <p>
     * The timestamp when the application status was last updated.
     * </p>
     * 
     * @return The timestamp when the application status was last updated.
     */
    public final Instant lastUpdatedTime() {
        return lastUpdatedTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeApplicationStateResponse)) {
            return false;
        }
        DescribeApplicationStateResponse other = (DescribeApplicationStateResponse) obj;
        return Objects.equals(applicationStatusAsString(), other.applicationStatusAsString())
                && Objects.equals(lastUpdatedTime(), other.lastUpdatedTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeApplicationStateResponse").add("ApplicationStatus", applicationStatusAsString())
                .add("LastUpdatedTime", lastUpdatedTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationStatus":
            return Optional.ofNullable(clazz.cast(applicationStatusAsString()));
        case "LastUpdatedTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ApplicationStatus", APPLICATION_STATUS_FIELD);
        map.put("LastUpdatedTime", LAST_UPDATED_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeApplicationStateResponse, T> g) {
        return obj -> g.apply((DescribeApplicationStateResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends MigrationHubResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeApplicationStateResponse> {
        /**
         * <p>
         * Status of the application - Not Started, In-Progress, Complete.
         * </p>
         * 
         * @param applicationStatus
         *        Status of the application - Not Started, In-Progress, Complete.
         * @see ApplicationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApplicationStatus
         */
        Builder applicationStatus(String applicationStatus);

        /**
         * <p>
         * Status of the application - Not Started, In-Progress, Complete.
         * </p>
         * 
         * @param applicationStatus
         *        Status of the application - Not Started, In-Progress, Complete.
         * @see ApplicationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApplicationStatus
         */
        Builder applicationStatus(ApplicationStatus applicationStatus);

        /**
         * <p>
         * The timestamp when the application status was last updated.
         * </p>
         * 
         * @param lastUpdatedTime
         *        The timestamp when the application status was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTime(Instant lastUpdatedTime);
    }

    static final class BuilderImpl extends MigrationHubResponse.BuilderImpl implements Builder {
        private String applicationStatus;

        private Instant lastUpdatedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeApplicationStateResponse model) {
            super(model);
            applicationStatus(model.applicationStatus);
            lastUpdatedTime(model.lastUpdatedTime);
        }

        public final String getApplicationStatus() {
            return applicationStatus;
        }

        public final void setApplicationStatus(String applicationStatus) {
            this.applicationStatus = applicationStatus;
        }

        @Override
        public final Builder applicationStatus(String applicationStatus) {
            this.applicationStatus = applicationStatus;
            return this;
        }

        @Override
        public final Builder applicationStatus(ApplicationStatus applicationStatus) {
            this.applicationStatus(applicationStatus == null ? null : applicationStatus.toString());
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        @Override
        public DescribeApplicationStateResponse build() {
            return new DescribeApplicationStateResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
