/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhub.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeMigrationTaskResponse extends MigrationHubResponse implements
        ToCopyableBuilder<DescribeMigrationTaskResponse.Builder, DescribeMigrationTaskResponse> {
    private static final SdkField<MigrationTask> MIGRATION_TASK_FIELD = SdkField
            .<MigrationTask> builder(MarshallingType.SDK_POJO).memberName("MigrationTask")
            .getter(getter(DescribeMigrationTaskResponse::migrationTask)).setter(setter(Builder::migrationTask))
            .constructor(MigrationTask::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MigrationTask").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MIGRATION_TASK_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final MigrationTask migrationTask;

    private DescribeMigrationTaskResponse(BuilderImpl builder) {
        super(builder);
        this.migrationTask = builder.migrationTask;
    }

    /**
     * <p>
     * Object encapsulating information about the migration task.
     * </p>
     * 
     * @return Object encapsulating information about the migration task.
     */
    public final MigrationTask migrationTask() {
        return migrationTask;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(migrationTask());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMigrationTaskResponse)) {
            return false;
        }
        DescribeMigrationTaskResponse other = (DescribeMigrationTaskResponse) obj;
        return Objects.equals(migrationTask(), other.migrationTask());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeMigrationTaskResponse").add("MigrationTask", migrationTask()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MigrationTask":
            return Optional.ofNullable(clazz.cast(migrationTask()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MigrationTask", MIGRATION_TASK_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeMigrationTaskResponse, T> g) {
        return obj -> g.apply((DescribeMigrationTaskResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends MigrationHubResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeMigrationTaskResponse> {
        /**
         * <p>
         * Object encapsulating information about the migration task.
         * </p>
         * 
         * @param migrationTask
         *        Object encapsulating information about the migration task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder migrationTask(MigrationTask migrationTask);

        /**
         * <p>
         * Object encapsulating information about the migration task.
         * </p>
         * This is a convenience method that creates an instance of the {@link MigrationTask.Builder} avoiding the need
         * to create one manually via {@link MigrationTask#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MigrationTask.Builder#build()} is called immediately and its
         * result is passed to {@link #migrationTask(MigrationTask)}.
         * 
         * @param migrationTask
         *        a consumer that will call methods on {@link MigrationTask.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #migrationTask(MigrationTask)
         */
        default Builder migrationTask(Consumer<MigrationTask.Builder> migrationTask) {
            return migrationTask(MigrationTask.builder().applyMutation(migrationTask).build());
        }
    }

    static final class BuilderImpl extends MigrationHubResponse.BuilderImpl implements Builder {
        private MigrationTask migrationTask;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMigrationTaskResponse model) {
            super(model);
            migrationTask(model.migrationTask);
        }

        public final MigrationTask.Builder getMigrationTask() {
            return migrationTask != null ? migrationTask.toBuilder() : null;
        }

        public final void setMigrationTask(MigrationTask.BuilderImpl migrationTask) {
            this.migrationTask = migrationTask != null ? migrationTask.build() : null;
        }

        @Override
        public final Builder migrationTask(MigrationTask migrationTask) {
            this.migrationTask = migrationTask;
            return this;
        }

        @Override
        public DescribeMigrationTaskResponse build() {
            return new DescribeMigrationTaskResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
