/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhubconfig;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.migrationhubconfig.model.CreateHomeRegionControlRequest;
import software.amazon.awssdk.services.migrationhubconfig.model.CreateHomeRegionControlResponse;
import software.amazon.awssdk.services.migrationhubconfig.model.DeleteHomeRegionControlRequest;
import software.amazon.awssdk.services.migrationhubconfig.model.DeleteHomeRegionControlResponse;
import software.amazon.awssdk.services.migrationhubconfig.model.DescribeHomeRegionControlsRequest;
import software.amazon.awssdk.services.migrationhubconfig.model.DescribeHomeRegionControlsResponse;
import software.amazon.awssdk.services.migrationhubconfig.model.GetHomeRegionRequest;
import software.amazon.awssdk.services.migrationhubconfig.model.GetHomeRegionResponse;
import software.amazon.awssdk.services.migrationhubconfig.paginators.DescribeHomeRegionControlsPublisher;

/**
 * Service client for accessing AWS Migration Hub Config asynchronously. This can be created using the static
 * {@link #builder()} method.
 *
 * <p>
 * The AWS Migration Hub home region APIs are available specifically for working with your Migration Hub home region.
 * You can use these APIs to determine a home region, as well as to create and work with controls that describe the home
 * region.
 * </p>
 * <ul>
 * <li>
 * <p>
 * You must make API calls for write actions (create, notify, associate, disassociate, import, or put) while in your
 * home region, or a <code>HomeRegionNotSetException</code> error is returned.
 * </p>
 * </li>
 * <li>
 * <p>
 * API calls for read actions (list, describe, stop, and delete) are permitted outside of your home region.
 * </p>
 * </li>
 * <li>
 * <p>
 * If you call a write API outside the home region, an <code>InvalidInputException</code> is returned.
 * </p>
 * </li>
 * <li>
 * <p>
 * You can call <code>GetHomeRegion</code> action to obtain the account's Migration Hub home region.
 * </p>
 * </li>
 * </ul>
 * <p>
 * For specific API usage, see the sections that follow in this AWS Migration Hub Home Region API reference.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface MigrationHubConfigAsyncClient extends AwsClient {
    String SERVICE_NAME = "mgh";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "migrationhub-config";

    /**
     * <p>
     * This API sets up the home region for the calling account only.
     * </p>
     *
     * @param createHomeRegionControlRequest
     * @return A Java Future containing the result of the CreateHomeRegionControl operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException Exception raised when an internal, configuration, or dependency error is
     *         encountered.</li>
     *         <li>ServiceUnavailableException Exception raised when a request fails due to temporary unavailability of
     *         the service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>DryRunOperationException Exception raised to indicate that authorization of an action was successful,
     *         when the <code>DryRun</code> flag is set to true.</li>
     *         <li>InvalidInputException Exception raised when the provided input violates a policy constraint or is
     *         entered in the wrong format or data type.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MigrationHubConfigException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample MigrationHubConfigAsyncClient.CreateHomeRegionControl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhub-config-2019-06-30/CreateHomeRegionControl"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateHomeRegionControlResponse> createHomeRegionControl(
            CreateHomeRegionControlRequest createHomeRegionControlRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API sets up the home region for the calling account only.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateHomeRegionControlRequest.Builder} avoiding
     * the need to create one manually via {@link CreateHomeRegionControlRequest#builder()}
     * </p>
     *
     * @param createHomeRegionControlRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.migrationhubconfig.model.CreateHomeRegionControlRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateHomeRegionControl operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException Exception raised when an internal, configuration, or dependency error is
     *         encountered.</li>
     *         <li>ServiceUnavailableException Exception raised when a request fails due to temporary unavailability of
     *         the service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>DryRunOperationException Exception raised to indicate that authorization of an action was successful,
     *         when the <code>DryRun</code> flag is set to true.</li>
     *         <li>InvalidInputException Exception raised when the provided input violates a policy constraint or is
     *         entered in the wrong format or data type.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MigrationHubConfigException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample MigrationHubConfigAsyncClient.CreateHomeRegionControl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhub-config-2019-06-30/CreateHomeRegionControl"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateHomeRegionControlResponse> createHomeRegionControl(
            Consumer<CreateHomeRegionControlRequest.Builder> createHomeRegionControlRequest) {
        return createHomeRegionControl(CreateHomeRegionControlRequest.builder().applyMutation(createHomeRegionControlRequest)
                .build());
    }

    /**
     * <p>
     * This operation deletes the home region configuration for the calling account. The operation does not delete
     * discovery or migration tracking data in the home region.
     * </p>
     *
     * @param deleteHomeRegionControlRequest
     * @return A Java Future containing the result of the DeleteHomeRegionControl operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException Exception raised when an internal, configuration, or dependency error is
     *         encountered.</li>
     *         <li>ServiceUnavailableException Exception raised when a request fails due to temporary unavailability of
     *         the service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InvalidInputException Exception raised when the provided input violates a policy constraint or is
     *         entered in the wrong format or data type.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MigrationHubConfigException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample MigrationHubConfigAsyncClient.DeleteHomeRegionControl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhub-config-2019-06-30/DeleteHomeRegionControl"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteHomeRegionControlResponse> deleteHomeRegionControl(
            DeleteHomeRegionControlRequest deleteHomeRegionControlRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation deletes the home region configuration for the calling account. The operation does not delete
     * discovery or migration tracking data in the home region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteHomeRegionControlRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteHomeRegionControlRequest#builder()}
     * </p>
     *
     * @param deleteHomeRegionControlRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.migrationhubconfig.model.DeleteHomeRegionControlRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteHomeRegionControl operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException Exception raised when an internal, configuration, or dependency error is
     *         encountered.</li>
     *         <li>ServiceUnavailableException Exception raised when a request fails due to temporary unavailability of
     *         the service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InvalidInputException Exception raised when the provided input violates a policy constraint or is
     *         entered in the wrong format or data type.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MigrationHubConfigException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample MigrationHubConfigAsyncClient.DeleteHomeRegionControl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhub-config-2019-06-30/DeleteHomeRegionControl"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteHomeRegionControlResponse> deleteHomeRegionControl(
            Consumer<DeleteHomeRegionControlRequest.Builder> deleteHomeRegionControlRequest) {
        return deleteHomeRegionControl(DeleteHomeRegionControlRequest.builder().applyMutation(deleteHomeRegionControlRequest)
                .build());
    }

    /**
     * <p>
     * This API permits filtering on the <code>ControlId</code> and <code>HomeRegion</code> fields.
     * </p>
     *
     * @param describeHomeRegionControlsRequest
     * @return A Java Future containing the result of the DescribeHomeRegionControls operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException Exception raised when an internal, configuration, or dependency error is
     *         encountered.</li>
     *         <li>ServiceUnavailableException Exception raised when a request fails due to temporary unavailability of
     *         the service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InvalidInputException Exception raised when the provided input violates a policy constraint or is
     *         entered in the wrong format or data type.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MigrationHubConfigException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample MigrationHubConfigAsyncClient.DescribeHomeRegionControls
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhub-config-2019-06-30/DescribeHomeRegionControls"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeHomeRegionControlsResponse> describeHomeRegionControls(
            DescribeHomeRegionControlsRequest describeHomeRegionControlsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API permits filtering on the <code>ControlId</code> and <code>HomeRegion</code> fields.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeHomeRegionControlsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeHomeRegionControlsRequest#builder()}
     * </p>
     *
     * @param describeHomeRegionControlsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.migrationhubconfig.model.DescribeHomeRegionControlsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DescribeHomeRegionControls operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException Exception raised when an internal, configuration, or dependency error is
     *         encountered.</li>
     *         <li>ServiceUnavailableException Exception raised when a request fails due to temporary unavailability of
     *         the service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InvalidInputException Exception raised when the provided input violates a policy constraint or is
     *         entered in the wrong format or data type.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MigrationHubConfigException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample MigrationHubConfigAsyncClient.DescribeHomeRegionControls
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhub-config-2019-06-30/DescribeHomeRegionControls"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeHomeRegionControlsResponse> describeHomeRegionControls(
            Consumer<DescribeHomeRegionControlsRequest.Builder> describeHomeRegionControlsRequest) {
        return describeHomeRegionControls(DescribeHomeRegionControlsRequest.builder()
                .applyMutation(describeHomeRegionControlsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeHomeRegionControls(software.amazon.awssdk.services.migrationhubconfig.model.DescribeHomeRegionControlsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.migrationhubconfig.paginators.DescribeHomeRegionControlsPublisher publisher = client.describeHomeRegionControlsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.migrationhubconfig.paginators.DescribeHomeRegionControlsPublisher publisher = client.describeHomeRegionControlsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.migrationhubconfig.model.DescribeHomeRegionControlsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.migrationhubconfig.model.DescribeHomeRegionControlsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeHomeRegionControls(software.amazon.awssdk.services.migrationhubconfig.model.DescribeHomeRegionControlsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeHomeRegionControlsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException Exception raised when an internal, configuration, or dependency error is
     *         encountered.</li>
     *         <li>ServiceUnavailableException Exception raised when a request fails due to temporary unavailability of
     *         the service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InvalidInputException Exception raised when the provided input violates a policy constraint or is
     *         entered in the wrong format or data type.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MigrationHubConfigException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample MigrationHubConfigAsyncClient.DescribeHomeRegionControls
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhub-config-2019-06-30/DescribeHomeRegionControls"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeHomeRegionControlsPublisher describeHomeRegionControlsPaginator(
            DescribeHomeRegionControlsRequest describeHomeRegionControlsRequest) {
        return new DescribeHomeRegionControlsPublisher(this, describeHomeRegionControlsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeHomeRegionControls(software.amazon.awssdk.services.migrationhubconfig.model.DescribeHomeRegionControlsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.migrationhubconfig.paginators.DescribeHomeRegionControlsPublisher publisher = client.describeHomeRegionControlsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.migrationhubconfig.paginators.DescribeHomeRegionControlsPublisher publisher = client.describeHomeRegionControlsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.migrationhubconfig.model.DescribeHomeRegionControlsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.migrationhubconfig.model.DescribeHomeRegionControlsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeHomeRegionControls(software.amazon.awssdk.services.migrationhubconfig.model.DescribeHomeRegionControlsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeHomeRegionControlsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeHomeRegionControlsRequest#builder()}
     * </p>
     *
     * @param describeHomeRegionControlsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.migrationhubconfig.model.DescribeHomeRegionControlsRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException Exception raised when an internal, configuration, or dependency error is
     *         encountered.</li>
     *         <li>ServiceUnavailableException Exception raised when a request fails due to temporary unavailability of
     *         the service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InvalidInputException Exception raised when the provided input violates a policy constraint or is
     *         entered in the wrong format or data type.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MigrationHubConfigException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample MigrationHubConfigAsyncClient.DescribeHomeRegionControls
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhub-config-2019-06-30/DescribeHomeRegionControls"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeHomeRegionControlsPublisher describeHomeRegionControlsPaginator(
            Consumer<DescribeHomeRegionControlsRequest.Builder> describeHomeRegionControlsRequest) {
        return describeHomeRegionControlsPaginator(DescribeHomeRegionControlsRequest.builder()
                .applyMutation(describeHomeRegionControlsRequest).build());
    }

    /**
     * <p>
     * Returns the calling account’s home region, if configured. This API is used by other AWS services to determine the
     * regional endpoint for calling AWS Application Discovery Service and Migration Hub. You must call
     * <code>GetHomeRegion</code> at least once before you call any other AWS Application Discovery Service and AWS
     * Migration Hub APIs, to obtain the account's Migration Hub home region.
     * </p>
     *
     * @param getHomeRegionRequest
     * @return A Java Future containing the result of the GetHomeRegion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException Exception raised when an internal, configuration, or dependency error is
     *         encountered.</li>
     *         <li>ServiceUnavailableException Exception raised when a request fails due to temporary unavailability of
     *         the service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InvalidInputException Exception raised when the provided input violates a policy constraint or is
     *         entered in the wrong format or data type.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MigrationHubConfigException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample MigrationHubConfigAsyncClient.GetHomeRegion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhub-config-2019-06-30/GetHomeRegion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetHomeRegionResponse> getHomeRegion(GetHomeRegionRequest getHomeRegionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the calling account’s home region, if configured. This API is used by other AWS services to determine the
     * regional endpoint for calling AWS Application Discovery Service and Migration Hub. You must call
     * <code>GetHomeRegion</code> at least once before you call any other AWS Application Discovery Service and AWS
     * Migration Hub APIs, to obtain the account's Migration Hub home region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetHomeRegionRequest.Builder} avoiding the need to
     * create one manually via {@link GetHomeRegionRequest#builder()}
     * </p>
     *
     * @param getHomeRegionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.migrationhubconfig.model.GetHomeRegionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetHomeRegion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException Exception raised when an internal, configuration, or dependency error is
     *         encountered.</li>
     *         <li>ServiceUnavailableException Exception raised when a request fails due to temporary unavailability of
     *         the service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InvalidInputException Exception raised when the provided input violates a policy constraint or is
     *         entered in the wrong format or data type.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MigrationHubConfigException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample MigrationHubConfigAsyncClient.GetHomeRegion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/migrationhub-config-2019-06-30/GetHomeRegion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetHomeRegionResponse> getHomeRegion(Consumer<GetHomeRegionRequest.Builder> getHomeRegionRequest) {
        return getHomeRegion(GetHomeRegionRequest.builder().applyMutation(getHomeRegionRequest).build());
    }

    @Override
    default MigrationHubConfigServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link MigrationHubConfigAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static MigrationHubConfigAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link MigrationHubConfigAsyncClient}.
     */
    static MigrationHubConfigAsyncClientBuilder builder() {
        return new DefaultMigrationHubConfigAsyncClientBuilder();
    }
}
