/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhubconfig.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeHomeRegionControlsRequest extends MigrationHubConfigRequest implements
        ToCopyableBuilder<DescribeHomeRegionControlsRequest.Builder, DescribeHomeRegionControlsRequest> {
    private static final SdkField<String> CONTROL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ControlId").getter(getter(DescribeHomeRegionControlsRequest::controlId))
            .setter(setter(Builder::controlId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ControlId").build()).build();

    private static final SdkField<String> HOME_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HomeRegion").getter(getter(DescribeHomeRegionControlsRequest::homeRegion))
            .setter(setter(Builder::homeRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HomeRegion").build()).build();

    private static final SdkField<Target> TARGET_FIELD = SdkField.<Target> builder(MarshallingType.SDK_POJO).memberName("Target")
            .getter(getter(DescribeHomeRegionControlsRequest::target)).setter(setter(Builder::target))
            .constructor(Target::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Target").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(DescribeHomeRegionControlsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeHomeRegionControlsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTROL_ID_FIELD,
            HOME_REGION_FIELD, TARGET_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String controlId;

    private final String homeRegion;

    private final Target target;

    private final Integer maxResults;

    private final String nextToken;

    private DescribeHomeRegionControlsRequest(BuilderImpl builder) {
        super(builder);
        this.controlId = builder.controlId;
        this.homeRegion = builder.homeRegion;
        this.target = builder.target;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The <code>ControlID</code> is a unique identifier string of your <code>HomeRegionControl</code> object.
     * </p>
     * 
     * @return The <code>ControlID</code> is a unique identifier string of your <code>HomeRegionControl</code> object.
     */
    public final String controlId() {
        return controlId;
    }

    /**
     * <p>
     * The name of the home region you'd like to view.
     * </p>
     * 
     * @return The name of the home region you'd like to view.
     */
    public final String homeRegion() {
        return homeRegion;
    }

    /**
     * <p>
     * The target parameter specifies the identifier to which the home region is applied, which is always of type
     * <code>ACCOUNT</code>. It applies the home region to the current <code>ACCOUNT</code>.
     * </p>
     * 
     * @return The target parameter specifies the identifier to which the home region is applied, which is always of
     *         type <code>ACCOUNT</code>. It applies the home region to the current <code>ACCOUNT</code>.
     */
    public final Target target() {
        return target;
    }

    /**
     * <p>
     * The maximum number of filtering results to display per page.
     * </p>
     * 
     * @return The maximum number of filtering results to display per page.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * If a <code>NextToken</code> was returned by a previous call, more results are available. To retrieve the next
     * page of results, make the call again using the returned token in <code>NextToken</code>.
     * </p>
     * 
     * @return If a <code>NextToken</code> was returned by a previous call, more results are available. To retrieve the
     *         next page of results, make the call again using the returned token in <code>NextToken</code>.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(controlId());
        hashCode = 31 * hashCode + Objects.hashCode(homeRegion());
        hashCode = 31 * hashCode + Objects.hashCode(target());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeHomeRegionControlsRequest)) {
            return false;
        }
        DescribeHomeRegionControlsRequest other = (DescribeHomeRegionControlsRequest) obj;
        return Objects.equals(controlId(), other.controlId()) && Objects.equals(homeRegion(), other.homeRegion())
                && Objects.equals(target(), other.target()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeHomeRegionControlsRequest").add("ControlId", controlId())
                .add("HomeRegion", homeRegion()).add("Target", target()).add("MaxResults", maxResults())
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ControlId":
            return Optional.ofNullable(clazz.cast(controlId()));
        case "HomeRegion":
            return Optional.ofNullable(clazz.cast(homeRegion()));
        case "Target":
            return Optional.ofNullable(clazz.cast(target()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ControlId", CONTROL_ID_FIELD);
        map.put("HomeRegion", HOME_REGION_FIELD);
        map.put("Target", TARGET_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeHomeRegionControlsRequest, T> g) {
        return obj -> g.apply((DescribeHomeRegionControlsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MigrationHubConfigRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeHomeRegionControlsRequest> {
        /**
         * <p>
         * The <code>ControlID</code> is a unique identifier string of your <code>HomeRegionControl</code> object.
         * </p>
         * 
         * @param controlId
         *        The <code>ControlID</code> is a unique identifier string of your <code>HomeRegionControl</code>
         *        object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder controlId(String controlId);

        /**
         * <p>
         * The name of the home region you'd like to view.
         * </p>
         * 
         * @param homeRegion
         *        The name of the home region you'd like to view.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder homeRegion(String homeRegion);

        /**
         * <p>
         * The target parameter specifies the identifier to which the home region is applied, which is always of type
         * <code>ACCOUNT</code>. It applies the home region to the current <code>ACCOUNT</code>.
         * </p>
         * 
         * @param target
         *        The target parameter specifies the identifier to which the home region is applied, which is always of
         *        type <code>ACCOUNT</code>. It applies the home region to the current <code>ACCOUNT</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder target(Target target);

        /**
         * <p>
         * The target parameter specifies the identifier to which the home region is applied, which is always of type
         * <code>ACCOUNT</code>. It applies the home region to the current <code>ACCOUNT</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link Target.Builder} avoiding the need to
         * create one manually via {@link Target#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Target.Builder#build()} is called immediately and its result is
         * passed to {@link #target(Target)}.
         * 
         * @param target
         *        a consumer that will call methods on {@link Target.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #target(Target)
         */
        default Builder target(Consumer<Target.Builder> target) {
            return target(Target.builder().applyMutation(target).build());
        }

        /**
         * <p>
         * The maximum number of filtering results to display per page.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of filtering results to display per page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * If a <code>NextToken</code> was returned by a previous call, more results are available. To retrieve the next
         * page of results, make the call again using the returned token in <code>NextToken</code>.
         * </p>
         * 
         * @param nextToken
         *        If a <code>NextToken</code> was returned by a previous call, more results are available. To retrieve
         *        the next page of results, make the call again using the returned token in <code>NextToken</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MigrationHubConfigRequest.BuilderImpl implements Builder {
        private String controlId;

        private String homeRegion;

        private Target target;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeHomeRegionControlsRequest model) {
            super(model);
            controlId(model.controlId);
            homeRegion(model.homeRegion);
            target(model.target);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getControlId() {
            return controlId;
        }

        public final void setControlId(String controlId) {
            this.controlId = controlId;
        }

        @Override
        public final Builder controlId(String controlId) {
            this.controlId = controlId;
            return this;
        }

        public final String getHomeRegion() {
            return homeRegion;
        }

        public final void setHomeRegion(String homeRegion) {
            this.homeRegion = homeRegion;
        }

        @Override
        public final Builder homeRegion(String homeRegion) {
            this.homeRegion = homeRegion;
            return this;
        }

        public final Target.Builder getTarget() {
            return target != null ? target.toBuilder() : null;
        }

        public final void setTarget(Target.BuilderImpl target) {
            this.target = target != null ? target.build() : null;
        }

        @Override
        public final Builder target(Target target) {
            this.target = target;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeHomeRegionControlsRequest build() {
            return new DescribeHomeRegionControlsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
