/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhubconfig.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A home region control is an object that specifies the home region for an account, with some additional information.
 * It contains a target (always of type <code>ACCOUNT</code>), an ID, and a time at which the home region was set.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HomeRegionControl implements SdkPojo, Serializable,
        ToCopyableBuilder<HomeRegionControl.Builder, HomeRegionControl> {
    private static final SdkField<String> CONTROL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ControlId").getter(getter(HomeRegionControl::controlId)).setter(setter(Builder::controlId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ControlId").build()).build();

    private static final SdkField<String> HOME_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HomeRegion").getter(getter(HomeRegionControl::homeRegion)).setter(setter(Builder::homeRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HomeRegion").build()).build();

    private static final SdkField<Target> TARGET_FIELD = SdkField.<Target> builder(MarshallingType.SDK_POJO).memberName("Target")
            .getter(getter(HomeRegionControl::target)).setter(setter(Builder::target)).constructor(Target::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Target").build()).build();

    private static final SdkField<Instant> REQUESTED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("RequestedTime").getter(getter(HomeRegionControl::requestedTime)).setter(setter(Builder::requestedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestedTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTROL_ID_FIELD,
            HOME_REGION_FIELD, TARGET_FIELD, REQUESTED_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String controlId;

    private final String homeRegion;

    private final Target target;

    private final Instant requestedTime;

    private HomeRegionControl(BuilderImpl builder) {
        this.controlId = builder.controlId;
        this.homeRegion = builder.homeRegion;
        this.target = builder.target;
        this.requestedTime = builder.requestedTime;
    }

    /**
     * <p>
     * A unique identifier that's generated for each home region control. It's always a string that begins with "hrc-"
     * followed by 12 lowercase letters and numbers.
     * </p>
     * 
     * @return A unique identifier that's generated for each home region control. It's always a string that begins with
     *         "hrc-" followed by 12 lowercase letters and numbers.
     */
    public final String controlId() {
        return controlId;
    }

    /**
     * <p>
     * The AWS Region that's been set as home region. For example, "us-west-2" or "eu-central-1" are valid home regions.
     * </p>
     * 
     * @return The AWS Region that's been set as home region. For example, "us-west-2" or "eu-central-1" are valid home
     *         regions.
     */
    public final String homeRegion() {
        return homeRegion;
    }

    /**
     * <p>
     * The target parameter specifies the identifier to which the home region is applied, which is always an
     * <code>ACCOUNT</code>. It applies the home region to the current <code>ACCOUNT</code>.
     * </p>
     * 
     * @return The target parameter specifies the identifier to which the home region is applied, which is always an
     *         <code>ACCOUNT</code>. It applies the home region to the current <code>ACCOUNT</code>.
     */
    public final Target target() {
        return target;
    }

    /**
     * <p>
     * A timestamp representing the time when the customer called <code>CreateHomeregionControl</code> and set the home
     * region for the account.
     * </p>
     * 
     * @return A timestamp representing the time when the customer called <code>CreateHomeregionControl</code> and set
     *         the home region for the account.
     */
    public final Instant requestedTime() {
        return requestedTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(controlId());
        hashCode = 31 * hashCode + Objects.hashCode(homeRegion());
        hashCode = 31 * hashCode + Objects.hashCode(target());
        hashCode = 31 * hashCode + Objects.hashCode(requestedTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HomeRegionControl)) {
            return false;
        }
        HomeRegionControl other = (HomeRegionControl) obj;
        return Objects.equals(controlId(), other.controlId()) && Objects.equals(homeRegion(), other.homeRegion())
                && Objects.equals(target(), other.target()) && Objects.equals(requestedTime(), other.requestedTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HomeRegionControl").add("ControlId", controlId()).add("HomeRegion", homeRegion())
                .add("Target", target()).add("RequestedTime", requestedTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ControlId":
            return Optional.ofNullable(clazz.cast(controlId()));
        case "HomeRegion":
            return Optional.ofNullable(clazz.cast(homeRegion()));
        case "Target":
            return Optional.ofNullable(clazz.cast(target()));
        case "RequestedTime":
            return Optional.ofNullable(clazz.cast(requestedTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ControlId", CONTROL_ID_FIELD);
        map.put("HomeRegion", HOME_REGION_FIELD);
        map.put("Target", TARGET_FIELD);
        map.put("RequestedTime", REQUESTED_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<HomeRegionControl, T> g) {
        return obj -> g.apply((HomeRegionControl) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HomeRegionControl> {
        /**
         * <p>
         * A unique identifier that's generated for each home region control. It's always a string that begins with
         * "hrc-" followed by 12 lowercase letters and numbers.
         * </p>
         * 
         * @param controlId
         *        A unique identifier that's generated for each home region control. It's always a string that begins
         *        with "hrc-" followed by 12 lowercase letters and numbers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder controlId(String controlId);

        /**
         * <p>
         * The AWS Region that's been set as home region. For example, "us-west-2" or "eu-central-1" are valid home
         * regions.
         * </p>
         * 
         * @param homeRegion
         *        The AWS Region that's been set as home region. For example, "us-west-2" or "eu-central-1" are valid
         *        home regions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder homeRegion(String homeRegion);

        /**
         * <p>
         * The target parameter specifies the identifier to which the home region is applied, which is always an
         * <code>ACCOUNT</code>. It applies the home region to the current <code>ACCOUNT</code>.
         * </p>
         * 
         * @param target
         *        The target parameter specifies the identifier to which the home region is applied, which is always an
         *        <code>ACCOUNT</code>. It applies the home region to the current <code>ACCOUNT</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder target(Target target);

        /**
         * <p>
         * The target parameter specifies the identifier to which the home region is applied, which is always an
         * <code>ACCOUNT</code>. It applies the home region to the current <code>ACCOUNT</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link Target.Builder} avoiding the need to
         * create one manually via {@link Target#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Target.Builder#build()} is called immediately and its result is
         * passed to {@link #target(Target)}.
         * 
         * @param target
         *        a consumer that will call methods on {@link Target.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #target(Target)
         */
        default Builder target(Consumer<Target.Builder> target) {
            return target(Target.builder().applyMutation(target).build());
        }

        /**
         * <p>
         * A timestamp representing the time when the customer called <code>CreateHomeregionControl</code> and set the
         * home region for the account.
         * </p>
         * 
         * @param requestedTime
         *        A timestamp representing the time when the customer called <code>CreateHomeregionControl</code> and
         *        set the home region for the account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestedTime(Instant requestedTime);
    }

    static final class BuilderImpl implements Builder {
        private String controlId;

        private String homeRegion;

        private Target target;

        private Instant requestedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(HomeRegionControl model) {
            controlId(model.controlId);
            homeRegion(model.homeRegion);
            target(model.target);
            requestedTime(model.requestedTime);
        }

        public final String getControlId() {
            return controlId;
        }

        public final void setControlId(String controlId) {
            this.controlId = controlId;
        }

        @Override
        public final Builder controlId(String controlId) {
            this.controlId = controlId;
            return this;
        }

        public final String getHomeRegion() {
            return homeRegion;
        }

        public final void setHomeRegion(String homeRegion) {
            this.homeRegion = homeRegion;
        }

        @Override
        public final Builder homeRegion(String homeRegion) {
            this.homeRegion = homeRegion;
            return this;
        }

        public final Target.Builder getTarget() {
            return target != null ? target.toBuilder() : null;
        }

        public final void setTarget(Target.BuilderImpl target) {
            this.target = target != null ? target.build() : null;
        }

        @Override
        public final Builder target(Target target) {
            this.target = target;
            return this;
        }

        public final Instant getRequestedTime() {
            return requestedTime;
        }

        public final void setRequestedTime(Instant requestedTime) {
            this.requestedTime = requestedTime;
        }

        @Override
        public final Builder requestedTime(Instant requestedTime) {
            this.requestedTime = requestedTime;
            return this;
        }

        @Override
        public HomeRegionControl build() {
            return new HomeRegionControl(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
