/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhubrefactorspaces.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The summary information for environments as a response to <code>ListEnvironments</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EnvironmentSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<EnvironmentSummary.Builder, EnvironmentSummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(EnvironmentSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTime").getter(getter(EnvironmentSummary::createdTime)).setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(EnvironmentSummary::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> ENVIRONMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EnvironmentId").getter(getter(EnvironmentSummary::environmentId)).setter(setter(Builder::environmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnvironmentId").build()).build();

    private static final SdkField<ErrorResponse> ERROR_FIELD = SdkField.<ErrorResponse> builder(MarshallingType.SDK_POJO)
            .memberName("Error").getter(getter(EnvironmentSummary::error)).setter(setter(Builder::error))
            .constructor(ErrorResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Error").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdatedTime").getter(getter(EnvironmentSummary::lastUpdatedTime))
            .setter(setter(Builder::lastUpdatedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(EnvironmentSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> NETWORK_FABRIC_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NetworkFabricType").getter(getter(EnvironmentSummary::networkFabricTypeAsString))
            .setter(setter(Builder::networkFabricType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkFabricType").build()).build();

    private static final SdkField<String> OWNER_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OwnerAccountId").getter(getter(EnvironmentSummary::ownerAccountId))
            .setter(setter(Builder::ownerAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerAccountId").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(EnvironmentSummary::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(EnvironmentSummary::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> TRANSIT_GATEWAY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TransitGatewayId").getter(getter(EnvironmentSummary::transitGatewayId))
            .setter(setter(Builder::transitGatewayId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CREATED_TIME_FIELD,
            DESCRIPTION_FIELD, ENVIRONMENT_ID_FIELD, ERROR_FIELD, LAST_UPDATED_TIME_FIELD, NAME_FIELD, NETWORK_FABRIC_TYPE_FIELD,
            OWNER_ACCOUNT_ID_FIELD, STATE_FIELD, TAGS_FIELD, TRANSIT_GATEWAY_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final Instant createdTime;

    private final String description;

    private final String environmentId;

    private final ErrorResponse error;

    private final Instant lastUpdatedTime;

    private final String name;

    private final String networkFabricType;

    private final String ownerAccountId;

    private final String state;

    private final Map<String, String> tags;

    private final String transitGatewayId;

    private EnvironmentSummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.createdTime = builder.createdTime;
        this.description = builder.description;
        this.environmentId = builder.environmentId;
        this.error = builder.error;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.name = builder.name;
        this.networkFabricType = builder.networkFabricType;
        this.ownerAccountId = builder.ownerAccountId;
        this.state = builder.state;
        this.tags = builder.tags;
        this.transitGatewayId = builder.transitGatewayId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the environment.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the environment.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * A timestamp that indicates when the environment is created.
     * </p>
     * 
     * @return A timestamp that indicates when the environment is created.
     */
    public final Instant createdTime() {
        return createdTime;
    }

    /**
     * <p>
     * A description of the environment.
     * </p>
     * 
     * @return A description of the environment.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The unique identifier of the environment.
     * </p>
     * 
     * @return The unique identifier of the environment.
     */
    public final String environmentId() {
        return environmentId;
    }

    /**
     * <p>
     * Any error associated with the environment resource.
     * </p>
     * 
     * @return Any error associated with the environment resource.
     */
    public final ErrorResponse error() {
        return error;
    }

    /**
     * <p>
     * A timestamp that indicates when the environment was last updated.
     * </p>
     * 
     * @return A timestamp that indicates when the environment was last updated.
     */
    public final Instant lastUpdatedTime() {
        return lastUpdatedTime;
    }

    /**
     * <p>
     * The name of the environment.
     * </p>
     * 
     * @return The name of the environment.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The network fabric type of the environment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #networkFabricType}
     * will return {@link NetworkFabricType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #networkFabricTypeAsString}.
     * </p>
     * 
     * @return The network fabric type of the environment.
     * @see NetworkFabricType
     */
    public final NetworkFabricType networkFabricType() {
        return NetworkFabricType.fromValue(networkFabricType);
    }

    /**
     * <p>
     * The network fabric type of the environment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #networkFabricType}
     * will return {@link NetworkFabricType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #networkFabricTypeAsString}.
     * </p>
     * 
     * @return The network fabric type of the environment.
     * @see NetworkFabricType
     */
    public final String networkFabricTypeAsString() {
        return networkFabricType;
    }

    /**
     * <p>
     * The Amazon Web Services account ID of the environment owner.
     * </p>
     * 
     * @return The Amazon Web Services account ID of the environment owner.
     */
    public final String ownerAccountId() {
        return ownerAccountId;
    }

    /**
     * <p>
     * The current state of the environment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link EnvironmentState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current state of the environment.
     * @see EnvironmentState
     */
    public final EnvironmentState state() {
        return EnvironmentState.fromValue(state);
    }

    /**
     * <p>
     * The current state of the environment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link EnvironmentState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current state of the environment.
     * @see EnvironmentState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags assigned to the environment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags assigned to the environment.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The ID of the transit gateway set up by the environment.
     * </p>
     * 
     * @return The ID of the transit gateway set up by the environment.
     */
    public final String transitGatewayId() {
        return transitGatewayId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(environmentId());
        hashCode = 31 * hashCode + Objects.hashCode(error());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(networkFabricTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(ownerAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(transitGatewayId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnvironmentSummary)) {
            return false;
        }
        EnvironmentSummary other = (EnvironmentSummary) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(createdTime(), other.createdTime())
                && Objects.equals(description(), other.description()) && Objects.equals(environmentId(), other.environmentId())
                && Objects.equals(error(), other.error()) && Objects.equals(lastUpdatedTime(), other.lastUpdatedTime())
                && Objects.equals(name(), other.name())
                && Objects.equals(networkFabricTypeAsString(), other.networkFabricTypeAsString())
                && Objects.equals(ownerAccountId(), other.ownerAccountId())
                && Objects.equals(stateAsString(), other.stateAsString()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(transitGatewayId(), other.transitGatewayId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EnvironmentSummary").add("Arn", arn()).add("CreatedTime", createdTime())
                .add("Description", description()).add("EnvironmentId", environmentId()).add("Error", error())
                .add("LastUpdatedTime", lastUpdatedTime()).add("Name", name())
                .add("NetworkFabricType", networkFabricTypeAsString()).add("OwnerAccountId", ownerAccountId())
                .add("State", stateAsString()).add("Tags", tags() == null ? null : "*** Sensitive Data Redacted ***")
                .add("TransitGatewayId", transitGatewayId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "CreatedTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "EnvironmentId":
            return Optional.ofNullable(clazz.cast(environmentId()));
        case "Error":
            return Optional.ofNullable(clazz.cast(error()));
        case "LastUpdatedTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedTime()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "NetworkFabricType":
            return Optional.ofNullable(clazz.cast(networkFabricTypeAsString()));
        case "OwnerAccountId":
            return Optional.ofNullable(clazz.cast(ownerAccountId()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "TransitGatewayId":
            return Optional.ofNullable(clazz.cast(transitGatewayId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EnvironmentSummary, T> g) {
        return obj -> g.apply((EnvironmentSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EnvironmentSummary> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the environment.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * A timestamp that indicates when the environment is created.
         * </p>
         * 
         * @param createdTime
         *        A timestamp that indicates when the environment is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(Instant createdTime);

        /**
         * <p>
         * A description of the environment.
         * </p>
         * 
         * @param description
         *        A description of the environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The unique identifier of the environment.
         * </p>
         * 
         * @param environmentId
         *        The unique identifier of the environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentId(String environmentId);

        /**
         * <p>
         * Any error associated with the environment resource.
         * </p>
         * 
         * @param error
         *        Any error associated with the environment resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder error(ErrorResponse error);

        /**
         * <p>
         * Any error associated with the environment resource.
         * </p>
         * This is a convenience that creates an instance of the {@link ErrorResponse.Builder} avoiding the need to
         * create one manually via {@link ErrorResponse#builder()}.
         *
         * When the {@link Consumer} completes, {@link ErrorResponse.Builder#build()} is called immediately and its
         * result is passed to {@link #error(ErrorResponse)}.
         * 
         * @param error
         *        a consumer that will call methods on {@link ErrorResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #error(ErrorResponse)
         */
        default Builder error(Consumer<ErrorResponse.Builder> error) {
            return error(ErrorResponse.builder().applyMutation(error).build());
        }

        /**
         * <p>
         * A timestamp that indicates when the environment was last updated.
         * </p>
         * 
         * @param lastUpdatedTime
         *        A timestamp that indicates when the environment was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTime(Instant lastUpdatedTime);

        /**
         * <p>
         * The name of the environment.
         * </p>
         * 
         * @param name
         *        The name of the environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The network fabric type of the environment.
         * </p>
         * 
         * @param networkFabricType
         *        The network fabric type of the environment.
         * @see NetworkFabricType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NetworkFabricType
         */
        Builder networkFabricType(String networkFabricType);

        /**
         * <p>
         * The network fabric type of the environment.
         * </p>
         * 
         * @param networkFabricType
         *        The network fabric type of the environment.
         * @see NetworkFabricType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NetworkFabricType
         */
        Builder networkFabricType(NetworkFabricType networkFabricType);

        /**
         * <p>
         * The Amazon Web Services account ID of the environment owner.
         * </p>
         * 
         * @param ownerAccountId
         *        The Amazon Web Services account ID of the environment owner.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerAccountId(String ownerAccountId);

        /**
         * <p>
         * The current state of the environment.
         * </p>
         * 
         * @param state
         *        The current state of the environment.
         * @see EnvironmentState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnvironmentState
         */
        Builder state(String state);

        /**
         * <p>
         * The current state of the environment.
         * </p>
         * 
         * @param state
         *        The current state of the environment.
         * @see EnvironmentState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnvironmentState
         */
        Builder state(EnvironmentState state);

        /**
         * <p>
         * The tags assigned to the environment.
         * </p>
         * 
         * @param tags
         *        The tags assigned to the environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The ID of the transit gateway set up by the environment.
         * </p>
         * 
         * @param transitGatewayId
         *        The ID of the transit gateway set up by the environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitGatewayId(String transitGatewayId);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private Instant createdTime;

        private String description;

        private String environmentId;

        private ErrorResponse error;

        private Instant lastUpdatedTime;

        private String name;

        private String networkFabricType;

        private String ownerAccountId;

        private String state;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String transitGatewayId;

        private BuilderImpl() {
        }

        private BuilderImpl(EnvironmentSummary model) {
            arn(model.arn);
            createdTime(model.createdTime);
            description(model.description);
            environmentId(model.environmentId);
            error(model.error);
            lastUpdatedTime(model.lastUpdatedTime);
            name(model.name);
            networkFabricType(model.networkFabricType);
            ownerAccountId(model.ownerAccountId);
            state(model.state);
            tags(model.tags);
            transitGatewayId(model.transitGatewayId);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        @Transient
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreatedTime() {
            return createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        @Transient
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getEnvironmentId() {
            return environmentId;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        @Override
        @Transient
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final ErrorResponse.Builder getError() {
            return error != null ? error.toBuilder() : null;
        }

        public final void setError(ErrorResponse.BuilderImpl error) {
            this.error = error != null ? error.build() : null;
        }

        @Override
        @Transient
        public final Builder error(ErrorResponse error) {
            this.error = error;
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        @Transient
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getNetworkFabricType() {
            return networkFabricType;
        }

        public final void setNetworkFabricType(String networkFabricType) {
            this.networkFabricType = networkFabricType;
        }

        @Override
        @Transient
        public final Builder networkFabricType(String networkFabricType) {
            this.networkFabricType = networkFabricType;
            return this;
        }

        @Override
        @Transient
        public final Builder networkFabricType(NetworkFabricType networkFabricType) {
            this.networkFabricType(networkFabricType == null ? null : networkFabricType.toString());
            return this;
        }

        public final String getOwnerAccountId() {
            return ownerAccountId;
        }

        public final void setOwnerAccountId(String ownerAccountId) {
            this.ownerAccountId = ownerAccountId;
        }

        @Override
        @Transient
        public final Builder ownerAccountId(String ownerAccountId) {
            this.ownerAccountId = ownerAccountId;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        @Transient
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        @Transient
        public final Builder state(EnvironmentState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        @Transient
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getTransitGatewayId() {
            return transitGatewayId;
        }

        public final void setTransitGatewayId(String transitGatewayId) {
            this.transitGatewayId = transitGatewayId;
        }

        @Override
        @Transient
        public final Builder transitGatewayId(String transitGatewayId) {
            this.transitGatewayId = transitGatewayId;
            return this;
        }

        @Override
        public EnvironmentSummary build() {
            return new EnvironmentSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
